/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;

public abstract class Reference {
    private Object referent;
    ReferenceQueue queue;
    Reference next;
    private static Reference processing;
    private static Lock lock;
    private static Reference pending;

    private static native void initForReset();

    private static native Reference process(Object var0);

    public Object get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != ReferenceQueue.NULL && this.next != null;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(Object object) {
        this(object, null);
    }

    Reference(Object object, ReferenceQueue referenceQueue) {
        this.referent = object;
        if (object == null) {
            this.queue = ReferenceQueue.NULL;
            this.next = this;
        } else {
            this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
            this.next = null;
        }
    }

    static {
        ThreadGroup threadGroup;
        processing = null;
        lock = new Lock();
        pending = null;
        ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup2 != null) {
            threadGroup = threadGroup2;
            threadGroup2 = threadGroup.getParent();
        }
        ReferenceHandler referenceHandler = new ReferenceHandler(threadGroup, "Reference Handler");
        referenceHandler.setPriority(10);
        referenceHandler.setDaemon(true);
        referenceHandler.start();
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        public void run() {
            Reference.initForReset();
            while (true) {
                Reference reference;
                if ((reference = Reference.process(lock)) == null) {
                    continue;
                }
                if (reference instanceof Cleaner) {
                    ((Cleaner)reference).clean();
                    continue;
                }
                ReferenceQueue referenceQueue = reference.queue;
                if (referenceQueue == ReferenceQueue.NULL) continue;
                referenceQueue.enqueue(reference);
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

