/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import com.ibm.jvm.ExtendedSystem;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;

public final class Method
extends AccessibleObject
implements Member {
    private Class clazz;
    private long slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private volatile Class securityCheckTargetClassCache;
    private static boolean useCaches = false;

    Method(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n, long l) {
        int n2;
        this.clazz = clazz;
        this.name = string;
        if (useCaches) {
            this.parameterTypes = classArray;
        } else {
            this.parameterTypes = new Class[classArray.length];
            n2 = 0;
            while (n2 < classArray.length) {
                this.parameterTypes[n2] = classArray[n2];
                ++n2;
            }
        }
        this.returnType = clazz2;
        if (useCaches) {
            this.exceptionTypes = classArray2;
        } else {
            this.exceptionTypes = new Class[classArray2.length];
            n2 = 0;
            while (n2 < classArray2.length) {
                this.exceptionTypes[n2] = classArray2[n2];
                ++n2;
            }
        }
        this.modifiers = n;
        this.slot = l;
    }

    Method copy() {
        Method method = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot);
        method.root = this;
        method.methodAccessor = this.methodAccessor;
        return method;
    }

    public Class getDeclaringClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getParameterTypes() {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.parameterTypes;
        }
        return Method.copy(this.parameterTypes);
    }

    public Class[] getExceptionTypes() {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.exceptionTypes;
        }
        return Method.copy(this.exceptionTypes);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Method) {
            Class[] classArray;
            Class[] classArray2;
            Method method = (Method)object;
            if (this.getDeclaringClass() == method.getDeclaringClass() && this.getName().equals(method.getName()) && (classArray2 = this.parameterTypes).length == (classArray = method.parameterTypes).length) {
                int n = 0;
                while (n < classArray2.length) {
                    if (classArray2[n] != classArray[n]) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.getModifiers();
            if (n != 0) {
                stringBuffer.append(Modifier.toString(n) + " ");
            }
            stringBuffer.append(Field.getTypeName(this.getReturnType()) + " ");
            stringBuffer.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            stringBuffer.append(this.getName() + "(");
            Class[] classArray = this.parameterTypes;
            int n2 = 0;
            while (n2 < classArray.length) {
                stringBuffer.append(Field.getTypeName(classArray[n2]));
                if (n2 < classArray.length - 1) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            stringBuffer.append(")");
            Class[] classArray2 = this.exceptionTypes;
            if (classArray2.length > 0) {
                stringBuffer.append(" throws ");
                int n3 = 0;
                while (n3 < classArray2.length) {
                    stringBuffer.append(classArray2[n3].getName());
                    if (n3 < classArray2.length - 1) {
                        stringBuffer.append(",");
                    }
                    ++n3;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "<" + exception + ">";
        }
    }

    public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (ExtendedSystem.isOldReflectionMode()) {
            return this.invoke0(object, objectArray);
        }
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            Class clazz;
            Class clazz2 = Reflection.getCallerClass(1);
            Class clazz3 = clazz = object == null || !Modifier.isProtected(this.modifiers) ? this.clazz : object.getClass();
            if (this.securityCheckCache != clazz2 || clazz != this.securityCheckTargetClassCache) {
                Reflection.ensureMemberAccess(clazz2, this.clazz, object, this.modifiers);
                this.securityCheckCache = clazz2;
                this.securityCheckTargetClassCache = clazz;
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(this, object, objectArray);
    }

    private native Object invoke0(Object var1, Object[] var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    private void acquireMethodAccessor() {
        MethodAccessor methodAccessor = null;
        if (this.root != null) {
            methodAccessor = this.root.getMethodAccessor();
        }
        if (methodAccessor != null) {
            this.methodAccessor = methodAccessor;
            return;
        }
        methodAccessor = AccessibleObject.reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(methodAccessor);
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor methodAccessor) {
        this.methodAccessor = methodAccessor;
        if (this.root != null) {
            this.root.setMethodAccessor(methodAccessor);
        }
    }

    static Class[] copy(Class[] classArray) {
        int n = classArray.length;
        if (n == 0) {
            return classArray;
        }
        Class[] classArray2 = new Class[n];
        int n2 = 0;
        while (n2 < n) {
            classArray2[n2] = classArray[n2];
            ++n2;
        }
        return classArray2;
    }
}

