/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

class StringCharBuffer
extends CharBuffer {
    CharSequence str;

    StringCharBuffer(CharSequence charSequence, int n, int n2) {
        super(-1, n, n2, charSequence.length());
        int n3 = charSequence.length();
        if (n < 0 || n > n3 || n2 < n || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        this.str = charSequence;
    }

    public CharBuffer slice() {
        return new StringCharBuffer(this.str, this.position(), this.limit());
    }

    private StringCharBuffer(CharSequence charSequence, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.str = charSequence;
    }

    public CharBuffer duplicate() {
        return new StringCharBuffer(this.str, this.markValue(), this.position(), this.limit(), this.capacity());
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public final char get() {
        return this.str.charAt(this.nextGetIndex());
    }

    public final char get(int n) {
        return this.str.charAt(this.checkIndex(n));
    }

    public final CharBuffer put(char c) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer put(int n, char c) {
        throw new ReadOnlyBufferException();
    }

    public final CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public final boolean isReadOnly() {
        return true;
    }

    final String toString(int n, int n2) {
        return this.str.toString().substring(n, n2);
    }

    public final CharSequence subSequence(int n, int n2) {
        try {
            int n3 = this.position();
            return new StringCharBuffer(this.str, n3 + this.checkIndex(n, n3), n3 + this.checkIndex(n2, n3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public boolean isDirect() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

