/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.jvm.Constants;
import com.ibm.jvm.ExtendedSystem;
import com.ibm.security.bootstrap.BootstrapProvider;
import com.ibm.security.util.PropertyExpander;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import sun.security.util.Debug;

public final class Security {
    private static final Debug sdebug = Debug.getInstance("properties");
    private static final Debug pdebug = Debug.getInstance("provider");
    private static final Debug adebug = Debug.getInstance("algorithm");
    private static final String providerLoading = "Provider Loading...";
    private static Provider bootstrapProvider;
    private static Properties props;
    private static Vector providers;
    private static Hashtable algorithmCache;
    private static Hashtable digestBeingLoaded;
    private static Hashtable searchResultsCache;
    private static boolean searchResultsCacheInvalid;
    static /* synthetic */ Class class$java$security$Security;

    private static void initialize() {
        boolean bl;
        block22: {
            Object object;
            File file;
            boolean bl2;
            block21: {
                props = new Properties();
                providers = new Vector(10);
                algorithmCache = new Hashtable(20);
                searchResultsCache = new Hashtable(5);
                digestBeingLoaded = new Hashtable(11);
                bootstrapProvider = new BootstrapProvider();
                bl = false;
                bl2 = false;
                String string = File.separator;
                file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + Constants.java_security);
                if (file.exists()) {
                    try {
                        object = new FileInputStream(file);
                        props.load((InputStream)object);
                        ((FileInputStream)object).close();
                        bl = true;
                        if (sdebug != null) {
                            sdebug.println("reading file " + file);
                        }
                        break block21;
                    }
                    catch (IOException iOException) {
                        if (sdebug != null) {
                            sdebug.println("unable to load security properties from " + file);
                            sdebug.printStackTrace(iOException);
                        }
                        break block21;
                    }
                }
                if (sdebug != null) {
                    sdebug.println("unable to read file " + file);
                }
            }
            if (props.getProperty("security.overridePropertiesFile", "false").equalsIgnoreCase("true")) {
                object = System.getProperty("java.security.properties");
                if (object != null && ((String)object).startsWith("=")) {
                    bl2 = true;
                    object = ((String)object).substring(1);
                }
                if (bl2) {
                    props = new Properties();
                    if (sdebug != null) {
                        sdebug.println("overriding other security properties files!");
                    }
                }
                if (object != null) {
                    try {
                        object = PropertyExpander.expand((String)object);
                        file = new File((String)object);
                        URL uRL = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL((String)object);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
                        props.load(bufferedInputStream);
                        bufferedInputStream.close();
                        bl = true;
                        if (sdebug != null) {
                            sdebug.println("reading security properties file: " + uRL);
                            if (bl2) {
                                sdebug.println("overriding other security properties files!");
                            }
                        }
                    }
                    catch (Exception exception) {
                        if (sdebug == null) break block22;
                        sdebug.println("unable to load security properties from " + (String)object);
                        sdebug.printStackTrace(exception);
                    }
                }
            }
        }
        if (bl) {
            if (pdebug != null) {
                pdebug.println("statically registered providers");
            }
            Security.copyStaticProviders();
        } else {
            if (pdebug != null) {
                pdebug.println("no statically registered providers, using defaults");
            }
            Security.defaultStaticProviders();
        }
        if (pdebug != null) {
            int n = 0;
            while (n < providers.size()) {
                pdebug.println("[" + n + "] " + providers.elementAt(n));
                ++n;
            }
            pdebug.println();
        }
    }

    private static void defaultStaticProviders() {
        providers.add("com.ibm.jsse.IBMJSSEProvider");
        providers.add("com.ibm.crypto.provider.IBMJCE");
        providers.add("com.ibm.security.jgss.IBMJGSSProvider");
        providers.add("com.ibm.security.cert.IBMCertPath");
    }

    private Security() {
    }

    private static void copyStaticProviders() {
        String string;
        int n = 1;
        while ((string = props.getProperty("security.provider." + n)) != null) {
            String string2 = string.trim();
            if (string2.length() == 0) {
                if (pdebug == null) break;
                pdebug.println("invalid entry for security.provider." + n);
                break;
            }
            if (!providers.contains(string2)) {
                providers.add(string2);
            }
            ++n;
        }
    }

    private static synchronized Provider getProviderAt(int n) {
        String string = null;
        Object object = providers.elementAt(n);
        if (object instanceof Provider) {
            return (Provider)object;
        }
        if (object == providerLoading) {
            return bootstrapProvider;
        }
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof LoadFailed) {
            string = ((LoadFailed)object).providerClassName;
        } else {
            if (pdebug != null) {
                pdebug.println("slot " + n + ", contains unrecognised entry, aborting. Type =" + object.getClass());
            }
            return null;
        }
        providers.setElementAt(providerLoading, n);
        final String string2 = string;
        if (pdebug != null) {
            pdebug.println("loading provider [" + string + "] into slot " + n + " ... ");
        }
        try {
            Provider provider = (Provider)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Provider.loadProvider(string2);
                }
            });
            providers.setElementAt(provider, n);
            searchResultsCacheInvalid = true;
            algorithmCache.clear();
            if (pdebug != null) {
                pdebug.println("slot " + n + " loaded with [" + provider + "]");
            }
            return provider;
        }
        catch (Exception exception) {
            LoadFailed loadFailed = new LoadFailed();
            loadFailed.loadException = exception;
            loadFailed.providerClassName = string2;
            providers.setElementAt(loadFailed, n);
            if (pdebug != null) {
                pdebug.println("slot " + n + ", load failed, " + exception);
                pdebug.printStackTrace(exception);
            }
            return null;
        }
    }

    private static String getProviderProperty(String string, Provider provider) {
        String string2 = provider.getProperty(string);
        if (string2 == null) {
            Enumeration enumeration = provider.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (!string.equalsIgnoreCase(string3)) continue;
                return provider.getProperty(string3);
            }
        }
        return string2;
    }

    public static String getAlgorithmProperty(String string, String string2) {
        String string3 = "Alg." + string2 + "." + string;
        int n = 0;
        while (n < providers.size()) {
            Provider provider = Security.getProviderAt(n);
            if (provider != null) {
                String string4 = provider.getProperty(string3);
                if (string4 != null) {
                    return string4;
                }
                Enumeration enumeration = provider.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    if (!string3.equalsIgnoreCase(string5)) continue;
                    return provider.getProperty(string5);
                }
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProviderProperty getAlgClassName(String string, String string2) throws NoSuchAlgorithmException {
        String string3 = string == null ? string2 : string2 + "." + string;
        ProviderProperty providerProperty = (ProviderProperty)algorithmCache.get(string3);
        if (providerProperty != null) {
            return providerProperty;
        }
        Class clazz = class$java$security$Security == null ? (class$java$security$Security = Security.class$("java.security.Security")) : class$java$security$Security;
        synchronized (clazz) {
            Provider provider = null;
            int n = 0;
            while (n < providers.size()) {
                provider = Security.getProviderAt(n);
                if (provider != null) {
                    String string4;
                    String string5 = Security.getProviderProperty(string3, provider);
                    if (string5 == null && (string4 = Security.getProviderProperty("Alg.Alias." + string2 + "." + string, provider)) != null) {
                        string5 = Security.getProviderProperty(string2 + "." + string4, provider);
                    }
                    if (string5 != null) {
                        providerProperty = new ProviderProperty();
                        providerProperty.className = string5;
                        providerProperty.provider = provider;
                        algorithmCache.put(string3, providerProperty);
                        return providerProperty;
                    }
                }
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string.toUpperCase() + " " + string2 + " not available");
    }

    private static ProviderProperty getAlgClassName(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            return Security.getAlgClassName(string, string3);
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("no such provider: " + string2);
        }
        return Security.getAlgClassName(string, provider, string3);
    }

    private static ProviderProperty getAlgClassName(String string, Provider provider, String string2) throws NoSuchAlgorithmException {
        Object object;
        String string3 = string2.equalsIgnoreCase("SecureRandom") && string == null ? string2 : string2 + "." + string;
        String string4 = Security.getProviderProperty(string3, provider);
        if (string4 == null) {
            if (string2.equalsIgnoreCase("SecureRandom") && string == null) {
                throw new NoSuchAlgorithmException("SecureRandom not available for provider " + provider.getName());
            }
            object = Security.getProviderProperty("Alg.Alias." + string2 + "." + string, provider);
            if (object != null) {
                string3 = string2 + "." + (String)object;
            }
            if (object == null || (string4 = Security.getProviderProperty(string3, provider)) == null) {
                throw new NoSuchAlgorithmException("no such algorithm: " + string + " for provider " + provider.getName());
            }
        }
        object = new ProviderProperty();
        ((ProviderProperty)object).className = string4;
        ((ProviderProperty)object).provider = provider;
        return object;
    }

    public static synchronized int insertProviderAt(Provider provider, int n) {
        Provider provider2;
        SecurityManager securityManager;
        if (pdebug != null) {
            pdebug.println("insert provider " + provider + " at " + n);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkSecurityAccess("insertProvider." + provider.getName());
        }
        if ((provider2 = Security.getProvider(provider.getName())) != null) {
            return -1;
        }
        int n2 = providers.size();
        if (n > n2 || n <= 0) {
            n = n2 + 1;
        }
        providers.insertElementAt(provider, n - 1);
        searchResultsCacheInvalid = true;
        algorithmCache.clear();
        ExtendedSystem.setJVMUnresettableConditionally(131075, new String("Modified security in Security.insertProvidersAt()"));
        return n;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, 0);
    }

    public static synchronized void removeProvider(String string) {
        Provider provider;
        SecurityManager securityManager;
        if (pdebug != null) {
            pdebug.println("remove provider " + string);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkSecurityAccess("removeProvider." + string);
        }
        if ((provider = Security.getProvider(string)) != null) {
            providers.remove(provider);
            searchResultsCacheInvalid = true;
            algorithmCache.clear();
            ExtendedSystem.setJVMUnresettableConditionally(131075, new String("Modified security in Security.removeProvider()"));
        }
    }

    public static synchronized Provider[] getProviders() {
        Vector vector = new Vector(providers.size());
        int n = 0;
        while (n < providers.size()) {
            Provider provider = Security.getProviderAt(n);
            if (provider != null) {
                vector.addElement(provider);
            }
            ++n;
        }
        Object[] objectArray = new Provider[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static synchronized Provider getProvider(String string) {
        int n = 0;
        while (n < providers.size()) {
            Provider provider = Security.getProviderAt(n);
            if (provider != null && provider.getName().equals(string)) {
                return provider;
            }
            ++n;
        }
        return null;
    }

    public static Provider[] getProviders(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf(58);
        if (n == -1) {
            string2 = new String(string);
            string3 = "";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        Hashtable hashtable = new Hashtable(1);
        hashtable.put(string2, string3);
        return Security.getProviders(hashtable);
    }

    public static Provider[] getProviders(Map map) {
        Provider[] providerArray;
        Object[] objectArray;
        Provider[] providerArray2 = Security.getProviders();
        Set set = map.keySet();
        HashSet hashSet = new HashSet(5);
        if (set == null || providerArray2 == null) {
            return providerArray2;
        }
        boolean bl = true;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            providerArray = (Provider[])map.get(objectArray);
            HashSet hashSet2 = Security.getAllQualifyingCandidates((String)objectArray, (String)providerArray, providerArray2);
            if (bl) {
                hashSet = hashSet2;
                bl = false;
            }
            if (hashSet2 != null && !hashSet2.isEmpty()) {
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    Provider provider = (Provider)iterator2.next();
                    if (hashSet2.contains(provider)) continue;
                    iterator2.remove();
                }
                continue;
            }
            hashSet = null;
            break;
        }
        if (hashSet == null || hashSet.isEmpty()) {
            return null;
        }
        objectArray = hashSet.toArray();
        providerArray = new Provider[objectArray.length];
        int n = 0;
        while (n < providerArray.length) {
            providerArray[n] = (Provider)objectArray[n];
            ++n;
        }
        return providerArray;
    }

    private static boolean checkSuperclass(Class clazz, Class clazz2) {
        while (!clazz.equals(clazz2)) {
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return false;
        }
        return true;
    }

    static Object[] getImpl(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (adebug != null) {
            adebug.println("request for " + string2 + " " + string + " from " + string3);
            adebug.printStackTrace(null);
        }
        ProviderProperty providerProperty = Security.getAlgClassName(string, string3, string2);
        if (adebug != null) {
            adebug.println("request for " + string + " can be met by " + providerProperty.provider);
        }
        Object[] objectArray = Security.createAlgInstance(string2, providerProperty);
        if (adebug != null) {
            adebug.println(string + " created, " + objectArray[0].getClass());
        }
        return objectArray;
    }

    static Object[] getImpl(String string, String string2, String string3, Object object) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        if (adebug != null) {
            adebug.println("request for " + string2 + " " + string + " from " + string3 + " Params=[" + object + "]");
            adebug.printStackTrace(null);
        }
        ProviderProperty providerProperty = Security.getAlgClassName(string, string3, string2);
        if (adebug != null) {
            adebug.println("request for " + string + " can be met by " + providerProperty.provider);
        }
        Object[] objectArray = Security.createAlgInstance(string2, providerProperty, object);
        if (adebug != null) {
            adebug.println(string + " created, " + objectArray[0].getClass());
        }
        return objectArray;
    }

    static Object[] getImpl(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        if (adebug != null) {
            adebug.println("request for " + string2 + " " + string + " from (" + provider + ")");
            adebug.printStackTrace(null);
        }
        ProviderProperty providerProperty = Security.getAlgClassName(string, provider, string2);
        if (adebug != null) {
            adebug.println("request for " + string + " can be met by " + providerProperty.provider);
        }
        Object[] objectArray = Security.createAlgInstance(string2, providerProperty);
        if (adebug != null) {
            adebug.println(string + " created, " + objectArray[0].getClass());
        }
        return objectArray;
    }

    static Object[] getImpl(String string, String string2, Provider provider, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (adebug != null) {
            adebug.println("request for " + string2 + " " + string + " from (" + provider + ") Params=[" + object + "]");
            adebug.printStackTrace(null);
        }
        ProviderProperty providerProperty = Security.getAlgClassName(string, provider, string2);
        if (adebug != null) {
            adebug.println("request for " + string + " can be met by " + providerProperty.provider);
        }
        Object[] objectArray = Security.createAlgInstance(string2, providerProperty, object);
        if (adebug != null) {
            adebug.println(string + " created, " + objectArray[0].getClass());
        }
        return objectArray;
    }

    private static Object[] createAlgInstance(String string, ProviderProperty providerProperty) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray;
            if (string.equals("MessageDigest")) {
                String string2 = providerProperty.className;
                if (digestBeingLoaded.containsKey(string2 + Thread.currentThread().getName())) {
                    ProviderProperty providerProperty2 = new ProviderProperty();
                    providerProperty2.className = "com.ibm.security.bootstrap." + string2.substring(string2.lastIndexOf(".") + 1);
                    providerProperty2.provider = bootstrapProvider;
                    objectArray = Security.createAlgInstance(string, providerProperty2, null);
                } else {
                    digestBeingLoaded.put(string2 + Thread.currentThread().getName(), "value");
                    objectArray = Security.createAlgInstance(string, providerProperty, null);
                    digestBeingLoaded.remove(string2 + Thread.currentThread().getName());
                }
            } else {
                objectArray = Security.createAlgInstance(string, providerProperty, null);
            }
            return objectArray;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new NoSuchAlgorithmException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static Object[] createAlgInstance(String string, ProviderProperty providerProperty, Object object) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String string2 = providerProperty.className;
        Provider provider = providerProperty.provider;
        try {
            Class clazz = string.equals("CertificateFactory") || string.equals("CertPathBuilder") || string.equals("CertPathValidator") || string.equals("CertStore") ? Class.forName("java.security.cert." + string + "Spi") : Class.forName("java.security." + string + "Spi");
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class clazz2 = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
            if (Security.checkSuperclass(clazz2, clazz)) {
                Object object2;
                if (string.equals("CertStore")) {
                    Constructor constructor = clazz2.getConstructor(new Class[]{Class.forName("java.security.cert.CertStoreParameters")});
                    object2 = constructor.newInstance(new Object[]{object});
                } else {
                    object2 = clazz2.newInstance();
                }
                return new Object[]{object2, provider};
            }
            if (adebug != null) {
                adebug.println("class configured for " + string + ": " + string2 + " not a " + string);
                adebug.printStackTrace(null);
            }
            throw new NoSuchAlgorithmException("class configured for " + string + ": " + string2 + " not a " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (adebug != null) {
                adebug.println("class configured for " + string + " cannot be found, " + classNotFoundException.getMessage());
                adebug.printStackTrace(classNotFoundException);
            }
            throw new NoSuchAlgorithmException("class configured for " + string + "(provider: " + provider + ")" + "cannot be found.\n" + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            if (adebug != null) {
                adebug.println("class " + string2 + " cannot be instantiated, " + instantiationException.getMessage());
                adebug.printStackTrace(instantiationException);
            }
            throw (NoSuchAlgorithmException)new NoSuchAlgorithmException("class " + string2 + " configured for " + string + "(provider: " + provider + ") cannot be " + "instantiated.\n").initCause(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (adebug != null) {
                adebug.println("class " + string2 + " cannot be accessed, " + illegalAccessException.getMessage());
                adebug.printStackTrace(illegalAccessException);
            }
            throw new NoSuchAlgorithmException("class " + string2 + " configured for " + string + "(provider: " + provider + ") cannot be accessed.\n" + illegalAccessException.getMessage());
        }
        catch (SecurityException securityException) {
            if (adebug != null) {
                adebug.println("class " + string2 + " cannot be accessed, " + securityException.getMessage());
                adebug.printStackTrace(securityException);
            }
            throw new NoSuchAlgorithmException("class " + string2 + " configured for " + string + "(provider: " + provider + ") cannot be accessed.\n" + securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (adebug != null) {
                adebug.println("constructor for " + string2 + " cannot be found, " + noSuchMethodException.getMessage());
                adebug.printStackTrace(noSuchMethodException);
            }
            throw new NoSuchAlgorithmException("constructor for class " + string2 + " configured for " + string + "(provider: " + provider + ") cannot be instantiated.\n" + noSuchMethodException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable;
            if (adebug != null) {
                adebug.println("invalid argument for constructor of " + string2 + ", " + invocationTargetException.getMessage());
                adebug.printStackTrace(invocationTargetException);
            }
            if ((throwable = invocationTargetException.getCause()) != null && throwable instanceof InvalidAlgorithmParameterException) {
                throw (InvalidAlgorithmParameterException)throwable;
            }
            throw new InvalidAlgorithmParameterException("constructor for class " + string2 + " configured for " + string + "(provider: " + provider + ") cannot be instantiated.\n" + invocationTargetException.getMessage());
        }
    }

    public static String getProperty(String string) {
        String string2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getProperty." + string));
        }
        if ((string2 = props.getProperty(string)) != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static void setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setProperty." + string));
        }
        props.put(string, string2);
        Security.invalidateSMCache(string);
        ExtendedSystem.setJVMUnresettableConditionally(131075, new String("Modified security in Security.setProperty()"));
    }

    private static void invalidateSMCache(String string) {
        final boolean bl = string.equals("package.access");
        boolean bl2 = string.equals("package.definition");
        if (bl || bl2) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Class clazz = Class.forName("java.lang.SecurityManager", false, null);
                        Field field = null;
                        boolean bl2 = false;
                        if (bl) {
                            field = clazz.getDeclaredField("packageAccessValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        } else {
                            field = clazz.getDeclaredField("packageDefinitionValid");
                            bl2 = field.isAccessible();
                            field.setAccessible(true);
                        }
                        field.setBoolean(field, false);
                        field.setAccessible(bl2);
                    }
                    catch (Exception exception) {}
                    return null;
                }
            });
        }
    }

    private static HashSet getAllQualifyingCandidates(String string, String string2, Provider[] providerArray) {
        if (searchResultsCacheInvalid) {
            searchResultsCache.clear();
            searchResultsCacheInvalid = false;
        }
        String[] stringArray = Security.getFilterComponents(string, string2);
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        String string5 = stringArray[2];
        String string6 = string3 + '.' + string4;
        HashSet hashSet = (HashSet)searchResultsCache.get(string6);
        HashSet hashSet2 = Security.getProvidersNotUsingCache(string3, string4, null, null, null, providerArray);
        if (hashSet2 == null || hashSet2.isEmpty()) {
            return null;
        }
        searchResultsCache.put(string6, hashSet2);
        if (string5 == null) {
            return hashSet2;
        }
        return Security.getProvidersNotUsingCache(string3, string4, string5, string2, hashSet, providerArray);
    }

    private static HashSet getProvidersNotUsingCache(String string, String string2, String string3, String string4, HashSet hashSet, Provider[] providerArray) {
        if (string3 != null && hashSet != null && !hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Provider provider = (Provider)iterator.next();
                if (Security.isCriterionSatisfied(provider, string, string2, string3, string4)) continue;
                iterator.remove();
            }
        }
        if (hashSet == null || hashSet.isEmpty()) {
            if (hashSet == null) {
                hashSet = new HashSet(5);
            }
            int n = 0;
            while (n < providerArray.length) {
                if (Security.isCriterionSatisfied(providerArray[n], string, string2, string3, string4)) {
                    hashSet.add(providerArray[n]);
                }
                ++n;
            }
        }
        return hashSet;
    }

    private static boolean isCriterionSatisfied(Provider provider, String string, String string2, String string3, String string4) {
        String string5;
        String string6 = string + '.' + string2;
        if (string3 != null) {
            string6 = string6 + ' ' + string3;
        }
        if ((string5 = Security.getProviderProperty(string6, provider)) == null) {
            String string7 = Security.getProviderProperty("Alg.Alias." + string + "." + string2, provider);
            if (string7 != null) {
                string6 = string + "." + string7;
                if (string3 != null) {
                    string6 = string6 + ' ' + string3;
                }
                string5 = Security.getProviderProperty(string6, provider);
            }
            if (string5 == null) {
                return false;
            }
        }
        if (string3 == null) {
            return true;
        }
        if (string3.equalsIgnoreCase("KeySize")) {
            return Integer.parseInt(string4, 10) <= Integer.parseInt(string5, 10);
        }
        if (string3.equalsIgnoreCase("ImplementedIn")) {
            return string4.equalsIgnoreCase(string5);
        }
        return string4.equalsIgnoreCase(string5);
    }

    static String[] getFilterComponents(String string, String string2) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new InvalidParameterException("Invalid filter");
        }
        String string3 = string.substring(0, n);
        String string4 = null;
        String string5 = null;
        if (string2.length() == 0) {
            string4 = string.substring(n + 1).trim();
            if (string4.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
        } else {
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string5 = string.substring(n2 + 1).trim();
            if (string5.length() == 0) {
                throw new InvalidParameterException("Invalid filter");
            }
            if (n2 < n || n == n2 - 1) {
                throw new InvalidParameterException("Invalid filter");
            }
            string4 = string.substring(n + 1, n2);
        }
        String[] stringArray = new String[]{string3, string4, string5};
        return stringArray;
    }

    public static Set getAlgorithms(String string) {
        HashSet hashSet = new HashSet();
        if (string == null || string.length() == 0 || string.endsWith(".")) {
            return hashSet;
        }
        int n = 0;
        while (n < providers.size()) {
            Enumeration enumeration = Security.getProviderAt(n).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = ((String)enumeration.nextElement()).toUpperCase();
                if (!string2.startsWith(string.toUpperCase()) || string2.indexOf(" ") >= 0) continue;
                hashSet.add(string2.substring(string.length() + 1));
            }
            ++n;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        searchResultsCacheInvalid = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Security.initialize();
                return null;
            }
        });
    }

    private static class LoadFailed {
        Exception loadException;
        String providerClassName;

        private LoadFailed() {
        }

        public String toString() {
            return "Load Failed, class=" + this.providerClassName + ", reason=" + this.loadException;
        }
    }

    private static class ProviderProperty {
        String className;
        Provider provider;

        private ProviderProperty() {
        }
    }
}

