/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathHelperInitializer;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class TrustAnchor {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private byte[] nameConstraints;
    private X509Certificate trustedCert;
    private String caName;
    private X500Name caX500Name;
    private PublicKey pubKey;

    public TrustAnchor(X509Certificate x509Certificate, byte[] byArray) {
        if (x509Certificate == null) {
            throw new NullPointerException("the trustedCert parameter must be non-null");
        }
        this.setNameConstraints(byArray);
        this.trustedCert = x509Certificate;
        this.caName = null;
        this.caX500Name = null;
        this.pubKey = null;
    }

    public TrustAnchor(String string, PublicKey publicKey, byte[] byArray) {
        if (string == null) {
            throw new NullPointerException("the caName parameter must be non-null");
        }
        if (publicKey == null) {
            throw new NullPointerException("the pubKey parameter must be non-null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("the caName parameter must be a non-empty String");
        }
        try {
            this.caX500Name = new X500Name(string);
            this.caName = this.caX500Name.getRFC2253Name();
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        this.pubKey = publicKey;
        this.trustedCert = null;
        this.setNameConstraints(byArray);
    }

    public final X509Certificate getTrustedCert() {
        return this.trustedCert;
    }

    public final String getCAName() {
        return this.caName;
    }

    public final PublicKey getCAPublicKey() {
        return this.pubKey;
    }

    public final byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TrustAnchor: \n");
        if (this.trustedCert != null) {
            stringBuffer.append("\tTrusted certificate: " + this.trustedCert.toString());
        } else {
            stringBuffer.append("\tTrusted ca: " + this.caName);
            stringBuffer.append("\tTrusted ca public key: " + this.pubKey.toString());
        }
        if (this.nameConstraints != null) {
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
                stringBuffer.append("\t" + nameConstraintsExtension.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private void setNameConstraints(byte[] byArray) throws IllegalArgumentException {
        if (byArray != null) {
            this.nameConstraints = (byte[])byArray.clone();
            try {
                NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)this.nameConstraints);
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(iOException.getMessage());
                illegalArgumentException.initCause(iOException);
                throw illegalArgumentException;
            }
        } else {
            this.nameConstraints = null;
        }
    }

    X500Principal getCA() {
        if (this.trustedCert != null) {
            return this.trustedCert.getSubjectX500Principal();
        }
        return new X500Principal(this.caName);
    }

    X500Name getCAX500Name() {
        return this.caX500Name;
    }

    static {
        if (!CertPathHelperInitializer.isInitialized()) {
            CertPathHelperInitializer.init();
        }
    }
}

