/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Logger;

public class Attributes
implements Map,
Cloneable {
    protected Map map;

    public Attributes() {
        this(11);
    }

    public Attributes(int n) {
        this.map = new HashMap(n);
    }

    public Attributes(Attributes attributes) {
        this.map = new HashMap(attributes);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public String getValue(String string) {
        return (String)this.get(new Name(string));
    }

    public String getValue(Name name) {
        return (String)this.get(name);
    }

    public Object put(Object object, Object object2) {
        return this.map.put((Name)object, (String)object2);
    }

    public String putValue(String string, String string2) {
        return (String)this.put(new Name(string), string2);
    }

    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public void putAll(Map map) {
        this.map.putAll((Attributes)map);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Object clone() {
        return new Attributes(this);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            StringBuffer stringBuffer = new StringBuffer(((Name)entry.getKey()).toString());
            stringBuffer.append(": ");
            String string = (String)entry.getValue();
            if (string != null) {
                byte[] byArray = string.getBytes("UTF8");
                string = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    void writeMain(DataOutputStream dataOutputStream) throws IOException {
        String string = Name.MANIFEST_VERSION.toString();
        String string2 = this.getValue(string);
        if (string2 == null) {
            string = Name.SIGNATURE_VERSION.toString();
            string2 = this.getValue(string);
        }
        if (string2 != null) {
            dataOutputStream.writeBytes(string + ": " + string2 + "\r\n");
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string3 = ((Name)entry.getKey()).toString();
            if (string2 == null || string3.equalsIgnoreCase(string)) continue;
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append(": ");
            String string4 = (String)entry.getValue();
            if (string4 != null) {
                byte[] byArray = string4.getBytes("UTF8");
                string4 = new String(byArray, 0, 0, byArray.length);
            }
            stringBuffer.append(string4);
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
        }
        dataOutputStream.writeBytes("\r\n");
    }

    /*
     * Unable to fully structure code
     */
    void read(Manifest.FastInputStream var1_1, byte[] var2_2) throws IOException {
        var3_3 = null;
        var4_4 = null;
        var5_5 = null;
        while ((var6_6 = var1_1.readLine(var2_2)) != -1) {
            block10: {
                var7_7 = false;
                if (var2_2[--var6_6] != 10) {
                    throw new IOException("line too long");
                }
                if (var6_6 > 0 && var2_2[var6_6 - 1] == 13) {
                    --var6_6;
                }
                if (var6_6 == 0) break;
                var8_8 = 0;
                if (var2_2[0] != 32) ** GOTO lbl27
                if (var3_3 == null) {
                    throw new IOException("misplaced continuation line");
                }
                var7_7 = true;
                var9_9 = new byte[var5_5.length + var6_6 - 1];
                System.arraycopy(var5_5, 0, var9_9, 0, var5_5.length);
                System.arraycopy(var2_2, 1, var9_9, var5_5.length, var6_6 - 1);
                if (var1_1.peek() == 32) {
                    var5_5 = var9_9;
                    continue;
                }
                var4_4 = new String(var9_9, 0, var9_9.length, "UTF8");
                var5_5 = null;
                break block10;
lbl-1000:
                // 1 sources

                {
                    if (var8_8 < var6_6) continue;
                    throw new IOException("invalid header field");
lbl27:
                    // 2 sources

                    ** while (var2_2[var8_8++] != 58)
                }
lbl28:
                // 1 sources

                if (var2_2[var8_8++] != 32) {
                    throw new IOException("invalid header field");
                }
                var3_3 = new String(var2_2, 0, 0, var8_8 - 2);
                if (var1_1.peek() == 32) {
                    var5_5 = new byte[var6_6 - var8_8];
                    System.arraycopy(var2_2, var8_8, var5_5, 0, var6_6 - var8_8);
                    continue;
                }
                var4_4 = new String(var2_2, var8_8, var6_6 - var8_8, "UTF8");
            }
            try {
                if (this.putValue(var3_3, var4_4) == null || var7_7) continue;
                Logger.getLogger("java.util.jar").warning("Duplicate name in Manifest: " + var3_3);
            }
            catch (IllegalArgumentException var9_10) {
                throw new IOException("invalid header field name: " + var3_3);
            }
        }
    }

    public static class Name {
        private String name;
        private int hashCode = -1;
        public static final Name MANIFEST_VERSION = new Name("Manifest-Version");
        public static final Name SIGNATURE_VERSION = new Name("Signature-Version");
        public static final Name CONTENT_TYPE = new Name("Content-Type");
        public static final Name CLASS_PATH = new Name("Class-Path");
        public static final Name MAIN_CLASS = new Name("Main-Class");
        public static final Name SEALED = new Name("Sealed");
        public static final Name EXTENSION_LIST = new Name("Extension-List");
        public static final Name EXTENSION_NAME = new Name("Extension-Name");
        public static final Name EXTENSION_INSTALLATION = new Name("Extension-Installation");
        public static final Name IMPLEMENTATION_TITLE = new Name("Implementation-Title");
        public static final Name IMPLEMENTATION_VERSION = new Name("Implementation-Version");
        public static final Name IMPLEMENTATION_VENDOR = new Name("Implementation-Vendor");
        public static final Name IMPLEMENTATION_VENDOR_ID = new Name("Implementation-Vendor-Id");
        public static final Name IMPLEMENTATION_URL = new Name("Implementation-URL");
        public static final Name SPECIFICATION_TITLE = new Name("Specification-Title");
        public static final Name SPECIFICATION_VERSION = new Name("Specification-Version");
        public static final Name SPECIFICATION_VENDOR = new Name("Specification-Vendor");

        public Name(String string) {
            if (string == null) {
                throw new NullPointerException("name");
            }
            if (!Name.isValid(string)) {
                throw new IllegalArgumentException(string);
            }
            this.name = string.intern();
        }

        private static boolean isValid(String string) {
            int n = string.length();
            if (n > 70 || n == 0) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!Name.isValid(string.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private static boolean isValid(char c) {
            return Name.isAlpha(c) || Name.isDigit(c) || c == '_' || c == '-';
        }

        private static boolean isAlpha(char c) {
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        public boolean equals(Object object) {
            if (object instanceof Name) {
                return this.name.equalsIgnoreCase(((Name)object).name);
            }
            return false;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.name.toLowerCase().hashCode();
            }
            return this.hashCode;
        }

        public String toString() {
            return this.name;
        }
    }
}

