/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.AccessController;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.OdbcDef;
import sun.security.action.LoadLibraryAction;

public class JdbcOdbc
extends JdbcOdbcObject {
    public static final int MajorVersion = 2;
    public static final int MinorVersion = 1;
    public String charSet;
    public String odbcDriverName;
    private static Map hstmtMap;
    public JdbcOdbcTracer tracer = new JdbcOdbcTracer();

    public static void addHstmt(long l, long l2) {
        hstmtMap.put(new Long(l), new Long(l2));
    }

    JdbcOdbc(JdbcOdbcTracer jdbcOdbcTracer, String string) throws SQLException {
        this.tracer = jdbcOdbcTracer;
        try {
            if (jdbcOdbcTracer.isTracing()) {
                java.util.Date date = new java.util.Date();
                String string2 = "";
                int n = 1;
                if (n < 1000) {
                    string2 = string2 + "0";
                }
                if (n < 100) {
                    string2 = string2 + "0";
                }
                if (n < 10) {
                    string2 = string2 + "0";
                }
                string2 = string2 + "" + n;
                jdbcOdbcTracer.trace("JDBC to ODBC Bridge 2." + string2);
                jdbcOdbcTracer.trace("Current Date/Time: " + date.toString());
                jdbcOdbcTracer.trace("Loading " + string + "JdbcOdbc library");
            }
            AccessController.doPrivileged(new LoadLibraryAction(string + "JdbcOdbc"));
            if (hstmtMap == null) {
                hstmtMap = Collections.synchronizedMap(new HashMap());
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (jdbcOdbcTracer.isTracing()) {
                jdbcOdbcTracer.trace("Unable to load " + string + "JdbcOdbc library");
            }
            throw new SQLException("Unable to load " + string + "JdbcOdbc library");
        }
    }

    public long SQLAllocConnect(long l) throws SQLException {
        long l2 = 0L;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Connection handle (SQLAllocConnect)");
        }
        byte[] byArray = new byte[1];
        l2 = this.allocConnect(l, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hDbc=" + l2);
        }
        return l2;
    }

    public long SQLAllocEnv() throws SQLException {
        long l = 0L;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Environment handle (SQLAllocEnv)");
        }
        byte[] byArray = new byte[1];
        l = this.allocEnv(byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hEnv=" + l);
        }
        return l;
    }

    public long SQLAllocStmt(long l) throws SQLException {
        long l2 = 0L;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Allocating Statement Handle (SQLAllocStmt), hDbc=" + l);
        }
        byte[] byArray = new byte[1];
        l2 = this.allocStmt(l, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("hStmt=" + l2);
        }
        JdbcOdbc.addHstmt(l2, l);
        return l2;
    }

    public void SQLBindColAtExec(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding Column DATA_AT_EXEC (SQLBindCol), hStmt=" + l + ", icol=" + n + ", SQLtype=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindColAtExec(l, n, n2, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColBinary(long l, int n, Object[] objectArray, byte[] byArray, int n2, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column binary (SQLBindColBinary), hStmt=" + l + ", icol=" + n);
        }
        byte[] byArray3 = new byte[1];
        this.bindColBinary(l, n, objectArray, byArray, n2, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColDate(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bound Column Date (SQLBindColDate), hStmt=" + l + ", icol=" + n);
        }
        Date date = null;
        int n2 = objectArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        byte[] byArray3 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] != null) {
                date = (Date)objectArray[n3];
                calendar.setTime(date);
                nArray[n3] = calendar.get(1);
                nArray2[n3] = calendar.get(2) + 1;
                nArray3[n3] = calendar.get(5);
            }
            ++n3;
        }
        this.bindColDate(l, n, nArray, nArray2, nArray3, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColDefault(long l, int n, byte[] byArray, byte[] byArray2) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol), hStmt=" + l + ", ipar=" + n + ", \t\t\tlength=" + byArray.length);
        }
        byte[] byArray3 = new byte[1];
        this.bindColDefault(l, n, byArray, byArray2, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColDouble(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column Double (SQLBindColDouble), hStmt=" + l + ", icol=" + n);
        }
        double[] dArray = new double[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                dArray[n2] = (Double)objectArray[n2];
            }
            ++n2;
        }
        byte[] byArray3 = new byte[1];
        this.bindColDouble(l, n, dArray, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColFloat(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        float[] fArray = new float[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                fArray[n2] = ((Float)objectArray[n2]).floatValue();
            }
            ++n2;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol Float), hStmt=" + l + ", icol=" + n);
        }
        byte[] byArray3 = new byte[1];
        this.bindColFloat(l, n, fArray, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColInteger(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding default column (SQLBindCol Integer), hStmt=" + l + ", icol=" + n);
        }
        int[] nArray = new int[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != null) {
                nArray[n2] = (Integer)objectArray[n2];
            }
            ++n2;
        }
        byte[] byArray3 = new byte[1];
        this.bindColInteger(l, n, nArray, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColString(long l, int n, int n2, Object[] objectArray, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding string/decimal Column (SQLBindColString), hStmt=" + l + ", icol=" + n + ", SQLtype=" + n2 + ", rgbValue=" + objectArray);
        }
        byte[] byArray3 = new byte[1];
        this.bindColString(l, n, OdbcDef.jdbcTypeToOdbc(n2), objectArray, n3, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColTime(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind column Time (SQLBindColTime), hStmt=" + l + ", icol=" + n);
        }
        Time time = null;
        int n2 = objectArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        byte[] byArray3 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] != null) {
                time = (Time)objectArray[n3];
                calendar.setTime(time);
                nArray[n3] = calendar.get(11);
                nArray2[n3] = calendar.get(12);
                nArray3[n3] = calendar.get(13);
            }
            ++n3;
        }
        this.bindColTime(l, n, nArray, nArray2, nArray3, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindColTimestamp(long l, int n, Object[] objectArray, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Bind Column Timestamp (SQLBindColTimestamp), hStmt=" + l + ", icol=" + n);
        }
        Timestamp timestamp = null;
        int n2 = objectArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        int[] nArray7 = new int[n2];
        byte[] byArray3 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n3 = 0;
        while (n3 < n2) {
            if (objectArray[n3] != null) {
                timestamp = (Timestamp)objectArray[n3];
                calendar.setTime(timestamp);
                nArray[n3] = calendar.get(1);
                nArray2[n3] = calendar.get(2) + 1;
                nArray3[n3] = calendar.get(5);
                nArray4[n3] = calendar.get(11);
                nArray5[n3] = calendar.get(12);
                nArray6[n3] = calendar.get(13);
                nArray7[n3] = timestamp.getNanos();
            }
            ++n3;
        }
        this.bindColTimestamp(l, n, nArray, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, byArray, byArray2, lArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterAtExec(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", len=" + n3);
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterAtExec(l, n, n2, n3, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterAtExec(long l, int n, int n2, int n3, int n4, byte[] byArray, int n5, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n3 + ", streamLength = " + n5 + " ,dataBufLen = " + n4);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterAtExec(l, n, n2, n3, n4, byArray, n5, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterBinary(long l, int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, long[] lArray) throws SQLException {
        int n3 = 0;
        n3 = byArray2.length < 8000 ? byArray2.length : 8000;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN binary parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2);
            JdbcOdbcObject.dumpByte(byArray, byArray.length);
        }
        byte[] byArray4 = new byte[1];
        this.bindInParameterBinary(l, n, OdbcDef.jdbcTypeToOdbc(n2), byArray, n3, byArray2, byArray3, byArray4, lArray);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterDate(long l, int n, Date date, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + date.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.bindInParameterDate(l, n, calendar.get(1), calendar.get(2) + 1, calendar.get(5), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterCalendarDate(long l, int n, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDate(l, n, calendar.get(1), calendar.get(2) + 1, calendar.get(5), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterDouble(long l, int n, int n2, int n3, double d, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter double (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", scale=" + n3 + ", rgbValue=" + d);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDouble(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, d, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterFloat(long l, int n, int n2, int n3, float f, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter float (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", scale=" + n3 + ", rgbValue=" + f);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterFloat(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, f, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterInteger(long l, int n, int n2, int n3, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter integer (SQLBindParameter), hStmt=" + l + ", ipar=" + n + "SQLtype=" + n2 + ", rgbValue=" + n3);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterInteger(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterNull(long l, int n, int n2, int n3, int n4, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN NULL parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterNull(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterString(long l, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + byArray);
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterString(l, n, OdbcDef.jdbcTypeToOdbc(n2), byArray, n3, n4, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterTime(long l, int n, Time time, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + time.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.bindInParameterTime(l, n, calendar.get(11), calendar.get(12), calendar.get(13), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterCalendarTime(long l, int n, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterTime(l, n, calendar.get(11), calendar.get(12), calendar.get(13), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterTimestamp(long l, int n, Timestamp timestamp, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + timestamp.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.bindInParameterTimestamp(l, n, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos(), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterCalendarTimestamp(long l, int n, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        int n2 = calendar.get(14) * 1000000;
        this.bindInParameterTimestamp(l, n, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), n2, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterBigint(long l, int n, int n2, int n3, long l2, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter bigint (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", scale=" + n3 + ", rgbValue=" + l2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterBigint(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, l2, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterString(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", prec=" + (byArray.length - 1) + ", scale=" + n3);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterString(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterDate(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT date parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", prec=" + (byArray.length - 1) + ", scale=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterDate(l, n, n2, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterTime(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", prec=" + (byArray.length - 1) + ", scale=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterTime(l, n, n2, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterTimestamp(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", scale=" + n3 + "length = " + (byArray.length - 1) + ", precision=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterTimestamp(l, n, n2, n3, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterString(long l, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterString(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterStr(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray, int n4) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterStr(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, byArray3, lArray, n4);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterBin(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray, int n4) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterBin(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, byArray3, lArray, n4);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterBinary(long l, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterBinary(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterFixed(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT parameter for fixed types (SQLBindParameter), hStmt=" + l + ", ipar=" + n + "SQLtype=" + n2 + ", maxLen=" + n3);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterFixed(l, n, OdbcDef.jdbcTypeToCType(n2), OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterTimeStamp(long l, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterTimeStamp(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameter(long l, int n, int n2, int n3, int n4, double d, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + d);
        }
        byte[] byArray2 = new byte[1];
        this.bindInOutParameter(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, d, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInOutParameterNull(long l, int n, int n2, int n3, int n4, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT NULL parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInOutParameterNull(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterStringArray(long l, int n, int n2, Object[] objectArray, int n3, int n4, int[] nArray) throws SQLException {
        Object object;
        int n5 = objectArray.length;
        Object[] objectArray2 = new Object[n5];
        if (n2 == 2 || n2 == 3) {
            int n6 = 0;
            while (n6 < n5) {
                if (objectArray[n6] != null) {
                    String string;
                    int n7;
                    object = (BigDecimal)objectArray[n6];
                    String string2 = ((BigDecimal)object).toString();
                    int n8 = string2.indexOf(46);
                    if (n8 != -1 && (n7 = (string = string2.substring(n8 + 1, string2.length())).length()) < n4) {
                        int n9 = 0;
                        while (n9 < n4 - n7) {
                            string2 = string2 + "0";
                            ++n9;
                        }
                    }
                    objectArray2[n6] = string2;
                }
                ++n6;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        object = new byte[(n3 + 1) * n5];
        this.bindInParameterStringArray(l, n, OdbcDef.jdbcTypeToOdbc(n2), objectArray2, (byte[])object, n3, n4, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterIntegerArray(long l, int n, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        int[] nArray2 = new int[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                nArray2[n3] = (Integer)objectArray[n3];
            }
            ++n3;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter Integer Array (SQLBindParameter), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterIntegerArray(l, n, OdbcDef.jdbcTypeToOdbc(n2), nArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterFloatArray(long l, int n, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        float[] fArray = new float[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                fArray[n3] = ((Float)objectArray[n3]).floatValue();
            }
            ++n3;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterFloatArray(l, n, OdbcDef.jdbcTypeToOdbc(n2), 0, fArray, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterDoubleArray(long l, int n, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        double[] dArray = new double[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                dArray[n3] = (Double)objectArray[n3];
            }
            ++n3;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterDoubleArray(l, n, OdbcDef.jdbcTypeToOdbc(n2), 0, dArray, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterDateArray(long l, int n, Object[] objectArray, int[] nArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterDateArray), hStmt=" + l + ", ipar=" + n);
        }
        int n2 = objectArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[11 * n2];
        if ((Date)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            Date date = null;
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray[n3] != null) {
                    date = (Date)objectArray[n3];
                    calendar.setTime(date);
                    nArray2[n3] = calendar.get(1);
                    nArray3[n3] = calendar.get(2) + 1;
                    nArray4[n3] = calendar.get(5);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (objectArray[n4] != null) {
                    Calendar calendar = (Calendar)objectArray[n4];
                    nArray2[n4] = calendar.get(1);
                    nArray3[n4] = calendar.get(2) + 1;
                    nArray4[n4] = calendar.get(5);
                }
                ++n4;
            }
        }
        this.bindInParameterDateArray(l, n, nArray2, nArray3, nArray4, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterTimeArray(long l, int n, Object[] objectArray, int[] nArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterTimeArray), hStmt=" + l + ", ipar=" + n);
        }
        int n2 = objectArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[9 * n2];
        if ((Time)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            Time time = null;
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray[n3] != null) {
                    time = (Time)objectArray[n3];
                    calendar.setTime(time);
                    nArray2[n3] = calendar.get(11);
                    nArray3[n3] = calendar.get(12);
                    nArray4[n3] = calendar.get(13);
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (objectArray[n4] != null) {
                    Calendar calendar = (Calendar)objectArray[n4];
                    nArray2[n4] = calendar.get(11);
                    nArray3[n4] = calendar.get(12);
                    nArray4[n4] = calendar.get(13);
                }
                ++n4;
            }
        }
        this.bindInParameterTimeArray(l, n, nArray2, nArray3, nArray4, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterTimestampArray(long l, int n, Object[] objectArray, int[] nArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN parameter timestamp (SQLBindParameterTimestampArray), hStmt=" + l + ", ipar=" + n);
        }
        int n2 = objectArray.length;
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        int[] nArray5 = new int[n2];
        int[] nArray6 = new int[n2];
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[30 * n2];
        if ((Timestamp)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            Timestamp timestamp = null;
            int n3 = 0;
            while (n3 < n2) {
                if (objectArray[n3] != null) {
                    timestamp = (Timestamp)objectArray[n3];
                    calendar.setTime(timestamp);
                    nArray2[n3] = calendar.get(1);
                    nArray3[n3] = calendar.get(2) + 1;
                    nArray4[n3] = calendar.get(5);
                    nArray5[n3] = calendar.get(11);
                    nArray6[n3] = calendar.get(12);
                    nArray7[n3] = calendar.get(13);
                    nArray8[n3] = timestamp.getNanos();
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (objectArray[n4] != null) {
                    Calendar calendar = (Calendar)objectArray[n4];
                    nArray2[n4] = calendar.get(1);
                    nArray3[n4] = calendar.get(2) + 1;
                    nArray4[n4] = calendar.get(5);
                    nArray5[n4] = calendar.get(11);
                    nArray6[n4] = calendar.get(12);
                    nArray7[n4] = calendar.get(13);
                    nArray8[n4] = calendar.get(14);
                }
                ++n4;
            }
        }
        this.bindInParameterTimestampArray(l, n, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterBinaryArray(long l, int n, int n2, Object[] objectArray, int n3, int[] nArray) throws SQLException {
        int n4 = objectArray.length;
        int n5 = 8000;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN binary parameter (SQLBindParameterBinaryArray), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n3 * n4];
        this.bindInParameterBinaryArray(l, n, OdbcDef.jdbcTypeToOdbc(n2), objectArray, n3, byArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindInParameterAtExecArray(long l, int n, int n2, int n3, int[] nArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding DATA_AT_EXEC Array parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", len=" + n3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[nArray.length];
        this.bindInParameterAtExecArray(l, n, n2, n3, byArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterNull(long l, int n, int n2, int n3, int n4, byte[] byArray, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT NULL parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.bindOutParameterNull(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterFixed(long l, int n, int n2, int n3, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", maxLen=" + n3);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterFixed(l, n, OdbcDef.jdbcTypeToCType(n2), OdbcDef.jdbcTypeToOdbc(n2), n3, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterBinary(long l, int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", SQLtype=" + n2 + ", precision=" + n3 + ", scale=" + n4 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterBinary(l, n, OdbcDef.jdbcTypeToOdbc(n2), n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterDate(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT date parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", prec=" + (byArray.length - 1) + ", scale=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterDate(l, n, n2, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterTime(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding IN OUT time parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", prec=" + (byArray.length - 1) + ", scale=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterTime(l, n, n2, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public void SQLBindOutParameterTimestamp(long l, int n, int n2, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Binding OUT time parameter (SQLBindParameter), hStmt=" + l + ", ipar=" + n + ", prec=" + (byArray.length - 1) + ", precision=" + n2);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterTimestamp(l, n, n2, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l);
        }
    }

    public String SQLBrowseConnect(long l, String string) throws SQLException, SQLWarning {
        String string2 = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connecting (SQLBrowseConnect), hDbc=" + l + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2000];
        byte[] byArray3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.browseConnect(l, byArray3, byArray2, byArray);
        if (byArray[0] == 99) {
            string2 = new String(byArray2);
            string2 = string2.trim();
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Attributes=" + string2);
        }
        return string2;
    }

    public void SQLCancel(long l) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Cancelling (SQLCancel), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        this.cancel(l, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public int SQLColAttributes(long l, int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        int n3 = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Column attributes (SQLColAttributes), hStmt=" + l + ", icol=" + n + ", type=" + n2);
        }
        byte[] byArray = new byte[1];
        n3 = this.colAttributes(l, n, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value (int)=" + n3);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n3);
                throw jdbcOdbcSQLWarning;
            }
        } else if (this.tracer.isTracing()) {
            this.tracer.trace("value (int)=" + n3);
        }
        return n3;
    }

    public String SQLColAttributesString(long l, int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Column attributes (SQLColAttributes), hStmt=" + l + ", icol=" + n + ", type=" + n2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.colAttributesString(l, n, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String();
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value (String)=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value (String)=" + string.trim());
        }
        return string.trim();
    }

    public void SQLColumns(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLColumns), hStmt=" + l + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.columns(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLColumnPrivileges(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLColumnPrivileges), hStmt=" + l + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.columnPrivileges(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public boolean SQLDescribeParamNullable(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        boolean bl = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter nullable (SQLDescribeParam), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        int n2 = this.describeParam(l, n, 4, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (n2 == 1) {
            bl = true;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("nullable=" + bl);
        }
        return bl;
    }

    public int SQLDescribeParamPrecision(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter precision (SQLDescribeParam), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        int n2 = this.describeParam(l, n, 2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("precision=" + n2);
        }
        return n2;
    }

    public int SQLDescribeParamScale(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter scale (SQLDescribeParam), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        int n2 = this.describeParam(l, n, 3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("scale=" + n2);
        }
        return n2;
    }

    public int SQLDescribeParamType(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter type (SQLDescribeParam), hStmt=" + l + ", ipar=" + n);
        }
        byte[] byArray = new byte[1];
        int n2 = this.describeParam(l, n, 1, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("type=" + n2);
        }
        return n2;
    }

    public void SQLDisconnect(long l) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Disconnecting (SQLDisconnect), hDbc=" + l);
        }
        Set set = hstmtMap.keySet();
        Object[] objectArray = set.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Long l2 = (Long)hstmtMap.get(objectArray[n2]);
            if (l2 != null && l2 == l) {
                this.SQLFreeStmt((Long)objectArray[n2], 1);
            }
            ++n2;
        }
        byte[] byArray = new byte[1];
        this.disconnect(l, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
    }

    public void SQLDriverConnect(long l, String string) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connecting (SQLDriverConnect), hDbc=" + l + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.driverConnect(l, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
    }

    public void SQLExecDirect(long l, String string, byte[] byArray) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Executing (SQLExecDirect), hStmt=" + l + ", szSqlStr=" + string);
        }
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.execDirect(l, byArray3, byArray2);
        if (byArray != null) {
            if (byArray2[0] != 0 && byArray2[0] != 100) {
                this.standardError(byArray2[0], 0L, 0L, l);
            }
            byArray[0] = byArray2[0];
        } else if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public boolean SQLExecute(long l) throws SQLException, SQLWarning {
        boolean bl = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Executing (SQLExecute), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        this.execute(l, byArray);
        if (byArray[0] == 99) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("SQL_NEED_DATA returned");
            }
            bl = true;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        return bl;
    }

    public boolean SQLFetch(long l) throws SQLException, SQLWarning {
        boolean bl = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Fetching (SQLFetch), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        this.fetch(l, byArray);
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
            if (this.tracer.isTracing()) {
                this.tracer.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        return bl;
    }

    public boolean SQLFetchScroll(long l, short s, int n) throws SQLException, SQLWarning {
        boolean bl = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Fetching (SQLFetchScroll), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        this.fetchScroll(l, s, n, byArray);
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
            if (this.tracer.isTracing()) {
                this.tracer.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        return bl;
    }

    public void SQLForeignKeys(long l, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("(SQLForeignKeys), hStmt=" + l + ", Pcatalog=" + string + ", Pschema=" + string2 + ", Ptable=" + string3 + ", Fcatalog=" + string4 + ", Fschema=" + string5 + ", Ftable=" + string6);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        char[] cArray5 = null;
        char[] cArray6 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        if (string5 != null) {
            cArray5 = string5.toCharArray();
        }
        if (string6 != null) {
            cArray6 = string6.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
            if (string5 != null) {
                byArray6 = this.CharsToBytes(this.charSet, cArray5);
            }
            if (string6 != null) {
                byArray7 = this.CharsToBytes(this.charSet, cArray6);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.foreignKeys(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray6, string5 == null, byArray7, string6 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLFreeConnect(long l) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Closing connection (SQLFreeConnect), hDbc=" + l);
        }
        byte[] byArray = new byte[1];
        this.freeConnect(l, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
    }

    public void SQLFreeEnv(long l) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Closing environment (SQLFreeEnv), hEnv=" + l);
        }
        byte[] byArray = new byte[1];
        this.freeEnv(l, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public void SQLFreeStmt(long l, int n) throws SQLException {
        byte[] byArray = new byte[1];
        Long l2 = new Long(l);
        if (n == 1) {
            if (hstmtMap.containsKey(l2)) {
                hstmtMap.remove(l2);
                this.freeStmt(l, n, byArray);
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Free statement (SQLFreeStmt), hStmt=" + l + ", fOption=" + n);
                }
            }
        } else {
            this.freeStmt(l, n, byArray);
            if (this.tracer.isTracing()) {
                this.tracer.trace("Free statement (SQLFreeStmt), hStmt=" + l + ", fOption=" + n);
            }
        }
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public long SQLGetConnectOption(long l, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection Option (SQLGetConnectOption), hDbc=" + l + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        long l2 = this.getConnectOption(l, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("option value (int)=" + l2);
        }
        return l2;
    }

    public String SQLGetConnectOptionString(long l, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Connection Option (SQLGetConnectOption), hDbc=" + l + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getConnectOptionString(l, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("option value (int)=" + string.trim());
        }
        return string.trim();
    }

    public String SQLGetCursorName(long l) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Cursor name (SQLGetCursorName), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getCursorName(l, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String();
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String(byArray2);
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + string.trim());
        }
        return string.trim();
    }

    public int SQLGetDataBinary(long l, int n, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        return this.SQLGetDataBinary(l, n, -2, byArray, byArray.length);
    }

    public int SQLGetDataBinary(long l, int n, int n2, byte[] byArray, int n3) throws SQLException, JdbcOdbcSQLWarning {
        int n4 = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get binary data (SQLGetData), hStmt=" + l + ", column=" + n + ", type=" + n2 + ", length=" + n3);
        }
        byte[] byArray2 = new byte[2];
        n4 = this.getDataBinary(l, n, n2, byArray, n3, byArray2);
        if (byArray2[0] == 100) {
            n4 = -1;
            byArray2[0] = 0;
        }
        if (byArray2[0] != 0) {
            try {
                this.standardError(byArray2[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    if (n4 == -1) {
                        this.tracer.trace("NULL");
                    } else if (this.tracer.isTracing()) {
                        this.tracer.trace("Bytes: " + n4);
                    }
                }
                jdbcOdbcSQLWarning.value = new Integer(n4);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            if (n4 == -1) {
                this.tracer.trace("NULL");
            } else if (this.tracer.isTracing()) {
                this.tracer.trace("Bytes: " + n4);
            }
        }
        return n4;
    }

    public Double SQLGetDataDouble(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get double data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        double d = this.getDataDouble(l, n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + d);
                    }
                    jdbcOdbcSQLWarning.value = new Double(d);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + d);
            }
            return new Double(d);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public Float SQLGetDataFloat(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get float data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        float f = (float)this.getDataFloat(l, n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + f);
                    }
                    jdbcOdbcSQLWarning.value = new Float(f);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + f);
            }
            return new Float(f);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public Integer SQLGetDataInteger(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get integer data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        int n2 = this.getDataInteger(l, n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("value=" + n2);
                    }
                    jdbcOdbcSQLWarning.value = new Integer(n2);
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("value=" + n2);
            }
            return new Integer(n2);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataString(long l, int n, int n2, boolean bl) throws SQLException, JdbcOdbcSQLWarning {
        byte[] byArray;
        byte[] byArray2;
        int n3;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get string data (SQLGetData), hStmt=" + l + ", column=" + n + ", maxLen=" + n2);
        }
        if ((n3 = this.getDataString(l, n, byArray2 = new byte[n2], byArray = new byte[2])) < 0) {
            byArray[1] = 1;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    char[] cArray = new char[n3];
                    String string = new String();
                    if (n3 > 0) {
                        try {
                            string = this.BytesToChars(this.charSet, byArray2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(unsupportedEncodingException);
                        }
                    } else {
                        try {
                            string = this.BytesToChars(this.charSet, byArray2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(unsupportedEncodingException);
                        }
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = bl ? string.trim() : string;
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            char[] cArray = new char[n3];
            if (n3 > 0) {
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
            } else {
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(string.trim());
            }
            if (bl) {
                return string.trim();
            }
            return string;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringDate(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get date data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[11];
        this.getDataStringDate(l, n, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(string.trim());
            }
            return string.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTime(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get time data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[9];
        this.getDataStringTime(l, n, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(string.trim());
            }
            return string.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTimestamp(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get timestamp data (SQLGetData), hStmt=" + l + ", column=" + n);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[30];
        this.getDataStringTimestamp(l, n, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (this.tracer.isTracing()) {
                        this.tracer.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (this.tracer.isTracing()) {
                        this.tracer.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (this.tracer.isTracing()) {
                this.tracer.trace(string.trim());
            }
            return string.trim();
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("NULL");
        }
        return null;
    }

    public int SQLGetInfo(long l, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info (SQLGetInfo), hDbc=" + l + ", fInfoType=" + s);
        }
        byte[] byArray = new byte[1];
        int n = this.getInfo(l, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" int value=" + n);
        }
        return n;
    }

    public int SQLGetInfoShort(long l, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info (SQLGetInfo), hDbc=" + l + ", fInfoType=" + s);
        }
        byte[] byArray = new byte[1];
        int n = this.getInfoShort(l, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" short value=" + n);
        }
        return n;
    }

    public String SQLGetInfoString(long l, short s) throws SQLException {
        return this.SQLGetInfoString(l, s, 300);
    }

    public String SQLGetInfoString(long l, short s, int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get connection info string (SQLGetInfo), hDbc=" + l + ", fInfoType=" + s + ", len=" + n);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n];
        this.getInfoString(l, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(string.trim());
        }
        return string.trim();
    }

    public long SQLGetStmtOption(long l, short s) throws SQLException, JdbcOdbcSQLWarning {
        long l2 = 0L;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get statement option (SQLGetStmtOption), hStmt=" + l + ", fOption=" + s);
        }
        byte[] byArray = new byte[1];
        l2 = this.getStmtOption(l, s, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + l2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(l2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + l2);
        }
        return l2;
    }

    public int SQLGetStmtAttr(long l, int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get Statement Attribute (SQLGetStmtAttr), hDbc=" + l + ", AttrType=" + n);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getStmtAttr(l, n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace(" int value=" + n2);
        }
        return n2;
    }

    public void SQLGetTypeInfo(long l, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get type info (SQLGetTypeInfo), hStmt=" + l + ", fSqlType=" + s);
        }
        byte[] byArray = new byte[1];
        this.getTypeInfo(l, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public boolean SQLMoreResults(long l) throws SQLException, SQLWarning {
        boolean bl = true;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get more results (SQLMoreResults), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        this.moreResults(l, byArray);
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("More results: " + bl);
        }
        return bl;
    }

    public String SQLNativeSql(long l, String string) throws SQLException {
        byte[] byArray = new byte[1];
        int n = 1024;
        if (string.length() * 4 > n && (n = string.length() * 4) > 32768) {
            n = 32768;
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Convert native SQL (SQLNativeSql), hDbc=" + l + ", nativeLen=" + n + ", SQL=" + string);
        }
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.nativeSql(l, byArray3, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
        String string2 = new String();
        try {
            string2 = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Native SQL=" + string2.trim());
        }
        return string2.trim();
    }

    public int SQLNumParams(long l) throws SQLException, JdbcOdbcSQLWarning {
        int n = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of parameter markers (SQLNumParams), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        n = this.numParams(l, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + n);
        }
        return n;
    }

    public int SQLNumResultCols(long l) throws SQLException, JdbcOdbcSQLWarning {
        int n = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of result columns (SQLNumResultCols), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        n = this.numResultCols(l, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + n);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + n);
        }
        return n;
    }

    public int SQLParamData(long l) throws SQLException, JdbcOdbcSQLWarning {
        int n = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get parameter number (SQLParamData), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        n = this.paramData(l, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n = -1;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter needing data=" + n);
        }
        return n;
    }

    public int SQLParamDataInBlock(long l, int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Get parameter number (SQLParamData in block-cursor), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        n2 = this.paramDataInBlock(l, n, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n2 = -1;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("Parameter needing data=" + n2);
        }
        return n2;
    }

    public void SQLPrepare(long l, String string) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Preparing (SQLPrepare), hStmt=" + l + ", szSqlStr=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.prepare(l, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLPutData(long l, byte[] byArray, int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Putting data (SQLPutData), hStmt=" + l + ", len=" + n);
        }
        byte[] byArray2 = new byte[1];
        this.putData(l, byArray, n, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l);
        }
    }

    public void SQLPrimaryKeys(long l, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Primary keys (SQLPrimaryKeys), hStmt=" + l + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[1];
        this.primaryKeys(l, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0L, 0L, l);
        }
    }

    public void SQLProcedures(long l, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Procedures (SQLProcedures), hStmt=" + l + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.procedures(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLProcedureColumns(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Procedure columns (SQLProcedureColumns), hStmt=" + l + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.procedureColumns(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public int SQLRowCount(long l) throws SQLException, JdbcOdbcSQLWarning {
        int n = 0;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Number of affected rows (SQLRowCount), hStmt=" + l);
        }
        byte[] byArray = new byte[1];
        n = this.rowCount(l, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("value=" + n);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (this.tracer.isTracing()) {
            this.tracer.trace("value=" + n);
        }
        return n;
    }

    public void SQLSetConnectOption(long l, short s, int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting connection option (SQLSetConnectOption), hDbc=" + l + ", fOption=" + s + ", vParam=" + n);
        }
        byte[] byArray = new byte[1];
        this.setConnectOption(l, s, n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
    }

    public void SQLSetConnectOption(long l, short s, String string) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting connection option string (SQLSetConnectOption), hDbc=" + l + ", fOption=" + s + ", vParam=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setConnectOptionString(l, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l, 0L);
        }
    }

    public void SQLSetCursorName(long l, String string) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting cursor name (SQLSetCursorName), hStmt=" + l + ", szCursor=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setCursorName(l, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLSetStmtOption(long l, short s, int n) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtOption), hStmt=" + l + ", fOption=" + s + ", vParam=" + n);
        }
        byte[] byArray = new byte[1];
        this.setStmtOption(l, s, n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLSetStmtAttr(long l, int n, int n2, int n3) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + l + ", fOption=" + n + ", vParam=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setStmtAttr(l, n, n2, n3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLSetStmtAttrPtr(long l, int n, int[] nArray, int n2, long[] lArray) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + l + ", fOption=" + n);
        }
        byte[] byArray = new byte[1];
        this.setStmtAttrPtr(l, n, nArray, n2, byArray, lArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public boolean SQLSetPos(long l, int n, int n2, int n3) throws SQLException {
        boolean bl = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("Setting row position (SQLSetPos), hStmt=" + l + ", operation = " + n2);
        }
        byte[] byArray = new byte[1];
        this.setPos(l, n, n2, n3, byArray);
        if (byArray[0] == 99) {
            if (this.tracer.isTracing()) {
                this.tracer.trace("SQL_NEED_DATA returned");
            }
            bl = true;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
        return bl;
    }

    public void SQLSpecialColumns(long l, short s, String string, String string2, String string3, int n, boolean bl) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Special columns (SQLSpecialColumns), hStmt=" + l + ", fColType=" + s + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", fScope=" + n + ", fNullable=" + bl);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.specialColumns(l, s, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, n, bl, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLStatistics(long l, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Statistics (SQLStatistics), hStmt=" + l + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", unique=" + bl + ", approximate=" + bl2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.statistics(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, bl, bl2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLTables(long l, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Tables (SQLTables), hStmt=" + l + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", types=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tables(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLTablePrivileges(long l, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Tables (SQLTables), hStmt=" + l + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tablePrivileges(l, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l);
        }
    }

    public void SQLTransact(long l, long l2, short s) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("Transaction (SQLTransact), hEnv=" + l + ", hDbc=" + l2 + ", fType=" + s);
        }
        byte[] byArray = new byte[1];
        this.transact(l, l2, s, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public native int bufferToInt(byte[] var1);

    public native float bufferToFloat(byte[] var1);

    public native double bufferToDouble(byte[] var1);

    public native long bufferToLong(byte[] var1);

    public native void convertDateString(byte[] var1, byte[] var2);

    public native void getDateStruct(byte[] var1, int var2, int var3, int var4);

    public native void convertTimeString(byte[] var1, byte[] var2);

    public native void getTimeStruct(byte[] var1, int var2, int var3, int var4);

    public native void getTimestampStruct(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    public native void convertTimestampString(byte[] var1, byte[] var2);

    public static native int getSQLLENSize();

    public static native void intToBytes(int var0, byte[] var1);

    public static native void longToBytes(long var0, byte[] var2);

    public static native void intTo4Bytes(int var0, byte[] var1);

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
        SQLWarning sQLWarning = jdbcOdbcSQLWarning;
        if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation dataTruncation = new DataTruncation(-1, false, true, 0, 0);
            sQLWarning = dataTruncation;
        }
        return sQLWarning;
    }

    protected native long allocConnect(long var1, byte[] var3);

    protected native long allocEnv(byte[] var1);

    protected native long allocStmt(long var1, byte[] var3);

    protected native void cancel(long var1, byte[] var3);

    protected native void bindColAtExec(long var1, int var3, int var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColBinary(long var1, int var3, Object[] var4, byte[] var5, int var6, byte[] var7, long[] var8, byte[] var9);

    protected native void bindColDate(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColDefault(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    protected native void bindColDouble(long var1, int var3, double[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColFloat(long var1, int var3, float[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColInteger(long var1, int var3, int[] var4, byte[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColString(long var1, int var3, int var4, Object[] var5, int var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTime(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTimestamp(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, byte[] var11, byte[] var12, long[] var13, byte[] var14);

    protected native void bindInParameterAtExec(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterAtExec(long var1, int var3, int var4, int var5, int var6, byte[] var7, int var8, byte[] var9, byte[] var10, long[] var11);

    protected native void bindInParameterBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterDate(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterDouble(long var1, int var3, int var4, int var5, double var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterFloat(long var1, int var3, int var4, int var5, double var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterBigint(long var1, int var3, int var4, int var5, long var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterInteger(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterString(long var1, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterTime(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterTimestamp(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, byte[] var11, byte[] var12, long[] var13);

    protected native void bindOutParameterString(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterDate(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInOutParameterTime(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInOutParameterString(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterStr(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9, int var10);

    protected native void bindInOutParameterBin(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9, int var10);

    protected native void bindInOutParameterBinary(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterFixed(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterTimeStamp(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameter(long var1, int var3, int var4, int var5, int var6, double var7, byte[] var9, byte[] var10, long[] var11);

    protected native void bindInOutParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterTimestamp(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterStringArray(long var1, int var3, int var4, Object[] var5, byte[] var6, int var7, int var8, int[] var9, byte[] var10);

    protected native void bindInParameterIntegerArray(long var1, int var3, int var4, int[] var5, int[] var6, byte[] var7);

    protected native void bindInParameterFloatArray(long var1, int var3, int var4, int var5, float[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDoubleArray(long var1, int var3, int var4, int var5, double[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDateArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimeArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimestampArray(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, byte[] var11, byte[] var12, int[] var13);

    protected native void bindInParameterBinaryArray(long var1, int var3, int var4, Object[] var5, int var6, byte[] var7, int[] var8, byte[] var9);

    protected native void bindInParameterAtExecArray(long var1, int var3, int var4, int var5, byte[] var6, int[] var7, byte[] var8);

    protected native void bindOutParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindOutParameterFixed(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindOutParameterBinary(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindOutParameterDate(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindOutParameterTime(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindOutParameterTimestamp(long var1, int var3, int var4, byte[] var5, byte[] var6, byte[] var7, long[] var8);

    protected native void browseConnect(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int colAttributes(long var1, int var3, int var4, byte[] var5);

    protected native void colAttributesString(long var1, int var3, int var4, byte[] var5, byte[] var6);

    protected native void columns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void columnPrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native int describeParam(long var1, int var3, int var4, byte[] var5);

    protected native void disconnect(long var1, byte[] var3);

    protected native void driverConnect(long var1, byte[] var3, byte[] var4);

    protected native int error(long var1, long var3, long var5, byte[] var7, byte[] var8, byte[] var9);

    protected native void execDirect(long var1, byte[] var3, byte[] var4);

    protected native void execute(long var1, byte[] var3);

    protected native void fetch(long var1, byte[] var3);

    protected native void fetchScroll(long var1, short var3, int var4, byte[] var5);

    protected native void foreignKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11, boolean var12, byte[] var13, boolean var14, byte[] var15);

    protected native void freeConnect(long var1, byte[] var3);

    protected native void freeEnv(long var1, byte[] var3);

    protected native void freeStmt(long var1, int var3, byte[] var4);

    protected native long getConnectOption(long var1, short var3, byte[] var4);

    protected native void getConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getCursorName(long var1, byte[] var3, byte[] var4);

    protected native long getStmtOption(long var1, short var3, byte[] var4);

    protected native int getStmtAttr(long var1, int var3, byte[] var4);

    protected native int getDataBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7);

    protected native double getDataDouble(long var1, int var3, byte[] var4);

    protected native double getDataFloat(long var1, int var3, byte[] var4);

    protected native int getDataInteger(long var1, int var3, byte[] var4);

    protected native int getDataString(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringDate(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTime(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTimestamp(long var1, int var3, byte[] var4, byte[] var5);

    protected native int getInfo(long var1, short var3, byte[] var4);

    protected native int getInfoShort(long var1, short var3, byte[] var4);

    protected native void getInfoString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getTypeInfo(long var1, short var3, byte[] var4);

    protected native void moreResults(long var1, byte[] var3);

    protected native void nativeSql(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int numParams(long var1, byte[] var3);

    protected native int numResultCols(long var1, byte[] var3);

    protected native int paramData(long var1, byte[] var3);

    protected native int paramDataInBlock(long var1, int var3, byte[] var4);

    protected native void prepare(long var1, byte[] var3, byte[] var4);

    protected native void primaryKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedures(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedureColumns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void putData(long var1, byte[] var3, int var4, byte[] var5);

    protected native int rowCount(long var1, byte[] var3);

    protected native void setConnectOption(long var1, short var3, int var4, byte[] var5);

    protected native void setConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void setCursorName(long var1, byte[] var3, byte[] var4);

    protected native void setStmtOption(long var1, short var3, int var4, byte[] var5);

    protected native void setStmtAttr(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void setStmtAttrPtr(long var1, int var3, int[] var4, int var5, byte[] var6, long[] var7);

    protected native void setPos(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void specialColumns(long var1, short var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, int var10, boolean var11, byte[] var12);

    protected native void statistics(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, boolean var9, boolean var10, byte[] var11);

    protected native void tables(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void tablePrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void transact(long var1, long var3, short var5, byte[] var6);

    protected static native void ReleaseStoredBytes(long var0, long var2);

    protected static native void ReleaseStoredChars(long var0, long var2);

    protected static native void ReleaseStoredIntegers(long var0, long var2);

    SQLException createSQLException(long l, long l2, long l3) {
        String string;
        Object object;
        boolean bl = false;
        Object object2 = null;
        Object object3 = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("ERROR - Generating SQLException...");
        }
        while (!bl) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[300];
            int n = this.error(l, l2, l3, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl = true;
                continue;
            }
            object = null;
            string = new String();
            String string2 = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray3);
                string2 = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            object = new SQLException(string.trim(), string2.trim(), n);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLException)object3).setNextException((SQLException)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General error";
            string = "S1000";
            if (this.tracer.isTracing()) {
                this.tracer.trace("ERROR - " + string + " " + (String)object);
            }
            object2 = new SQLException((String)object, string);
        }
        return object2;
    }

    SQLWarning createSQLWarning(long l, long l2, long l3) {
        String string;
        Object object;
        boolean bl = false;
        Object object2 = null;
        Object object3 = null;
        if (this.tracer.isTracing()) {
            this.tracer.trace("WARNING - Generating SQLWarning...");
        }
        while (!bl) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[300];
            int n = this.error(l, l2, l3, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl = true;
                continue;
            }
            object = null;
            string = new String();
            String string2 = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray3);
                string2 = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            object = new JdbcOdbcSQLWarning(string.trim(), string2.trim(), n);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLWarning)object3).setNextWarning((SQLWarning)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General warning";
            string = "S1000";
            if (this.tracer.isTracing()) {
                this.tracer.trace("WARNING - " + string + " " + (String)object);
            }
            object2 = new JdbcOdbcSQLWarning((String)object, string);
        }
        return object2;
    }

    void throwGenericSQLException() throws SQLException {
        String string = "General error";
        String string2 = "S1000";
        if (this.tracer.isTracing()) {
            this.tracer.trace("ERROR - " + string2 + " " + string);
        }
        throw new SQLException(string, string2);
    }

    void standardError(short s, long l, long l2, long l3) throws SQLException, SQLWarning {
        if (this.tracer.isTracing()) {
            this.tracer.trace("RETCODE = " + s);
        }
        switch (s) {
            case -1: {
                throw this.createSQLException(l, l2, l3);
            }
            case 1: {
                throw this.createSQLWarning(l, l2, l3);
            }
            case -2: {
                String string = "Invalid handle";
                if (this.tracer.isTracing()) {
                    this.tracer.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
            case 100: {
                String string = "No data found";
                if (this.tracer.isTracing()) {
                    this.tracer.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
        }
        this.throwGenericSQLException();
    }

    public JdbcOdbcTracer getTracer() {
        return this.tracer;
    }
}

