/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import com.ibm.jvm.ExtendedSystem;
import java.io.InputStream;
import sun.jdbc.odbc.JdbcOdbcInputStream;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPlatform;

public class JdbcOdbcBoundCol
extends JdbcOdbcObject {
    protected int type = 9999;
    protected int len = -1;
    protected JdbcOdbcInputStream inputStream;
    protected boolean isRenamed = false;
    protected String aliasName = null;
    protected int rowSetSize;
    protected Object colObj;
    protected Object[] columnWiseData;
    protected byte[] columnWiseLength;
    protected byte[] binaryData;
    protected int streamType;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    protected long pA1 = 0L;
    protected long pA2 = 0L;
    protected long pB1 = 0L;
    protected long pB2 = 0L;
    protected long pC1 = 0L;
    protected long pC2 = 0L;
    protected long pS1 = 0L;
    protected long pS2 = 0L;

    public void setInputStream(JdbcOdbcInputStream jdbcOdbcInputStream) {
        this.inputStream = jdbcOdbcInputStream;
    }

    public void closeInputStream() {
        if (this.inputStream != null) {
            this.inputStream.invalidate();
            this.inputStream = null;
        }
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setLength(int n) {
        this.len = n;
    }

    public int getLength() {
        return this.len;
    }

    public void setAliasName(String string) {
        this.aliasName = string;
        this.isRenamed = true;
    }

    public String mapAliasName(String string) {
        if (this.isRenamed) {
            return this.aliasName;
        }
        return string;
    }

    public void setColumnValue(Object object, int n) {
        try {
            if (this.type == -1 || this.type == -4) {
                if ((InputStream)object != null) {
                    this.setInputStream((JdbcOdbcInputStream)object);
                } else {
                    this.colObj = object;
                }
            } else {
                this.colObj = object;
            }
            this.setLength(n);
        }
        catch (Exception exception) {}
    }

    public Object getColumnValue() {
        if (this.type == -1 || this.type == -4) {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            return this.colObj;
        }
        return this.colObj;
    }

    public JdbcOdbcInputStream getInputStream() {
        return this.inputStream;
    }

    public void initStagingArea(int n) {
        this.rowSetSize = n;
        this.columnWiseData = new Object[this.rowSetSize + 1];
        this.columnWiseLength = new byte[(this.rowSetSize + 1) * JdbcOdbcPlatform.getLengthBufferSize()];
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(-6);
        int n2 = 0;
        while (n2 < (this.rowSetSize + 1) * byArray.length) {
            int n3 = 0;
            while (n3 < byArray.length) {
                this.columnWiseLength[n2 + n3] = byArray[n3];
                ++n3;
            }
            n2 += byArray.length;
        }
    }

    public void resetColumnToIgnoreData() {
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(-6);
        int n = 0;
        while (n < (this.rowSetSize + 1) * byArray.length) {
            int n2 = 0;
            while (n2 < byArray.length) {
                this.columnWiseLength[n + n2] = byArray[n2];
                ++n2;
            }
            n += byArray.length;
        }
    }

    public void setRowValues(int n, Object object, int n2) {
        int n3;
        this.columnWiseData[n] = object;
        byte[] byArray = JdbcOdbcPlatform.convertIntToByteArray(n2);
        int n4 = n3 = n * byArray.length;
        while (n4 < n3 + byArray.length) {
            this.columnWiseLength[n4] = byArray[n4 - n3];
            ++n4;
        }
    }

    public Object getRowValue(int n) {
        return this.columnWiseData[n];
    }

    public int getRowLenInd(int n) {
        return this.columnWiseLength[n];
    }

    public Object[] getRowValues() {
        return this.columnWiseData;
    }

    public byte[] getRowLengths() {
        return this.columnWiseLength;
    }

    public byte[] allocBindDataBuffer(int n) {
        this.binaryData = (byte[])ExtendedSystem.newArray(Byte.TYPE, n, this);
        return this.binaryData;
    }

    public void setStreamType(int n) {
        this.streamType = n;
    }

    public int getStreamType() {
        return this.streamType;
    }
}

