/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcConnection;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcTracer;
import sun.jdbc.odbc.ee.ConnectionHandler;
import sun.security.action.GetPropertyAction;

public class JdbcOdbcDriver
extends JdbcOdbcObject
implements JdbcOdbcDriverInterface {
    protected static JdbcOdbc OdbcApi;
    protected static long hEnv;
    protected static long hDbc;
    protected static Hashtable connectionList;
    protected int iTimeOut;
    protected static String nativePrefix;
    protected PrintWriter outWriter;
    protected JdbcOdbcTracer tracer = new JdbcOdbcTracer();
    private String newCharset;

    public JdbcOdbcDriver() {
        if (connectionList == null) {
            connectionList = new Hashtable();
        }
        nativePrefix = "";
    }

    protected void finalize() {
        if (OdbcApi.getTracer().isTracing()) {
            OdbcApi.getTracer().trace("Driver.finalize");
        }
        try {
            if (hDbc != 0L) {
                this.disconnect(hDbc);
                this.closeConnection(hDbc);
                hDbc = 0L;
            }
        }
        catch (SQLException sQLException) {}
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        this.newCharset = properties.getProperty("charSet", System.getProperty("file.encoding"));
        if (!this.initialize()) {
            return null;
        }
        JdbcOdbcConnection jdbcOdbcConnection = new JdbcOdbcConnection(OdbcApi, hEnv, this);
        int n = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        jdbcOdbcConnection.initialize(JdbcOdbcDriver.getSubName(string), properties, n);
        jdbcOdbcConnection.setURL(string);
        return jdbcOdbcConnection;
    }

    public synchronized Connection EEConnect(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.connect (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (hDbc != 0L) {
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        if (!this.initialize()) {
            return null;
        }
        ConnectionHandler connectionHandler = new ConnectionHandler(OdbcApi, hEnv, this);
        int n = this.getTimeOut() > 0 ? this.getTimeOut() : DriverManager.getLoginTimeout();
        connectionHandler.initialize(JdbcOdbcDriver.getSubName(string), properties, n);
        connectionHandler.setURL(string);
        return connectionHandler;
    }

    public int getTimeOut() {
        return this.iTimeOut;
    }

    public void setTimeOut(int n) {
        this.iTimeOut = n;
    }

    public PrintWriter getWriter() {
        return this.outWriter;
    }

    public void setWriter(PrintWriter printWriter) {
        this.outWriter = printWriter;
        this.tracer.setWriter(this.outWriter);
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = false;
        if (this.knownURL(string) && this.trusted()) {
            bl = true;
        }
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (this.tracer.isTracing()) {
            this.tracer.trace("*Driver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        String string2 = JdbcOdbcDriver.makeConnectionString(properties);
        String string3 = "";
        string3 = this.getConnectionAttributes(JdbcOdbcDriver.getSubName(string), string2);
        Hashtable hashtable = this.getAttributeProperties(string3);
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[hashtable.size()];
        int n = 0;
        while (n < hashtable.size()) {
            driverPropertyInfoArray[n] = (DriverPropertyInfo)hashtable.get(new Integer(n));
            ++n;
        }
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 1;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private boolean initialize() throws SQLException {
        boolean bl;
        block8: {
            bl = true;
            if (OdbcApi == null || this.newCharset != JdbcOdbcDriver.OdbcApi.charSet) {
                try {
                    OdbcApi = new JdbcOdbc(this.tracer, nativePrefix);
                    this.tracer = OdbcApi.getTracer();
                    JdbcOdbcDriver.OdbcApi.charSet = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
                }
                catch (Exception exception) {
                    if (OdbcApi.getTracer().isTracing()) {
                        OdbcApi.getTracer().trace("Unable to load JdbcOdbc library");
                    }
                    bl = false;
                }
            }
            if (this.getWriter() != null) {
                OdbcApi.getTracer().setWriter(this.getWriter());
            }
            if (hEnv != 0L) break block8;
            try {
                hEnv = OdbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (OdbcApi.getTracer().isTracing()) {
                    OdbcApi.getTracer().trace("Unable to allocate environment");
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean knownURL(String string) {
        String string2 = JdbcOdbcDriver.getProtocol(string);
        if (!string2.equalsIgnoreCase("jdbc")) {
            return false;
        }
        string2 = JdbcOdbcDriver.getSubProtocol(string);
        return string2.equalsIgnoreCase("odbc");
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n2 + 1, n);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private boolean trusted() {
        SecurityManager securityManager;
        boolean bl = false;
        if (this.tracer.isTracing()) {
            this.tracer.trace("JDBC to ODBC Bridge: Checking security");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            try {
                String string = (String)AccessController.doPrivileged(new GetPropertyAction("browser"));
                if (string != null && string.equalsIgnoreCase("Netscape Navigator")) {
                    nativePrefix = "Netscape_";
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                securityManager.checkWrite("JdbcOdbcSecurityCheck");
                bl = true;
            }
            catch (SecurityException securityException) {
                if (this.tracer.isTracing()) {
                    this.tracer.trace("Security check failed: " + securityException.getMessage());
                }
                bl = false;
            }
        } else {
            if (this.tracer.isTracing()) {
                this.tracer.trace("No SecurityManager present, assuming trusted application/applet");
            }
            bl = true;
        }
        bl = true;
        return bl;
    }

    public String getConnectionAttributes(String string, String string2) throws SQLException {
        String string3;
        String string4 = "DSN=" + string + string2;
        if (hDbc == 0L) {
            hDbc = this.allocConnection(hEnv);
        }
        if ((string3 = OdbcApi.SQLBrowseConnect(hDbc, string4)) == null) {
            string3 = "";
            this.disconnect(hDbc);
            this.closeConnection(hDbc);
            hDbc = 0L;
        }
        return string3;
    }

    public Hashtable getAttributeProperties(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Hashtable hashtable = new Hashtable();
        int n4 = string.length();
        while (n < n4) {
            boolean bl = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            n2 = string.indexOf(";", n);
            if (n2 < 0) {
                n2 = n4;
            }
            String string5 = string.substring(n, n2);
            int n5 = 0;
            int n6 = string5.indexOf(":", 0);
            int n7 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl = false;
                ++n5;
            }
            if (n6 > 0) {
                string2 = string5.substring(n5, n6);
            }
            if (n6 > 0 && n7 > 0) {
                string3 = string5.substring(n6 + 1, n7);
            }
            if (n7 > 0 && (string4 = string5.substring(n7 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = JdbcOdbcDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n3), driverPropertyInfo);
            ++n3;
            n = n2 + 1;
        }
        return hashtable;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration enumeration = properties.propertyNames();
        JdbcOdbcDriver.OdbcApi.charSet = properties.getProperty("charSet", (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding")));
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    protected static String[] listToArray(String var0) {
        var1_1 = null;
        var3_2 = new Hashtable();
        var4_3 = 0;
        var5_4 = 1;
        var6_5 = 1;
        var7_6 = var0.length();
        if (!var0.startsWith("{")) {
            return null;
        }
        if (var0.endsWith("}")) ** GOTO lbl19
        return null;
lbl-1000:
        // 1 sources

        {
            var6_5 = var0.indexOf(",", var5_4);
            if (var6_5 < 0) {
                var6_5 = var7_6 - 1;
            }
            var2_7 = var0.substring(var5_4, var6_5);
            var3_2.put(new Integer(var4_3), var2_7);
            ++var4_3;
            var5_4 = var6_5 + 1;
lbl19:
            // 2 sources

            ** while (var5_4 < var7_6)
        }
lbl20:
        // 1 sources

        var1_1 = new String[var4_3];
        var5_4 = 0;
        while (var5_4 < var4_3) {
            var1_1[var5_4] = var2_7 = (String)var3_2.get(new Integer(var5_4));
            ++var5_4;
        }
        return var1_1;
    }

    public long allocConnection(long l) throws SQLException {
        long l2 = 0L;
        l2 = OdbcApi.SQLAllocConnect(l);
        connectionList.put(new Long(l2), new Long(l));
        return l2;
    }

    public void closeConnection(long l) throws SQLException {
        OdbcApi.SQLFreeConnect(l);
        Long l2 = (Long)connectionList.remove(new Long(l));
        if (connectionList.size() == 0 && hEnv != 0L) {
            OdbcApi.SQLFreeEnv(hEnv);
            hEnv = 0L;
        }
    }

    public void disconnect(long l) throws SQLException {
        OdbcApi.SQLDisconnect(l);
    }

    static {
        block3: {
            JdbcOdbcTracer jdbcOdbcTracer = new JdbcOdbcTracer();
            if (jdbcOdbcTracer.isTracing()) {
                jdbcOdbcTracer.trace("JdbcOdbcDriver class loaded");
            }
            JdbcOdbcDriver jdbcOdbcDriver = new JdbcOdbcDriver();
            try {
                DriverManager.registerDriver(jdbcOdbcDriver);
            }
            catch (SQLException sQLException) {
                if (!jdbcOdbcTracer.isTracing()) break block3;
                jdbcOdbcTracer.trace("Unable to register driver");
            }
        }
    }
}

