/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock;
    private static long lastRefresh;
    private static final int TIMEOUT = 300000;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private LinkedList searchlist;
    private LinkedList nameservers;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$net$dns$ResolverConfigurationImpl;

    private LinkedList resolvconf(String string, int n, int n2) {
        LinkedList linkedList = new LinkedList();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/resolv.conf"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                int n3 = n;
                if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';' || !string2.startsWith(string) || (string3 = string2.substring(string.length())).length() == 0 || string3.charAt(0) != ' ' && string3.charAt(0) != '\t') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (string4.charAt(0) == '#' || string4.charAt(0) == ';') break;
                    linkedList.add(string4);
                    if (--n3 == 0) break;
                }
                if (--n2 == 0) break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        return linkedList;
    }

    private void loadConfig() {
        long l;
        if (!$assertionsDisabled && !Thread.holdsLock(lock)) {
            throw new AssertionError();
        }
        if (lastRefresh >= 0L && (l = System.currentTimeMillis()) - lastRefresh < 300000L) {
            return;
        }
        this.nameservers = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ResolverConfigurationImpl.this.resolvconf("nameserver", 1, 5);
            }
        });
        this.searchlist = this.getSearchList();
        lastRefresh = System.currentTimeMillis();
    }

    private LinkedList getSearchList() {
        LinkedList linkedList = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("search", 6, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        String string = ResolverConfigurationImpl.localDomain0();
        if (string != null && string.length() > 0) {
            linkedList = new LinkedList();
            linkedList.add(string);
            return linkedList;
        }
        linkedList = (LinkedList)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("domain", 1, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        String string2 = ResolverConfigurationImpl.fallbackDomain0();
        if (string2 != null && string2.length() > 0) {
            linkedList.add(string2);
        }
        return linkedList;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.nameservers.clone();
        }
    }

    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native String localDomain0();

    static native String fallbackDomain0();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$net$dns$ResolverConfigurationImpl == null ? (class$sun$net$dns$ResolverConfigurationImpl = ResolverConfigurationImpl.class$("sun.net.dns.ResolverConfigurationImpl")) : class$sun$net$dns$ResolverConfigurationImpl).desiredAssertionStatus();
        lock = new Object();
        lastRefresh = -1L;
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

