/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.NTLMAuthSequence;

class NTLMAuthentication
extends AuthenticationInfo {
    static char NTLM_AUTH = (char)78;
    static boolean supported;
    private String hostname;
    private static String defaultDomain;
    PasswordAuthentication pw;
    String username;
    String ntdomain;
    String password;

    private void init0() {
        this.hostname = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string;
                try {
                    string = InetAddress.getLocalHost().getHostName().toUpperCase();
                }
                catch (UnknownHostException unknownHostException) {
                    string = "localhost";
                }
                return string;
            }
        });
        int n = this.hostname.indexOf(46);
        if (n != -1) {
            this.hostname = this.hostname.substring(0, n);
        }
    }

    public NTLMAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', NTLM_AUTH, uRL, "");
        this.init(passwordAuthentication);
    }

    private void init(PasswordAuthentication passwordAuthentication) {
        this.pw = passwordAuthentication;
        if (passwordAuthentication != null) {
            String string = passwordAuthentication.getUserName();
            int n = string.indexOf(92);
            if (n == -1) {
                this.username = string;
                this.ntdomain = defaultDomain;
            } else {
                this.ntdomain = string.substring(0, n).toUpperCase();
                this.username = string.substring(n + 1);
            }
            this.password = new String(passwordAuthentication.getPassword());
        } else {
            this.username = null;
            this.ntdomain = null;
            this.password = null;
        }
        this.init0();
    }

    public NTLMAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        super(bl ? (char)'p' : 's', NTLM_AUTH, string, n, "");
        this.init(passwordAuthentication);
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    static boolean isSupported() {
        return supported;
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            if (!supported) {
                return false;
            }
            NTLMAuthSequence nTLMAuthSequence = (NTLMAuthSequence)httpURLConnection.authObj;
            if (nTLMAuthSequence == null) {
                nTLMAuthSequence = new NTLMAuthSequence(this.username, this.password, this.ntdomain);
                httpURLConnection.authObj = nTLMAuthSequence;
            }
            String string2 = "NTLM " + nTLMAuthSequence.getAuthHeader(string.length() > 6 ? string.substring(5) : null);
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }

    static {
        defaultDomain = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.name");
                String string2 = System.getProperty("os.arch");
                boolean bl = System.getProperty("com.ibm.NONTLM") != null;
                boolean bl2 = supported = string.toUpperCase().startsWith("WINDOWS") && string2.equals("x86") && !bl;
                if (!supported) {
                    return null;
                }
                String string3 = System.getProperty("http.auth.ntlm.domain");
                if (string3 == null) {
                    return "domain";
                }
                return string3;
            }
        });
    }
}

