/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import sun.reflect.BootstrapConstructorAccessorImpl;
import sun.reflect.ConstructorAccessor;
import sun.reflect.DelegatingConstructorAccessorImpl;
import sun.reflect.DelegatingMethodAccessorImpl;
import sun.reflect.FieldAccessor;
import sun.reflect.FieldAccessorGenerator;
import sun.reflect.InstantiationExceptionConstructorAccessorImpl;
import sun.reflect.LangReflectAccess;
import sun.reflect.MethodAccessor;
import sun.reflect.MethodAccessorGenerator;
import sun.reflect.NativeConstructorAccessorImpl;
import sun.reflect.NativeMethodAccessorImpl;
import sun.reflect.Reflection;
import sun.reflect.SerializationConstructorAccessorImpl;
import sun.reflect.UnsafeFieldAccessorFactory;

public class ReflectionFactory {
    private static boolean initted = false;
    private static boolean useUnsafeFieldAccessors = true;
    private static Permission reflectionFactoryAccessPerm = new RuntimePermission("reflectionFactoryAccess");
    private static ReflectionFactory soleInstance = new ReflectionFactory();
    private static volatile LangReflectAccess langReflectAccess;
    private static boolean noInflation;
    private static int inflationThreshold;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$sun$reflect$ConstructorAccessorImpl;

    private ReflectionFactory() {
    }

    public static ReflectionFactory getReflectionFactory() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(reflectionFactoryAccessPerm);
        }
        return soleInstance;
    }

    public void setLangReflectAccess(LangReflectAccess langReflectAccess) {
        ReflectionFactory.langReflectAccess = langReflectAccess;
    }

    public FieldAccessor newFieldAccessor(Field field) {
        ReflectionFactory.checkInitted();
        if (useUnsafeFieldAccessors && !Modifier.isVolatile(field.getModifiers())) {
            return UnsafeFieldAccessorFactory.newFieldAccessor(field);
        }
        return new FieldAccessorGenerator().generate(field.getDeclaringClass(), field.getName(), field.getType(), field.getModifiers());
    }

    public MethodAccessor newMethodAccessor(Method method) {
        ReflectionFactory.checkInitted();
        if (noInflation) {
            return new MethodAccessorGenerator().generateMethod(method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes(), method.getModifiers());
        }
        NativeMethodAccessorImpl nativeMethodAccessorImpl = new NativeMethodAccessorImpl(method);
        DelegatingMethodAccessorImpl delegatingMethodAccessorImpl = new DelegatingMethodAccessorImpl(nativeMethodAccessorImpl);
        nativeMethodAccessorImpl.setParent(delegatingMethodAccessorImpl);
        return delegatingMethodAccessorImpl;
    }

    public ConstructorAccessor newConstructorAccessor(Constructor constructor) {
        ReflectionFactory.checkInitted();
        Class clazz = constructor.getDeclaringClass();
        if (Modifier.isAbstract(clazz.getModifiers())) {
            return new InstantiationExceptionConstructorAccessorImpl(null);
        }
        if (clazz == (class$java$lang$Class == null ? (class$java$lang$Class = ReflectionFactory.class$("java.lang.Class")) : class$java$lang$Class)) {
            return new InstantiationExceptionConstructorAccessorImpl("Can not instantiate java.lang.Class");
        }
        if (Reflection.isSubclassOf(clazz, class$sun$reflect$ConstructorAccessorImpl == null ? (class$sun$reflect$ConstructorAccessorImpl = ReflectionFactory.class$("sun.reflect.ConstructorAccessorImpl")) : class$sun$reflect$ConstructorAccessorImpl)) {
            return new BootstrapConstructorAccessorImpl(constructor);
        }
        if (noInflation) {
            return new MethodAccessorGenerator().generateConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers());
        }
        NativeConstructorAccessorImpl nativeConstructorAccessorImpl = new NativeConstructorAccessorImpl(constructor);
        DelegatingConstructorAccessorImpl delegatingConstructorAccessorImpl = new DelegatingConstructorAccessorImpl(nativeConstructorAccessorImpl);
        nativeConstructorAccessorImpl.setParent(delegatingConstructorAccessorImpl);
        return delegatingConstructorAccessorImpl;
    }

    public Field newField(Class clazz, String string, Class clazz2, int n, long l) {
        return ReflectionFactory.langReflectAccess().newField(clazz, string, clazz2, n, l);
    }

    public Method newMethod(Class clazz, String string, Class[] classArray, Class clazz2, Class[] classArray2, int n, long l) {
        return ReflectionFactory.langReflectAccess().newMethod(clazz, string, classArray, clazz2, classArray2, n, l);
    }

    public Constructor newConstructor(Class clazz, Class[] classArray, Class[] classArray2, int n, long l) {
        return ReflectionFactory.langReflectAccess().newConstructor(clazz, classArray, classArray2, n, l);
    }

    public MethodAccessor getMethodAccessor(Method method) {
        return ReflectionFactory.langReflectAccess().getMethodAccessor(method);
    }

    public void setMethodAccessor(Method method, MethodAccessor methodAccessor) {
        ReflectionFactory.langReflectAccess().setMethodAccessor(method, methodAccessor);
    }

    public ConstructorAccessor getConstructorAccessor(Constructor constructor) {
        return ReflectionFactory.langReflectAccess().getConstructorAccessor(constructor);
    }

    public void setConstructorAccessor(Constructor constructor, ConstructorAccessor constructorAccessor) {
        ReflectionFactory.langReflectAccess().setConstructorAccessor(constructor, constructorAccessor);
    }

    public Method copyMethod(Method method) {
        return ReflectionFactory.langReflectAccess().copyMethod(method);
    }

    public Field copyField(Field field) {
        return ReflectionFactory.langReflectAccess().copyField(field);
    }

    public Constructor copyConstructor(Constructor constructor) {
        return ReflectionFactory.langReflectAccess().copyConstructor(constructor);
    }

    public Constructor newConstructorForSerialization(Class clazz, Constructor constructor) {
        if (constructor.getDeclaringClass() == clazz) {
            return constructor;
        }
        SerializationConstructorAccessorImpl serializationConstructorAccessorImpl = new MethodAccessorGenerator().generateSerializationConstructor(clazz, constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), constructor.getDeclaringClass());
        Constructor constructor2 = this.newConstructor(constructor.getDeclaringClass(), constructor.getParameterTypes(), constructor.getExceptionTypes(), constructor.getModifiers(), ReflectionFactory.langReflectAccess().getConstructorSlot(constructor));
        this.setConstructorAccessor(constructor2, serializationConstructorAccessorImpl);
        return constructor2;
    }

    static int inflationThreshold() {
        return inflationThreshold;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.out == null) {
                    return null;
                }
                String string = System.getProperty("sun.reflect.useGeneratedFieldAccessors");
                if (string != null && string.equals("true")) {
                    useUnsafeFieldAccessors = false;
                }
                if ((string = System.getProperty("sun.reflect.noInflation")) != null && string.equals("true")) {
                    noInflation = true;
                }
                if ((string = System.getProperty("sun.reflect.inflationThreshold")) != null) {
                    try {
                        inflationThreshold = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw (RuntimeException)new RuntimeException("Unable to parse property sun.reflect.inflationThreshold").initCause(numberFormatException);
                    }
                }
                initted = true;
                return null;
            }
        });
    }

    private static LangReflectAccess langReflectAccess() {
        if (langReflectAccess == null) {
            Modifier.isPublic(1);
        }
        return langReflectAccess;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        noInflation = false;
        inflationThreshold = 15;
    }

    public static final class GetReflectionFactoryAction
    implements PrivilegedAction {
        public Object run() {
            return ReflectionFactory.getReflectionFactory();
        }
    }
}

