/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.rmi.ConnectIOException;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.tcp.ConnectionAcceptor;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetLongAction;

public class TCPChannel
implements Channel {
    private final TCPEndpoint ep;
    private final TCPTransport tr;
    private final List freeList = new ArrayList();
    private Reaper reaper = null;
    private boolean usingMultiplexer = false;
    private ConnectionMultiplexer multiplexer = null;
    private ConnectionAcceptor acceptor;
    private AccessControlContext okContext;
    private WeakHashMap authcache;
    private SecurityManager cacheSecurityManager = null;
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.connectionTimeout", 15000L));
    private static final int handshakeTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.handshakeTimeout", 60000));
    private static final int responseTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.responseTimeout", 0));

    TCPChannel(TCPTransport tCPTransport, TCPEndpoint tCPEndpoint) {
        this.tr = tCPTransport;
        this.ep = tCPEndpoint;
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    private void checkConnectPermission() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (securityManager != this.cacheSecurityManager) {
            this.okContext = null;
            this.authcache = new WeakHashMap();
            this.cacheSecurityManager = securityManager;
        }
        AccessControlContext accessControlContext = AccessController.getContext();
        if (this.okContext == null || !this.okContext.equals(accessControlContext) && !this.authcache.containsKey(accessControlContext)) {
            securityManager.checkConnect(this.ep.getHost(), this.ep.getPort());
            this.authcache.put(accessControlContext, new SoftReference(accessControlContext));
        }
        this.okContext = accessControlContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection newConnection() throws RemoteException {
        TCPConnection tCPConnection;
        do {
            tCPConnection = null;
            List list = this.freeList;
            synchronized (list) {
                int n = this.freeList.size() - 1;
                if (n >= 0) {
                    this.checkConnectPermission();
                    tCPConnection = (TCPConnection)this.freeList.get(n);
                    this.freeList.remove(n);
                }
            }
            if (tCPConnection == null) continue;
            if (!tCPConnection.isDead()) {
                TCPTransport.tcpLog.log(Log.BRIEF, "reuse connection");
                return tCPConnection;
            }
            this.free(tCPConnection, false);
        } while (tCPConnection != null);
        return this.createConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection createConnection() throws RemoteException {
        TCPConnection tCPConnection;
        TCPTransport.tcpLog.log(Log.BRIEF, "create connection");
        if (!this.usingMultiplexer) {
            Socket socket = this.ep.newSocket();
            tCPConnection = new TCPConnection(this, socket);
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(tCPConnection.getOutputStream());
                this.writeTransportHeader(dataOutputStream);
                if (!tCPConnection.isReusable()) {
                    dataOutputStream.writeByte(76);
                }
                dataOutputStream.writeByte(75);
                dataOutputStream.flush();
                int n = 0;
                try {
                    n = socket.getSoTimeout();
                    socket.setSoTimeout(handshakeTimeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DataInputStream dataInputStream = new DataInputStream(tCPConnection.getInputStream());
                byte by = dataInputStream.readByte();
                if (by != 78) {
                    throw new ConnectIOException(by == 79 ? "JRMP StreamProtocol not supported by server" : "non-JRMP server at remote endpoint");
                }
                String string = dataInputStream.readUTF();
                int n2 = dataInputStream.readInt();
                if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                    TCPTransport.tcpLog.log(Log.VERBOSE, "server suggested " + string + ":" + n2);
                }
                TCPEndpoint.setLocalHost(string);
                TCPEndpoint tCPEndpoint = TCPEndpoint.getLocalEndpoint(0, this.ep.getClientSocketFactory(), this.ep.getServerSocketFactory());
                dataOutputStream.writeUTF(tCPEndpoint.getHost());
                dataOutputStream.writeInt(tCPEndpoint.getPort());
                if (TCPTransport.tcpLog.isLoggable(Log.VERBOSE)) {
                    TCPTransport.tcpLog.log(Log.VERBOSE, "using " + tCPEndpoint.getHost() + ":" + tCPEndpoint.getPort());
                }
                try {
                    socket.setSoTimeout(n != 0 ? n : responseTimeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                if (iOException instanceof RemoteException) {
                    throw (RemoteException)iOException;
                }
                throw new ConnectIOException("error during JRMP connection establishment", iOException);
            }
        } else {
            try {
                tCPConnection = this.multiplexer.openConnection();
            }
            catch (IOException iOException) {
                TCPChannel tCPChannel = this;
                synchronized (tCPChannel) {
                    this.usingMultiplexer = false;
                    this.multiplexer = null;
                }
                throw new ConnectIOException("error opening virtual connection over multiplexed connection", iOException);
            }
        }
        return tCPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Connection connection, boolean bl) {
        if (connection == null) {
            return;
        }
        if (bl && connection.isReusable()) {
            long l = System.currentTimeMillis();
            TCPTransport.tcpLog.log(Log.BRIEF, "reuse connection");
            List list = this.freeList;
            synchronized (list) {
                this.freeList.add(connection);
                if (this.reaper == null) {
                    TCPTransport.tcpLog.log(Log.BRIEF, "create reaper");
                    this.reaper = new Reaper();
                    Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this.reaper, "ConnectionExpiration-" + this.ep.toString(), true));
                    thread.start();
                }
            }
            ((TCPConnection)connection).setLastUseTime(l);
            ((TCPConnection)connection).setExpiration(l + idleTimeout);
        } else {
            TCPTransport.tcpLog.log(Log.BRIEF, "close connection");
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeTransportHeader(DataOutputStream dataOutputStream) throws RemoteException {
        try {
            DataOutputStream dataOutputStream2 = new DataOutputStream(dataOutputStream);
            dataOutputStream2.writeInt(1246907721);
            dataOutputStream2.writeShort(2);
        }
        catch (IOException iOException) {
            throw new ConnectIOException("error writing JRMP transport header", iOException);
        }
    }

    synchronized void useMultiplexer(ConnectionMultiplexer connectionMultiplexer) {
        this.multiplexer = connectionMultiplexer;
        this.usingMultiplexer = true;
    }

    void acceptMultiplexConnection(Connection connection) {
        if (this.acceptor == null) {
            this.acceptor = new ConnectionAcceptor(this.tr);
            this.acceptor.startNewAcceptor();
        }
        this.acceptor.accept(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedCache() {
        Object[] objectArray;
        List list = this.freeList;
        synchronized (list) {
            objectArray = this.freeList.toArray();
            this.freeList.clear();
        }
        int n = objectArray.length;
        while (--n >= 0) {
            Connection connection = (Connection)objectArray[n];
            objectArray[n] = null;
            try {
                connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean freeCachedConnections() {
        List list = this.freeList;
        synchronized (list) {
            int n = this.freeList.size();
            if (n > 0) {
                long l = System.currentTimeMillis();
                ListIterator listIterator = this.freeList.listIterator(n);
                while (listIterator.hasPrevious()) {
                    TCPConnection tCPConnection = (TCPConnection)listIterator.previous();
                    if (!tCPConnection.expired(l)) continue;
                    TCPTransport.tcpLog.log(Log.VERBOSE, "connection timeout expired");
                    try {
                        tCPConnection.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    listIterator.remove();
                }
            }
            if (this.freeList.isEmpty()) {
                this.reaper = null;
                return false;
            }
            return true;
        }
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        public void run() {
            do {
                try {
                    Thread.sleep(idleTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TCPTransport.tcpLog.log(Log.VERBOSE, "wake up");
            } while (TCPChannel.this.freeCachedConnections());
            TCPTransport.tcpLog.log(Log.VERBOSE, "exit");
        }
    }
}

