/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Vector;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetPropertyAction;

public class TCPTransport
extends Transport
implements Runnable {
    static final int logLevel = LogStream.parseLevel(TCPTransport.getLogLevel());
    static String threadPooling = (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.connectionPool"));
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", logLevel);
    private static int threadNum = 0;
    private static final ThreadLocal threadConnectionHandler = new ThreadLocal();
    private final LinkedList epList;
    private ServerSocket server = null;
    private final Map channelTable = new HashMap(11);
    private Vector pool = new Vector();
    private static int startThreadNum = 0;
    static final RMISocketFactory defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
    private static final int connectionReadTimeout = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    private transient long acceptFailureTime = 0L;
    private transient int acceptFailureCount;

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"));
    }

    TCPTransport(LinkedList linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shedConnectionCaches() {
        int n;
        TCPChannel[] tCPChannelArray;
        Map map = this.channelTable;
        synchronized (map) {
            tCPChannelArray = new TCPChannel[this.channelTable.size()];
            Iterator iterator = this.channelTable.values().iterator();
            n = 0;
            while (iterator.hasNext()) {
                tCPChannelArray[n] = (TCPChannel)iterator.next();
                ++n;
            }
        }
        while (--n >= 0) {
            tCPChannelArray[n].shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel = (TCPChannel)this.channelTable.remove(endpoint);
                if (tCPChannel != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    public void exportObject(Target target) throws RemoteException {
        this.listen();
        target.setExportedTransport(this);
        super.exportObject(target);
    }

    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList linkedList = this.epList;
        synchronized (linkedList) {
            return (TCPEndpoint)this.epList.getLast();
        }
    }

    private synchronized void listen() throws RemoteException {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this, "TCP Accept-" + n, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private synchronized boolean continueAfterAcceptFailure(Throwable throwable) {
        boolean bl;
        RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
        if (rMIFailureHandler != null) {
            bl = throwable instanceof Exception ? rMIFailureHandler.failure((Exception)throwable) : rMIFailureHandler.failure(new InvocationTargetException(throwable));
        } else {
            long l = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || l - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = l;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
            TCPTransport.tcpLog.log(Log.BRIEF, "listening on port " + this.getEndpoint().getPort());
        }
        while (true) {
            if ((var1_1 = this.server) == null) {
                return;
            }
            var2_2 /* !! */  = null;
            try {
                var3_3 = var1_1.accept();
                var4_4 = var3_3.getInetAddress();
                v0 = var5_7 = var4_4 != null ? var4_4.getHostAddress() : "0.0.0.0";
                if (TCPTransport.threadPooling == null) {
                    var6_11 = (Thread)AccessController.doPrivileged(new NewThreadAction(new ConnectionHandler(var3_3, var5_7), "TCP Connection(" + ++TCPTransport.threadNum + ")-" + var5_7, true, true));
                    var6_11.start();
                    continue;
                }
                this.handleConnection(var3_3, var5_7);
                continue;
            }
            catch (IOException var4_6) {
                var2_2 /* !! */  = var4_6;
            }
            catch (RuntimeException var5_10) {
                var2_2 /* !! */  = var5_10;
            }
            catch (Error var6_14) {
                var2_2 /* !! */  = var6_14;
            }
            finally {
                if (var2_2 /* !! */  == null) continue;
                if (!(var2_2 /* !! */  instanceof SecurityException)) {
                    try {
                        TCPEndpoint.shedConnectionCaches();
                    }
                    catch (OutOfMemoryError var5_9) {
                    }
                    catch (Exception var6_12) {}
                }
                if (var2_2 /* !! */  instanceof IOException || var2_2 /* !! */  instanceof OutOfMemoryError || var2_2 /* !! */  instanceof NoClassDefFoundError || var2_2 /* !! */  instanceof MissingResourceException || var2_2 /* !! */  instanceof SecurityException) {
                    if (!this.continueAfterAcceptFailure(var2_2 /* !! */ )) ** break;
                    continue;
                    return;
                }
                if (var2_2 /* !! */  instanceof RuntimeException) {
                    throw (RuntimeException)var2_2 /* !! */ ;
                }
                throw (Error)var2_2 /* !! */ ;
            }
            break;
        }
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection var1_1, boolean var2_2) {
        block20: {
            block21: {
                var3_3 = this.getEndpoint().getPort();
                try {
                    try {
                        var4_4 = new DataInputStream(var1_1.getInputStream());
                        block14: do {
                            if ((var5_6 = var4_4.read()) == -1) {
                                if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                    TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") connection closed");
                                }
                                break block20;
                            }
                            if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                                TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") op = " + var5_6);
                            }
                            switch (var5_6) {
                                case 80: {
                                    var6_7 = new StreamRemoteCall(var1_1);
                                    if (this.serviceCall(var6_7)) continue block14;
                                    var9_9 = null;
                                    break block21;
                                }
                                case 82: {
                                    var7_8 = new DataOutputStream(var1_1.getOutputStream());
                                    var7_8.writeByte(83);
                                    var1_1.releaseOutputStream();
                                    break;
                                }
                                case 84: {
                                    DGCAckHandler.received(UID.read(var4_4));
                                    break;
                                }
                                default: {
                                    throw new IOException("unknown transport op " + var5_6);
                                }
                            }
                        } while (var2_2);
                        break block20;
                    }
                    catch (IOException var4_5) {
                        if (TCPTransport.tcpLog.isLoggable(Log.BRIEF)) {
                            TCPTransport.tcpLog.log(Log.BRIEF, "(port " + var3_3 + ") exception: ", var4_5);
                        }
                        var9_11 = null;
                        try {
                            var1_1.close();
                            return;
                        }
                        catch (IOException var10_15) {
                            return;
                        }
                    }
                }
                catch (Throwable var8_17) {
                    var9_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl45:
                    // 1 sources

                    var1_1.close();
                    throw var8_17;
lbl47:
                    // 1 sources

                    catch (IOException var10_16) {
                        // empty catch block
                    }
                    throw var8_17;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 340->349)] { 
lbl52:
            // 1 sources

            var1_1.close();
            return;
lbl54:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
            return;
        }
        var9_10 = null;
        try {}
        catch (IOException var10_14) {}
        var1_1.close();
        return;
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = (ConnectionHandler)threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    ConnectionHandler getHandler() {
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        ConnectionHandler connectionHandler = null;
        Vector vector = this.pool;
        // MONITORENTER : vector
        if (this.pool.size() > 0) {
            connectionHandler = (ConnectionHandler)this.pool.lastElement();
            this.pool.removeElementAt(this.pool.size() - 1);
        }
        // MONITOREXIT : vector
        if (connectionHandler != null) {
            if (logLevel < 10) return connectionHandler;
            LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: reusing a connection thread from pool");
            return connectionHandler;
        }
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport(" + tCPEndpoint.getPort() + ").run: creating a new connection thread");
        }
        connectionHandler = new ConnectionHandler();
        Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(connectionHandler, String.valueOf(++startThreadNum), true, true));
        thread.start();
        Thread thread2 = thread;
        // MONITORENTER : thread2
        while (!connectionHandler.threadStarted) {
            try {
                thread.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : thread2
        return connectionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConnection(Socket socket, String string) {
        ConnectionHandler connectionHandler;
        ConnectionHandler connectionHandler2 = connectionHandler = this.getHandler();
        synchronized (connectionHandler2) {
            connectionHandler.initThread(socket, string);
            connectionHandler.notify();
        }
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private WeakHashMap authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;
        private boolean threadStarted = false;
        String name;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        ConnectionHandler() {
        }

        void initThread(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
            this.name = "TCP Connection(" + ++threadNum + ")-" + string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleRequest() {
            Object object;
            TCPEndpoint tCPEndpoint = TCPTransport.this.getEndpoint();
            int n = tCPEndpoint.getPort();
            threadConnectionHandler.set(this);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connectionReadTimeout > 0) {
                    this.socket.setSoTimeout(connectionReadTimeout);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object object2 = this.socket.getInputStream();
                object = ((InputStream)object2).markSupported() ? object2 : new BufferedInputStream((InputStream)object2);
                ((InputStream)object).mark(4);
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                int n2 = dataInputStream.readInt();
                if (n2 == 1347375956) {
                    tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                    ((InputStream)object).reset();
                    try {
                        this.socket = new HttpReceiveSocket(this.socket, (InputStream)object, null);
                        this.remoteHost = "0.0.0.0";
                        object2 = this.socket.getInputStream();
                        object = new BufferedInputStream((InputStream)object2);
                        dataInputStream = new DataInputStream((InputStream)object);
                        n2 = dataInputStream.readInt();
                    }
                    catch (IOException iOException) {
                        throw new RemoteException("Error HTTP-unwrapping call", iOException);
                    }
                }
                short s = dataInputStream.readShort();
                if (n2 != 1246907721 || s != 2) {
                    TCPTransport.closeSocket(this.socket);
                    return;
                }
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                int n3 = this.socket.getPort();
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + n3 + "]");
                }
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 76: {
                        TCPEndpoint tCPEndpoint2 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint2);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, (InputStream)object, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, false);
                        return;
                    }
                    case 75: {
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") " + "suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        String string = dataInputStream.readUTF();
                        int n4 = dataInputStream.readInt();
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + string + ":" + n4);
                        }
                        TCPEndpoint tCPEndpoint3 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint3);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, (InputStream)object, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, true);
                        return;
                    }
                    case 77: {
                        ConnectionMultiplexer connectionMultiplexer;
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") accepting multiplex protocol");
                        }
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        TCPEndpoint tCPEndpoint4 = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + tCPEndpoint4.getHost() + ":" + tCPEndpoint4.getPort());
                        }
                        Map map = TCPTransport.this.channelTable;
                        synchronized (map) {
                            TCPChannel tCPChannel = (TCPChannel)TCPTransport.this.getChannel(tCPEndpoint4);
                            connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, (InputStream)object, outputStream, false);
                            tCPChannel.useMultiplexer(connectionMultiplexer);
                        }
                        connectionMultiplexer.run();
                        return;
                    }
                    default: {
                        dataOutputStream.writeByte(79);
                        dataOutputStream.flush();
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                tcpLog.log(Log.BRIEF, "terminated with exception:", iOException);
                return;
            }
            finally {
                TCPTransport.closeSocket(this.socket);
                if (threadPooling != null) {
                    this.socket = null;
                    threadConnectionHandler.set(null);
                    object = TCPTransport.this.pool;
                    synchronized (object) {
                        TCPTransport.this.pool.addElement(this);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread thread;
            if (threadPooling == null) {
                this.handleRequest();
                return;
            }
            Thread thread2 = thread = Thread.currentThread();
            synchronized (thread2) {
                this.threadStarted = true;
                thread.notify();
            }
            while (true) {
                ConnectionHandler connectionHandler = this;
                synchronized (connectionHandler) {
                    while (this.socket == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    thread.setName(this.name);
                }
                this.handleRequest();
            }
        }
    }
}

