/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import com.ibm.misc.BASE64Encoder;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.ManifestDigester;

public class SignatureFile {
    Manifest sf;
    String baseName;

    public SignatureFile(MessageDigest[] messageDigestArray, Manifest manifest, ManifestDigester manifestDigester, String string, boolean bl) {
        this.baseName = string;
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        this.sf = new Manifest();
        Attributes attributes = this.sf.getMainAttributes();
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        attributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        attributes.putValue("Created-By", string2 + " (" + string3 + ")");
        if (bl) {
            int n = 0;
            while (n < messageDigestArray.length) {
                attributes.putValue(messageDigestArray[n].getAlgorithm() + "-Digest-Manifest", bASE64Encoder.encode(manifestDigester.manifestDigest(messageDigestArray[n])));
                ++n;
            }
        }
        Map map = this.sf.getEntries();
        Iterator iterator = manifest.getEntries().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string4 = (String)entry.getKey();
            ManifestDigester.Entry entry2 = manifestDigester.get(string4, false);
            if (entry2 == null) continue;
            Attributes attributes2 = new Attributes();
            int n = 0;
            while (n < messageDigestArray.length) {
                attributes2.putValue(messageDigestArray[n].getAlgorithm() + "-Digest", bASE64Encoder.encode(entry2.digest(messageDigestArray[n])));
                ++n;
            }
            map.put(string4, attributes2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.sf.write(outputStream);
    }

    public String getMetaName() {
        return "META-INF/" + this.baseName + ".SF";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Block generateBlock(PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
        return new Block(this, privateKey, x509CertificateArray, bl);
    }

    public static class Block {
        private PKCS7 block;
        private String blockFileName;

        Block(SignatureFile signatureFile, PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            String string;
            BigInteger bigInteger;
            Principal principal = x509CertificateArray[0].getIssuerDN();
            if (!(principal instanceof X500Name)) {
                bigInteger = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
                principal = (Principal)bigInteger.get("issuer.dname");
            }
            bigInteger = x509CertificateArray[0].getSerialNumber();
            String string2 = privateKey.getAlgorithm();
            if (string2.equalsIgnoreCase("DSA")) {
                string = "SHA1";
            } else if (string2.equalsIgnoreCase("RSA")) {
                string = "MD5";
            } else {
                throw new RuntimeException("private key is not a DSA or RSA key");
            }
            String string3 = string + "with" + string2;
            this.blockFileName = "META-INF/" + signatureFile.getBaseName() + "." + string2;
            AlgorithmId algorithmId = AlgorithmId.get((String)string);
            AlgorithmId algorithmId2 = AlgorithmId.get((String)string3);
            AlgorithmId algorithmId3 = AlgorithmId.get((String)string2);
            Signature signature = Signature.getInstance(string3);
            signature.initSign(privateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            signatureFile.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ContentInfo contentInfo = bl ? new ContentInfo(PKCSOID.DATA_OID, null) : new ContentInfo(byArray);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            SignerInfo signerInfo = new SignerInfo((X500Name)principal, bigInteger, algorithmId, algorithmId3, byArray2);
            AlgorithmId[] algorithmIdArray = new AlgorithmId[]{algorithmId};
            SignerInfo[] signerInfoArray = new SignerInfo[]{signerInfo};
            this.block = new PKCS7(algorithmIdArray, contentInfo, x509CertificateArray, signerInfoArray);
        }

        public String getMetaName() {
            return this.blockFileName;
        }

        public void write(OutputStream outputStream) throws IOException {
            this.block.encodeSignedData(outputStream);
        }
    }
}

