/*							*/
/*   Licensed Materials - Property of IBM               */
/*							*/
/*   5765-530            				*/
/*   (C) Copyright IBM Corp. 1996 All Rights Reserved.	*/
/*							*/

#ifdef TRACE_C
int curr_tracelevel = 0;
#else
extern int curr_tracelevel;
#endif

/* 
 *	C-Macros for tracing
 */

#define TRACESIZE	(1024*1024)

#define TRACE_FUNC_ENTRY(level,function) {if( level <= curr_tracelevel) \
		trace_func_entry(function);}
#define TRACE_FUNC_DATA(level,datatype,data) {if( level <= curr_tracelevel) \
		trace_func_data(datatype,data);}
#define TRACE_ANY_DATA(level,function,comment,datatype,data) \
	{ if( level <= curr_tracelevel) \
		trace_any_data(function,comment, datatype,data);}
#define TRACE_FUNC_EXIT(level,function,datatype,data) \
	{if( level <= curr_tracelevel) \
		trace_func_exit(function,datatype, data);}

/* function prototypes */
char *trace_open_file( unsigned long maxsize);
void trace_close_file();
void trace_func_entry( char *functionname);
void trace_func_data( short desc, char *data);
void trace_any_data( char *function, char *comment, short desc, char *data);
void trace_func_exit( char *function, short desc, char *data);

