/*							*/
/*   COPYRIGHT: Licensed material - Property of IBM     */
/*   5765-530 (C) Copyright IBM Corp. 1996, 1996	*/
/*							*/
/*
 *	lib.h
 *	
 *	Header file to provide global function prototypes
 *
 *
 */

/* Exported from read_write.c */

extern char *convertString();
extern char *convertStringForFile( char direction, char *buf, int size, int fd);
extern int   readInt( int sock, int *value);
extern int   readStructure( int sock, short datatype, char *value, int size);
extern int   writeStructure( int sock, short datatype, char *value, int size);


/* Exported from lib.c */

extern void  duplicate_quotes( char *s);
extern void  split_lines(char *msg);
extern void  sqlCreateFile( char *text, char *suffix, char *ofile);
extern char *generate_filename( char *prefix, char *suffix);
extern char *hostname();    /* Gets hostname of current system */
extern int   hextochar( char *hexstring, int   len);
extern int   sqlExecute( char *text);
extern void  sqlExecute1( int sock, char *text);


/* Exported from environ.c */

extern char *Setenv(char *name, char *value);
extern char *Unsetenv(char *name);


/*Exported from async.c */

extern void  asyncClearProcesses();
extern void  asyncKill( int pid, int signal);
extern void  asyncProcList( int conn);
extern void  asyncProcListReady( int conn);
extern void  finish_proc( int procid);
extern int   asyncExecute( char *command);
extern int   asyncFileLine( char *file, char *buf);
extern int   asyncFileLineAll( int sock, char *file, char *buf);


/* Exported from codepage.c */

extern char *find_localset( );
extern int   find_isoset( char *charset);
extern int   initConversionTable( char *remoteset, int remote_iso, int socket);


/* Exported from connect.c */

extern void  Read( int sock, char *buffer, int size, char *func, short datatype);
extern void  Write(int sock, char *buffer, int size, char *func, short datatype);
extern int   SetUid( char *username, char *password);

