/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cli.traceparse;

import com.ibm.db2.cli.traceparse.CLITrace;
import com.ibm.db2.cli.traceparse.InvalidCliTraceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;

public class CLITraceProcessor {
    private CLITrace cliTrace;
    private File cliTraceFile;
    private long numberOfLinesRead;

    private CLITraceProcessor() {
    }

    public CLITraceProcessor(File file) throws FileNotFoundException, InvalidCliTraceException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        this.cliTraceFile = file;
    }

    public CLITraceProcessor(String string) throws FileNotFoundException {
        if (string != null && !string.equals("")) {
            this.cliTraceFile = new File(string);
            if (!this.cliTraceFile.exists()) {
                throw new FileNotFoundException();
            }
        } else {
            throw new FileNotFoundException();
        }
    }

    public CLITrace getCLITrace() {
        return this.cliTrace;
    }

    public long processTrace() throws IOException, InvalidCliTraceException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        this.numberOfLinesRead = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.cliTraceFile));
        return this.processTrace2(bufferedReader, false);
    }

    public long processTrace(long l) throws IOException, InvalidCliTraceException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        this.numberOfLinesRead = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.cliTraceFile));
        while (this.numberOfLinesRead < l) {
            if (bufferedReader.readLine() == null) {
                return -1L;
            }
            ++this.numberOfLinesRead;
        }
        return this.processTrace2(bufferedReader, false);
    }

    public long processTrace(long l, boolean bl) throws IOException, InvalidCliTraceException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        this.numberOfLinesRead = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.cliTraceFile));
        while (this.numberOfLinesRead < l) {
            if (bufferedReader.readLine() == null) {
                return -1L;
            }
            ++this.numberOfLinesRead;
        }
        return this.processTrace2(bufferedReader, bl);
    }

    public long processTrace(boolean bl) throws IOException, InvalidCliTraceException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        this.numberOfLinesRead = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.cliTraceFile));
        return this.processTrace2(bufferedReader, bl);
    }

    private long processTrace2(BufferedReader bufferedReader, boolean bl) throws IOException, InvalidCliTraceException, IllegalAccessException, ClassNotFoundException, InstantiationException, IllegalArgumentException {
        this.cliTrace = new CLITrace(bl);
        String string = null;
        boolean bl2 = true;
        while ((string = bufferedReader.readLine()) != null) {
            Serializable serializable;
            ++this.numberOfLinesRead;
            String string2 = new String(string.trim());
            if (string2.startsWith("[") && !string2.startsWith("Date & Time", 2)) {
                try {
                    Timestamp timestamp = Timestamp.valueOf(string2.substring(string2.indexOf("]") - 26, string2.indexOf("]") - 1));
                    string2 = string2.substring(string2.indexOf("]") + 1);
                    string2 = string2.trim();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            try {
                if (string2.startsWith("Build")) {
                    this.cliTrace.setCLITraceVersion(6);
                    this.cliTrace.setHeader(string2);
                    continue;
                }
                if (string2.startsWith("[")) {
                    this.cliTrace.setCLITraceVersion(7);
                    this.cliTrace.setHeader(string2);
                    continue;
                }
                if (string2.startsWith("SQL")) {
                    int n = 0;
                    if (!string2.endsWith(")")) {
                        serializable = new StringBuffer(string2);
                        while ((string = bufferedReader.readLine()) != null) {
                            ++n;
                            ((StringBuffer)serializable).append(string.trim());
                            if (!((StringBuffer)serializable).toString().endsWith(")")) continue;
                            string2 = ((StringBuffer)serializable).toString();
                            break;
                        }
                        if (string == null) {
                            return this.numberOfLinesRead + (long)n;
                        }
                    }
                    if (bl2) {
                        bl2 = false;
                        this.cliTrace.processInputValues(string2, this.numberOfLinesRead);
                    } else {
                        bl2 = true;
                        this.cliTrace.processReturnValues(string2);
                    }
                    this.numberOfLinesRead += (long)n;
                    continue;
                }
                if (string2.startsWith("sql")) {
                    this.cliTrace.processCommBuffer(string2.replace(',', '.'));
                    continue;
                }
                if (string2.startsWith("--->")) {
                    this.cliTrace.parseAppTimeElapsed(string2.replace(',', '.'));
                    continue;
                }
                if (string2.startsWith("<---")) {
                    this.cliTrace.parseReturnCode(string2.replace(',', '.'));
                    continue;
                }
                if (!string2.startsWith("(") || !string2.endsWith(")")) continue;
                this.cliTrace.addInformationalMessage(string2);
            }
            catch (InvalidCliTraceException invalidCliTraceException) {
                invalidCliTraceException.setLineNumber(this.numberOfLinesRead);
                bufferedReader.close();
                throw invalidCliTraceException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                serializable = new InvalidCliTraceException(exception, this.numberOfLinesRead);
                throw serializable;
            }
        }
        return this.numberOfLinesRead;
    }

    public void setFileName(String string) throws FileNotFoundException {
        this.cliTraceFile = new File(string);
    }

    public void setTraceFile(File file) {
        this.cliTraceFile = file;
    }
}

