@echo off
rem Licensed Materials - Property of IBM
rem
rem Governed under the terms of the International
rem License Agreement for Non-Warranted Sample Code.
rem
rem  (C) COPYRIGHT International Business Machines Corp. 1996 - 2002
rem  All Rights Reserved.
rem
rem  US Government Users Restricted Rights - Use, duplication or
rem  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.

rem BATCH FILE: bldrtn.bat 
rem Builds C routines (stored procedures and UDFs) on Windows
rem Usage: bldrtn prog_name [ db_name ]

rem Default compiler is set to Microsoft Visual C++
rem To use a different compiler, comment out 'set BLDCOMP=cl'
rem and uncomment 'set BLDCOMP=icl'or 'set BLDCOMP=ecl'
rem Microsoft C/C++ Compiler
set BLDCOMP=cl

rem Intel C++ Compiler for 32-bit applications
rem set BLDCOMP=icl

rem Intel C++ Compiler for Itanium 64-bit applications
rem set BLDCOMP=ecl

rem Define and add bufferoverflowu.lib to link rulefor 
rem Windows x64 to resolve __security_cookie errors
if "%CPU%" == "AMD64" Set BUFFEROVERFLOWLIB=bufferoverflowu.lib

if exist "%1.sqc" goto embedded
if exist "%1.sqx" goto embedded
goto compile

:embedded
rem Precompile and bind the program.
call embprep %1 %2

:compile
rem Compile the program.
if exist "%1.cxx" goto cpp
%BLDCOMP% -Zi -Od -c -W2 -DWIN32 -MD %1.c
goto link_step
:cpp
%BLDCOMP% -Zi -Od -c -W2 -DWIN32 -MD %1.cxx

:link_step
rem Link the program.
link -debug -out:%1.dll -dll %1.obj db2api.lib %BUFFEROVERFLOWLIB%  -def:%1.def 

rem Copy the routine DLL to the 'function' directory
copy %1.dll "%DB2PATH%\function"
@echo on
