/*---------------------------------------------------------------------
--(c) Copyright IBM Corporation 2006  All rights reserved.           --
--                                                                   --
--This sample program is owned by International Business Machines    --
--Corporation or one of its subsidiaries ("IBM") and is copyrighted  --
--and licensed, not sold.                                            --
--BY ACCESSING, COPYING, OR USING THIS SAMPLE PROGRAM, YOU AGREE TO  --
--THE TERMS OF THE AGREEMENT TITLED "International License Agreement --
--for Non-Warranted db2perf Programs" LOCATED IN THE FILE NAMED      --
--"license.txt".                                                     --
--                                                                   --
-- db2perf_udf.c                                                     --
-- Steve Rees - srees@ca.ibm.com                                     --
--                                                                   --
-- Processes parameter SQL statement, and replaces string and        --
-- numeric literals with parameter markers.                          --
--                                                                   --
---------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sqlca.h>
#include <sqludf.h>

#define IS_LETTER( X )  ( (((X) >= 'A') && ((X) <= 'Z')) || (((X) >= 'a') && ((X) <= 'z')) || ((X) == '_') )
#define IS_DIGIT( X )   ( ((X) >= '0') && ((X) <= '9') )
#define IS_SIGN( X )    ( (X) == '-' || ((X) == '+') )
#define IS_DECIMAL( X ) ( (X) == '.' )
#define IS_SPACE( X )   ( (X) == ' ' )
#define IS_QUOTE( X )   ( (X) == '\'' )



#ifdef __cplusplus
extern "C"
#endif
void SQL_API_FN db2perf_RmLiterals(SQLUDF_CHAR *inString,
                          SQLUDF_CHAR *outString,
                          SQLUDF_SMALLINT *inStrNullInd,
                          SQLUDF_SMALLINT *outStrNullInd,
                          SQLUDF_TRAIL_ARGS)
{
  if (*inStrNullInd == -1 )
  {
    *outStrNullInd = -1;
  }
  else
  {
    char *in,*out;
    char quote;

    in = inString;
    out = outString;

    /* March the 'in' pointer through the string, until the end. */
    while( *in != '\0' )
    {

      if( IS_QUOTE( *in ) )
      {
 	/* Starting a string literal */
	quote = *in;

	do
	{
	  ++in;

	  if( !(*in) )
	    goto exit;;

	  /* We found a quote character, but there are two in a row, so it's escaped, as in 'a''b' */
	  if( (*in == quote)  &&  (*(in+1) == quote) )
	    in += 2;

	} while( *in && (*in != quote) );
	
	if( *in )
	  ++in;

	/* Insert a parameter marker in the output string to replace the string literal */
        *(out++) = '?';

	continue;
      }


      if( IS_SIGN( *in ) || IS_DECIMAL(*in) || IS_DIGIT( *in ) )
      {
 	/* Starting a numeric literal */
	++in;

	while( IS_DIGIT( *in ) || IS_DECIMAL( *in ) )
          ++in;
	
	/* Allow for scientific notation, signs, decimals, etc. */
	if( (*in == 'e') || (*in == 'E') )
	{
	  ++in;
	  if( IS_SIGN( *in ) )
	  {
	    ++in;
	  }
	  while( IS_DIGIT( *in ) || IS_DECIMAL( *in ) )
	    ++in;
	}

        *(out++) = '?';

        continue;
      }


      if( IS_LETTER( *in ) )
      {
  	/* Copy alphanumeric terms like SELECT and T1 straight to output */
        while( IS_LETTER( *in ) || IS_DIGIT( *in ) || IS_DECIMAL ( *in ) )
          *(out++) = *(in++);

        continue;   
      }


      /* compress multiple spaces in the input string to one in the output string */
      if( IS_SPACE( *in ) )
      {
        *(out++) = *(in++);

        while( IS_SPACE( *in ) )
          in++;

        continue;
      }

      *(out++) = *(in++);
    }

exit:
    *out = '\0';
    *outStrNullInd = 0;

  }
}


