
-------------------------------------------------------------------------------
-- Title Information Table
-------------------------------------------------------------------------------
CREATE TABLE VO.Title
(

  TitleID               INTEGER NOT NULL,
  VCGUID                INTEGER NOT NULL,

  Name                  VARCHAR(64) NOT NULL,

  InCount               INTEGER NOT NULL,

  VideoDate             DATE NOT NULL,
  TheaterDate           DATE NOT NULL,

  RatingID              INTEGER NOT NULL,
  GenreID               INTEGER NOT NULL,
  RunningTime           INTEGER NOT NULL,
  ImageFile             VARCHAR(64) NOT NULL,

  DateAdded             DATE NOT NULL,

  PRIMARY KEY           (TitleID)

);


-------------------------------------------------------------------------------
-- Cast/Crew/Critics Information Table
-------------------------------------------------------------------------------
CREATE TABLE VO.Person

(

  PersonID              INTEGER NOT NULL,
  FirstName             VARCHAR(32) NOT NULL,
  LastName              VARCHAR(32) NOT NULL,
  BirthDate             DATE,
  DeathDate             DATE,
  Sex                   CHAR(1) NOT NULL,
  ImageFile             VARCHAR(64) NOT NULL,

  PRIMARY KEY           (PersonID)

);


-------------------------------------------------------------------------------
-- Cast/Crew Roles in Titles Table
-------------------------------------------------------------------------------
CREATE TABLE VO.TitlePerson

(

  TitleID               INTEGER NOT NULL,
  PersonID              INTEGER NOT NULL,
  RoleID                INTEGER NOT NULL,

  PRIMARY KEY           (TitleID, PersonID, RoleID)

);


-------------------------------------------------------------------------------
-- Customer's Wish List of Titles Table
-------------------------------------------------------------------------------
CREATE TABLE VO.WishedTitles

(

  CustomerID    INTEGER NOT NULL,
  TitleID       INTEGER NOT NULL,
  DateAdded     DATE NOT NULL,

  PRIMARY KEY   (CustomerID, TitleID)

);


-------------------------------------------------------------------------------
-- Title Statistics Table
-------------------------------------------------------------------------------
CREATE TABLE VO.TitleStats

(

  TitleID               INTEGER NOT NULL,

  Rank                  INTEGER NOT NULL,

  NumCriticRatings      INTEGER NOT NULL,
  AvgCriticRating       FLOAT NOT NULL,

  NumCustomerRatings    INTEGER NOT NULL,
  AvgCustomerRating     FLOAT NOT NULL,

  WeekRentals           INTEGER NOT NULL,
  MonthRentals          INTEGER NOT NULL,
  YearRentals           INTEGER NOT NULL,
  TotalRentals          INTEGER NOT NULL,
  LastRentalDate        DATE NOT NULL,

  WeekRatings           INTEGER NOT NULL,
  MonthRatings          INTEGER NOT NULL,
  DayRatings            INTEGER NOT NULL,
  TotalRatings          INTEGER NOT NULL,
  AvgRating             FLOAT NOT NULL,
  LastRatingDate        DATE NOT NULL,

  DayViews              INTEGER NOT NULL,
  WeekViews             INTEGER NOT NULL,
  MonthViews            INTEGER NOT NULL,
  YearViews             INTEGER NOT NULL,
  TotalViews            INTEGER NOT NULL,
  LastViewDate          DATE NOT NULL,

  PRIMARY KEY           (TitleID)

);


