#!/bin/sh
#       Top-level setup shell script.
ME=`basename $0`' (top-level)'
USAGE="Usage:  $ME "'[product]'

platform=`uname -s`
case "$platform" in
SunOS)  platform=solaris ;;
HP-UX)   platform=hpux ;;
AIX)    platform=aix  ;;
*)      echo 1>&2 "$ME": unrecognized platform: "$platform"
        exit 1 ;;
esac

if [ ! -d $platform ]; then
	platform=`echo $platform | tr '[a-z]' '[A-Z]'`
	if [ ! -d $platform ]; then
        	echo 1>&2 "$ME": no such directory: $platform
		echo 1>&2 "$ME": could not locate installer
        	exit 1
	fi
fi


## -- Ask for input from user
# $1: prompt	$2: default	$3+: other choices
# Returning value comes back as $input
# USAGE:  ask 'Prompt' "default" ...
ask () {
	_pr="$1"
	_def="$2"
	prompt="${_pr}"
	shift
	if [ $# -gt 0 ]; then prompt="$prompt"' ['"${_def}"']' ; shift ; fi
	if [ $# -gt 0 ]; then prompt="$prompt"' {'"${_def} ""$@"'}' ; fi
	echo 1>&2 "$prompt ?"
	while read input ; do
		if [ -z "$input" ]; then input="${_def}" ; break ; fi
		if [ $# -eq 0 ]; then break ; fi
# @@@@ extend to limit to choices given
		break;
	done
}

## -- Error and information reporting
FATAL () {
	echo 1>&2 "$ME:  FATAL: $1"
	shift
	while [ $# -gt 0 ]; do
		echo 1>&2 "$ME: (FATAL)   $1"
		shift
	done
	echo 1>&2 "$ME: EXITING ...."
	exit 1
}

ERROR () {
	echo 1>&2 "$ME:  ERROR: $1"
	shift
	while [ $# -gt 0 ]; do
		echo 1>&2 "$ME: (ERROR)   $1"
		shift
	done
}

WARN () {
	echo 1>&2 "$ME:  WARNING: $1"
	shift
	while [ $# -gt 0 ]; do
		echo 1>&2 "$ME: (WARNING)   $1"
		shift
	done
}

FYI () {
	echo 1>&2 "$ME:  FYI: $1"
	shift
	while [ $# -gt 0 ]; do
		echo 1>&2 "$ME: (FYI)   $1"
		shift
	done
}


cd $platform 
case "$#" in
0)	prodlist=`find . ! -name . -type d -prune -print | sed -e 's|^\./||'`
	ask 'Install which product' "" $prodlist
	prod="$input"
	;;
1)	prod="$1" ;;
*)	ERROR "inappropriate number of arguments"
	echo 1>&2 "$USAGE"
	exit 1 ;;
esac

if [ -f $prod/essinst ]; then
	cd $prod ; ./essinst
elif [ -f $prod/ESSINST ]; then
	cd $prod ; ./ESSINST
else
	echo 1>&2 "$ME": could not locate installer: $prod/essinst
	echo 1>&2 "$ME": could not locate installer: $prod/ESSINST
	exit 1
fi

echo 1>&2 "$ME": done
exit 0
