/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.AttrPool;
import com.ibm.xml.framework.ContentModel;
import com.ibm.xml.framework.ContentSpecNode;
import com.ibm.xml.framework.ElementDeclPool;
import com.ibm.xml.framework.InsertableElementsInfo;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLValidationHandler;
import com.ibm.xml.internal.CMException;
import com.ibm.xml.internal.DFAContentModel;
import com.ibm.xml.internal.MixedContentModel;
import com.ibm.xml.internal.SimpleContentModel;

public class DefaultValidationHandler
implements XMLValidationHandler {
    private ElementDeclPool fDeclPool;
    private XMLErrorHandler fErrHandler;
    private AttrPool fAttrPool;
    private StringPool fStringPool;
    private ParserState fParserState;
    private static final boolean DEBUG_PRINT_ATTRIBUTES = false;
    private static final boolean DEBUG_PRINT_CONTENT = false;

    public DefaultValidationHandler(ParserState parserState) {
        this.fDeclPool = parserState.cacheElementDeclPool();
        this.fErrHandler = parserState.getErrorHandler();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fStringPool = parserState.cacheStringPool();
        this.fParserState = parserState;
        boolean bl = this.fDeclPool == null || this.fErrHandler == null || this.fAttrPool == null || this.fStringPool == null || this.fParserState == null;
    }

    public void reset(ParserState parserState) {
        this.fDeclPool = parserState.cacheElementDeclPool();
        this.fErrHandler = parserState.getErrorHandler();
        this.fAttrPool = parserState.cacheAttrPool();
        this.fStringPool = parserState.cacheStringPool();
        this.fParserState = parserState;
    }

    public void checkRootElementName(int n) throws Exception {
        int n2 = this.fDeclPool.getRootElement();
        if (n2 == -1) {
            return;
        }
        int n3 = this.fDeclPool.getElementName(n2);
        if (n != n3) {
            this.fErrHandler.error2(126, n3, n);
        }
    }

    public void checkAttributes(int n, int n2) throws Exception {
        if (this.fParserState.getCheckNamespace()) {
            this.fDeclPool.checkNamespace(n, n2);
        }
    }

    public int checkContent(int n, int n2, int[] nArray) throws Exception {
        int n3 = this.fDeclPool.getElementName(n);
        int n4 = this.fDeclPool.getContentSpecType(n);
        if (n4 == 1) {
            if (n2 != 0) {
                return 0;
            }
        } else if (n4 != 2) {
            if (n4 == 3 || n4 == 4) {
                ContentModel contentModel = null;
                try {
                    contentModel = this.getContentModel(n);
                    return contentModel.validateContent(n2, nArray);
                }
                catch (CMException cMException) {
                    cMException.send(this.fErrHandler);
                }
            } else if (n4 == 0) {
                this.fErrHandler.error1(166, n3);
            } else {
                this.fErrHandler.error(152);
            }
        }
        return -1;
    }

    public void checkIDRefNames() throws Exception {
        this.fDeclPool.checkIdRefs();
    }

    public int whatCanGoHere(int n, boolean bl, InsertableElementsInfo insertableElementsInfo) throws Exception {
        if (insertableElementsInfo.insertAt > insertableElementsInfo.childCount || insertableElementsInfo.curChildren == null || insertableElementsInfo.childCount < 1 || insertableElementsInfo.childCount > insertableElementsInfo.curChildren.length) {
            this.fErrHandler.error(158);
        }
        int n2 = 0;
        try {
            ContentModel contentModel = this.getContentModel(n);
            n2 = contentModel.whatCanGoHere(bl, insertableElementsInfo);
        }
        catch (CMException cMException) {
            cMException.send(this.fErrHandler);
        }
        return n2;
    }

    private final ContentModel createChildModel(int n) throws CMException {
        ContentSpecNode contentSpecNode = new ContentSpecNode();
        this.fDeclPool.getContentSpecNode(this.fDeclPool.getContentSpec(n), contentSpecNode);
        if (contentSpecNode.value == -1) {
            throw new CMException(159);
        }
        if (contentSpecNode.type == 0) {
            return new SimpleContentModel(contentSpecNode.value, -1, contentSpecNode.type);
        }
        if (contentSpecNode.type == 4 || contentSpecNode.type == 5) {
            ContentSpecNode contentSpecNode2 = new ContentSpecNode();
            ContentSpecNode contentSpecNode3 = new ContentSpecNode();
            this.fDeclPool.getContentSpecNode(contentSpecNode.value, contentSpecNode2);
            this.fDeclPool.getContentSpecNode(contentSpecNode.otherValue, contentSpecNode3);
            if (contentSpecNode2.type == 0 && contentSpecNode3.type == 0) {
                return new SimpleContentModel(contentSpecNode2.value, contentSpecNode3.value, contentSpecNode.type);
            }
        } else if (contentSpecNode.type == 1 || contentSpecNode.type == 2 || contentSpecNode.type == 3) {
            ContentSpecNode contentSpecNode4 = new ContentSpecNode();
            this.fDeclPool.getContentSpecNode(contentSpecNode.value, contentSpecNode4);
            if (contentSpecNode4.type == 0) {
                return new SimpleContentModel(contentSpecNode4.value, -1, contentSpecNode.type);
            }
        } else {
            throw new CMException(152);
        }
        return new DFAContentModel(n, this.fStringPool, this.fDeclPool);
    }

    ContentModel getContentModel(int n) throws CMException {
        ContentModel contentModel = this.fDeclPool.getContentModel(n);
        if (contentModel != null) {
            return contentModel;
        }
        int n2 = this.fDeclPool.getContentSpecType(n);
        if (n2 == 3) {
            contentModel = new MixedContentModel(this.fDeclPool, n);
        } else if (n2 == 4) {
            contentModel = this.createChildModel(n);
        } else {
            throw new CMException(152);
        }
        this.fDeclPool.setContentModel(n, contentModel);
        return contentModel;
    }
}

