/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.internal;

import com.ibm.xml.framework.ChunkyCharArray;
import com.ibm.xml.framework.ParserState;
import com.ibm.xml.framework.ScanContentState;
import com.ibm.xml.framework.StringPool;
import com.ibm.xml.framework.StringProducer;
import com.ibm.xml.framework.XMLDocumentHandler;
import com.ibm.xml.framework.XMLErrorHandler;
import com.ibm.xml.framework.XMLReader;
import com.ibm.xml.framework.XMLScanner;
import com.ibm.xml.internal.StringHasher;
import java.io.InputStream;

final class UTF8Reader
extends XMLReader {
    protected static final int CHUNK_SHIFT = 14;
    protected static final int CHUNK_SIZE = 16384;
    protected static final int CHUNK_MASK = 16383;
    protected char[] fCharacters = new char[256];
    protected int fCharDataLength;
    protected XMLScanner fScanner;
    protected StringPool fStringPool;
    protected XMLDocumentHandler fDocumentHandler;
    protected boolean fSendCharDataAsCharArray = false;
    protected XMLErrorHandler fErrorHandler;
    protected InputStream fInputStream;
    protected UTF8DataChunk fCurrentChunk;
    protected int fCurrentIndex;
    protected byte[] fMostRecentData;
    protected int fMostRecentByte;
    protected int fLength;
    protected boolean fCheckOverflow = false;
    protected byte[] fOverflow;
    protected int fOverflowOffset;
    protected int fOverflowEnd;
    protected boolean fSkipLinefeed = false;
    protected int fPartialMultiByteIn;
    protected byte[] fPartialMultiByteChar = new byte[4];
    protected boolean fPartialMultiByteResult = false;
    protected int fFastCopyCount;
    protected int fOutputOffset;
    protected int fPartialMultiByteOut;

    UTF8Reader(ParserState parserState, String string, String string2, InputStream inputStream) throws Exception {
        super(parserState, string, string2);
        this.fInputStream = inputStream;
        this.fScanner = parserState.getScanner();
        this.fStringPool = parserState.cacheStringPool();
        this.fDocumentHandler = parserState.getDocumentHandler();
        this.fSendCharDataAsCharArray = this.fDocumentHandler != null && this.fDocumentHandler.sendCharDataAsCharArray();
        this.fErrorHandler = parserState.getErrorHandler();
        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, null);
        this.fillCurrentChunk();
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addString(n, n2);
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fCurrentChunk.addSymbol(n, n2, 0);
    }

    protected int addSymbol(int n, int n2, int n3) {
        return this.fCurrentChunk.addSymbol(n, n2, n3);
    }

    public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
        this.fCurrentChunk.append(chunkyCharArray, n, n2);
    }

    protected int slowLoadNextByte() throws Exception {
        if (this.fCurrentChunk.nextChunk() != null) {
            this.fCurrentChunk = this.fCurrentChunk.nextChunk();
            this.fCurrentIndex = 0;
            this.fMostRecentData = this.fCurrentChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
            return this.fMostRecentByte;
        }
        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
        return this.fillCurrentChunk();
    }

    protected int loadNextByte() throws Exception {
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            return this.slowLoadNextByte();
        }
        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        return this.fMostRecentByte;
    }

    protected void checkEOF(int n) {
        if (n > this.fLength) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    protected void skipOneCharStartingWithByte(int n) throws Exception {
        if ((0x80 & n) == 0) {
            if (n == 0) {
                int n2 = this.fCurrentOffset + 1;
                if (n2 > this.fLength) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                ++this.fCharacterCounter;
                return;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                return;
            }
            ++this.fCharacterCounter;
            return;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        if ((0xE0 & n) == 192) {
            return;
        }
        this.loadNextByte();
        if ((0xF0 & n) == 224) {
            return;
        }
        this.loadNextByte();
    }

    public int skipOneChar() throws Exception {
        int n = this.fMostRecentByte;
        this.skipOneCharStartingWithByte(n);
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public int skipAsciiChar() throws Exception {
        ++this.fCharacterCounter;
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public int skipToChar(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (n != c) {
            this.skipOneCharStartingWithByte(n);
            n = this.loadNextByte();
        }
        return this.fCurrentOffset;
    }

    public int skipPastChar(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (true) {
            if (n == c) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return this.fCurrentOffset;
            }
            this.skipOneCharStartingWithByte(n);
            n = this.loadNextByte();
        }
    }

    public boolean skippedValidChar() throws Exception {
        int n = this.fMostRecentByte;
        if ((0x80 & n) == 0) {
            int n2;
            if (n >= 32 || n == 9) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return true;
            }
            if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
                this.loadNextByte();
                return true;
            }
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentIndex;
        int n4 = this.fCurrentOffset;
        int n5 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (!(n == 237 && n5 >= 160 || n == 239 && n5 == 191 && n6 >= 190)) {
                ++this.fCharacterCounter;
                this.loadNextByte();
                return true;
            }
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n4;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        this.loadNextByte();
        if (n <= 244 && (n != 244 || n5 < 144)) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n3;
        this.fCurrentOffset = n4;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return false;
    }

    public boolean lookingAtValidChar() throws Exception {
        int n = this.fMostRecentByte;
        if ((0x80 & n) == 0) {
            int n2;
            if (n >= 32 || n == 9 || n == 10) {
                return true;
            }
            if (n == 0 && (n2 = this.fCurrentOffset + 1) > this.fLength) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return false;
        }
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentIndex;
        int n4 = this.fCurrentOffset;
        int n5 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n4;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n4;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return (n != 237 || n5 < 160) && (n != 239 || n5 != 191 || n6 < 190);
        }
        this.loadNextByte();
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n3;
        this.fCurrentOffset = n4;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return n <= 244 && (n != 244 || n5 < 144);
    }

    public int skipInvalidChar(int n) throws Exception {
        int n2;
        int n3 = this.fMostRecentByte;
        ++this.fCharacterCounter;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            int n4 = this.loadNextByte();
            if ((0xE0 & n3) == 192) {
                n2 = ((0x1F & n3) << 6) + (0x3F & n4);
            } else {
                int n5 = this.loadNextByte();
                if ((0xF0 & n3) == 224) {
                    n2 = ((0xF & n3) << 12) + ((0x3F & n4) << 6) + (0x3F & n5);
                } else {
                    int n6 = this.loadNextByte();
                    n2 = ((0xF & n3) << 18) + ((0x3F & n4) << 12) + ((0x3F & n5) << 6) + (0x3F & n6);
                }
            }
        }
        switch (n) {
            case 63: 
            case 85: {
                String string = Integer.toHexString(n2);
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 80: 
            case 82: 
            case 110: {
                String string = new Character((char)n2).toString();
                this.fErrorHandler.error1(n, this.fStringPool.addString(string));
                break;
            }
            case 43: {
                String string = new Character((char)n2).toString();
                String string2 = Integer.toHexString(n2);
                this.fErrorHandler.error2(n, this.fStringPool.addString(string), this.fStringPool.addString(string2));
            }
        }
        this.loadNextByte();
        return this.fCurrentOffset;
    }

    public boolean skippedChar(char c) throws Exception {
        int n = this.fMostRecentByte;
        if (n != c) {
            return false;
        }
        ++this.fCharacterCounter;
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        return true;
    }

    public boolean lookingAtChar(char c) {
        int n = this.fMostRecentByte;
        return n == c;
    }

    public boolean skippedSpace() throws Exception {
        int n = this.fMostRecentByte;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 9) {
            ++this.fCharacterCounter;
        } else if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
        } else {
            return false;
        }
        ++this.fCurrentOffset;
        if (++this.fCurrentIndex == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 0xFF;
        }
        return true;
    }

    public boolean lookingAtSpace() {
        int n = this.fMostRecentByte;
        return n == 32 || n == 9 || n == 10;
    }

    public int skipPastSpaces() throws Exception {
        int n = this.fMostRecentByte;
        while (true) {
            if (n == 32 || n == 9) {
                ++this.fCharacterCounter;
            } else if (n == 10) {
                ++this.fLinefeedCounter;
                this.fCharacterCounter = 1;
            } else {
                return this.fCurrentOffset;
            }
            n = this.loadNextByte();
        }
    }

    public int skipDecimalDigit() throws Exception {
        int n = this.fMostRecentByte;
        if (n < 48 || n > 57) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return n - 48;
    }

    public int skipHexDigit() throws Exception {
        int n = this.fMostRecentByte;
        if (n > 102 || XMLReader.fgAsciiXDigitChar[n] == 0) {
            return -1;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
    }

    public boolean skippedAlpha() throws Exception {
        int n = this.fMostRecentByte;
        if (n > 122 || XMLReader.fgAsciiAlphaChar[n] == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return true;
    }

    protected final boolean skippedAsciiCharWithFlag(byte by) throws Exception {
        int n = this.fMostRecentByte;
        if ((n & 0x80) != 0 || (XMLReader.fgCharFlags[n] & by) == 0) {
            return false;
        }
        ++this.fCharacterCounter;
        this.loadNextByte();
        return true;
    }

    public final boolean skippedVersionNum() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)1);
    }

    public final boolean skippedEncName() throws Exception {
        return this.skippedAsciiCharWithFlag((byte)2);
    }

    public final boolean skippedPubidChar() throws Exception {
        int n = this.fMostRecentByte;
        if ((n & 0x80) != 0) {
            return false;
        }
        if ((XMLReader.fgCharFlags[n] & 4) != 0) {
            ++this.fCharacterCounter;
            this.loadNextByte();
            return true;
        }
        if (n == 10) {
            ++this.fLinefeedCounter;
            this.fCharacterCounter = 1;
            this.loadNextByte();
            return true;
        }
        return false;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = cArray.length;
        byte[] byArray = this.fMostRecentData;
        int n2 = this.fCurrentIndex;
        if (n2 + n <= 16384) {
            int n3 = 0;
            while (n3 < n) {
                if (byArray[n2++] != cArray[n3]) {
                    return false;
                }
                ++n3;
            }
            this.fCharacterCounter += n;
            this.fCurrentOffset += n;
            this.fCurrentIndex = n2;
            if (n2 == 16384) {
                this.slowLoadNextByte();
            } else {
                this.fMostRecentByte = byArray[n2] & 0xFF;
            }
            return true;
        }
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n4 = this.fCurrentOffset;
        int n5 = n2;
        int n6 = 0;
        while (n2 < 16384) {
            if (byArray[n2++] == cArray[n6++]) continue;
            return false;
        }
        this.slowLoadNextByte();
        byArray = this.fMostRecentData;
        n2 = 0;
        while (n6 < n) {
            if (byArray[n2++] == cArray[n6++]) continue;
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n5;
            this.fCurrentOffset = n4;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = this.fMostRecentData[n5] & 0xFF;
            return false;
        }
        this.fCharacterCounter += n;
        this.fCurrentOffset += n;
        this.fCurrentIndex = n2;
        if (n2 == 16384) {
            this.slowLoadNextByte();
        } else {
            this.fMostRecentByte = byArray[n2] & 0xFF;
        }
        return true;
    }

    public int scanName(char c, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block21: {
            int n7;
            UTF8DataChunk uTF8DataChunk;
            block22: {
                int n8;
                int n9;
                n6 = this.fCurrentOffset++;
                byte[] byArray = this.fMostRecentData;
                n5 = this.fMostRecentByte;
                if ((n5 & 0x80) == 0) {
                    if (XMLReader.fgAsciiInitialNameChar[n5] == 0) {
                        return -1;
                    }
                    n9 = n5;
                } else {
                    UTF8DataChunk uTF8DataChunk2 = this.fCurrentChunk;
                    n8 = this.fCurrentIndex++;
                    if (this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        byArray = this.fMostRecentData;
                    }
                    n4 = byArray[this.fCurrentIndex] & 0xFF;
                    if ((0xE0 & n5) == 192) {
                        n9 = ((0x1F & n5) << 6) + (0x3F & n4);
                        if ((XMLReader.fgCharFlags[n9] & 0x10) == 0) {
                            this.fCurrentChunk = uTF8DataChunk2;
                            this.fCurrentIndex = n8;
                            this.fCurrentOffset = n6;
                            this.fMostRecentData = uTF8DataChunk2.toByteArray();
                            this.fMostRecentByte = n5;
                            return -1;
                        }
                    } else {
                        ++this.fCurrentOffset;
                        if (++this.fCurrentIndex == 16384) {
                            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                            this.fillCurrentChunk();
                            byArray = this.fMostRecentData;
                        }
                        n3 = byArray[this.fCurrentIndex] & 0xFF;
                        if ((0xF0 & n5) == 224) {
                            if (n5 == 237 && n4 >= 160 || n5 == 239 && n4 == 191 && n3 >= 190) {
                                this.fCurrentChunk = uTF8DataChunk2;
                                this.fCurrentIndex = n8;
                                this.fCurrentOffset = n6;
                                this.fMostRecentData = uTF8DataChunk2.toByteArray();
                                this.fMostRecentByte = n5;
                                return -1;
                            }
                            n9 = ((0xF & n5) << 12) + ((0x3F & n4) << 6) + (0x3F & n3);
                            if ((XMLReader.fgCharFlags[n9] & 0x10) == 0) {
                                this.fCurrentChunk = uTF8DataChunk2;
                                this.fCurrentIndex = n8;
                                this.fCurrentOffset = n6;
                                this.fMostRecentData = uTF8DataChunk2.toByteArray();
                                this.fMostRecentByte = n5;
                                return -1;
                            }
                        } else {
                            this.fCurrentChunk = uTF8DataChunk2;
                            this.fCurrentIndex = n8;
                            this.fCurrentOffset = n6;
                            this.fMostRecentData = uTF8DataChunk2.toByteArray();
                            this.fMostRecentByte = n5;
                            return -1;
                        }
                    }
                }
                n2 = 0;
                n8 = 0;
                while (true) {
                    n2 = StringHasher.hashChar(n2, n8++, n9);
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        byArray = this.fMostRecentData;
                    }
                    if (c == (n5 = byArray[this.fCurrentIndex] & 0xFF)) break block21;
                    if ((n5 & 0x80) == 0) {
                        if (XMLReader.fgAsciiNameChar[n5] != 0) {
                            n9 = n5;
                            continue;
                        }
                        break block21;
                    }
                    uTF8DataChunk = this.fCurrentChunk;
                    n3 = this.fCurrentOffset++;
                    n7 = this.fCurrentIndex++;
                    if (this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        byArray = this.fMostRecentData;
                    }
                    int n10 = byArray[this.fCurrentIndex] & 0xFF;
                    if ((0xE0 & n5) == 192) {
                        n9 = ((0x1F & n5) << 6) + (0x3F & n10);
                        if ((XMLReader.fgCharFlags[n9] & 0x20) != 0) continue;
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n3;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        break block21;
                    }
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
                        this.fillCurrentChunk();
                        byArray = this.fMostRecentData;
                    }
                    int n11 = byArray[this.fCurrentIndex] & 0xFF;
                    if ((0xF0 & n5) != 224) break block22;
                    if (n5 == 237 && n10 >= 160 || n5 == 239 && n10 == 191 && n11 >= 190) {
                        this.fCurrentChunk = uTF8DataChunk;
                        this.fCurrentIndex = n7;
                        this.fCurrentOffset = n3;
                        this.fMostRecentData = uTF8DataChunk.toByteArray();
                        break block21;
                    }
                    n9 = ((0xF & n5) << 12) + ((0x3F & n10) << 6) + (0x3F & n11);
                    if ((XMLReader.fgCharFlags[n9] & 0x20) == 0) break;
                }
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n7;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                break block21;
            }
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n7;
            this.fCurrentOffset = n3;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
        }
        this.fMostRecentByte = n5;
        n4 = n2;
        n2 = (n4 &= Integer.MAX_VALUE) == 0 ? 1 : n4;
        n4 = this.fCurrentOffset - n6;
        n3 = this.fCurrentChunk.addSymbol(n6, n4, n2);
        if (n == -1 || n == n3) {
            return n3;
        }
        return -1;
    }

    protected boolean skippedMultiByteCharWithFlag(int n, int n2) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n3 = this.fCurrentOffset;
        int n4 = this.fCurrentIndex;
        int n5 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            if ((XMLReader.fgCharFlags[((0x1F & n) << 6) + (0x3F & n5)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n5 >= 160 || n == 239 && n5 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            if ((XMLReader.fgCharFlags[((0xF & n) << 12) + ((0x3F & n5) << 6) + (0x3F & n6)] & n2) == 0) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n4;
                this.fCurrentOffset = n3;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        this.fCurrentChunk = uTF8DataChunk;
        this.fCurrentIndex = n4;
        this.fCurrentOffset = n3;
        this.fMostRecentData = uTF8DataChunk.toByteArray();
        this.fMostRecentByte = n;
        return false;
    }

    public int skipPastName(char c) throws Exception {
        int n = this.fMostRecentByte;
        if ((n & 0x80) == 0 ? XMLReader.fgAsciiInitialNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 16)) {
            return this.fCurrentOffset;
        }
        do {
            ++this.fCharacterCounter;
            n = this.loadNextByte();
            if (c != n) continue;
            return this.fCurrentOffset;
        } while (!((n & 0x80) == 0 ? XMLReader.fgAsciiNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 32)));
        return this.fCurrentOffset;
    }

    public int skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentByte;
        while (c != n) {
            if ((n & 0x80) == 0 ? XMLReader.fgAsciiNameChar[n] == 0 : !this.skippedMultiByteCharWithFlag(n, 32)) {
                return this.fCurrentOffset;
            }
            ++this.fCharacterCounter;
            n = this.loadNextByte();
        }
        return this.fCurrentOffset;
    }

    /*
     * Unable to fully structure code
     */
    public int scanContent(ScanContentState var1_1) throws Exception {
        block95: {
            this.fCurrentChunk.clearPreviousChunk();
            this.fCharDataLength = 0;
            var2_2 = this.fCurrentOffset++;
            var3_3 = this.fMostRecentByte;
            if ((var3_3 & 128) != 0) break block95;
            switch (XMLReader.fgAsciiWSCharData[var3_3]) {
                case 0: {
                    ++this.fCharacterCounter;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(var3_3);
                    }
                    ** GOTO lbl196
                }
                case 1: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (!var1_1.inCDSect) {
                        return 1;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(60);
                    }
                    ** GOTO lbl196
                }
                case 2: {
                    ++this.fCharacterCounter;
                    ++this.fCurrentOffset;
                    if (++this.fCurrentIndex == 16384) {
                        this.slowLoadNextByte();
                    } else {
                        this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                    }
                    if (!var1_1.inCDSect) {
                        return 2;
                    }
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(38);
                    }
                    ** GOTO lbl196
                }
                case 3: {
                    ++this.fCharacterCounter;
                    var3_3 = this.loadNextByte();
                    if (var3_3 == 93) ** GOTO lbl50
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl50:
                    // 1 sources

                    if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl63
                    var4_4 = this.fCurrentChunk;
                    var5_7 = this.fCurrentIndex;
                    var6_10 = this.fCurrentOffset;
                    if (this.loadNextByte() == 62) ** GOTO lbl69
                    this.fCurrentChunk = var4_4;
                    this.fCurrentIndex = var5_7;
                    this.fCurrentOffset = var6_10;
                    this.fMostRecentData = var4_4.toByteArray();
                    this.fMostRecentByte = 93;
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl63:
                    // 1 sources

                    if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl67
                    if (this.fSendCharDataAsCharArray) {
                        this.appendCharData(93);
                    }
                    ** GOTO lbl196
lbl67:
                    // 1 sources

                    ++this.fCurrentIndex;
                    ++this.fCurrentOffset;
lbl69:
                    // 2 sources

                    this.loadNextByte();
                    this.fCharacterCounter += 2;
                    if (var1_1.inCDSect) {
                        var1_1.inCDSect = false;
                        return this.scanContent(var1_1);
                    }
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    do {
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(var3_3);
                        }
                        if (var3_3 == 10) {
                            ++this.fLinefeedCounter;
                            this.fCharacterCounter = 1;
                        } else {
                            ++this.fCharacterCounter;
                        }
                        ++this.fCurrentOffset;
                    } while ((var3_3 = ++this.fCurrentIndex == 16384 ? this.slowLoadNextByte() : (this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255)) == 32 || var3_3 == 9 || var3_3 == 10);
                    if ((var3_3 & 128) != 0) ** GOTO lbl181
                    switch (XMLReader.fgAsciiCharData[var3_3]) {
                        case 0: {
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(var3_3);
                            }
                            ** GOTO lbl196
                        }
                        case 1: {
                            if (!var1_1.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callWSCharDataHandler(var2_2, this.fCurrentOffset, false);
                                }
                                ++this.fCharacterCounter;
                                this.loadNextByte();
                                return 25;
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(var3_3);
                            }
                            ** GOTO lbl196
                        }
                        case 2: {
                            if (!var1_1.inCDSect) {
                                if (this.fDocumentHandler != null) {
                                    this.callWSCharDataHandler(var2_2, this.fCurrentOffset, false);
                                }
                                ++this.fCharacterCounter;
                                this.loadNextByte();
                                return 26;
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(var3_3);
                            }
                            ** GOTO lbl196
                        }
                        case 3: {
                            var4_5 = this.fCurrentOffset++;
                            var3_3 = this.loadNextByte();
                            if (var3_3 == 93) ** GOTO lbl146
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl146:
                            // 1 sources

                            if (this.fCurrentIndex + 1 != 16384) ** GOTO lbl160
                            var5_8 = this.fCurrentChunk;
                            var6_10 = this.fCurrentIndex;
                            var7_11 = this.fCurrentOffset;
                            if (this.loadNextByte() == 62) ** GOTO lbl166
                            this.fCurrentChunk = var5_8;
                            this.fCurrentIndex = var6_10;
                            this.fCurrentOffset = var7_11;
                            this.fMostRecentData = var5_8.toByteArray();
                            this.fMostRecentByte = 93;
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl160:
                            // 1 sources

                            if (this.fMostRecentData[this.fCurrentIndex + 1] == 62) ** GOTO lbl165
                            ++this.fCharacterCounter;
                            if (this.fSendCharDataAsCharArray) {
                                this.appendCharData(93);
                            }
                            ** GOTO lbl196
lbl165:
                            // 1 sources

                            ++this.fCurrentIndex;
lbl166:
                            // 2 sources

                            this.loadNextByte();
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(var2_2, var4_5, var1_1.inCDSect);
                            }
                            this.fCharacterCounter += 3;
                            if (var1_1.inCDSect) {
                                var1_1.inCDSect = false;
                                return this.scanContent(var1_1);
                            }
                            return 27;
                        }
                        case 4: {
                            if (this.fDocumentHandler != null) {
                                this.callWSCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                            }
                            return 28;
                        }
                        default: {
                            ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                        }
                    }
lbl181:
                    // 1 sources

                    if (this.fSendCharDataAsCharArray) {
                        if (!this.copyMultiByteCharData(var3_3)) {
                            this.callWSCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                            return 28;
                        }
                    } else if (!this.skipMultiByteCharData(var3_3)) {
                        if (this.fDocumentHandler != null) {
                            this.callWSCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                        }
                        return 28;
                    }
                    ** GOTO lbl196
                }
                default: {
                    ** if (!this.fSendCharDataAsCharArray) goto lbl-1000
                }
            }
        }
        if (!this.skipMultiByteCharData(var3_3)) {
            return 4;
        }
lbl196:
        // 16 sources

        if (this.fSendCharDataAsCharArray) lbl-1000:
        // 3 sources

        {
            var3_3 = this.copyAsciiCharData();
        } else lbl-1000:
        // 3 sources

        {
            var3_3 = this.skipAsciiCharData();
        }
        block23: while (true) {
            if ((var3_3 & 128) == 0) {
                switch (XMLReader.fgAsciiCharData[var3_3]) {
                    default: {
                        continue block23;
                    }
                    case 0: {
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(var3_3);
                        }
                        var3_3 = this.loadNextByte();
                        continue block23;
                    }
                    case 1: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            return 9;
                        }
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(var3_3);
                        }
                        var3_3 = this.loadNextByte();
                        continue block23;
                    }
                    case 2: {
                        if (!var1_1.inCDSect) {
                            if (this.fDocumentHandler != null) {
                                this.callCharDataHandler(var2_2, this.fCurrentOffset, false);
                            }
                            ++this.fCharacterCounter;
                            ++this.fCurrentOffset;
                            if (++this.fCurrentIndex == 16384) {
                                this.slowLoadNextByte();
                            } else {
                                this.fMostRecentByte = this.fMostRecentData[this.fCurrentIndex] & 255;
                            }
                            return 10;
                        }
                        ++this.fCharacterCounter;
                        if (this.fSendCharDataAsCharArray) {
                            this.appendCharData(var3_3);
                        }
                        var3_3 = this.loadNextByte();
                        continue block23;
                    }
                    case 3: {
                        var4_6 = this.fCurrentOffset++;
                        var3_3 = this.loadNextByte();
                        if (var3_3 != 93) {
                            ++this.fCharacterCounter;
                            if (!this.fSendCharDataAsCharArray) continue block23;
                            this.appendCharData(93);
                            continue block23;
                        }
                        if (this.fCurrentIndex + 1 == 16384) {
                            var5_9 = this.fCurrentChunk;
                            var6_10 = this.fCurrentIndex;
                            var7_11 = this.fCurrentOffset;
                            if (this.loadNextByte() != 62) {
                                this.fCurrentChunk = var5_9;
                                this.fCurrentIndex = var6_10;
                                this.fCurrentOffset = var7_11;
                                this.fMostRecentData = var5_9.toByteArray();
                                this.fMostRecentByte = 93;
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block23;
                                this.appendCharData(93);
                                continue block23;
                            }
                        } else {
                            if (this.fMostRecentData[this.fCurrentIndex + 1] != 62) {
                                ++this.fCharacterCounter;
                                if (!this.fSendCharDataAsCharArray) continue block23;
                                this.appendCharData(93);
                                continue block23;
                            }
                            ++this.fCurrentIndex;
                        }
                        this.loadNextByte();
                        if (this.fDocumentHandler != null) {
                            this.callCharDataHandler(var2_2, var4_6, var1_1.inCDSect);
                        }
                        this.fCharacterCounter += 3;
                        if (var1_1.inCDSect) {
                            var1_1.inCDSect = false;
                            return this.scanContent(var1_1);
                        }
                        return 11;
                    }
                    case 4: 
                }
                if (var3_3 == 10) {
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                    var3_3 = this.loadNextByte();
                    continue;
                }
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                }
                return 12;
            }
            if (this.fSendCharDataAsCharArray) {
                if (!this.copyMultiByteCharData(var3_3)) {
                    this.callCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                    return 12;
                }
            } else if (!this.skipMultiByteCharData(var3_3)) {
                if (this.fDocumentHandler != null) {
                    this.callCharDataHandler(var2_2, this.fCurrentOffset, var1_1.inCDSect);
                }
                return 12;
            }
            var3_3 = this.fMostRecentByte;
        }
    }

    protected boolean copyMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            int n5 = ((0x1F & n) << 6) + (0x3F & n4);
            this.appendCharData(n5);
            return true;
        }
        int n6 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n6 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            int n7 = ((0xF & n) << 12) + ((0x3F & n4) << 6) + (0x3F & n6);
            this.appendCharData(n7);
            return true;
        }
        int n8 = this.loadNextByte();
        if (n > 244 || n == 244 && n4 >= 144) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n2;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        int n9 = ((0xF & n) << 18) + ((0x3F & n4) << 12) + ((0x3F & n6) << 6) + (0x3F & n8);
        if (n9 < 65536) {
            this.appendCharData(n9);
        } else {
            this.appendCharData((n9 - 65536 >> 10) + 55296);
            this.appendCharData((n9 - 65536 & 0x3FF) + 56320);
        }
        return true;
    }

    protected boolean skipMultiByteCharData(int n) throws Exception {
        UTF8DataChunk uTF8DataChunk = this.fCurrentChunk;
        int n2 = this.fCurrentOffset;
        int n3 = this.fCurrentIndex;
        int n4 = this.loadNextByte();
        if ((0xE0 & n) == 192) {
            return true;
        }
        int n5 = this.loadNextByte();
        if ((0xF0 & n) == 224) {
            if (n == 237 && n4 >= 160 || n == 239 && n4 == 191 && n5 >= 190) {
                this.fCurrentChunk = uTF8DataChunk;
                this.fCurrentIndex = n3;
                this.fCurrentOffset = n2;
                this.fMostRecentData = uTF8DataChunk.toByteArray();
                this.fMostRecentByte = n;
                return false;
            }
            return true;
        }
        this.loadNextByte();
        if (n > 244 || n == 244 && n4 >= 144) {
            this.fCurrentChunk = uTF8DataChunk;
            this.fCurrentIndex = n3;
            this.fCurrentOffset = n2;
            this.fMostRecentData = uTF8DataChunk.toByteArray();
            this.fMostRecentByte = n;
            return false;
        }
        return true;
    }

    protected int copyAsciiCharData() throws Exception {
        int n = this.fCharDataLength;
        int n2 = this.fCurrentIndex;
        int n3 = this.fCurrentOffset - n2;
        while (true) {
            byte[] byArray = this.fMostRecentData;
            while (n2 < 16384) {
                int n4 = 16384;
                int n5 = this.fCharacters.length - 2 - n;
                int n6 = 16384 - n2;
                if (n5 < n6) {
                    if (n5 < 64) {
                        char[] cArray = new char[this.fCharacters.length * 2];
                        System.arraycopy(this.fCharacters, 0, cArray, 0, this.fCharacters.length);
                        this.fCharacters = cArray;
                        n5 = this.fCharacters.length - 2 - n;
                        if (n5 < n6) {
                            n4 = n2 + n5;
                        }
                    } else {
                        n4 = n2 + n5;
                    }
                }
                while (n2 < n4) {
                    int n7 = byArray[n2] & 0xFF;
                    if ((n7 & 0x80) != 0) {
                        this.fCurrentOffset = n3 + n2;
                        this.fCurrentIndex = n2;
                        this.fMostRecentByte = n7;
                        this.fCharDataLength = n;
                        return n7;
                    }
                    if (XMLReader.fgAsciiCharData[n7] != 0) {
                        if (n7 != 10) {
                            this.fCurrentOffset = n3 + n2;
                            this.fCurrentIndex = n2;
                            this.fMostRecentByte = n7;
                            this.fCharDataLength = n;
                            return n7;
                        }
                        ++this.fLinefeedCounter;
                        this.fCharacterCounter = 1;
                    } else {
                        ++this.fCharacterCounter;
                    }
                    this.fCharacters[n++] = (char)n7;
                    ++n2;
                }
            }
            n3 += n2;
            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n2 = 0;
        }
    }

    protected int skipAsciiCharData() throws Exception {
        int n = this.fCurrentIndex;
        int n2 = this.fCurrentOffset - n;
        while (true) {
            byte[] byArray = this.fMostRecentData;
            while (n < 16384) {
                int n3 = byArray[n] & 0xFF;
                if ((n3 & 0x80) != 0) {
                    this.fCurrentOffset = n2 + n;
                    this.fCurrentIndex = n;
                    this.fMostRecentByte = n3;
                    return n3;
                }
                if (XMLReader.fgAsciiCharData[n3] != 0) {
                    if (n3 != 10) {
                        this.fCurrentOffset = n2 + n;
                        this.fCurrentIndex = n;
                        this.fMostRecentByte = n3;
                        return n3;
                    }
                    ++this.fLinefeedCounter;
                    this.fCharacterCounter = 1;
                } else {
                    ++this.fCharacterCounter;
                }
                ++n;
            }
            n2 += n;
            this.fCurrentChunk = new UTF8DataChunk(this.fStringPool, this.fCurrentChunk);
            this.fillCurrentChunk();
            n = 0;
        }
    }

    protected void appendCharData(int n) {
        if (this.fCharacters.length == this.fCharDataLength) {
            char[] cArray = new char[this.fCharacters.length * 2];
            System.arraycopy(this.fCharacters, 0, cArray, 0, this.fCharacters.length);
            this.fCharacters = cArray;
        }
        this.fCharacters[this.fCharDataLength++] = (char)n;
    }

    public void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        if (!this.fSendCharDataAsCharArray) {
            int n3 = n2 - n;
            n3 = n3 == 0 ? 0 : this.fCurrentChunk.addString(n, n3);
            this.fDocumentHandler.characters(n3, bl);
            return;
        }
        this.fDocumentHandler.characters(this.fCharacters, 0, this.fCharDataLength, bl);
    }

    public void callWSCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = this.fParserState.getScanner().getCurrentContentSpecType();
        if (n3 != 4) {
            this.callCharDataHandler(n, n2, bl);
            return;
        }
        if (!this.fSendCharDataAsCharArray) {
            int n4 = n2 - n;
            n4 = n4 == 0 ? 0 : this.fCurrentChunk.addString(n, n4);
            this.fDocumentHandler.ignorableWhitespace(n4, bl);
            return;
        }
        this.fDocumentHandler.ignorableWhitespace(this.fCharacters, 0, this.fCharDataLength, bl);
    }

    /*
     * Unable to fully structure code
     */
    protected int fillCurrentChunk() throws Exception {
        this.fOutputOffset = 0;
        if (this.fCheckOverflow) {
            if (this.fOverflowEnd < 16384) {
                if (this.fOverflowEnd > 0) {
                    this.fMostRecentData = new byte[1 + this.fOverflowEnd - this.fOverflowOffset];
                    this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                } else {
                    this.fMostRecentData = new byte[1];
                }
                this.fMostRecentData[this.fOutputOffset] = 0;
                this.fOverflow = null;
                this.fLength += this.fOutputOffset;
                this.fCurrentIndex = 0;
                this.fCurrentChunk.setByteArray(this.fMostRecentData);
                this.fMostRecentByte = this.fMostRecentData[0];
                return this.fMostRecentByte;
            }
            this.fMostRecentData = new byte[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
            this.fCheckOverflow = false;
        } else {
            if (this.fOverflow == null) {
                this.fOverflow = new byte[16384];
            }
            this.fMostRecentData = null;
        }
        do lbl-1000:
        // 3 sources

        {
            block12: {
                this.fOverflowOffset = 0;
                this.fOverflowEnd = 0;
                var1_1 = 16384;
                var2_2 = 0;
                do {
                    if ((var2_2 = this.fInputStream.read(this.fOverflow, this.fOverflowEnd, var1_1)) == -1) {
                        this.fInputStream.close();
                        this.fInputStream = null;
                        if (this.fMostRecentData == null) {
                            this.fMostRecentData = new byte[1 + this.fOverflowEnd];
                            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = 0;
                            break;
                        }
                        var3_3 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                        if (var3_3) {
                            if (this.fOverflowEnd == 16384) {
                                this.fCheckOverflow = true;
                                this.fOverflowOffset = 0;
                                this.fOverflowEnd = 0;
                                break;
                            }
                            this.fOverflow = null;
                            this.fMostRecentData[this.fOutputOffset] = 0;
                            break;
                        }
                        this.fCheckOverflow = true;
                        break;
                    }
                    if (var2_2 <= 0) continue;
                    this.fOverflowEnd += var2_2;
                    var1_1 -= var2_2;
                } while (var1_1 > 0);
                if (var2_2 == -1) break;
                if (this.fMostRecentData == null) break block12;
                var3_3 = this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
                if (this.fOutputOffset != 16384) ** GOTO lbl-1000
                if (var3_3) break;
                this.fCheckOverflow = true;
                break;
            }
            this.fMostRecentData = new byte[16384];
            this.copyNormalize(this.fOverflow, this.fOverflowOffset, this.fMostRecentData, this.fOutputOffset);
        } while (this.fOutputOffset != 16384);
        this.fLength += this.fOutputOffset;
        this.fCurrentIndex = 0;
        this.fCurrentChunk.setByteArray(this.fMostRecentData);
        this.fMostRecentByte = this.fMostRecentData[0];
        return this.fMostRecentByte;
    }

    protected boolean copyNormalize(byte[] byArray, int n, byte[] byArray2, int n2) throws Exception {
        int n3;
        int n4 = this.fOverflowEnd;
        int n5 = byArray2.length;
        if (n == n4) {
            return true;
        }
        byte by = byArray[n];
        if (this.fSkipLinefeed) {
            this.fSkipLinefeed = false;
            if (by == 10) {
                if (++n == n4) {
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n2;
                    return true;
                }
                by = byArray[n];
            }
        } else if (this.fPartialMultiByteIn > 0) {
            if (!this.handlePartialMultiByteChar(by, byArray, n, n4, byArray2, n2, n5)) {
                return this.fPartialMultiByteResult;
            }
            n = this.fOverflowOffset;
            n2 = this.fOutputOffset;
            by = byArray[n];
        }
        while (n2 < n5) {
            n3 = n4 - n;
            int n6 = n5 - n2;
            if (n3 > n6) {
                n3 = n6;
            }
            ++n;
            while (true) {
                if (by == 13 || (by & 0x80) != 0) {
                    if (by == 13) {
                        byArray2[n2++] = 10;
                        if (n == n4) {
                            this.fSkipLinefeed = true;
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n2;
                            return true;
                        }
                        by = byArray[n];
                        if (by == 10) {
                            if (++n == n4) {
                                this.fOverflowOffset = n;
                                this.fOutputOffset = n2;
                                return true;
                            }
                            by = byArray[n];
                        }
                        if (n2 == n5) {
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n2;
                            return false;
                        }
                    } else {
                        if (!this.handleMultiByteChar(by, byArray, n, n4, byArray2, n2, n5)) {
                            return this.fPartialMultiByteResult;
                        }
                        n = this.fOverflowOffset;
                        n2 = this.fOutputOffset;
                        by = byArray[n];
                    }
                    if ((n3 = n4 - n) > (n6 = n5 - n2)) {
                        n3 = n6;
                    }
                    ++n;
                    continue;
                }
                do {
                    byArray2[n2++] = by;
                } while (--n3 != 0 && (by = byArray[n++]) != 13 && (by & 0x80) == 0);
                if (n3 == 0) break;
            }
            if (n == n4) break;
        }
        n3 = n != n4 ? 0 : 1;
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return n3 != 0;
    }

    protected boolean exitNormalize(int n, int n2, boolean bl) {
        this.fOverflowOffset = n;
        this.fOutputOffset = n2;
        return bl;
    }

    protected void savePartialMultiByte(int n, int n2, byte by, byte by2, byte by3, byte by4) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteOut = n2;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
        this.fPartialMultiByteChar[--n] = by3;
        this.fPartialMultiByteChar[--n] = by4;
    }

    protected void savePartialMultiByte(int n, int n2, byte by, byte by2, byte by3) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteOut = n2;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
        this.fPartialMultiByteChar[--n] = by3;
    }

    protected void savePartialMultiByte(int n, int n2, byte by, byte by2) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteOut = n2;
        this.fPartialMultiByteChar[n] = by;
        this.fPartialMultiByteChar[--n] = by2;
    }

    protected void savePartialMultiByte(int n, int n2, byte by) {
        this.fPartialMultiByteIn = n--;
        this.fPartialMultiByteOut = n2;
        this.fPartialMultiByteChar[n] = by;
    }

    protected boolean handleMultiByteChar(byte by, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws Exception {
        byte by2;
        if (n == n2) {
            int n5 = 1;
            this.fPartialMultiByteIn = n5--;
            this.fPartialMultiByteOut = 0;
            this.fPartialMultiByteChar[n5] = by;
            this.fOverflowOffset = n;
            this.fOutputOffset = n3;
            this.fPartialMultiByteResult = true;
            return false;
        }
        if (((by2 = byArray[n++]) & 0xC0) != 128) {
            this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)));
        }
        if ((by & 0xE0) == 192) {
            byArray2[n3++] = by;
            if (n3 == n4) {
                this.savePartialMultiByte(2, 1, by2, by);
                boolean bl = n == n2;
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = bl;
                return false;
            }
            byArray2[n3++] = by2;
            if (n == n2 || n3 == n4) {
                boolean bl = n == n2;
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = bl;
                return false;
            }
        } else {
            byte by3;
            if (n == n2) {
                this.savePartialMultiByte(2, 0, by2, by);
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = true;
                return false;
            }
            if (((by3 = byArray[n++]) & 0xC0) != 128) {
                this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)));
            }
            if ((by & 0xF0) == 224) {
                byArray2[n3++] = by;
                if (n3 == n4) {
                    this.savePartialMultiByte(3, 1, by3, by2, by);
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
                byArray2[n3++] = by2;
                if (n3 == n4) {
                    this.savePartialMultiByte(3, 2, by3, by2, by);
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
                byArray2[n3++] = by3;
                if (n == n2 || n3 == n4) {
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
            } else {
                byte by4;
                if ((by & 0xF8) != 240) {
                    this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(by)));
                }
                if (n == n2) {
                    this.savePartialMultiByte(3, 0, by3, by2, by);
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (((by4 = byArray[n++]) & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)), this.fStringPool.addString(Integer.toHexString(by4)));
                }
                byArray2[n3++] = by;
                if (n3 == n4) {
                    this.savePartialMultiByte(4, 1, by4, by3, by2, by);
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
                byArray2[n3++] = by2;
                if (n3 == n4) {
                    this.savePartialMultiByte(4, 2, by4, by3, by2, by);
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
                byArray2[n3++] = by3;
                if (n3 == n4) {
                    this.savePartialMultiByte(4, 3, by4, by3, by2, by);
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
                byArray2[n3++] = by4;
                if (n == n2 || n3 == n4) {
                    boolean bl = n == n2;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = bl;
                    return false;
                }
            }
        }
        this.fOverflowOffset = n;
        this.fOutputOffset = n3;
        return true;
    }

    protected boolean handlePartialMultiByteChar(byte by, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws Exception {
        if (n3 == n4) {
            boolean bl = n == n2;
            this.fOverflowOffset = n;
            this.fOutputOffset = n3;
            this.fPartialMultiByteResult = bl;
            return false;
        }
        int n5 = this.fPartialMultiByteIn;
        int n6 = this.fPartialMultiByteOut;
        this.fPartialMultiByteIn = 0;
        this.fPartialMultiByteOut = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        switch (n5) {
            case 1: {
                by2 = by;
                break;
            }
            case 2: {
                by3 = by;
                break;
            }
            case 3: {
                by4 = by;
                break;
            }
            case 4: {
                by5 = by;
            }
        }
        int n7 = n5;
        switch (n5) {
            case 4: {
                by4 = this.fPartialMultiByteChar[--n7];
            }
            case 3: {
                by3 = this.fPartialMultiByteChar[--n7];
            }
            case 2: {
                by2 = this.fPartialMultiByteChar[--n7];
            }
            case 1: {
                by = this.fPartialMultiByteChar[--n7];
            }
        }
        switch (n5) {
            case 1: {
                if ((by2 & 0xC0) != 128) {
                    this.fErrorHandler.error2(57, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)));
                }
            }
            case 2: {
                if ((by & 0xE0) == 192) {
                    switch (n6) {
                        case 0: {
                            byArray2[n3++] = by;
                            if (n3 == n4) {
                                int n8 = 2;
                                this.fPartialMultiByteIn = n8--;
                                this.fPartialMultiByteOut = 1;
                                this.fPartialMultiByteChar[n8] = by2;
                                this.fOverflowOffset = n;
                                this.fOutputOffset = n3;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 1: {
                            byArray2[n3++] = by2;
                            if (n3 != n4) break;
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n3;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    if (n5 >= 2 || ++n != n2) break;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (n5 < 2) {
                    if (++n == n2) {
                        int n9 = 2;
                        this.fPartialMultiByteIn = n9--;
                        this.fPartialMultiByteOut = 0;
                        this.fPartialMultiByteChar[n9] = by2;
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    by3 = byArray[n];
                }
                if ((by3 & 0xC0) != 128) {
                    this.fErrorHandler.error3(58, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)));
                }
            }
            case 3: {
                if ((by & 0xF0) == 224) {
                    switch (n6) {
                        case 0: {
                            byArray2[n3++] = by;
                            if (n3 == n4) {
                                this.savePartialMultiByte(3, 1, by3, by2);
                                this.fOverflowOffset = n;
                                this.fOutputOffset = n3;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 1: {
                            byArray2[n3++] = by2;
                            if (n3 == n4) {
                                this.savePartialMultiByte(3, 2, by3, by2);
                                this.fOverflowOffset = n;
                                this.fOutputOffset = n3;
                                this.fPartialMultiByteResult = false;
                                return false;
                            }
                        }
                        case 2: {
                            byArray2[n3++] = by3;
                            if (n3 != n4) break;
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n3;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    if (n5 >= 3 || ++n != n2) break;
                    this.fOverflowOffset = n;
                    this.fOutputOffset = n3;
                    this.fPartialMultiByteResult = true;
                    return false;
                }
                if (n5 < 3) {
                    if ((by & 0xF8) != 240) {
                        this.fErrorHandler.error1(56, this.fStringPool.addString(Integer.toHexString(by)));
                    }
                    if (++n == n2) {
                        this.savePartialMultiByte(3, 0, by3, by2);
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = true;
                        return false;
                    }
                    by4 = byArray[n];
                }
                if ((by4 & 0xC0) != 128) {
                    this.fErrorHandler.error4(59, this.fStringPool.addString(Integer.toHexString(by)), this.fStringPool.addString(Integer.toHexString(by2)), this.fStringPool.addString(Integer.toHexString(by3)), this.fStringPool.addString(Integer.toHexString(by4)));
                }
            }
            case 4: {
                switch (n6) {
                    case 0: {
                        byArray2[n3++] = by;
                        if (n3 == n4) {
                            this.savePartialMultiByte(4, 1, by4, by3, by2);
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n3;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 1: {
                        byArray2[n3++] = by2;
                        if (n3 == n4) {
                            this.savePartialMultiByte(4, 2, by4, by3, by2);
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n3;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 2: {
                        byArray2[n3++] = by3;
                        if (n3 == n4) {
                            this.savePartialMultiByte(4, 3, by4, by3, by2);
                            this.fOverflowOffset = n;
                            this.fOutputOffset = n3;
                            this.fPartialMultiByteResult = false;
                            return false;
                        }
                    }
                    case 3: {
                        byArray2[n3++] = by4;
                        if (n3 != n4) break;
                        this.fOverflowOffset = n;
                        this.fOutputOffset = n3;
                        this.fPartialMultiByteResult = false;
                        return false;
                    }
                }
                if (n5 >= 4 || ++n != n2) break;
                this.fOverflowOffset = n;
                this.fOutputOffset = n3;
                this.fPartialMultiByteResult = true;
                return false;
            }
        }
        this.fOverflowOffset = n;
        this.fOutputOffset = n3;
        return true;
    }

    protected class UTF8DataChunk
    implements StringProducer {
        protected StringPool fStringPool;
        protected int fChunk;
        protected byte[] fData;
        protected UTF8DataChunk fPreviousChunk;
        protected UTF8DataChunk fNextChunk;

        protected UTF8DataChunk(StringPool stringPool, UTF8DataChunk uTF8DataChunk) throws Exception {
            UTF8Reader.this = UTF8Reader.this;
            this.fStringPool = stringPool;
            this.fChunk = uTF8DataChunk == null ? 0 : uTF8DataChunk.fChunk + 1;
            this.fPreviousChunk = uTF8DataChunk;
            if (uTF8DataChunk != null) {
                uTF8DataChunk.fNextChunk = this;
            }
        }

        protected UTF8DataChunk(UTF8DataChunk uTF8DataChunk) {
            UTF8Reader.this = UTF8Reader.this;
            this.fStringPool = uTF8DataChunk.fStringPool;
            this.fChunk = uTF8DataChunk.fChunk;
            this.fData = uTF8DataChunk.fData;
            this.fPreviousChunk = null;
            this.fNextChunk = null;
        }

        public UTF8DataChunk chunkFor(int n) {
            int n2 = n >> 14;
            UTF8DataChunk uTF8DataChunk = this;
            while (n2 != uTF8DataChunk.fChunk) {
                uTF8DataChunk = uTF8DataChunk.fPreviousChunk;
            }
            return uTF8DataChunk;
        }

        public byte[] toByteArray() {
            return this.fData;
        }

        public void setByteArray(byte[] byArray) {
            this.fData = byArray;
        }

        public UTF8DataChunk nextChunk() {
            return this.fNextChunk;
        }

        public void clearPreviousChunk() {
            if (this.fPreviousChunk != null) {
                this.fPreviousChunk.fNextChunk = null;
                this.fPreviousChunk = null;
            }
        }

        public String toString(int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer(n2);
            UTF8DataChunk uTF8DataChunk = this;
            int n3 = n + n2;
            int n4 = n & 0x3FFF;
            byte[] byArray = this.fData;
            while (n < n3) {
                int n5;
                int n6;
                int n7;
                int n8 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((n8 & 0x80) == 0) {
                    stringBuffer.append((char)n8);
                    continue;
                }
                int n9 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((0xE0 & n8) == 192) {
                    n7 = ((0x1F & n8) << 6) + (0x3F & n9);
                    stringBuffer.append((char)n7);
                    continue;
                }
                n7 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((0xF0 & n8) == 224) {
                    n6 = ((0xF & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n7);
                    stringBuffer.append((char)n6);
                    continue;
                }
                n6 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((n5 = ((0xF & n8) << 18) + ((0x3F & n9) << 12) + ((0x3F & n7) << 6) + (0x3F & n6)) < 65536) {
                    stringBuffer.append((char)n5);
                    continue;
                }
                stringBuffer.append((char)((n5 - 65536 >> 10) + 55296));
                stringBuffer.append((char)((n5 - 65536 & 0x3FF) + 56320));
            }
            return stringBuffer.toString();
        }

        public boolean equalsString(int n, int n2, String string, int n3) {
            UTF8DataChunk uTF8DataChunk = this;
            int n4 = n + n2;
            int n5 = n & 0x3FFF;
            byte[] byArray = this.fData;
            int n6 = 0;
            while (n < n4) {
                int n7;
                int n8;
                int n9;
                if (n6 == n3) {
                    return false;
                }
                int n10 = byArray[n5++] & 0xFF;
                ++n;
                if (n5 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n5 = 0;
                }
                if ((n10 & 0x80) == 0) {
                    if (n10 == string.charAt(n6++)) continue;
                    return false;
                }
                int n11 = byArray[n5++] & 0xFF;
                ++n;
                if (n5 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n5 = 0;
                }
                if ((0xE0 & n10) == 192) {
                    n9 = ((0x1F & n10) << 6) + (0x3F & n11);
                    if (n9 == string.charAt(n6++)) continue;
                    return false;
                }
                n9 = byArray[n5++] & 0xFF;
                ++n;
                if (n5 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n5 = 0;
                }
                if ((0xF0 & n10) == 224) {
                    n8 = ((0xF & n10) << 12) + ((0x3F & n11) << 6) + (0x3F & n9);
                    if (n8 == string.charAt(n6++)) continue;
                    return false;
                }
                n8 = byArray[n5++] & 0xFF;
                ++n;
                if (n5 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n5 = 0;
                }
                if ((n7 = ((0xF & n10) << 18) + ((0x3F & n11) << 12) + ((0x3F & n9) << 6) + (0x3F & n8)) < 65536) {
                    if (n7 == string.charAt(n6++)) continue;
                    return false;
                }
                if ((n7 - 65536 >> 10) + 55296 != string.charAt(n6++)) {
                    return false;
                }
                if (n6 == n3) {
                    return false;
                }
                if ((n7 - 65536 & 0x3FF) + 56320 == string.charAt(n6++)) continue;
                return false;
            }
            return n6 == n3;
        }

        protected UTF8DataChunk createClump(int n) {
            UTF8DataChunk uTF8DataChunk = new UTF8DataChunk(this);
            UTF8DataChunk uTF8DataChunk2 = this.fNextChunk;
            UTF8DataChunk uTF8DataChunk3 = uTF8DataChunk;
            do {
                UTF8DataChunk uTF8DataChunk4;
                uTF8DataChunk3.fNextChunk = uTF8DataChunk4 = new UTF8DataChunk(uTF8DataChunk2);
                uTF8DataChunk2 = uTF8DataChunk2.fNextChunk;
                uTF8DataChunk3 = uTF8DataChunk4;
            } while (uTF8DataChunk3.fChunk != n);
            return uTF8DataChunk;
        }

        public int addString(int n, int n2) {
            int n3 = n >> 14;
            if (n3 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addString(n, n2);
                }
                try {
                    UTF8Reader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n4 = n + n2 - 1 >> 14;
            if (n3 == n4) {
                return this.fStringPool.addString(this, n & 0x3FFF, n2);
            }
            return this.fStringPool.addString(this.createClump(n4), n & 0x3FFF, n2);
        }

        public int addSymbol(int n, int n2, int n3) {
            int n4 = n >> 14;
            if (n4 != this.fChunk) {
                if (this.fPreviousChunk != null) {
                    return this.fPreviousChunk.addSymbol(n, n2, n3);
                }
                try {
                    UTF8Reader.this.fErrorHandler.error(168);
                }
                catch (Exception exception) {}
                return -1;
            }
            int n5 = n + n2 - 1 >> 14;
            if (n4 == n5) {
                if (n3 == 0) {
                    n3 = this.getHashcode(n, n2);
                }
                return this.fStringPool.addSymbol(this, n & 0x3FFF, n2, n3);
            }
            if (n3 == 0) {
                n3 = this.getHashcode(n, n2);
            }
            return this.fStringPool.addSymbol(this.createClump(n5), n & 0x3FFF, n2, n3);
        }

        public void append(ChunkyCharArray chunkyCharArray, int n, int n2) {
            UTF8DataChunk uTF8DataChunk = this.chunkFor(n);
            int n3 = n + n2;
            int n4 = n & 0x3FFF;
            byte[] byArray = this.fData;
            while (n < n3) {
                int n5;
                int n6;
                int n7;
                int n8 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((n8 & 0x80) == 0) {
                    chunkyCharArray.append((char)n8);
                    continue;
                }
                int n9 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((0xE0 & n8) == 192) {
                    n7 = ((0x1F & n8) << 6) + (0x3F & n9);
                    chunkyCharArray.append((char)n7);
                    continue;
                }
                n7 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((0xF0 & n8) == 224) {
                    n6 = ((0xF & n8) << 12) + ((0x3F & n9) << 6) + (0x3F & n7);
                    chunkyCharArray.append((char)n6);
                    continue;
                }
                n6 = byArray[n4++] & 0xFF;
                ++n;
                if (n4 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n4 = 0;
                }
                if ((n5 = ((0xF & n8) << 18) + ((0x3F & n9) << 12) + ((0x3F & n7) << 6) + (0x3F & n6)) < 65536) {
                    chunkyCharArray.append((char)n5);
                    continue;
                }
                chunkyCharArray.append((char)((n5 - 65536 >> 10) + 55296));
                chunkyCharArray.append((char)((n5 - 65536 & 0x3FF) + 56320));
            }
        }

        protected int getHashcode(int n, int n2) {
            int n3;
            UTF8DataChunk uTF8DataChunk = this.chunkFor(n);
            int n4 = n + n2;
            int n5 = 0;
            int n6 = 0;
            int n7 = n & 0x3FFF;
            byte[] byArray = uTF8DataChunk.fData;
            while (n < n4) {
                int n8;
                int n9;
                int n10;
                n3 = byArray[n7++] & 0xFF;
                ++n;
                if (n7 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n7 = 0;
                }
                if ((n3 & 0x80) == 0) {
                    n5 = StringHasher.hashChar(n5, n6++, n3);
                    continue;
                }
                int n11 = byArray[n7++] & 0xFF;
                ++n;
                if (n7 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n7 = 0;
                }
                if ((0xE0 & n3) == 192) {
                    n10 = ((0x1F & n3) << 6) + (0x3F & n11);
                    n5 = StringHasher.hashChar(n5, n6++, n10);
                    continue;
                }
                n10 = byArray[n7++] & 0xFF;
                ++n;
                if (n7 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n7 = 0;
                }
                if ((0xF0 & n3) == 224) {
                    n9 = ((0xF & n3) << 12) + ((0x3F & n11) << 6) + (0x3F & n10);
                    n5 = StringHasher.hashChar(n5, n6++, n9);
                    continue;
                }
                n9 = byArray[n7++] & 0xFF;
                ++n;
                if (n7 == 16384) {
                    uTF8DataChunk = uTF8DataChunk.fNextChunk;
                    byArray = uTF8DataChunk.fData;
                    n7 = 0;
                }
                if ((n8 = ((0xF & n3) << 18) + ((0x3F & n11) << 12) + ((0x3F & n10) << 6) + (0x3F & n9)) < 65536) {
                    n5 = StringHasher.hashChar(n5, n6++, n8);
                    continue;
                }
                n5 = StringHasher.hashChar(n5, n6++, (n8 - 65536 >> 10) + 55296);
                n5 = StringHasher.hashChar(n5, n6++, (n8 - 65536 & 0x3FF) + 56320);
            }
            n3 = n5;
            if ((n3 &= Integer.MAX_VALUE) == 0) {
                return 1;
            }
            return n3;
        }
    }
}

