/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.parser;

import com.ibm.xml.parser.Child;
import com.ibm.xml.parser.TXDOMException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TXNodeList
implements NodeList,
Serializable {
    static final long serialVersionUID = 3392852660870983354L;
    Vector nodes = new Vector();
    static EmptyNodeListImpl emptyNodeList = new EmptyNodeListImpl();

    public int getLength() {
        return this.nodes.size();
    }

    public Enumeration elements() {
        return this.nodes.elements();
    }

    public Node item(int n) {
        return (Node)this.nodes.elementAt(n);
    }

    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    public void replace(int n, Node node) throws DOMException {
        if (n < 0 || this.nodes.size() <= n) {
            throw new TXDOMException(1, "com.ibm.xml.parser.TXNodeList#replace(): Wrong index: " + n);
        }
        Child child = (Child)this.item(n);
        Child child2 = (Child)child.getPreviousSibling();
        Child child3 = (Child)child.getNextSibling();
        this.nodes.setElementAt(node, n);
        Child child4 = (Child)node;
        child4.setPreviousSibling(child2);
        if (child2 != null) {
            child2.setNextSibling(child4);
        }
        child4.setNextSibling(child3);
        if (child3 != null) {
            child3.setPreviousSibling(child4);
        }
        child.setPreviousSibling(null);
        child.setNextSibling(null);
        child.setParentNode(null);
    }

    public void insert(int n, Node node) throws DOMException {
        if (n < 0 || n > this.nodes.size()) {
            throw new TXDOMException(1, "com.ibm.xml.parser.TXNodeList#insert(): Wrong index: " + n);
        }
        Child child = n > 0 ? (Child)this.nodes.elementAt(n - 1) : null;
        Child child2 = this.nodes.size() > n ? (Child)this.nodes.elementAt(n) : null;
        this.nodes.insertElementAt(node, n);
        Child child3 = (Child)node;
        child3.setPreviousSibling(child);
        if (child != null) {
            child.setNextSibling(child3);
        }
        child3.setNextSibling(child2);
        if (child2 != null) {
            child2.setPreviousSibling(child3);
        }
    }

    public Node remove(int n) throws DOMException {
        if (n < 0 || this.nodes.size() <= n) {
            throw new TXDOMException(1, "com.ibm.xml.parser.TXNodeList#remove(): Wrong index: " + n);
        }
        Child child = (Child)this.nodes.elementAt(n);
        Child child2 = (Child)child.getPreviousSibling();
        Child child3 = (Child)child.getNextSibling();
        this.nodes.removeElementAt(n);
        child.setParentNode(null);
        child.setPreviousSibling(null);
        child.setNextSibling(null);
        if (child2 != null) {
            child2.setNextSibling(child3);
        }
        if (child3 != null) {
            child3.setPreviousSibling(child2);
        }
        return child;
    }

    public void append(Node node) {
        this.insert(this.nodes.size(), node);
    }

    public void ensureCapacity(int n) {
        this.nodes.ensureCapacity(n);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public synchronized boolean equals(Object object, boolean bl) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NodeList)) {
            return false;
        }
        NodeList nodeList = (NodeList)object;
        if (nodeList.getLength() != this.getLength()) {
            return false;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (!((Child)node).equals(this.item(n), bl)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    TXNodeList() {
    }

    static class EmptyNodeListImpl
    implements NodeList {
        public Node item(int n) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public int getLength() {
            return 0;
        }

        EmptyNodeListImpl() {
        }
    }

    static class VectorNodeList
    implements NodeList {
        Vector data;

        VectorNodeList(Vector vector) {
            this.data = vector;
        }

        public Node item(int n) {
            return (Node)this.data.elementAt(n);
        }

        public int getLength() {
            return this.data.size();
        }
    }

    static class ArrayNodeList
    implements NodeList {
        Node[] data;

        ArrayNodeList(Node[] nodeArray) {
            this.data = nodeArray;
        }

        public Node item(int n) {
            return this.data[n];
        }

        public int getLength() {
            return this.data.length;
        }
    }
}

