/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

class ACatalog
implements Serializable {
    private AGroupObjectsSet iGroupObjectsSet;
    private AFileObjectsSet iFileObjectsSet;
    private ATraceFile tf = new ATraceFile(this);
    private ARepository aRepository;
    public LineNumberReader catalogBuffer;
    static int indexCounter;
    private boolean iChanged;
    private boolean iCatalogValid;
    private boolean iCatalogRead;
    private AFtp aFtp = null;
    private int iCurrentKey;
    static final int keyIndex = 0;
    static final int keyFilename = 1;
    static final int keyNameInRepository = 2;
    static final int keyFileNameType = 3;
    static final int keyComparisonName = 4;
    static final String LABELCATALOGVERSION;
    static final String CATALOGVERSION;
    static final String LABELNUMBERFILES;
    static final String LABELNUMBERGROUPS;
    static final String LABEL_FILE;
    static final String LABEL_GROUP;
    static final String LABEL_INDEX;
    static final String LABEL_FILENAME;
    static final String LABEL_PCFILETYPE;
    static final String LABEL_TITLE;
    static final String LABEL_HOSTFILETYPE;
    static final String LABEL_NAMEINREPOSITORY;
    static final String LABEL_DATE;
    static final String LABEL_INSTALLDATE;
    static final String LABEL_REFERENCECOUNT;
    static final String LABEL_GROUPOBJECTPTR;
    static final String LABEL_MISSINGFROMGROUP;
    static final String LABEL_FILESIZE;
    static final String LABEL_FILEOBJECTPTR;
    static final String LABEL_FILEOBJECTS;
    static final String LABEL_MISSINGFILEOBJECTS;
    static final String LEFTSQUAREBRACE;
    static final String RIGHTSQUAREBRACE;
    static final String SPACE;
    static final String DOT;
    static /* synthetic */ Class class$AFileObject;
    static /* synthetic */ Class class$AGroupObject;

    ACatalog(ARepository aRepository) {
        this.aRepository = aRepository;
        this.iGroupObjectsSet = new AGroupObjectsSet();
        this.iFileObjectsSet = new AFileObjectsSet();
        this.setChanged(false);
        this.setCatalogValid(false);
        this.setCatalogRead(false);
    }

    public void clearCatalog() {
        this.fileObjectsSet().clear();
        this.groupObjectsSet().clear();
        this.setChanged(false);
        this.setCatalogValid(false);
        this.setCatalogRead(false);
    }

    public void setRepository(ARepository aRepository) {
        this.aRepository = aRepository;
    }

    public ARepository repository() {
        return this.aRepository;
    }

    public void setChanged(boolean bl) {
        this.iChanged = bl;
    }

    protected boolean hasChanged() {
        return this.iChanged;
    }

    public void setCatalogValid(boolean bl) {
        this.iCatalogValid = bl;
    }

    public boolean isCatalogValid() {
        return this.iCatalogValid;
    }

    public void setCatalogRead(boolean bl) {
        this.iCatalogRead = bl;
    }

    public boolean isCatalogRead() {
        return this.iCatalogRead;
    }

    public int write(boolean bl) {
        boolean bl2 = true;
        this.resetIndexCounter(0);
        this.tf.write("write()", 10, "Entry");
        String string = this.aRepository.catalogFileName();
        AMainWindow.UpdateStatusInfo("Writing catalog " + string + " ...");
        AStatusWindow.write("Writing catalog " + string + " ...");
        try {
            ABaseObject aBaseObject;
            File file = new File(string);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(LABELCATALOGVERSION + CATALOGVERSION);
            printStream.println(LABELNUMBERFILES + this.fileObjectsSet().size());
            printStream.println(LABELNUMBERGROUPS + this.groupObjectsSet().size());
            Enumeration enumeration = this.fileObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AFileObject)enumeration.nextElement();
                ((AFileObject)aBaseObject).writeCatalog(printStream);
            }
            this.tf.write("write()", 11, "After write fileObjectsSet()");
            enumeration = this.groupObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AGroupObject)enumeration.nextElement();
                ((AGroupObject)aBaseObject).writeCatalog(printStream);
            }
            printStream.close();
        }
        catch (IOException iOException) {
            AUtilities.showInfoMessage("Error saving catalog file : " + string);
            this.tf.write("write()", 0, "IO Exception writing :" + iOException.toString());
            bl2 = false;
        }
        AStatusWindow.write("Writing catalog " + string + " completed");
        this.setChanged(false);
        this.setCatalogRead(false);
        AMainWindow.UpdateStatusInfo("");
        this.tf.write("write()", 10, "Exit");
        return 0;
    }

    public AFtpReturnCode bookCase() {
        Object object;
        Object object2;
        String string = AUtilities.tempDirectory() + File.separator + "bookcase.fil";
        String string2 = this.repository().fileTypesList().getObject(3).bklShelfName();
        string2 = "'" + AUtilities.strip(string2, '\'') + ".BKLSHELF" + "'";
        File file = new File(string);
        this.tf.write("bookCase()", 22, "bookCaseFileName:" + string + ", bookCaseFileNameOnHost:" + string2);
        AMainWindow.UpdateStatusInfo("Writing BKLSHELF ...");
        try {
            object2 = new PrintStream(new FileOutputStream(file));
            this.tf.write("bookCase()", 22, "Print stream create");
            Enumeration enumeration = this.groupObjectsSet().elements();
            this.tf.write("bookCase()", 22, "No. of group elements:" + this.groupObjectsSet().size());
            while (enumeration.hasMoreElements()) {
                AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
                object = AUtilities.strip(aGroupObject.nameInRepository(), '\'');
                this.tf.write("bookCase()", 22, "groupElement:" + aGroupObject.nameInRepository());
                if (this.repository().hostType() == 1) {
                    ((PrintStream)object2).println("SHELF " + aGroupObject.fileName() + " " + (String)object + " " + aGroupObject.title());
                    this.tf.write("bookCase()", 22, "nameInRepository:" + (String)object);
                    this.tf.write("bookCase()", 22, "Info. written:SHELF " + aGroupObject.fileName() + " " + (String)object + " " + aGroupObject.title());
                    continue;
                }
                ((PrintStream)object2).println("TEMP_HFS " + aGroupObject.fileName() + " " + (String)object + " " + aGroupObject.title());
            }
            ((PrintStream)object2).close();
        }
        catch (IOException iOException) {
            this.tf.write("bookCase()", 0, "IOException:" + iOException.toString());
        }
        AStatusWindow.write("Uploading BKLSHELF ...");
        object2 = this.repository().ftpSiteCommands(3);
        AFtp aFtp = new AFtp();
        aFtp.setLogonParameters(new AFtpLogonParameters(this.repository()));
        AFtpReturnCode aFtpReturnCode = aFtp.logon();
        if (aFtpReturnCode.getCommandCode() != 2) {
            this.tf.write("bookCase()", 0, "Ftp logon error:" + aFtpReturnCode.getCommandCode());
            aFtp.quit();
            AMainWindow.UpdateStatusInfo("");
            return aFtpReturnCode;
        }
        aFtpReturnCode = aFtp.quote("SITE RECFM=VB LRECL=259");
        aFtpReturnCode = aFtp.quote("SITE TRACK PRIMARY=1 SECONDARY=1");
        object = ((Vector)object2).elements();
        while (object.hasMoreElements()) {
            aFtpReturnCode = aFtp.quote((String)object.nextElement());
        }
        aFtpReturnCode = aFtp.ascii();
        aFtpReturnCode = aFtp.put(string, string2);
        if (aFtpReturnCode.getCommandCode() != 2) {
            this.tf.write("bookCase()", 0, "Ftp put error:" + aFtpReturnCode.getCommandCode());
            AMainWindow.UpdateStatusInfo("");
            return aFtpReturnCode;
        }
        AMainWindow.UpdateStatusInfo("");
        aFtp.quit();
        return aFtpReturnCode;
    }

    public int read(AMainWindow aMainWindow) throws IOException {
        Object object;
        Object object2;
        Object object3;
        ABaseObject aBaseObject;
        Object object4;
        int n = 0;
        String string = this.aRepository.catalogFileName();
        this.tf.write("read(AMainWindow)", 10, "Entry - " + string);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            return 1;
        }
        this.catalogBuffer = new LineNumberReader(fileReader);
        String string2 = "";
        String string3 = "";
        string2 = this.catalogBuffer.readLine();
        if (string2 == null) {
            this.catalogBuffer.close();
            return n;
        }
        if (!string2.startsWith(LABELCATALOGVERSION)) {
            return 4;
        }
        string3 = string2.substring(LABELCATALOGVERSION.length());
        int n2 = new Integer(string3);
        if (new Integer(string3) > new Integer(CATALOGVERSION)) {
            return 5;
        }
        string2 = this.catalogBuffer.readLine();
        if (!string2.startsWith(LABELNUMBERFILES)) {
            return 4;
        }
        string3 = string2.substring(LABELNUMBERFILES.length());
        Integer n3 = new Integer(string3);
        this.tf.write("read(AMainWindow)", 11, "No. of files..:" + n3);
        string2 = this.catalogBuffer.readLine();
        if (!string2.startsWith(LABELNUMBERGROUPS)) {
            return 4;
        }
        string3 = string2.substring(LABELNUMBERGROUPS.length());
        Integer n4 = new Integer(string3);
        this.tf.write("read(AMainWindow)", 11, "No. of group..:" + n4);
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        n5 = n3 + n4;
        this.tf.write("read(AMainWindow)", 11, "Total count:" + n5);
        AProgressObject aProgressObject = null;
        if (n5 > 100) {
            aProgressObject = new AProgressObject(aMainWindow, n5);
            aProgressObject.setText("Reading file objects from catalog file");
            bl = true;
        }
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < n3) {
                if (bl && ++n6 % 50 == 0 && !aProgressObject.update(n6) || bl && aProgressObject.isProcessCanceled()) break;
                object4 = new AFileObject();
                ((ABaseObject)object4).setInCatalog(true);
                if (((AFileObject)object4).readCatalog(this, n2) > 0) {
                    if (bl) {
                        aProgressObject.removeProgressObject();
                    }
                    this.tf.write("read(AMainWindow)", 0, "Error reading line no. : " + this.catalogBuffer.getLineNumber());
                    this.catalogBuffer.close();
                    fileReader.close();
                    return 3;
                }
                ((ABaseObject)object4).setKeyField(new Integer(((ABaseObject)object4).index()).toString());
                this.tf.write("read(AMainWindow)", 11, "File object added to set:" + ((ABaseObject)object4).keyField());
                this.fileObjectsSet().add(((ABaseObject)object4).keyField(), object4);
                ++n7;
            }
            if (bl && aProgressObject.isProcessCanceled()) {
                n = 2;
                break;
            }
            if (bl) {
                aProgressObject.setText("Reading group objects from catalog file");
            }
            int n8 = 0;
            while (n8 < n4) {
                if (bl && ++n6 % 25 == 0 && !aProgressObject.update(n6) || bl && aProgressObject.isProcessCanceled()) break;
                aBaseObject = new AGroupObject();
                aBaseObject.setInCatalog(true);
                if (((AGroupObject)aBaseObject).readCatalog(this, this.fileObjectsSet()) > 0) {
                    if (bl) {
                        aProgressObject.removeProgressObject();
                    }
                    this.tf.write("read(AMainWindow)", 0, "Error reading line no. : " + this.catalogBuffer.getLineNumber());
                    this.catalogBuffer.close();
                    fileReader.close();
                    return 3;
                }
                aBaseObject.setKeyField(new Integer(aBaseObject.index()).toString());
                object3 = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
                object2 = ((DateFormat)object3).format(aBaseObject.date());
                ((AGroupObject)aBaseObject).setShelfDate((String)object2);
                ((AGroupObject)aBaseObject).setShelfFileName(aBaseObject.fileName());
                object = ((AGroupObject)aBaseObject).fileObjectsSet().elements();
                while (object.hasMoreElements()) {
                    AFileObject aFileObject = (AFileObject)object.nextElement();
                    if (!aFileObject.pcFileType().toUpperCase().equals("BKI")) continue;
                    ((AGroupObject)aBaseObject).setIndexFileName(aFileObject.fileName());
                    object2 = ((DateFormat)object3).format(aFileObject.date());
                    ((AGroupObject)aBaseObject).setIndexDate((String)object2);
                    break;
                }
                this.groupObjectsSet().add(aBaseObject.keyField(), aBaseObject);
                this.tf.write("read(AMainWindow)", 11, "Group object added to set:" + aBaseObject.keyField());
                ++n8;
            }
            if (!bl || !aProgressObject.isProcessCanceled()) continue;
            n = 2;
            break;
        }
        if (bl && aProgressObject.isProcessCanceled()) {
            aProgressObject.removeProgressObject();
        }
        this.catalogBuffer.close();
        fileReader.close();
        if (n == 2) {
            return n;
        }
        Enumeration enumeration = this.fileObjectsSet().elements();
        object4 = this.groupObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            aBaseObject = (AFileObject)enumeration.nextElement();
            if (((AFileObject)aBaseObject).groupObjectPtrValue() != 0) {
                object3 = new Integer(((AFileObject)aBaseObject).groupObjectPtrValue()).toString();
                object2 = this.groupObjectsSet().getObjects(object3);
                if (object2 != null) {
                    ((AFileObject)aBaseObject).setGroupObjectPtr((AGroupObject)((Vector)object2).firstElement());
                } else {
                    ((AFileObject)aBaseObject).setGroupObjectPtr(null);
                }
            }
            if (!((AFileObject)aBaseObject).missingFromGroupValues().equals("")) {
                this.tf.write("read(AMainWindow)", 10, "Missing from group values:" + ((AFileObject)aBaseObject).missingFromGroupValues());
                object3 = new StringTokenizer(((AFileObject)aBaseObject).missingFromGroupValues(), " ");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    if (!this.groupObjectsSet().containsKey(object2)) continue;
                    this.tf.write("read(AMainWindow)", 10, "Group set contains the missing from group:" + (String)object2);
                    object = (AGroupObject)this.groupObjectsSet().getObjects(object2).elementAt(0);
                    ((AFileObject)aBaseObject).addToMissingFromGroupSet((AGroupObject)object);
                }
            }
            if (((AFileObject)aBaseObject).missingFromGroupSet().size() <= 0) continue;
            ((AFileObject)aBaseObject).setReferenceCount(-((AFileObject)aBaseObject).missingFromGroupSet().size());
        }
        if (bl) {
            aProgressObject.removeProgressObject();
        }
        this.setChanged(false);
        this.setCatalogRead(true);
        this.setCatalogValid(true);
        this.tf.write("read(AMainWindow)", 10, "Exit - " + string);
        return 0;
    }

    public int read(String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = 0;
        this.tf.write("Overload read()", 10, "Entry - " + string);
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
        }
        catch (IOException iOException) {
            return 1;
        }
        this.catalogBuffer = new LineNumberReader(fileReader);
        String string2 = "";
        String string3 = "";
        string2 = this.catalogBuffer.readLine();
        if (string2 == null) {
            this.catalogBuffer.close();
            return n;
        }
        if (!string2.startsWith(LABELCATALOGVERSION)) {
            return 4;
        }
        string3 = string2.substring(LABELCATALOGVERSION.length());
        int n2 = new Integer(string3);
        string2 = this.catalogBuffer.readLine();
        if (!string2.startsWith(LABELNUMBERFILES)) {
            return 4;
        }
        string3 = string2.substring(LABELNUMBERFILES.length());
        Integer n3 = new Integer(string3);
        this.tf.write("Overload read()", 10, "No. of files..:" + n3);
        string2 = this.catalogBuffer.readLine();
        if (!string2.startsWith(LABELNUMBERGROUPS)) {
            return 4;
        }
        string3 = string2.substring(LABELNUMBERGROUPS.length());
        Integer n4 = new Integer(string3);
        this.tf.write("Overload read()", 10, "No. of group..:" + n4);
        int n5 = n3 + n4;
        this.tf.write("Overload read()", 10, "Total count:" + n5);
        int n6 = 0;
        while (n6 < n3) {
            AFileObject aFileObject = new AFileObject();
            aFileObject.setInCatalog(true);
            if (aFileObject.readCatalog(this, n2) > 0) {
                this.tf.write("Overload read()", 0, "Error reading line no. : " + this.catalogBuffer.getLineNumber());
                this.catalogBuffer.close();
                fileReader.close();
                return 3;
            }
            aFileObject.setKeyField(new Integer(aFileObject.index()).toString());
            this.fileObjectsSet().add(aFileObject.keyField(), aFileObject);
            ++n6;
        }
        int n7 = 0;
        while (n7 < n4) {
            object5 = new AGroupObject();
            ((ABaseObject)object5).setInCatalog(true);
            if (((AGroupObject)object5).readCatalog(this, this.fileObjectsSet()) > 0) {
                this.tf.write("Overload read()", 0, "Error reading line no. : " + this.catalogBuffer.getLineNumber());
                this.catalogBuffer.close();
                fileReader.close();
                return 3;
            }
            ((ABaseObject)object5).setKeyField(new Integer(((ABaseObject)object5).index()).toString());
            object4 = new SimpleDateFormat("MM/dd/yy HH:mm:ss");
            object3 = ((DateFormat)object4).format(((ABaseObject)object5).date());
            ((AGroupObject)object5).setShelfDate((String)object3);
            ((AGroupObject)object5).setShelfFileName(((ABaseObject)object5).fileName());
            object2 = ((AGroupObject)object5).fileObjectsSet().elements();
            while (object2.hasMoreElements()) {
                object = (AFileObject)object2.nextElement();
                if (!((ABaseObject)object).pcFileType().toUpperCase().equals("BKI")) continue;
                ((AGroupObject)object5).setIndexFileName(((ABaseObject)object).fileName());
                object3 = ((DateFormat)object4).format(((ABaseObject)object).date());
                ((AGroupObject)object5).setIndexDate((String)object3);
                break;
            }
            this.groupObjectsSet().add(((ABaseObject)object5).keyField(), object5);
            ++n7;
        }
        this.tf.write("Overload read()", 11, "check1:" + n);
        this.catalogBuffer.close();
        fileReader.close();
        if (n == 2) {
            return n;
        }
        this.tf.write("Overload read()", 11, "check2:" + n);
        object5 = this.fileObjectsSet().elements();
        object4 = this.groupObjectsSet().elements();
        while (object5.hasMoreElements()) {
            object3 = (AFileObject)object5.nextElement();
            if (((AFileObject)object3).groupObjectPtrValue() != 0) {
                object2 = new Integer(((AFileObject)object3).groupObjectPtrValue()).toString();
                object = this.groupObjectsSet().getObjects(object2);
                if (object != null) {
                    ((AFileObject)object3).setGroupObjectPtr((AGroupObject)((Vector)object).firstElement());
                } else {
                    ((AFileObject)object3).setGroupObjectPtr(null);
                }
            }
            if (((String)(object2 = ((AFileObject)object3).missingFromGroupValues().trim())).length() > 0 && !((String)object2).equals("0")) {
                this.tf.write("Overload read()", 11, "fileName:" + ((ABaseObject)object3).fileNameType());
                object = new StringTokenizer((String)object2, " ");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    if (!this.groupObjectsSet().containsKey(string4)) {
                        this.tf.write("Overload read()", 11, "Not contains:" + string4);
                        return 4;
                    }
                    AGroupObject aGroupObject = (AGroupObject)this.groupObjectsSet().getObjects(string4).elementAt(0);
                    ((AFileObject)object3).addToMissingFromGroupSet(aGroupObject);
                }
            }
            if (((AFileObject)object3).missingFromGroupSet().size() <= 0) continue;
            ((AFileObject)object3).setReferenceCount(-((AFileObject)object3).missingFromGroupSet().size());
        }
        this.setChanged(false);
        this.setCatalogRead(true);
        this.setCatalogValid(true);
        this.tf.write("Overload read(AMainWindow)", 10, "Exit - " + string);
        return 0;
    }

    public boolean addObjects(AGroupObjectsSet aGroupObjectsSet, AFileObjectsSet aFileObjectsSet) {
        ABaseObject aBaseObject;
        Enumeration enumeration;
        this.tf.write("addObjects()", 10, "Start - No. of file objects :" + aFileObjectsSet.size());
        boolean bl = true;
        if (aFileObjectsSet != null) {
            enumeration = aFileObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AFileObject)enumeration.nextElement();
                if (this.addFileObject((AFileObject)aBaseObject)) continue;
                bl = false;
                return bl;
            }
        }
        if (aGroupObjectsSet != null) {
            enumeration = aGroupObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AGroupObject)enumeration.nextElement();
                this.tf.write("addObjects()", 11, "*missing file objects* :" + ((AGroupObject)aBaseObject).missingFileObjectsSet().size());
                if (!this.addGroupObject((AGroupObject)aBaseObject)) continue;
                AGroupObject aGroupObject = (AGroupObject)this.groupObjectsSet().getObjects(aBaseObject.keyField()).elementAt(0);
            }
        }
        if (this.repository().hostType() == 1) {
            this.bookCase();
        }
        this.tf.write("addObjects()", 10, "Exit - No. of file objects :" + aFileObjectsSet.size());
        return bl;
    }

    private boolean addGroupObject(AGroupObject aGroupObject) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.tf.write("addGroupObject()", 11, "Entry Group Name :" + aGroupObject.keyField());
        if (this.groupObjectsSet().containsKey(aGroupObject.keyField())) {
            this.tf.write("addGroupObject()", 11, "addGroupObject found key");
            return true;
        }
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        AFileObjectsSet aFileObjectsSet2 = new AFileObjectsSet();
        aGroupObject.setDate(aGroupObject.shelfDate());
        aGroupObject.setIndex(++ABaseObject.indexCounter);
        Object object6 = aGroupObject.fileObjectPtr();
        this.tf.write("addGroupObject()", 11, "**missing file objects** :" + aGroupObject.missingFileObjectsSet().size());
        this.tf.write("addGroupObject()", 11, "file object pointer:" + object6);
        this.tf.write("addGroupObject()", 11, "check for file object in Files Set: " + ((ABaseObject)object6).fileNameType() + ", keyField:" + ((ABaseObject)object6).keyField());
        if (this.fileObjectsSet().containsKey(aGroupObject.keyField())) {
            this.tf.write("addGroupObject()", 11, "Already exists");
            object5 = (AFileObject)this.fileObjectsSet().getObjects(aGroupObject.keyField()).elementAt(0);
            this.tf.write("addGroupObject()", 11, "AFileObject.index()-" + ((ABaseObject)object6).index() + ", " + ((ABaseObject)object6).fileNameType() + ", " + object6);
            this.tf.write("addGroupObject()", 11, "fObject.index()-" + ((ABaseObject)object5).index() + ", " + ((ABaseObject)object5).fileNameType() + ", " + object5);
            aGroupObject.setFileObjectPtr((AFileObject)object5);
            aGroupObject.setFileObjectPtrValue(((ABaseObject)object5).index());
            ((AFileObject)object5).setGroupObjectPtr(aGroupObject);
            ((AFileObject)object5).setGroupObjectPtrValue(aGroupObject.index());
            if (((ABaseObject)object5).title().equals("*Unknown*")) {
                ((ABaseObject)object5).setTitle(aGroupObject.title());
            }
            object6 = object5;
        }
        this.tf.write("addGroupObject()", 11, "Group.. : Filename:" + aGroupObject.fileNameType() + ", Index" + aGroupObject.index() + ", PtrVal:" + ((AFileObject)object6).groupObjectPtrValue());
        this.tf.write("addGroupObject()", 11, "File.. : Filename:" + ((ABaseObject)object6).fileNameType() + ", Index" + ((ABaseObject)object6).index() + ", PtrVal:" + aGroupObject.fileObjectPtrValue());
        ((ABaseObject)object6).setDate(aGroupObject.date());
        object5 = null;
        if (!aGroupObject.inCatalog()) {
            object5 = aGroupObject.bookSet().elements();
            this.tf.write("addGroupObject()", 11, "Not In Catalog, No. of books:" + aGroupObject.bookSet().size());
        } else {
            object5 = aGroupObject.fileObjectsSet().elements();
            this.tf.write("addGroupObject()", 11, "In Catalog, No. of books:" + aGroupObject.fileObjectsSet().size());
        }
        while (object5.hasMoreElements()) {
            Object object7;
            Object object8;
            object4 = (AFileObject)object5.nextElement();
            if (aGroupObject.inCatalog()) {
                object3 = aGroupObject.bookSet().elements();
                while (object3.hasMoreElements()) {
                    object2 = (AFileObject)object3.nextElement();
                    if (!((ABaseObject)object4).keyField().equals(((ABaseObject)object2).keyField())) continue;
                    ((AFileObject)object4).setIncluded(((AFileObject)object2).included());
                    break;
                }
            }
            this.tf.write("addGroupObject()", 11, "bookFile:" + ((ABaseObject)object4).fileName() + "." + ((ABaseObject)object4).pcFileType() + ", Included:" + ((AFileObject)object4).included());
            if (!((AFileObject)object4).included() || ((ABaseObject)object4).pcFileType().toUpperCase().equals("BKS")) continue;
            object3 = ((ABaseObject)object4).keyField();
            this.tf.write("addGroupObject()", 11, "**Book File** : " + (String)object3);
            object2 = "BOOK";
            object = "";
            Object object9 = "";
            if (!this.fileObjectsSet().containsKey(object3)) {
                object = this.repository().hostType() == 1 ? this.repository().fileTypesList().getObject(1).hlqs() : this.repository().softcopyDirectories();
                if (((ABaseObject)object4).pcFileType().toUpperCase().equals("BKI")) {
                    object2 = "BKINDEX";
                    object = this.repository().hostType() == 1 ? AUtilities.strip(this.repository().fileTypesList().getObject(5).hlq(), '\'') + DOT : this.repository().indexDirectories();
                }
                this.tf.write("addGroupObject()", 11, "nameInRepository:" + (String)object);
                object8 = new StringTokenizer((String)object, "\n");
                while (((StringTokenizer)object8).hasMoreTokens()) {
                    object7 = ((StringTokenizer)object8).nextToken();
                    object7 = AUtilities.strip((String)object7, '\'');
                    if (this.repository().hostType() == 1) {
                        object9 = object = "'" + ((String)object7 + "." + ((ABaseObject)object4).fileName() + "." + ((ABaseObject)object4).hostFileType()).toUpperCase() + "'";
                    } else {
                        object = (String)object7 + ((ABaseObject)object4).fileNameType();
                        object9 = ((ABaseObject)object4).fileNameType().toUpperCase();
                    }
                    object3 = object9;
                    this.tf.write("addGroupObject()", 11, "check bookFile:" + (String)object3);
                    if (!this.fileObjectsSet().containsKey(object3)) continue;
                    this.tf.write("addGroupObject()", 11, "found bookFile:" + (String)object3);
                    break;
                }
            }
            if (this.fileObjectsSet().containsKey(object3)) {
                object8 = this.fileObjectsSet().getObjects(object3);
                object7 = ((Vector)object8).elements();
                while (object7.hasMoreElements()) {
                    AFileObject aFileObject = (AFileObject)object7.nextElement();
                    this.tf.write("addGroupObject()", 11, "Contains object " + aFileObject.fileName() + "." + aFileObject.pcFileType());
                    this.tf.write("addGroupObject()", 11, "Contains object index:" + aFileObject.index());
                    if (aFileObject.referenceCount() >= 0) {
                        this.tf.write("addGroupObject()", 11, "Not missing from group:" + aFileObject.index() + ", groupObjectPtr():" + aFileObject.groupObjectPtr());
                        aFileObject.setDate(((ABaseObject)object4).date());
                        aFileObject.incrementReferenceCount();
                        if (aFileObject.title().equals("*Unknown*")) {
                            aFileObject.setTitle(((ABaseObject)object4).title());
                        }
                        this.tf.write("addGroupObject()", 11, "Book: aBook.title():" + ((ABaseObject)object4).title() + ", fObject.title():" + aFileObject.title());
                        aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                        continue;
                    }
                    aFileObject.decrementReferenceCount();
                    aFileObject.addToMissingFromGroupSet(aGroupObject);
                    aFileObjectsSet2.add(aFileObject.keyField(), aFileObject);
                }
                continue;
            }
            this.tf.write("addGroupObject()", 11, "Missing from group:" + (String)object3);
            object8 = new AFileObject();
            ((ABaseObject)object8).setIndex(++ABaseObject.indexCounter);
            ((AFileObject)object8).addToMissingFromGroupSet(aGroupObject);
            ((ABaseObject)object8).setTitle(((ABaseObject)object4).title());
            ((ABaseObject)object8).setDate(((ABaseObject)object4).date());
            ((ABaseObject)object8).setFileName(((ABaseObject)object4).fileName());
            ((ABaseObject)object8).setPCFileType((String)object2);
            ((ABaseObject)object8).setHostFileType((String)object2);
            ((ABaseObject)object8).setKeyField((String)object9);
            ((ABaseObject)object8).setNameInRepository((String)object);
            ((ABaseObject)object8).setTitle(((ABaseObject)object4).title());
            ((AFileObject)object8).decrementReferenceCount();
            this.tf.write("addGroupObject()", 11, "New file object:" + ((ABaseObject)object8).keyField() + ", index - " + ((ABaseObject)object8).index());
            aFileObjectsSet2.add(((ABaseObject)object8).keyField(), object8);
            this.fileObjectsSet().add(((ABaseObject)object8).keyField(), object8);
        }
        if (!aGroupObject.inCatalog()) {
            aGroupObject.fileObjectsSet().putAll(aFileObjectsSet);
            aGroupObject.missingFileObjectsSet().putAll(aFileObjectsSet2);
        } else {
            aGroupObject.fileObjectsSet().clear();
            object4 = aGroupObject.missingFileObjectsSet().elements();
            while (object4.hasMoreElements()) {
                object3 = null;
                try {
                    object2 = (AFileObject)object4.nextElement();
                    object3 = (AFileObject)((AFileObject)object2).clone();
                    this.tf.write("addGroupObject()", 11, "Original:" + object2 + ", Clone:" + object3);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
                ((ABaseObject)object3).setIndex(++ABaseObject.indexCounter);
                this.tf.write("addGroupObject()", 11, "B4 check missingFromGroupSet size:" + ((AFileObject)object3).missingFromGroupSet().size() + ", Group keyfield:" + aGroupObject.keyField());
                ((AFileObject)object3).missingFromGroupSet().clear();
                this.tf.write("addGroupObject()", 11, "Missing from group set contains:" + aGroupObject.keyField());
                ((AFileObject)object3).addToMissingFromGroupSet(aGroupObject);
                ((AFileObject)object3).decrementReferenceCount();
                this.tf.write("addGroupObject()", 11, "After check missingFromGroupSet size:" + ((AFileObject)object3).missingFromGroupSet().size() + ", Index:" + aGroupObject.index());
                aFileObjectsSet2.add(((ABaseObject)object3).keyField(), object3);
                if (!this.fileObjectsSet().containsKey(((ABaseObject)object3).keyField())) {
                    this.fileObjectsSet().add(((ABaseObject)object3).keyField(), object3);
                } else {
                    object2 = this.fileObjectsSet().getObjects(((ABaseObject)object3).keyField());
                    object = (AFileObject)((Vector)object2).firstElement();
                    ((AFileObject)object).incrementReferenceCount();
                    aFileObjectsSet2.clear();
                    aFileObjectsSet.add(((ABaseObject)object).keyField(), object);
                }
                this.tf.write("addGroupObject", 11, "new file object added with keyfield:" + ((ABaseObject)object3).keyField() + ", size:" + this.fileObjectsSet().size());
            }
            aGroupObject.missingFileObjectsSet().clear();
            aGroupObject.fileObjectsSet().putAll(aFileObjectsSet);
            aGroupObject.missingFileObjectsSet().putAll(aFileObjectsSet2);
        }
        aFileObjectsSet = null;
        aFileObjectsSet2 = null;
        aGroupObject.setInCatalog(true);
        this.groupObjectsSet().add(aGroupObject.keyField(), aGroupObject);
        this.tf.write("addGroupObject", 11, "Group object added:" + aGroupObject.nameInRepository());
        this.tf.write("addGroupObject", 11, "new group object added to Master group set:" + aGroupObject + ", Master GSet " + this.groupObjectsSet().size());
        this.setChanged(true);
        this.tf.write("addGroupObject", 11, "Exit");
        return false;
    }

    private boolean addFileObject(AFileObject aFileObject) {
        Object object;
        Object object2;
        AFileObject aFileObject2;
        Enumeration enumeration;
        Cloneable cloneable;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<AFileObject> vector = null;
        this.tf.write("addFileObject", 11, "Entry");
        if (this.fileObjectsSet().containsKey(aFileObject.keyField())) {
            cloneable = this.fileObjectsSet().getObjects(aFileObject.keyField());
            enumeration = cloneable.elements();
            while (enumeration.hasMoreElements()) {
                aFileObject2 = (AFileObject)enumeration.nextElement();
                this.tf.write("addFileObject()", 11, "The File is - " + aFileObject2 + ", " + aFileObject2.nameInRepository());
                if (aFileObject2.referenceCount() < 0) {
                    object2 = null;
                    vector = new Vector<AFileObject>();
                    object = new Vector();
                    Enumeration enumeration2 = aFileObject2.missingFromGroupSet().elements();
                    while (enumeration2.hasMoreElements()) {
                        object2 = (AGroupObject)enumeration2.nextElement();
                        this.tf.write("addFileObject()", 11, "The Group is - " + ((ABaseObject)object2).nameInRepository());
                        aFileObject.setIndex(aFileObject2.index());
                        this.tf.write("addFileObject()", 11, "existing file object check key - " + aFileObject.keyField() + ", missing size:" + ((AGroupObject)object2).missingFileObjectsSet().size());
                        if (((AGroupObject)object2).missingFileObjectsSet().containsKey(aFileObject.keyField())) {
                            Vector vector2 = ((AGroupObject)object2).missingFileObjectsSet().getObjects(aFileObject.keyField());
                            this.tf.write("addFileObject()", 11, "missingVector size:" + vector2.size());
                            ((AGroupObject)object2).missingFileObjectsSet().removeAll(vector2);
                            this.tf.write("addFileObject()", 11, "existing file object key found - " + ((AGroupObject)object2).missingFileObjectsSet().size() + ", " + ((AFileObject)vector2.firstElement()).keyField());
                        }
                        ((AGroupObject)object2).fileObjectsSet().add(aFileObject.keyField(), aFileObject);
                        aFileObject.incrementReferenceCount();
                        bl3 = true;
                        this.tf.write("addFileObject()", 11, "File Group object - " + ((AGroupObject)object2).fileObjectPtr() + ", " + ((AGroupObject)object2).fileObjectPtr().nameInRepository());
                        vector.addElement(((AGroupObject)object2).fileObjectPtr());
                        this.tf.write("addFileObject()", 11, "Existing file object - " + aFileObject.fileName() + " - " + aFileObject.pcFileType());
                        this.tf.write("addFileObject()", 11, "Existing file object indexes - " + aFileObject.index() + " - " + aFileObject2.index());
                    }
                    this.tf.write("addFileObject()", 11, "tobeTransferredForUpdateBookshelf size:" + vector.size());
                    aFileObject.missingFromGroupSet().clear();
                    continue;
                }
                bl2 = true;
            }
        }
        if (bl3) {
            this.tf.write("addFileObject()", 11, "fileWasMissing:" + aFileObject.keyField());
            if (this.fileObjectsSet().containsKey(aFileObject.keyField())) {
                this.tf.write("addFileObject()", 11, "Contains:" + aFileObject.keyField());
                cloneable = this.fileObjectsSet().getObjects(aFileObject.keyField());
                this.tf.write("addFileObject()", 11, "b4 missingVector:" + cloneable.size() + ", File set:" + this.fileObjectsSet().size());
                this.fileObjectsSet().removeAll((Vector)cloneable);
                this.tf.write("addFileObject()", 11, "after missingVector:" + cloneable.size() + ", File set:" + this.fileObjectsSet().size());
            }
            this.tf.write("addFileObject()", 11, "B4 add to fileset, missingFromGroupSet size:" + aFileObject.missingFromGroupSet().size());
            this.fileObjectsSet().add(aFileObject.keyField(), aFileObject);
            cloneable = null;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                aFileObject2 = (AFileObject)enumeration.nextElement();
                object2 = new AFtpReturnCode();
                object = this.repository().cacheDirectory() + aFileObject2.fileNameType();
                if (this.repository().hostType() != 1) continue;
                object = this.repository().cacheDirectory() + AUtilities.strip(aFileObject2.nameInRepository(), '\'');
                if (cloneable == null) {
                    cloneable = this.createTempKeySet(3);
                }
                if (((AFtpReturnCode)(object2 = ATransferProcess.updateBookshelf(aFileObject2, (AFileObjectsSet)cloneable, this.repository(), (String)object))).getProcessCode() != 0) {
                    this.tf.write("addFileObject()", 0, "Error updating bookshelf:" + (String)object);
                    bl = false;
                    return bl;
                }
                object2 = this.repository().putShelfToHost(aFileObject2.groupObjectPtr(), (String)object, null);
                if (((AFtpReturnCode)object2).getCommandCode() == 2) continue;
                this.tf.write("addFileObject()", 0, "Error putting shelf:" + (String)object + " to " + this.repository().repositoryTitle());
                bl = false;
                return bl;
            }
        } else if (!bl2) {
            aFileObject.setIndex(++ABaseObject.indexCounter);
            aFileObject.setInCatalog(true);
            this.tf.write("addFileObject()", 11, "New file object - " + aFileObject.fileName() + " - " + aFileObject.pcFileType());
            this.tf.write("addFileObject()", 11, "KeyField is:" + aFileObject.keyField() + ", index:" + aFileObject.index());
            this.tf.write("addFileObject()", 11, "Reference count is:" + aFileObject.referenceCount());
            this.fileObjectsSet().add(aFileObject.keyField(), aFileObject);
        }
        this.setChanged(true);
        this.tf.write("addFileObject", 11, "Exit");
        return bl;
    }

    private void setGroupObjectsSet(AGroupObjectsSet aGroupObjectsSet) {
        this.iGroupObjectsSet = aGroupObjectsSet;
    }

    public AGroupObjectsSet groupObjectsSet() {
        return this.iGroupObjectsSet;
    }

    private void setFileObjectsSet(AFileObjectsSet aFileObjectsSet) {
        this.iFileObjectsSet = aFileObjectsSet;
    }

    public AFileObjectsSet fileObjectsSet() {
        return this.iFileObjectsSet;
    }

    public void resetIndexCounter(int n) {
        indexCounter = n;
    }

    public AGroupObject getObjectByPtrValue(int n) {
        AGroupObject aGroupObject = null;
        Enumeration enumeration = this.groupObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            aGroupObject = (AGroupObject)enumeration.nextElement();
            try {
                Integer n2 = new Integer(aGroupObject.keyField());
                if (n2 != n) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return aGroupObject;
    }

    public AFileObjectsSet createTempKeySet(int n) {
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        this.tf.write("createTempKeySet()", 11, "Entry, Key is:" + n + ", " + 3 + ", " + 1);
        AFileObject aFileObject = null;
        Enumeration enumeration = this.fileObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            AFileObject aFileObject2 = (AFileObject)enumeration.nextElement();
            try {
                aFileObject = (AFileObject)aFileObject2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            switch (n) {
                case 0: {
                    aFileObject.setKeyField(new Integer(aFileObject.index()).toString());
                    break;
                }
                case 1: {
                    aFileObject.setKeyField(aFileObject.fileName());
                    break;
                }
                case 2: {
                    aFileObject.setKeyField(aFileObject.nameInRepository());
                    break;
                }
                case 3: {
                    aFileObject.setKeyField(aFileObject.fileNameType());
                    break;
                }
                case 4: {
                    aFileObject.setKeyField(new AComparisonName(aFileObject.fileName()).stub());
                }
            }
            this.tf.write("createTempKeySet()", 11, "New file Field-" + aFileObject.keyField() + ", " + aFileObject.fileNameType());
            aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
        }
        this.tf.write("createTempKeySet()", 11, "New file set-" + this.fileObjectsSet().size() + ", " + aFileObjectsSet.size());
        return aFileObjectsSet;
    }

    public void changeKey(int n) {
        Object object;
        this.tf.write("changeKey()", 11, "Entry, Key is:" + n + ", currentKey():" + this.currentKey());
        if (n == this.currentKey()) {
            this.tf.write("changeKey()", 11, "Currentkey:" + this.currentKey() + " and keyType " + n + " change requested is same.");
            return;
        }
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        AGroupObjectsSet aGroupObjectsSet = new AGroupObjectsSet();
        AMainWindow.UpdateStatusInfo("Changing keys ...");
        Enumeration enumeration = this.fileObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            object = (AFileObject)enumeration.nextElement();
            switch (n) {
                case 0: {
                    ((ABaseObject)object).setKeyField(new Integer(((ABaseObject)object).index()).toString());
                    break;
                }
                case 1: {
                    ((ABaseObject)object).setKeyField(((ABaseObject)object).fileName());
                    break;
                }
                case 2: {
                    ((ABaseObject)object).setKeyField(((ABaseObject)object).nameInRepository());
                    break;
                }
                case 3: {
                    ((ABaseObject)object).setKeyField(((ABaseObject)object).fileNameType());
                    break;
                }
                case 4: {
                    ((ABaseObject)object).setKeyField(new AComparisonName(((ABaseObject)object).fileName()).stub());
                }
            }
            this.tf.write("changeKey()", 11, "New file Field-" + ((ABaseObject)object).keyField() + ", " + ((ABaseObject)object).fileNameType());
            aFileObjectsSet.add(((ABaseObject)object).keyField(), object);
            ((AFileObject)object).setMissingFromGroupSet(this.changeGroupKey(((AFileObject)object).missingFromGroupSet()));
        }
        this.fileObjectsSet().clear();
        this.tf.write("changeKey()", 11, "Old file set-" + this.fileObjectsSet().size() + ", " + aFileObjectsSet.size());
        this.setFileObjectsSet(aFileObjectsSet);
        this.tf.write("changeKey()", 11, "New file set-" + this.fileObjectsSet().size() + ", " + aFileObjectsSet.size());
        object = this.groupObjectsSet().elements();
        while (object.hasMoreElements()) {
            AGroupObject aGroupObject = (AGroupObject)object.nextElement();
            switch (n) {
                case 0: {
                    aGroupObject.setKeyField(new Integer(aGroupObject.index()).toString());
                    break;
                }
                case 1: {
                    aGroupObject.setKeyField(aGroupObject.fileName());
                    break;
                }
                case 2: {
                    aGroupObject.setKeyField(aGroupObject.nameInRepository());
                    break;
                }
                case 3: {
                    aGroupObject.setKeyField(aGroupObject.fileNameType());
                    break;
                }
                case 4: {
                    aGroupObject.setKeyField(new AComparisonName(aGroupObject.fileName()).stub());
                }
            }
            this.tf.write("changeKey()", 11, "New group Field-" + aGroupObject.keyField());
            aGroupObjectsSet.add(aGroupObject.keyField(), aGroupObject);
            aGroupObject.setFileObjectsSet(this.changeFileKey(aGroupObject.fileObjectsSet()));
            aGroupObject.setMissingFileObjectsSet(this.changeFileKey(aGroupObject.missingFileObjectsSet()));
        }
        this.groupObjectsSet().clear();
        this.tf.write("changeKey()", 11, "Old group set-" + this.groupObjectsSet().size() + ", " + aGroupObjectsSet.size());
        this.setGroupObjectsSet(aGroupObjectsSet);
        this.setCurrentKey(n);
        this.tf.write("changeKey()", 11, "Current key type-" + this.currentKey());
        AMainWindow.UpdateStatusInfo("");
        this.tf.write("changeKey()", 11, "Exit, New group set-" + this.groupObjectsSet().size() + ", " + aGroupObjectsSet.size());
    }

    private AFileObjectsSet changeFileKey(AFileObjectsSet aFileObjectsSet) {
        AFileObjectsSet aFileObjectsSet2 = new AFileObjectsSet();
        Enumeration enumeration = aFileObjectsSet.elements();
        while (enumeration.hasMoreElements()) {
            AFileObject aFileObject = (AFileObject)enumeration.nextElement();
            aFileObjectsSet2.add(aFileObject.keyField(), aFileObject);
        }
        return aFileObjectsSet2;
    }

    private AGroupObjectsSet changeGroupKey(AGroupObjectsSet aGroupObjectsSet) {
        AGroupObjectsSet aGroupObjectsSet2 = new AGroupObjectsSet();
        Enumeration enumeration = aGroupObjectsSet.elements();
        while (enumeration.hasMoreElements()) {
            AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
            aGroupObjectsSet2.add(aGroupObject.keyField(), aGroupObject);
        }
        return aGroupObjectsSet2;
    }

    public void deleteObjects(AFileObjectsSet aFileObjectsSet, AGroupObjectsSet aGroupObjectsSet, AFileObjectsSet aFileObjectsSet2, AGroupObjectsSet aGroupObjectsSet2, boolean bl) {
        this.tf.write("deleteObjects()", 10, "Entry");
        this.tf.write("deleteObjects()", 11, "No. of file objects:" + aFileObjectsSet.size());
        this.tf.write("deleteObjects()", 11, "No. of group objects:" + aGroupObjectsSet.size());
        if (aGroupObjectsSet.size() > 0) {
            this.deleteGroupObjects(aFileObjectsSet, aGroupObjectsSet, aGroupObjectsSet2, aFileObjectsSet2);
        }
        if (aFileObjectsSet.size() > 0) {
            this.deleteFileObjects(aFileObjectsSet, aGroupObjectsSet, aFileObjectsSet2, aGroupObjectsSet2, bl);
        }
        if (this.aFtp != null && this.aFtp.isConnected()) {
            this.aFtp.quit();
            this.aFtp = null;
        }
        if (this.repository().hostType() == 1) {
            this.bookCase();
        }
        this.tf.write("deleteObjects()", 11, "No. of file objects in remove file set:" + aFileObjectsSet2.size());
        this.tf.write("deleteObjects()", 11, "No. of group objects in remove group set:" + aGroupObjectsSet2.size());
        this.tf.write("deleteObjects()", 10, "Exit");
    }

    public void deleteFileObjects(AFileObjectsSet aFileObjectsSet, AGroupObjectsSet aGroupObjectsSet, AFileObjectsSet aFileObjectsSet2, AGroupObjectsSet aGroupObjectsSet2, boolean bl) {
        this.tf.write("deleteFileObjects()", 11, "Entry:" + aFileObjectsSet.size());
        Enumeration enumeration = aFileObjectsSet.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Serializable serializable;
            Object object2;
            AFileObject aFileObject = (AFileObject)enumeration.nextElement();
            this.tf.write("deleteFileObjects()", 11, "start check:" + aFileObject.keyField() + ", ForceDelete:" + bl);
            if (!aFileObject.canDelete() && bl) {
                object2 = this.groupObjectsSet().elements();
                while (object2.hasMoreElements()) {
                    serializable = (AGroupObject)object2.nextElement();
                    object = ((AGroupObject)serializable).fileObjectsSet().getObjects(aFileObject.keyField());
                    if (object == null) continue;
                    ((AGroupObject)serializable).fileObjectsSet().removeAll((Vector)object);
                    aFileObject.addToMissingFromGroupSet((AGroupObject)serializable);
                    ((AGroupObject)serializable).missingFileObjectsSet().add(aFileObject.keyField(), aFileObject);
                    aFileObject.decrementReferenceCount();
                }
            }
            if (!aFileObject.canDelete()) continue;
            object2 = aFileObject.nameInRepository();
            if (this.removeFile(aFileObject)) {
                this.tf.write("deleteFileObjects()", 11, (String)object2 + " successfully deleted.");
            } else {
                this.tf.write("deleteFileObjects()", 11, (String)object2 + " could not be deleted.");
            }
            this.setChanged(true);
            if (aFileObject.groupObjectPtr() != null) {
                Cloneable cloneable;
                Object object3;
                serializable = new File(this.repository().cacheDirectory() + aFileObject.fileNameType());
                this.tf.write("deleteFileObjects()", 11, "Cache file to be deleted:" + ((File)serializable).getAbsolutePath());
                if (!((File)serializable).delete()) {
                    this.tf.write("deleteFileObjects()", 11, ((File)serializable).getAbsolutePath() + " could not be deleted from cache.");
                }
                object = aFileObject.groupObjectPtr().missingFileObjectsSet().elements();
                while (object.hasMoreElements()) {
                    object3 = (AFileObject)object.nextElement();
                    if (!this.fileObjectsSet().containsKey(((ABaseObject)object3).keyField())) continue;
                    aFileObjectsSet2.add(((ABaseObject)object3).keyField(), object3);
                    cloneable = this.fileObjectsSet().getObjects(((ABaseObject)object3).keyField());
                    this.fileObjectsSet().removeAll((Vector)cloneable);
                }
                object3 = aFileObject.groupObjectPtr().fileObjectsSet().elements();
                while (object3.hasMoreElements()) {
                    cloneable = (AFileObject)object3.nextElement();
                    if (((AFileObject)cloneable).canDelete()) {
                        aFileObject.groupObjectPtr().fileObjectsSet().remove(((ABaseObject)((Object)cloneable)).keyField());
                        continue;
                    }
                    if (aGroupObjectsSet.containsKey(aFileObject.groupObjectPtr().keyField())) continue;
                    ((AFileObject)cloneable).decrementReferenceCount();
                }
                if (this.groupObjectsSet().containsKey(aFileObject.groupObjectPtr().keyField())) {
                    this.tf.write("deleteFileObjects()", 11, "contains group object");
                    aGroupObjectsSet2.add(aFileObject.groupObjectPtr().keyField(), aFileObject.groupObjectPtr());
                    this.groupObjectsSet().removeAll(this.groupObjectsSet().getObjects(aFileObject.groupObjectPtr().keyField()));
                }
            }
            if (!this.fileObjectsSet().containsKey(aFileObject.keyField())) continue;
            if (!bl) {
                aFileObjectsSet2.add(aFileObject.keyField(), aFileObject);
                this.fileObjectsSet().removeAll(this.fileObjectsSet().getObjects(aFileObject.keyField()));
                continue;
            }
            this.tf.write("deleteFileObjects()", 11, "Missing from groups size:" + aFileObject.missingFromGroupSet().size());
            int n = 0 - aFileObject.missingFromGroupSet().size();
            this.tf.write("deleteFileObjects()", 11, "count:" + n);
            aFileObject.setReferenceCount(n);
        }
        this.tf.write("deleteFileObjects()", 11, "Exit");
    }

    public void deleteGroupObjects(AFileObjectsSet aFileObjectsSet, AGroupObjectsSet aGroupObjectsSet, AGroupObjectsSet aGroupObjectsSet2, AFileObjectsSet aFileObjectsSet2) {
        this.tf.write("deleteGroupObjects()", 11, "Entry");
        Enumeration enumeration = aGroupObjectsSet.elements();
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable;
            Object object;
            AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
            this.setChanged(true);
            this.tf.write("deleteGroupObjects()", 11, "No. of files " + aGroupObject.fileObjectsSet().size() + " in this group:" + aGroupObject.fileNameType());
            Enumeration enumeration2 = aGroupObject.fileObjectsSet().elements();
            while (enumeration2.hasMoreElements()) {
                object = (AFileObject)enumeration2.nextElement();
                this.tf.write("deleteGroupObjects()", 11, "File:" + ((ABaseObject)object).fileNameType() + ", Ref. Count:" + ((AFileObject)object).referenceCount());
                ((AFileObject)object).decrementReferenceCount();
                this.tf.write("deleteGroupObjects()", 11, "After decrement File:" + ((ABaseObject)object).fileNameType() + ", Ref. Count:" + ((AFileObject)object).referenceCount());
                if (!((AFileObject)object).canDelete()) continue;
                this.tf.write("deleteGroupObjects()", 11, "canDelete File:" + ((ABaseObject)object).fileNameType());
                if (aFileObjectsSet.containsKey(((ABaseObject)object).keyField())) continue;
                aFileObjectsSet.add(((ABaseObject)object).keyField(), object);
            }
            object = aGroupObject.missingFileObjectsSet().elements();
            this.tf.write("deleteGroupObjects()", 11, "No. of missing objects for this group:" + aGroupObject.missingFileObjectsSet().size());
            while (object.hasMoreElements()) {
                cloneable = (AFileObject)object.nextElement();
                if (!this.fileObjectsSet().containsKey(((ABaseObject)((Object)cloneable)).keyField())) continue;
                aFileObjectsSet2.add(((ABaseObject)((Object)cloneable)).keyField(), cloneable);
            }
            if (this.fileObjectsSet().containsKey(aGroupObject.fileObjectPtr().keyField())) {
                cloneable = this.fileObjectsSet().getObjects(aGroupObject.fileObjectPtr().keyField());
                if (!aFileObjectsSet.containsKey(aGroupObject.fileObjectPtr().keyField())) {
                    aFileObjectsSet.add(aGroupObject.fileObjectPtr().keyField(), aGroupObject.fileObjectPtr());
                }
                this.fileObjectsSet().removeAll((Vector)cloneable);
            }
            if (!this.groupObjectsSet().containsKey(aGroupObject.keyField())) continue;
            aFileObjectsSet2.add(aGroupObject.fileObjectPtr().keyField(), aGroupObject.fileObjectPtr());
            aGroupObjectsSet2.add(aGroupObject.keyField(), aGroupObject);
            cloneable = this.groupObjectsSet().getObjects(aGroupObject.keyField());
            this.tf.write("deleteGroupObjecs()", 11, "Group objects found:" + ((Vector)cloneable).size() + ", Master GSet " + this.groupObjectsSet().size());
            this.groupObjectsSet().removeAll((Vector)cloneable);
            this.tf.write("deleteGroupObjecs()", 11, "Group object deleted:" + ((Vector)cloneable).firstElement() + ", Master GSet " + this.groupObjectsSet().size());
        }
        this.tf.write("deleteGroupObjects()", 11, "Exit");
    }

    private boolean removeFile(AFileObject aFileObject) {
        AFtpReturnCode aFtpReturnCode;
        boolean bl = true;
        String string = aFileObject.nameInRepository();
        this.tf.write("removeFile()", 11, "delete file is:" + string);
        if (this.repository().hostType() == 5) {
            File file = new File(string);
            if (!file.delete()) {
                bl = false;
            }
        } else if (this.aFtp == null) {
            this.aFtp = new AFtp();
            this.aFtp.setLogonParameters(new AFtpLogonParameters(this.repository()));
            AFtpReturnCode aFtpReturnCode2 = this.aFtp.logon();
            if (aFtpReturnCode2.getCommandCode() == 2 && (aFtpReturnCode2 = this.aFtp.dele(string)).getCommandCode() != 2) {
                this.tf.write("removeFile()", 0, "Error deleting file:" + string);
                this.tf.write("removeFile()", 0, "ftpRC:" + aFtpReturnCode2.getCommandCode());
                bl = false;
            }
        } else if (this.aFtp.isConnected() && (aFtpReturnCode = this.aFtp.dele(string)).getCommandCode() != 2) {
            this.tf.write("removeFile()", 0, "Error deleting file:" + string);
            this.tf.write("removeFile()", 0, "ftpRC:" + aFtpReturnCode.getCommandCode());
            bl = false;
        }
        return bl;
    }

    public int createCatalog(ACatalog aCatalog, AMainWindow aMainWindow) {
        this.tf.write("createCatalog()", 10, "Start");
        int n = 0;
        AMainWindow.UpdateStatusInfo("Creating catalog ...");
        int n2 = aCatalog.repository().hostType();
        n = n2 == 1 ? this.createMVS(aMainWindow) : (n2 == 5 ? this.createPC(aMainWindow) : this.createOE(aMainWindow));
        if (n == 0 && aCatalog != null) {
            this.tf.write("createCatalog()", 11, "Current key:" + this.currentKey());
            aCatalog.changeKey(this.currentKey());
            this.tf.write("createCatalog()", 11, "Start setting old catalog values, Old catalog size:" + aCatalog.fileObjectsSet().size() + ", New Catalog size:" + this.fileObjectsSet().size());
            Enumeration enumeration = aCatalog.fileObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                Serializable serializable;
                AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                Vector vector = this.fileObjectsSet().getObjects(aFileObject.keyField());
                this.tf.write("createCatalog()", 11, "Check1:" + aFileObject.keyField());
                if (vector != null) {
                    serializable = (AFileObject)vector.firstElement();
                    this.tf.write("createCatalog()", 11, "Check2:" + ((ABaseObject)serializable).keyField());
                    if (((ABaseObject)serializable).title().equals("*Unknown*")) {
                        ((ABaseObject)serializable).setTitle(aFileObject.title());
                        this.tf.write("createCatalog()", 11, "Check4:" + aFileObject.title());
                        this.tf.write("createCatalog()", 11, "Check5:" + ((ABaseObject)serializable).title());
                    }
                    if (((ABaseObject)serializable).size().floatValue() == 0.0f) {
                        ((ABaseObject)serializable).setSize(aFileObject.size());
                    }
                    if (((ABaseObject)serializable).date() == null) {
                        ((ABaseObject)serializable).setDate(aFileObject.date());
                    }
                    if (((ABaseObject)serializable).installDate() != null) continue;
                    ((ABaseObject)serializable).setInstallDate(aFileObject.installDate());
                    continue;
                }
                if (aFileObject.groupObjectPtr() == null) continue;
                serializable = new File(this.repository().cacheDirectory() + File.separator + aFileObject.fileNameType());
                ((File)serializable).delete();
                if (n2 != 1) continue;
                serializable = new File(this.repository().cacheDirectory() + File.separator + AUtilities.strip(aFileObject.nameInRepository(), '\''));
                ((File)serializable).delete();
            }
        }
        this.setChanged(true);
        AMainWindow.UpdateStatusInfo("");
        this.tf.write("createCatalog()", 10, "Exit");
        return n;
    }

    private int createMVS(AMainWindow aMainWindow) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        String string;
        this.tf.write("createMVS()", 10, "Entry");
        int n = 0;
        this.setCurrentKey(2);
        String string2 = AUtilities.strip(this.repository().fileTypesList().getObject(2).hlq(), '\'') + "\n";
        String string3 = AUtilities.strip(this.repository().fileTypesList().getObject(5).hlq(), '\'') + "\n";
        if (string2.indexOf(string3) == -1) {
            string2 = string2 + string3;
        }
        Enumeration enumeration = this.repository().fileTypesList().getObject(1).hlqsAsVector().elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string2.indexOf(string = AUtilities.strip(string, '\'') + "\n") != -1) continue;
            string2 = string2 + string;
        }
        this.tf.write("createMVS()", 11, "listOfDirectories:" + string2);
        string = "";
        this.aFtp = new AFtp();
        this.aFtp.setLogonParameters(new AFtpLogonParameters(this.repository()));
        AFtpReturnCode aFtpReturnCode = this.aFtp.logon();
        if (aFtpReturnCode.getCommandCode() != 2) {
            n = 1;
            this.tf.write("createMVS()", 0, "Error logging on:" + aFtpReturnCode.getCommandCode());
            return n;
        }
        aFtpReturnCode = this.aFtp.quote("SITE AUTORECALL");
        if (aFtpReturnCode.getCommandCode() != 2) {
            n = 1;
            this.tf.write("createMVS()", 0, "Error issuing site commands:" + aFtpReturnCode.getCommandCode());
            return n;
        }
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string4;
            String string5;
            Object[] objectArray;
            string = stringTokenizer.nextToken();
            string = string.trim();
            this.tf.write("createMVS()", 11, "currentDirectory:" + string);
            if (string.trim().length() == 0) continue;
            String string6 = "'" + string + ".*" + "'";
            AStatusWindow.write("Analyzing " + string + " directory...");
            AStatusWindow.write(AUtilities.LINE_SEPARATOR + "Querying contents of " + string6 + AUtilities.LINE_SEPARATOR + "This may take a few seconds..." + AUtilities.LINE_SEPARATOR);
            object8 = new ByteArrayOutputStream();
            aFtpReturnCode = this.aFtp.dir(string6, (ByteArrayOutputStream)object8);
            if (aFtpReturnCode.getCommandCode() != 2) {
                objectArray = new Object[]{"OK", "Cancel"};
                object7 = aFtpReturnCode.getServerResponse().elements();
                string5 = "";
                while (object7.hasMoreElements()) {
                    string4 = (String)object7.nextElement();
                    string5 = string5 + string4 + "<br>";
                }
                string4 = "Error querying the contents of " + string + "<br>" + string5;
                n = JOptionPane.showOptionDialog(AUtilities.mainWindow, "<html>" + string4 + "</html>", "Confirm Dialog", 2, 3, null, objectArray, objectArray[1]);
                if (n != 1) continue;
                break;
            }
            objectArray = ((ByteArrayOutputStream)object8).toString();
            this.tf.write("createMVS()", 11, "directoryListing:" + (String)objectArray);
            object7 = new StringTokenizer((String)objectArray, "\r\n");
            string5 = ((StringTokenizer)object7).nextToken();
            while (((StringTokenizer)object7).hasMoreTokens()) {
                Object object9;
                string5 = ((StringTokenizer)object7).nextToken();
                this.tf.write("createMVS()", 11, "currentLine:" + string5);
                if (string5.trim().length() == 0 || string5.startsWith("Error determining attributes")) continue;
                string5 = string5.toUpperCase();
                string4 = "";
                Object object10 = "";
                Object object11 = "";
                object6 = "";
                object5 = "";
                object4 = "";
                object3 = new StringTokenizer(string5, " ");
                int n3 = ((StringTokenizer)object3).countTokens();
                int n4 = 1;
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object3).nextToken();
                    if (n3 == 2 && n4 == 2) {
                        string4 = AUtilities.strip((String)object2, '\'');
                    }
                    if (n4 == 3) {
                        object11 = object2;
                    } else if (n4 == 4) {
                        object6 = object2;
                    } else if (n4 == 5) {
                        object5 = object2;
                    } else if (n4 == 6) {
                        object4 = object2;
                    } else if (n4 == 8) {
                        object10 = object2;
                    } else if (n4 == 10) {
                        string4 = AUtilities.strip((String)object2, '\'');
                    }
                    ++n4;
                }
                object2 = string4;
                object = "";
                int n5 = string4.lastIndexOf(".");
                int n6 = string4.lastIndexOf(".", n5 - 1);
                object = n6 != -1 ? string4.substring(n6 + 1) : string4;
                n5 = ((String)object).indexOf(".");
                String string7 = ((String)object).substring(n5 + 1);
                string4 = ((String)object).substring(0, n5);
                this.tf.write("createMVS()", 11, "fileName:" + string4 + ", type:" + string7 + ", hostName:" + (String)object2);
                if (string4.equals("EBRXTEMP") || !string7.equals("BOOK") && !string7.equals("BKINDEX") && !string7.equals("BKSHELF") && !string7.equals("PDF")) continue;
                ASoftcopyProperties aSoftcopyProperties = new ASoftcopyProperties();
                aSoftcopyProperties.setFileName(string4);
                aSoftcopyProperties.setFileType(string7);
                aSoftcopyProperties.setAbsoluteFileName((String)object2);
                this.tf.write("createMVS()", 11, "col4:" + (String)object6 + ", col5:" + (String)object5 + ", col8:" + (String)object10);
                long l = 0L;
                if (n3 > 2) {
                    l = (new Long((String)object6) + new Long((String)object5)) * new Long((String)object10);
                }
                this.tf.write("createMVS()", 11, "lVal:" + l);
                aSoftcopyProperties.setSize(new Float(l));
                Date date = null;
                if (((String)object11).length() == 0) {
                    date = new Date(0L);
                } else {
                    try {
                        object9 = new SimpleDateFormat("yyyy/MM/dd");
                        date = ((DateFormat)object9).parse((String)object11);
                    }
                    catch (ParseException parseException) {
                        this.tf.write("createMVS()", 0, "Date Parse Exception:" + parseException.toString());
                        date = new Date(0L);
                    }
                }
                aSoftcopyProperties.setDate(date);
                object9 = "";
                if (string7.equals("BKSHELF")) {
                    object9 = "bks";
                } else if (string7.equals("BOOK")) {
                    object9 = "boo";
                } else if (string7.equals("BKINDEX")) {
                    object9 = "bki";
                }
                aFileObjectsSet.add(new String(string4 + "." + (String)object9).toUpperCase(), aSoftcopyProperties);
                AFileObject aFileObject = new AFileObject();
                aFileObject.setFileName(string4);
                aFileObject.setPCFileType((String)object9);
                aFileObject.setHostFileType(string7);
                aFileObject.setNameInRepository("'" + aSoftcopyProperties.absoluteFileName().toUpperCase() + "'");
                aFileObject.setSize(aSoftcopyProperties.size());
                aFileObject.setInstallDate(aSoftcopyProperties.date());
                aFileObject.setKeyField(aFileObject.nameInRepository());
                this.addFileObject(aFileObject);
                if (!((String)object9).toUpperCase().equals("BKS")) continue;
                ++n2;
            }
        }
        if (n == 1) {
            if (this.aFtp != null && this.aFtp.isConnected()) {
                this.aFtp.quit();
                this.aFtp = null;
            }
            return n;
        }
        boolean bl = false;
        object8 = null;
        if (n2 > 5) {
            object8 = new AProgressObject(aMainWindow, n2, true, false);
            ((AProgressObject)object8).setText("Processing shelves ...");
            bl = true;
        }
        int n7 = 0;
        object7 = null;
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        object6 = aFileObjectsSet.elements();
        while (object6.hasMoreElements()) {
            object5 = (ASoftcopyProperties)object6.nextElement();
            this.tf.write("createMVS()", 11, "File on host:" + ((ASoftcopyProperties)object5).absoluteFileName().toUpperCase());
            if (!((ASoftcopyProperties)object5).fileType().toUpperCase().equals("BKSHELF") || this.groupObjectsSet().containsKey("'" + ((ASoftcopyProperties)object5).absoluteFileName().toUpperCase() + "'")) continue;
            AStatusWindow.write("Processing shelf " + ((ASoftcopyProperties)object5).fileName());
            this.tf.write("createMVS()", 11, "Total memory : " + l + ", Free memory : " + l2);
            object4 = ((ASoftcopyProperties)object5).absoluteFileName();
            object3 = AUtilities.tempDirectory() + File.separator + (String)object4;
            String string8 = this.repository().cacheDirectory() + (String)object4;
            this.tf.write("createMVS()", 11, "downName:" + (String)object3 + ", cacheName:" + string8);
            File file = new File(string8);
            if (file.exists()) {
                object2 = new Date(file.lastModified());
                object = new SimpleDateFormat("EEE, MMM d, yyyy");
                String string9 = ((DateFormat)object).format((Date)object2);
                try {
                    object2 = ((DateFormat)object).parse(string9);
                }
                catch (ParseException parseException) {
                    this.tf.write("createMVS()", 0, "ParseException:" + parseException);
                }
                this.tf.write("createMVS()", 11, "1. Host shelfdate:" + ((ASoftcopyProperties)object5).date() + ", Cache Date:" + object2);
                long l3 = ((Date)object2).getTime();
                this.tf.write("createMVS()", 11, "Host shelfdate:" + ((ASoftcopyProperties)object5).date().getTime());
                this.tf.write("createMVS()", 11, "Cache shelfdate:" + l3);
                AUtilities.CopyFile(string8, (String)object3);
            }
            if (!new File((String)object3).exists()) {
                object2 = ((ASoftcopyProperties)object5).absoluteFileName();
                object2 = "'" + (String)object2 + "'";
                this.tf.write("createMVS()", 11, "Temp. shelf name:" + (String)object2);
                this.aFtp.ascii();
                aFtpReturnCode = this.aFtp.get((String)object3, (String)object2);
                if (aFtpReturnCode.getCommandCode() != 2) {
                    this.tf.write("createMVS()", 0, "Error transferring " + (String)object2 + " to " + (String)object3);
                    n = 1;
                    break;
                }
                this.tf.write("createMVS()", 11, "Shelf copied to tempDirectory:" + (String)object3);
            }
            object2 = new AGroupObject();
            ((ABaseObject)object2).setFileName(((ASoftcopyProperties)object5).fileName());
            ((ABaseObject)object2).setPCFileType(((ASoftcopyProperties)object5).fileType());
            ((ABaseObject)object2).setHostFileType(((ASoftcopyProperties)object5).fileType());
            ((ABaseObject)object2).setNameInRepository("'" + ((ASoftcopyProperties)object5).absoluteFileName().toUpperCase() + "'");
            ((ABaseObject)object2).setInstallDate(((ASoftcopyProperties)object5).date());
            ((ABaseObject)object2).setKeyField(((ABaseObject)object2).nameInRepository());
            this.tf.write("createMVS()", 11, "New Group keyfield:" + ((ABaseObject)object2).keyField());
            AGroupObject.setIsErrorMessageShown(true);
            if (!((AGroupObject)object2).read((String)object3, aFileObjectsSet, true) && !((AGroupObject)object2).isCancelled()) {
                new File((String)object3).delete();
                continue;
            }
            if (((AGroupObject)object2).isCancelled()) {
                new File((String)object3).delete();
                n = 1;
                break;
            }
            this.addGroupObject((AGroupObject)object2);
            ((AGroupObject)object2).delete();
            l = Runtime.getRuntime().totalMemory();
            l2 = Runtime.getRuntime().freeMemory();
            if (l2 < 3300000L) {
                Runtime.getRuntime().gc();
            }
            if (((AGroupObject)object2).fixShelf()) {
                this.tf.write("createMVS()", 11, "Fix shelf:" + (String)object3);
                if (object7 == null) {
                    object7 = this.createTempKeySet(3);
                }
                if ((aFtpReturnCode = ATransferProcess.updateBookshelf(((AGroupObject)object2).fileObjectPtr(), (AFileObjectsSet)object7, this.repository(), (String)object3)).getProcessCode() != 0) {
                    this.tf.write("createMVS()", 0, "Error updating shelf:" + (String)object3);
                    n = 2;
                    break;
                }
                aFtpReturnCode = this.repository().putShelfToHost((AGroupObject)object2, (String)object3, this.aFtp);
                if (aFtpReturnCode.getCommandCode() != 2) {
                    this.tf.write("createMVS()", 0, "Error putting shelf:" + (String)object3 + " to " + this.repository().repositoryTitle());
                    n = 2;
                    break;
                }
                AUtilities.CopyFile((String)object3, string8);
            }
            if (!new File(string8).exists()) {
                AUtilities.CopyFile((String)object3, string8);
                this.tf.write("createMVS()", 11, "Shelf copied to cacheDirectory:" + string8);
            }
            new File((String)object3).delete();
            Runtime.getRuntime().gc();
            if (bl && !((AProgressObject)object8).update(++n7)) break;
        }
        if (bl) {
            ((AProgressObject)object8).removeProgressObject();
        }
        if (object7 != null) {
            ((HashMap)object7).clear();
            object7 = null;
        }
        AGroupObject.setIsErrorMessageShown(false);
        if (this.aFtp != null && this.aFtp.isConnected()) {
            this.aFtp.quit();
            this.aFtp = null;
        }
        this.tf.write("createMVS()", 10, "Exit");
        return n;
    }

    private int createOE(AMainWindow aMainWindow) {
        Object object;
        String string;
        String string2;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object[] objectArray;
        String string3;
        this.tf.write("createOE()", 10, "Entry");
        int n2 = 0;
        this.setCurrentKey(3);
        String string4 = this.repository().shelvesDirectories() + "\n";
        if (string4.indexOf(this.repository().indexDirectories()) == -1) {
            string4 = string4 + this.repository().indexDirectories() + "\n";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.repository().softcopyDirectories(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string4.indexOf(string3) != -1) continue;
            string4 = string4 + string3;
        }
        this.tf.write("createOE()", 11, "listOfDirectories:" + string4);
        string3 = "";
        AGroupObjectsSet aGroupObjectsSet = new AGroupObjectsSet();
        this.aFtp = new AFtp();
        this.aFtp.setLogonParameters(new AFtpLogonParameters(this.repository()));
        AFtpReturnCode aFtpReturnCode = this.aFtp.logon();
        if (aFtpReturnCode.getCommandCode() != 2) {
            n2 = 1;
            this.tf.write("createOE()", 0, "Error logging on:" + aFtpReturnCode.getCommandCode());
            return n2;
        }
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        int n3 = 0;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "\n");
        while (stringTokenizer2.hasMoreTokens()) {
            String string5;
            String string6;
            StringTokenizer stringTokenizer3;
            string3 = stringTokenizer2.nextToken();
            string3 = string3.trim();
            this.tf.write("createOE()", 11, "currentDirectory:" + string3);
            if (string3.trim().length() == 0) continue;
            AStatusWindow.write("Analyzing " + string3 + " directory...");
            AStatusWindow.write(AUtilities.LINE_SEPARATOR + "Querying contents of " + string3 + AUtilities.LINE_SEPARATOR + "This may take a few seconds..." + AUtilities.LINE_SEPARATOR);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!string3.substring(string3.length() - 1).equals("/")) {
                string3 = string3 + "/";
            }
            this.tf.write("createOE()", 11, "check current directory:" + string3);
            aFtpReturnCode = this.aFtp.cwd(string3);
            if (aFtpReturnCode.getCommandCode() != 2) {
                objectArray = new Object[]{"OK", "Cancel"};
                stringTokenizer3 = aFtpReturnCode.getServerResponse().elements();
                string6 = "";
                while (stringTokenizer3.hasMoreElements()) {
                    string5 = (String)stringTokenizer3.nextElement();
                    string6 = string6 + string5 + "<br>";
                }
                string5 = "Error querying the contents of " + string3 + "<br>" + string6;
                n2 = JOptionPane.showOptionDialog(AUtilities.mainWindow, "<html>" + string5 + "</html>", "Confirm Dialog", 2, 3, null, objectArray, objectArray[1]);
                if (n2 != 1) continue;
                break;
            }
            aFtpReturnCode = this.aFtp.dir("", byteArrayOutputStream);
            objectArray = byteArrayOutputStream.toString();
            this.tf.write("createOE()", 11, "directoryListing:" + (String)objectArray);
            stringTokenizer3 = new StringTokenizer((String)objectArray, "\r\n");
            string6 = "";
            while (stringTokenizer3.hasMoreTokens()) {
                Object object5;
                Object object6;
                string6 = stringTokenizer3.nextToken();
                this.tf.write("createOE()", 11, "currentLine:" + string6);
                if (string6.trim().length() == 0 || !string6.startsWith("-")) continue;
                string5 = "";
                String string7 = "";
                String string8 = "";
                object4 = "";
                object3 = "";
                object2 = new StringTokenizer(string6, " ");
                if (((StringTokenizer)object2).countTokens() != 9) {
                    this.tf.write("createOE()", 0, "Error parsing line:" + string6);
                    continue;
                }
                n = 1;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object2).nextToken();
                    if (n == 5) {
                        string7 = string2;
                    } else if (n == 6) {
                        string8 = string2;
                    } else if (n == 7) {
                        object4 = string2;
                    } else if (n == 8) {
                        object3 = string2;
                    } else if (n == 9) {
                        string5 = string2;
                    }
                    ++n;
                }
                string2 = string5;
                int n4 = string5.lastIndexOf("/");
                string = "";
                string = n4 != -1 ? string5.substring(n4 + 1) : string5;
                object = null;
                try {
                    n4 = string.indexOf(".");
                    if (n4 <= 0) continue;
                    object = string.substring(n4 + 1);
                    string5 = string.substring(0, n4);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                ASoftcopyProperties aSoftcopyProperties = new ASoftcopyProperties();
                aSoftcopyProperties.setFileName(string5);
                aSoftcopyProperties.setFileType((String)object);
                aSoftcopyProperties.setAbsoluteFileName(string3 + string2);
                aSoftcopyProperties.setSize(new Float(string7));
                Date date = null;
                try {
                    n4 = ((String)object3).indexOf(":");
                    if (n4 != -1) {
                        object6 = new GregorianCalendar();
                        int n5 = ((Calendar)object6).get(1);
                        object3 = new Integer(n5).toString();
                    }
                    object6 = string8 + " " + (String)object4 + " " + (String)object3;
                    object5 = new SimpleDateFormat("MMM dd yyyy");
                    date = ((DateFormat)object5).parse((String)object6);
                }
                catch (ParseException parseException) {
                    this.tf.write("createOE()", 0, "Date Parse Exception:" + parseException.toString());
                    date = new Date(0L);
                }
                aSoftcopyProperties.setDate(date);
                object6 = "";
                object5 = "";
                if (((String)object).toUpperCase().equals("BKS")) {
                    object6 = "bks";
                    object5 = "BKSHELF";
                } else if (((String)object).toUpperCase().equals("BOO")) {
                    object6 = "boo";
                    object5 = "BOOK";
                } else if (((String)object).toUpperCase().equals("BKI")) {
                    object6 = "bki";
                    object5 = "BKINDEX";
                }
                if (!aFileObjectsSet.containsKey(new String(string5 + "." + (String)object6).toUpperCase())) {
                    aFileObjectsSet.add(new String(string5 + "." + (String)object6).toUpperCase(), aSoftcopyProperties);
                }
                AFileObject aFileObject = new AFileObject();
                aFileObject.setFileName(string5);
                aFileObject.setPCFileType((String)object6);
                aFileObject.setHostFileType((String)object5);
                aFileObject.setNameInRepository(aSoftcopyProperties.absoluteFileName());
                aFileObject.setSize(aSoftcopyProperties.size());
                aFileObject.setInstallDate(aSoftcopyProperties.date());
                aFileObject.setKeyField(aFileObject.fileNameType());
                this.addFileObject(aFileObject);
                if (!((String)object6).toUpperCase().equals("BKS")) continue;
                ++n3;
            }
            byteArrayOutputStream = null;
            objectArray = null;
        }
        if (n2 == 1) {
            if (this.aFtp != null && this.aFtp.isConnected()) {
                this.aFtp.quit();
                this.aFtp = null;
            }
            return n2;
        }
        boolean bl = false;
        objectArray = null;
        if (n3 > 5) {
            objectArray = new AProgressObject(aMainWindow, n3, true, false);
            objectArray.setText("Processing shelves ...");
            bl = true;
        }
        int n6 = 0;
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        object4 = aFileObjectsSet.elements();
        while (object4.hasMoreElements()) {
            object3 = (ASoftcopyProperties)object4.nextElement();
            if (!((ASoftcopyProperties)object3).fileType().toUpperCase().equals("BKS")) continue;
            AStatusWindow.write("Processing shelf " + ((ASoftcopyProperties)object3).fileName());
            AStatusWindow.write("Total memory : " + l + ", Free memory : " + l2);
            this.tf.write("createOE()", 11, "Total memory : " + l + ", Free memory : " + l2);
            object2 = "";
            n = ((ASoftcopyProperties)object3).absoluteFileName().indexOf(".");
            if (n != -1) {
                object2 = ((ASoftcopyProperties)object3).absoluteFileName().substring(n + 1);
            }
            string2 = ((ASoftcopyProperties)object3).fileName() + "." + (String)object2;
            String string9 = AUtilities.tempDirectory() + File.separator + string2;
            string = this.repository().cacheDirectory() + string2;
            this.tf.write("createOE()", 11, "downName:" + string9 + ", cacheName:" + string);
            if (new File(string).exists()) {
                AUtilities.CopyFile(string, string9);
            } else {
                object = ((ASoftcopyProperties)object3).absoluteFileName();
                this.tf.write("createOE()", 11, "Temp. shelf name:" + (String)object);
                this.aFtp.ascii();
                aFtpReturnCode = this.aFtp.get(string9, (String)object);
                if (aFtpReturnCode.getCommandCode() != 2) {
                    this.tf.write("createOE()", 0, "Error transferring " + (String)object + " to " + string9);
                    if (bl) {
                        objectArray.removeProgressObject();
                    }
                    return 1;
                }
            }
            if (!new File(string).exists()) {
                AUtilities.CopyFile(string9, string);
            }
            object = new AGroupObject();
            ((ABaseObject)object).setFileName(((ASoftcopyProperties)object3).fileName());
            ((ABaseObject)object).setPCFileType(((ASoftcopyProperties)object3).fileType());
            ((ABaseObject)object).setHostFileType("BKSHELF");
            ((ABaseObject)object).setNameInRepository(((ASoftcopyProperties)object3).absoluteFileName());
            ((ABaseObject)object).setInstallDate(((ASoftcopyProperties)object3).date());
            ((ABaseObject)object).setKeyField(((ABaseObject)object).fileNameType());
            AGroupObject.setIsErrorMessageShown(true);
            if (!((AGroupObject)object).read(string9, aFileObjectsSet) && !((AGroupObject)object).isCancelled()) {
                new File(string9).delete();
                continue;
            }
            if (((AGroupObject)object).isCancelled()) {
                new File(string9).delete();
                n2 = 1;
                break;
            }
            this.addGroupObject((AGroupObject)object);
            ((AGroupObject)object).delete();
            l = Runtime.getRuntime().totalMemory();
            l2 = Runtime.getRuntime().freeMemory();
            if (l2 < 3300000L) {
                Runtime.getRuntime().gc();
            }
            new File(string9).delete();
            if (++n6 % 150 == 0) {
                this.aFtp.noop();
            }
            if (bl && !objectArray.update(n6)) break;
        }
        if (bl) {
            objectArray.removeProgressObject();
        }
        AGroupObject.setIsErrorMessageShown(false);
        if (this.aFtp != null && this.aFtp.isConnected()) {
            this.aFtp.quit();
            this.aFtp = null;
        }
        this.tf.write("createOE()", 10, "Exit");
        return n2;
    }

    private int createPC(AMainWindow aMainWindow) {
        Object object;
        Object object2;
        ASoftcopyProperties aSoftcopyProperties;
        Object object3;
        String[] stringArray;
        Object object4;
        this.tf.write("createPC()", 10, "Entry");
        int n = 0;
        this.setCurrentKey(3);
        String string = this.repository().shelvesDirectories() + "\n";
        if (string.indexOf(this.repository().indexDirectories()) == -1) {
            string = string + this.repository().indexDirectories() + "\n";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.repository().softcopyDirectories(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            object4 = stringTokenizer.nextToken();
            if (string.indexOf((String)object4) != -1) continue;
            string = string + (String)object4;
        }
        this.tf.write("createPC()", 11, "listOfDirectories:" + string);
        object4 = new StringTokenizer(string, "\n");
        String string2 = "";
        int n2 = 0;
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        while (((StringTokenizer)object4).hasMoreTokens()) {
            Object object5;
            string2 = ((StringTokenizer)object4).nextToken();
            string2 = string2.trim();
            this.tf.write("createPC()", 11, "currentDirectory:" + string2);
            if (string2.trim().length() == 0) continue;
            AStatusWindow.write("Analyzing " + string2 + " directory...");
            File file = new File(string2);
            stringArray = file.list();
            if (stringArray == null) {
                Object[] objectArray = new Object[]{"OK", "Cancel"};
                object5 = "Error querying the contents of " + string2;
                n = JOptionPane.showOptionDialog(AUtilities.mainWindow, "<html>" + (String)object5 + "</html>", "Confirm Dialog", 2, 3, null, objectArray, objectArray[1]);
                if (n != 1) continue;
                break;
            }
            int n3 = 0;
            while (n3 < stringArray.length) {
                object5 = new File(file, stringArray[n3]);
                this.tf.write("createPC()", 11, ((File)object5).getAbsolutePath() + " : " + ((File)object5).isFile());
                if (((File)object5).isFile()) {
                    String string3 = ((File)object5).getAbsolutePath();
                    String string4 = ((File)object5).getName();
                    int n4 = string4.lastIndexOf(46);
                    object3 = "";
                    if (n4 != -1) {
                        object3 = string4.substring(n4 + 1);
                        string4 = string4.substring(0, n4);
                    }
                    if (((String)object3).toUpperCase().equals("BKS") || ((String)object3).toUpperCase().equals("BKI") || ((String)object3).toUpperCase().equals("BOO")) {
                        aSoftcopyProperties = new ASoftcopyProperties();
                        aSoftcopyProperties.setFileName(string4);
                        aSoftcopyProperties.setFileType((String)object3);
                        aSoftcopyProperties.setAbsoluteFileName(string3);
                        aSoftcopyProperties.setSize(new Float(((File)object5).length()));
                        long l = ((File)object5).lastModified();
                        object2 = null;
                        object2 = new Date(l);
                        this.tf.write("createPC()", 11, "lastModified:" + l);
                        this.tf.write("createPC()", 11, "iDate:" + object2);
                        aSoftcopyProperties.setDate((Date)object2);
                        object = "";
                        if (((String)object3).toUpperCase().equals("BKS")) {
                            object = "BKSHELF";
                        } else if (((String)object3).toUpperCase().equals("BOO")) {
                            object = "BOOK";
                        } else if (((String)object3).toUpperCase().equals("BKI")) {
                            object = "BKINDEX";
                        }
                        if (!aFileObjectsSet.containsKey(new String(string4 + "." + (String)object3).toUpperCase())) {
                            aFileObjectsSet.add(new String(string4 + "." + (String)object3).toUpperCase(), aSoftcopyProperties);
                        }
                        AFileObject aFileObject = new AFileObject();
                        aFileObject.setFileName(string4);
                        aFileObject.setPCFileType((String)object3);
                        aFileObject.setHostFileType((String)object);
                        aFileObject.setNameInRepository(aSoftcopyProperties.absoluteFileName());
                        aFileObject.setSize(aSoftcopyProperties.size());
                        aFileObject.setInstallDate(aSoftcopyProperties.date());
                        aFileObject.setKeyField(aFileObject.fileNameType());
                        this.addFileObject(aFileObject);
                        if (((String)object3).toUpperCase().equals("BKS")) {
                            ++n2;
                        }
                    }
                }
                ++n3;
            }
        }
        if (n == 1) {
            return n;
        }
        boolean bl = false;
        stringArray = null;
        this.tf.write("createPC()", 11, "Shelves count:" + n2);
        if (n2 > 5) {
            stringArray = new AProgressObject(aMainWindow, n2, true, false);
            stringArray.setText("Processing shelves ...");
            bl = true;
        }
        int n5 = 0;
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        object3 = aFileObjectsSet.elements();
        while (object3.hasMoreElements()) {
            aSoftcopyProperties = (ASoftcopyProperties)object3.nextElement();
            if (!aSoftcopyProperties.fileType().toUpperCase().equals("BKS")) continue;
            AStatusWindow.write("Processing shelf " + aSoftcopyProperties.fileName());
            this.tf.write("createPC()", 11, "Total memory : " + l + ", Free memory : " + l2);
            String string5 = aSoftcopyProperties.fileName() + "." + aSoftcopyProperties.fileType();
            String string6 = AUtilities.tempDirectory() + File.separator + string5;
            object2 = this.repository().cacheDirectory() + string5;
            this.tf.write("createPC()", 11, "downName:" + string6 + ", cacheName:" + (String)object2);
            if (new File((String)object2).exists()) {
                AUtilities.CopyFile((String)object2, string6);
            } else {
                object = aSoftcopyProperties.absoluteFileName();
                this.tf.write("createPC()", 11, "Temp. shelf name:" + (String)object);
                if (!AUtilities.CopyFile((String)object, string6)) {
                    this.tf.write("createPC()", 0, "Error copying " + (String)object + " to " + string6);
                }
            }
            if (!new File((String)object2).exists()) {
                AUtilities.CopyFile(string6, (String)object2);
            }
            object = new AGroupObject();
            ((ABaseObject)object).setFileName(aSoftcopyProperties.fileName());
            ((ABaseObject)object).setPCFileType("BKSHELF");
            ((ABaseObject)object).setHostFileType("BKSHELF");
            ((ABaseObject)object).setNameInRepository(aSoftcopyProperties.absoluteFileName());
            ((ABaseObject)object).setInstallDate(aSoftcopyProperties.date());
            ((ABaseObject)object).setKeyField(((ABaseObject)object).fileNameType());
            AGroupObject.setIsErrorMessageShown(true);
            if (!((AGroupObject)object).read(string6, aFileObjectsSet) && !((AGroupObject)object).isCancelled()) {
                new File(string6).delete();
                continue;
            }
            if (((AGroupObject)object).isCancelled()) {
                new File(string6).delete();
                n = 1;
                break;
            }
            this.addGroupObject((AGroupObject)object);
            ((AGroupObject)object).delete();
            l = Runtime.getRuntime().totalMemory();
            l2 = Runtime.getRuntime().freeMemory();
            if (l2 < 3300000L) {
                Runtime.getRuntime().gc();
            }
            new File(string6).delete();
            if (bl && !stringArray.update(++n5)) break;
        }
        if (bl) {
            stringArray.removeProgressObject();
        }
        AGroupObject.setIsErrorMessageShown(false);
        this.tf.write("createPC()", 10, "Exit");
        return n;
    }

    public static AFileObjectsSet getUniqueObjects(Vector vector) {
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        AFileObject aFileObject = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            Object e = vector.firstElement();
            if (e.getClass() == (class$AFileObject == null ? ACatalog.class$("AFileObject") : class$AFileObject)) {
                aFileObjectsSet.values().addAll(vector);
                break;
            }
            AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
            if (!aGroupObject.inCatalog()) {
                enumeration2 = aGroupObject.bookSet().elements();
                while (enumeration2.hasMoreElements()) {
                    aFileObject = (AFileObject)enumeration2.nextElement();
                    if (aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                    aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                }
                aFileObjectsSet.add(aGroupObject.fileObjectPtr().keyField(), aGroupObject.fileObjectPtr());
                continue;
            }
            enumeration2 = aGroupObject.fileObjectsSet().elements();
            while (enumeration2.hasMoreElements()) {
                aFileObject = (AFileObject)enumeration2.nextElement();
                if (aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
            }
        }
        return aFileObjectsSet;
    }

    public static AFileObjectsSet getUniqueObjects(ABaseSet aBaseSet, ARepository aRepository) {
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        AFileObject aFileObject = null;
        aRepository.tf.write("getUniqueObjects() overload", 13, "Current Catalog key:" + aRepository.catalog().currentKey());
        AFileObjectsSet aFileObjectsSet2 = aRepository.catalog().fileObjectsSet();
        Enumeration enumeration = aBaseSet.elements();
        while (enumeration.hasMoreElements()) {
            AFileObject aFileObject2;
            Vector vector;
            Object object;
            Cloneable cloneable;
            Object e = enumeration.nextElement();
            if (e.getClass() == (class$AFileObject == null ? ACatalog.class$("AFileObject") : class$AFileObject)) {
                aFileObject = (AFileObject)e;
                if (aFileObject.isMissing() || aFileObject.referenceCount() < 0) continue;
                if (!aFileObjectsSet2.containsKey(aFileObject.keyField())) {
                    if (aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                    aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                    continue;
                }
                cloneable = aFileObjectsSet2.getObjects(aFileObject.keyField());
                if (cloneable == null || ((AFileObject)(object = (AFileObject)((Vector)cloneable).firstElement())).referenceCount() >= 0 || aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                continue;
            }
            if (e.getClass() != (class$AGroupObject == null ? ACatalog.class$("AGroupObject") : class$AGroupObject)) continue;
            cloneable = (AGroupObject)e;
            if (!((ABaseObject)((Object)cloneable)).inCatalog()) {
                object = ((AGroupObject)cloneable).bookSet().elements();
                while (object.hasMoreElements()) {
                    aFileObject = (AFileObject)object.nextElement();
                    if (aFileObject.isMissing()) continue;
                    if (!aFileObjectsSet2.containsKey(aFileObject.keyField())) {
                        if (aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                        aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                        continue;
                    }
                    vector = aFileObjectsSet2.getObjects(aFileObject.keyField());
                    if (vector == null || (aFileObject2 = (AFileObject)vector.firstElement()).referenceCount() >= 0 || aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                    aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                }
                if (!aFileObjectsSet2.containsKey(((AGroupObject)cloneable).fileObjectPtr().keyField())) {
                    if (aFileObjectsSet.containsKey(((AGroupObject)cloneable).fileObjectPtr().keyField())) continue;
                    aFileObjectsSet.add(((AGroupObject)cloneable).fileObjectPtr().keyField(), ((AGroupObject)cloneable).fileObjectPtr());
                    continue;
                }
                vector = aFileObjectsSet2.getObjects(aFileObject.keyField());
                if (vector == null || (aFileObject2 = (AFileObject)vector.firstElement()).referenceCount() >= 0 || aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                continue;
            }
            object = ((AGroupObject)cloneable).fileObjectsSet().elements();
            while (object.hasMoreElements()) {
                aFileObject = (AFileObject)object.nextElement();
                if (aFileObject.referenceCount() < 0) continue;
                if (!aFileObjectsSet2.containsKey(aFileObject.keyField())) {
                    if (aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                    aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
                    continue;
                }
                vector = aFileObjectsSet2.getObjects(aFileObject.keyField());
                if (vector == null || (aFileObject2 = (AFileObject)vector.firstElement()).referenceCount() >= 0 || aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
                aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
            }
            if (!aFileObjectsSet2.containsKey(((AGroupObject)cloneable).fileObjectPtr().keyField())) {
                if (aFileObjectsSet.containsKey(((AGroupObject)cloneable).fileObjectPtr().keyField())) continue;
                aFileObjectsSet.add(((AGroupObject)cloneable).fileObjectPtr().keyField(), ((AGroupObject)cloneable).fileObjectPtr());
                continue;
            }
            vector = aFileObjectsSet2.getObjects(aFileObject.keyField());
            if (vector == null || (aFileObject2 = (AFileObject)vector.firstElement()).referenceCount() >= 0 || aFileObjectsSet.containsKey(aFileObject.keyField())) continue;
            aFileObjectsSet.add(aFileObject.keyField(), aFileObject);
        }
        return aFileObjectsSet;
    }

    protected void setCurrentKey(int n) {
        this.iCurrentKey = n;
    }

    protected int currentKey() {
        return this.iCurrentKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LABELCATALOGVERSION = new String("[catalogVersion]");
        CATALOGVERSION = new String("4");
        LABELNUMBERFILES = new String("[numberFiles]");
        LABELNUMBERGROUPS = new String("[numberGroups]");
        LABEL_FILE = new String("F ");
        LABEL_GROUP = new String("G ");
        LABEL_INDEX = new String("01");
        LABEL_FILENAME = new String("02");
        LABEL_PCFILETYPE = new String("03");
        LABEL_TITLE = new String("04");
        LABEL_HOSTFILETYPE = new String("05");
        LABEL_NAMEINREPOSITORY = new String("06");
        LABEL_DATE = new String("07");
        LABEL_INSTALLDATE = new String("08");
        LABEL_REFERENCECOUNT = new String("09");
        LABEL_GROUPOBJECTPTR = new String("10");
        LABEL_MISSINGFROMGROUP = new String("11");
        LABEL_FILESIZE = new String("15");
        LABEL_FILEOBJECTPTR = new String("12");
        LABEL_FILEOBJECTS = new String("13");
        LABEL_MISSINGFILEOBJECTS = new String("14");
        LEFTSQUAREBRACE = new String("[");
        RIGHTSQUAREBRACE = new String("]");
        SPACE = new String(" ");
        DOT = new String(".");
    }
}

