/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;

class ADescriptorDownload
implements PropertyChangeListener {
    private ATraceFile tf = new ATraceFile(this);
    private JFrame owner;
    private ASourceWindow sourceWindow;
    private String serverName;
    private final String MASTER_DESCRIPTOR_FILENAME = "/epubs/df/ebrscrt.des";
    private ADescriptorListWindow adlWindow = null;
    private InputStream masterDescriptorIS = null;
    private String masterDescriptorFilename = null;
    private Vector masterDescriptorContents = null;
    private InputStream descriptorIS = null;
    private AFtpReturnCode gFtpRC = null;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.tf.write("propertyChanged()", 19, "entry");
        this.tf.write("PropertyName:", 19, propertyChangeEvent.getPropertyName() + ", Old:" + propertyChangeEvent.getOldValue() + ", New:" + propertyChangeEvent.getNewValue());
        this.gFtpRC = new AFtpReturnCode();
        if (propertyChangeEvent.getPropertyName().equals("okay")) {
            Object object;
            String string = (String)propertyChangeEvent.getOldValue();
            String string2 = "";
            Enumeration enumeration = this.masterDescriptorContents.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                int n = ((String)object).indexOf(34);
                if (n == -1) {
                    AUtilities.showInfoMessage("Error in master descriptor file");
                    return;
                }
                if (!((String)object).substring(n).trim().equals(string)) continue;
                string2 = ((String)object).substring(0, n - 1).trim();
                break;
            }
            this.tf.write("desFileName:", 18, string2);
            object = new AFtpReturnCode();
            AMainWindow.UpdateStatusInfo("Downloading descriptor file " + string2);
            this.sourceWindow.setTitle(this.sourceWindow.aSourceObject.sourceTitle() + " - " + AUtilities.strip(string, '\"'));
            object = this.openDescriptorFile(string2);
            if (((AFtpReturnCode)object).getProcessCode() == 0) {
                object = this.readDescriptorFile();
            }
            AMainWindow.UpdateStatusInfo("");
            this.gFtpRC = object;
        } else if (propertyChangeEvent.getPropertyName().equals("cancel")) {
            this.gFtpRC.setProcessCode(1);
        }
        this.tf.write("propertyChanged", 19, "exit");
    }

    private AFtpReturnCode displayListOfDescriptors() {
        this.tf.write("displayListOfDescriptors()", 18, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.adlWindow = new ADescriptorListWindow(this.owner, this.masterDescriptorContents, this);
        this.tf.write("displayListOfDescriptors()", 18, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode processDescriptor() {
        this.tf.write("processDescriptor()", 18, "entry");
        AMainWindow.UpdateStatusInfo("Retrieving list of product categories ...");
        AFtpReturnCode aFtpReturnCode = this.openMasterDescriptor(this.serverName);
        if (aFtpReturnCode.getProcessCode() == 0) {
            aFtpReturnCode = this.readMasterDescriptor();
        }
        AMainWindow.UpdateStatusInfo("");
        if (aFtpReturnCode.getProcessCode() == 0) {
            aFtpReturnCode = this.displayListOfDescriptors();
        }
        if (this.gFtpRC != null) {
            aFtpReturnCode = this.gFtpRC;
        }
        this.tf.write("processDescriptor()", 18, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openMasterDescriptor(String string) {
        this.tf.write("openMasterDescriptor()", 18, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        try {
            this.tf.write("openMasterDescriptor()", 18, "server:" + string + ", master descriptor file:" + "/epubs/df/ebrscrt.des");
            URL uRL = new URL("http", string, "/epubs/df/ebrscrt.des");
            this.masterDescriptorIS = uRL.openStream();
            this.masterDescriptorFilename = uRL.toString();
            this.tf.write("openMasterDescriptor()", 18, "url:" + this.masterDescriptorFilename);
        }
        catch (Exception exception) {
            this.tf.write("openMasterDescriptor()", 0, "Exception:" + exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error attempting to open list of descriptor files:" + AUtilities.LINE_SEPARATOR + AUtilities.LINE_SEPARATOR + this.masterDescriptorFilename);
            String string2 = exception.getClass().getName();
            if (string2.equals("java.io.FileNotFoundException")) {
                aFtpReturnCode.setProcessCode(401);
            }
            if (string2.equals("java.net.NoRouteToHostException")) {
                aFtpReturnCode.setProcessCode(407);
            }
            aFtpReturnCode.setProcessCode(400);
        }
        this.tf.write("openMasterDescriptor()", 18, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode readMasterDescriptor() {
        this.tf.write("readMasterDescriptor()", 18, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.masterDescriptorIS));
            this.masterDescriptorContents = new Vector();
            String string = bufferedReader.readLine();
            int n = string.indexOf("filename");
            if (n == -1) {
                this.tf.write("readMasterDescriptor()", 0, "Error in " + this.masterDescriptorFilename);
                StringBuffer stringBuffer = new StringBuffer();
                while (string != null) {
                    this.tf.write("readMasterDescriptor()", 19, "lineOfText:" + string);
                    stringBuffer.append(string);
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.tf.write("readMasterDescriptor()", 19, "buff:" + stringBuffer.toString());
                String string2 = "<html><h2>Error occurred during reading descriptor file.</h2></html>";
                AInfoDisplay aInfoDisplay = new AInfoDisplay((Frame)this.owner, string2, stringBuffer.toString());
                aFtpReturnCode.setProcessCode(1);
                return aFtpReturnCode;
            }
            string = bufferedReader.readLine();
            while (string != null) {
                this.masterDescriptorContents.addElement(string);
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            this.tf.write("readMasterDescriptor()", 0, "Exception:" + exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error reading list of descriptor files from:" + AUtilities.LINE_SEPARATOR + AUtilities.LINE_SEPARATOR + this.masterDescriptorFilename);
            String string = exception.getClass().getName();
            if (string.equals("java.net.NoRouteToHostException")) {
                aFtpReturnCode.setProcessCode(407);
            }
            aFtpReturnCode.setProcessCode(402);
        }
        this.tf.write("readMasterDescriptor()", 18, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode openDescriptorFile(String string) {
        this.tf.write("openDescriptorFile()", 18, "entry:" + string);
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        AStatusWindow.write("Downloading descriptor file " + string);
        try {
            URL uRL = new URL("http", this.serverName, string);
            this.descriptorIS = uRL.openStream();
        }
        catch (Exception exception) {
            this.tf.write("openDescriptorFile()", 0, "Exception:" + exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error attempting to open list of descriptor files:" + AUtilities.LINE_SEPARATOR + AUtilities.LINE_SEPARATOR + this.masterDescriptorFilename);
            String string2 = exception.getClass().getName();
            if (string2.equals("java.io.FileNotFoundException")) {
                aFtpReturnCode.setProcessCode(401);
            }
            if (string2.equals("java.net.NoRouteToHostException")) {
                aFtpReturnCode.setProcessCode(407);
            }
            aFtpReturnCode.setProcessCode(400);
        }
        this.tf.write("openDescriptorFile()", 18, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode readDescriptorFile() {
        this.tf.write("readDescriptorFile()", 18, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        PrintStream printStream = null;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.descriptorIS));
            File file = new File(AUtilities.tempDirectory() + File.separator + "ebrscrt.des");
            printStream = new PrintStream(new FileOutputStream(file));
            while ((string = bufferedReader.readLine()) != null) {
                printStream.println(string);
            }
            printStream.close();
        }
        catch (Exception exception) {
            this.tf.write("readDescriptorFile()", 0, "Exception:" + exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setMessage("Error reading list of descriptor files from:" + AUtilities.LINE_SEPARATOR + AUtilities.LINE_SEPARATOR + this.masterDescriptorFilename);
            String string = exception.getClass().getName();
            if (string.equals("java.net.NoRouteToHostException")) {
                aFtpReturnCode.setProcessCode(407);
            }
            aFtpReturnCode.setProcessCode(402);
        }
        this.tf.write("readDescriptorFile()", 18, "exit");
        return aFtpReturnCode;
    }

    public ADescriptorDownload(ASourceWindow aSourceWindow, String string) {
        this.tf.write("ADescriptorDownload()", 18, "entry");
        this.sourceWindow = aSourceWindow;
        this.owner = AUtilities.mainWindow;
        String string2 = string;
        int n = string2.indexOf("://");
        if (n != -1) {
            string2 = string2.substring(n + 3);
        }
        this.serverName = string2 = AUtilities.strip(string2, '/');
        AProxy.setProxyProperties(this.serverName);
        this.tf.write("ADescriptorDownload()", 18, "exit");
    }
}

