/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AFindWindow
extends JDialog
implements ActionListener {
    private AMainWindow owner;
    private JTable table;
    private JLabel findLabel;
    private JTextField findTextField;
    private String iFindText;
    public int retCode = 0;
    private ATraceFile tf;
    private int column = -1;
    private int row = -1;

    AFindWindow(AMainWindow aMainWindow, JTable jTable, String string) {
        super(aMainWindow, "Find", true);
        JPanel jPanel;
        this.owner = aMainWindow;
        this.table = jTable;
        this.setFindText(string);
        this.tf = new ATraceFile(this);
        JPanel jPanel2 = jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.findLabel = new JLabel("Search Text");
        this.findTextField = new JTextField(80);
        this.findTextField.setText(this.getFindText());
        this.findTextField.setEditable(true);
        this.findTextField.setVisible(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.findLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.findTextField);
        JPanel jPanel3 = new JPanel(){

            public Insets getInsets() {
                return new Insets(0, 0, 20, 0);
            }
        };
        JButton jButton = new JButton("Find");
        JButton jButton2 = new JButton("Cancel");
        jButton.setMnemonic('F');
        jButton2.setMnemonic('C');
        jPanel3.add((Component)jButton, "East");
        jPanel3.add((Component)jButton2, "West");
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AFindWindow.this.retCode = 1;
                AFindWindow.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel3);
        ((Component)this).setSize(300, 200);
        this.setLocationRelativeTo(aMainWindow);
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Find")) {
            if (this.findTextField.getText().trim().length() == 0) {
                AUtilities.showInfoMessage("Enter the text to be searched");
                return;
            }
            this.retCode = 0;
            this.setFindText(this.findTextField.getText().trim());
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.retCode = 1;
            this.dispose();
        }
    }

    private void setFindText(String string) {
        this.iFindText = string;
    }

    protected String getFindText() {
        return this.iFindText;
    }

    private void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public boolean findFirst() {
        boolean bl = false;
        String string = this.getFindText();
        this.tf.write("findFirst()", 18, "Search Text:" + string);
        int n = this.table.getColumnCount();
        int n2 = 0;
        while (n2 < this.table.getRowCount()) {
            int n3 = 0;
            while (n3 < n) {
                String string2 = this.table.getValueAt(n2, n3).toString().toUpperCase();
                int n4 = string2.indexOf(string.toUpperCase());
                if (n4 != -1) {
                    this.row = n2;
                    this.column = n3;
                    bl = true;
                    this.moveMouse(string2.substring(0, n4));
                    break;
                }
                ++n3;
            }
            if (bl) break;
            ++n2;
        }
        return bl;
    }

    public boolean findNext() {
        boolean bl = false;
        String string = this.getFindText();
        ++this.column;
        int n = this.getColumn();
        int n2 = this.table.getColumnCount();
        int n3 = this.getRow();
        while (n3 < this.table.getRowCount()) {
            int n4 = n;
            while (n4 < n2) {
                String string2 = this.table.getValueAt(n3, n4).toString().toUpperCase();
                int n5 = string2.indexOf(string.toUpperCase());
                if (n5 != -1) {
                    this.row = n3;
                    this.column = n4;
                    bl = true;
                    this.moveMouse(string2.substring(0, n5));
                    break;
                }
                ++n4;
            }
            n = 0;
            if (bl) break;
            ++n3;
        }
        return bl;
    }

    private void moveMouse(String string) {
        try {
            Robot robot = new Robot();
            Rectangle rectangle = this.table.getCellRect(this.getRow(), this.getColumn(), true);
            this.tf.write("moveMouse()", 19, "Rect:" + rectangle);
            int n = new Double(rectangle.getX()).intValue();
            int n2 = new Double(rectangle.getY()).intValue();
            Point point = new Point(new Double(rectangle.getX()).intValue(), new Double(rectangle.getX()).intValue());
            int n3 = ((Component)this.table).getFontMetrics(this.table.getFont()).stringWidth(string);
            int n4 = ((Component)this.table).getFontMetrics(this.table.getFont()).getHeight() / 2;
            Rectangle rectangle2 = this.table.getVisibleRect();
            if (!rectangle2.contains(rectangle)) {
                this.tf.write("moveMouse()", 19, "visibleRect:" + rectangle2);
                int n5 = new Double(rectangle2.getHeight()).intValue() * 2 / 3;
                this.tf.write("moveMouse()", 19, "approxHeight:" + n5);
                this.tf.write("moveMouse()", 19, "b4 rect:" + rectangle);
                rectangle.setRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight() + (double)n5);
                this.tf.write("moveMouse()", 19, "after rect:" + rectangle);
            }
            this.table.scrollRectToVisible(rectangle);
            Point point2 = this.table.getLocationOnScreen();
            robot.mouseMove(point2.x + n + n3, point2.y + n2 + n4);
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }
}

