/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;

class AFtpLogonParameters {
    private String host;
    private String port;
    private String userid;
    private String password;
    private String proxyServer;
    private String proxyPort;
    private Vector logonCommands;
    private int connectionType;
    private int hostType;
    private ARepository aRepository;
    private boolean changed = false;

    public AFtpLogonParameters(ARepository aRepository) {
        this.setRepository(aRepository);
        this.setHost(aRepository.ftpHost());
        this.setPort(aRepository.ftpPort());
        this.setUserid(aRepository.ftpUserid());
        this.setPassword(aRepository.ftpPassword());
        this.setLogonCommands(aRepository.commonFtpSiteCommandsAsVector());
        this.setHostType(aRepository.hostType());
        this.setConnectionType(1);
        this.setChanged(false);
    }

    public AFtpLogonParameters(String string, String string2, String string3, String string4, Vector vector, int n) {
        this.setRepository(null);
        this.setHost(string);
        this.setPort(string2);
        this.setUserid(string3);
        this.setPassword(string4);
        this.setLogonCommands(vector);
        this.setHostType(n);
        this.setConnectionType(1);
        this.setChanged(false);
    }

    public String toString() {
        String string = "Host    : " + this.getHost();
        String string2 = "Port    : " + this.getPort();
        String string3 = "Userid  : " + this.getUserid();
        String string4 = "Password: " + this.getPassword();
        String string5 = "HostType: " + String.valueOf(this.getHostType());
        String string6 = "Commands: ";
        if (this.logonCommands.size() == 0) {
            string6 = string6 + "<none>";
        } else {
            Enumeration enumeration = this.logonCommands.elements();
            while (enumeration.hasMoreElements()) {
                string6 = string6 + (String)enumeration.nextElement() + AUtilities.LINE_SEPARATOR + "          ";
            }
        }
        return string + AUtilities.LINE_SEPARATOR + string2 + AUtilities.LINE_SEPARATOR + string3 + AUtilities.LINE_SEPARATOR + string4 + AUtilities.LINE_SEPARATOR + string5 + AUtilities.LINE_SEPARATOR + string6;
    }

    public ARepository getRepository() {
        return this.aRepository;
    }

    private void setRepository(ARepository aRepository) {
        this.aRepository = aRepository;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string == null ? "" : string.trim();
        this.setChanged(true);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string == null || string == "" ? "21" : string.trim();
        this.setChanged(true);
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String string) {
        this.userid = string == null ? "" : string.trim();
        this.setChanged(true);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string == null ? "" : string.trim();
        this.setChanged(true);
    }

    public Vector getLogonCommands() {
        return this.logonCommands;
    }

    public void setLogonCommands(Vector vector) {
        this.logonCommands = vector;
        this.setChanged(true);
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public int getHostType() {
        return this.hostType;
    }

    public void setHostType(int n) {
        this.hostType = n;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String string) {
        this.proxyServer = string;
        this.setChanged(true);
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String string) {
        this.proxyPort = string;
        this.setChanged(true);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }
}

