/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ARepositoryWindow
extends ABaseInternalFrame
implements ActionListener {
    private JPopupMenu popup;
    private JMenuBar menuBar1;
    JMenu fileMenu;
    JMenu editMenu;
    JMenu optionsMenu;
    JMenu helpMenu;
    private JMenu subMenu;
    private JMenu synchronizeSubMenu;
    private JMenu sendToSubMenu;
    private JMenu updateBookShelfSubMenu;
    private JMenu pUpdateBookShelfSubMenu;
    private JMenuItem itemDetails;
    private JMenuItem itemSelectAll;
    private JMenuItem itemDeselectAll;
    private JMenuItem itemSortByMissingShelves;
    private JMenuItem itemRepository;
    private JMenuItem itemDelete;
    private JMenuItem itemEditTitle;
    private JMenuItem itemExclude;
    private JMenuItem itemViewContents;
    private JMenuItem itemClone;
    private JMenuItem itemCreateCatalog;
    private JMenuItem itemEraseCache;
    private JMenuItem itemPrint;
    private JMenuItem itemSaveAs;
    private JMenuItem itemClose;
    private JMenuItem itemUpdateSelected;
    private JMenuItem itemUpdateAll;
    private JMenuItem itemCut;
    private JMenuItem itemPaste;
    private JMenuItem itemCopy;
    private JMenuItem itemFind;
    private JMenuItem itemFindNext;
    private JMenuItem itemUserGuide;
    private JMenuItem pItemEditTitle;
    private JMenuItem pItemDelete;
    private JMenuItem pItemExclude;
    private JMenuItem pItemViewContents;
    private JMenuItem pItemDetails;
    private JMenuItem pItemUpdateSelected;
    private JMenuItem pItemUpdateAll;
    private JMenuItem itemDownloadFromInternet;
    private JMenuItem pItemDownloadFromInternet;
    private JTabbedPane tabbedPane;
    public ADNDTableTarget groupViewTable;
    public ADNDTableTarget fileViewTable;
    private JScrollPane groupViewScrollPane;
    private JScrollPane fileViewScrollPane;
    private AGroupViewTargetModel groupViewDataModel;
    private AFileViewTargetModel fileViewDataModel;
    private JLabel infoLabel;
    public AMainWindow mainWindow;
    private PopupListener popupListener;
    public MyChangeListener aMyChangeListener;
    private ABaseSet sentObjects;
    public ARepository aRepositoryObject;
    private ARepository srcRepository = null;
    private AFindWindow findWindow;
    private String searchString = "";
    protected Vector viewContentsVector = new Vector();
    private ATraceFile tf;
    private boolean catalogRead = false;
    private ASwingWorker addItemsWorker = null;
    private APropertyObject aPropObject = null;
    private int[] groupColumnOrder = new int[3];
    private int[] fileColumnOrder = new int[5];
    private String groupColumnSort = null;
    private String fileColumnSort = null;

    public ARepositoryWindow(AMainWindow aMainWindow, ARepository aRepository, ARepository aRepository2, ABaseSet aBaseSet) {
        super("", true, true, true, true);
        this.mainWindow = aMainWindow;
        this.aRepositoryObject = aRepository;
        this.sentObjects = aBaseSet;
        this.srcRepository = aRepository2;
        this.processMain();
    }

    public ARepositoryWindow(AMainWindow aMainWindow, ARepository aRepository, ABaseSet aBaseSet) {
        super("", true, true, true, true);
        this.mainWindow = aMainWindow;
        this.aRepositoryObject = aRepository;
        this.sentObjects = aBaseSet;
        this.processMain();
    }

    public void processMain() {
        this.tf = new ATraceFile(this);
        if (AMainWindow.userIniFlag) {
            String string = "Repository" + new Integer(this.aRepositoryObject.index()).toString();
            this.aPropObject = AMainWindow.userProperties.getObject(string);
            if (this.aPropObject == null) {
                this.aPropObject = new APropertyObject();
                this.aPropObject.setTitle("Repository - " + this.aRepositoryObject.repositoryTitle());
                this.aPropObject.setSize(new Dimension(600, 350));
                this.aPropObject.setLocation(new Point(40, 40));
                this.aPropObject.setColumnSequence("0,1,2,111,0,1,2,3,4", 9);
                this.aPropObject.setColumnSort("0 true 0 true 0 true");
            }
        } else {
            this.aPropObject = new APropertyObject();
            this.aPropObject.setTitle("Repository - " + this.aRepositoryObject.repositoryTitle());
            this.aPropObject.setSize(new Dimension(600, 350));
            this.aPropObject.setLocation(new Point(40, 40));
            this.aPropObject.setColumnSequence("0,1,2,111,0,1,2,3,4", 9);
            this.aPropObject.setColumnSort("0 true 0 true 0 true");
        }
        this.setTitle(this.aPropObject.title());
        this.setSize(this.aPropObject.size());
        this.setLocation(this.aPropObject.location());
        this.itemRepository = this.mainWindow.getWindowMenu().add(new JMenuItem(this.getTitle()));
        this.itemRepository.addActionListener(this.mainWindow);
        this.aRepositoryObject.setRepositoryWindow(this);
        if (!this.constructRest()) {
            this.dispose();
            this.aRepositoryObject.setRepositoryWindow(null);
            return;
        }
        try {
            this.mainWindow.getDeskTopPane().add(this);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.show();
        }
        catch (Exception exception) {
            this.tf.write("", 0, this.aRepositoryObject.repositoryTitle() + ", Exception:" + exception.toString());
        }
        this.groupViewTable.requestFocus();
        AStatusWindow.write(this.aRepositoryObject.repositoryTitle() + " Window added");
        this.tf.write("processMain()", 18, "Exit");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("actionPerformed() : ", 19, actionEvent.paramString());
        if (actionEvent.getActionCommand().equals("Create Catalog")) {
            ASwingWorker aSwingWorker = new ASwingWorker("CreateCatalog"){

                public Object construct() {
                    ARepositoryWindow.this.mainWindow.listWindow.CreateCatalog(ARepositoryWindow.this.aRepositoryObject);
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Erase Cache")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Erase cache"){

                public Object construct() {
                    ARepositoryWindow.this.mainWindow.listWindow.EraseCache(ARepositoryWindow.this.aRepositoryObject);
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Print")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Printing"){

                public Object construct() {
                    ARepositoryWindow.this.print();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Save As")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Save As"){

                public Object construct() {
                    ARepositoryWindow.this.saveAs();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Clone ...")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Clone"){

                public Object construct() {
                    ARepositoryWindow.this.mainWindow.listWindow.Clone(ARepositoryWindow.this.aRepositoryObject);
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Selected ...")) {
            this.UpdateBookShelves(false);
        } else if (actionEvent.getActionCommand().equals("All ...")) {
            this.UpdateBookShelves(true);
        } else if (actionEvent.getActionCommand().equals("Open")) {
            this.viewContents();
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Delete"){

                public Object construct() {
                    ARepositoryWindow.this.delete();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Details")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Details"){

                public Object construct() {
                    ARepositoryWindow.this.Details();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Edit Title")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Edit Title"){

                public Object construct() {
                    ARepositoryWindow.this.editTitle();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Exclude from shelf")) {
            ASwingWorker aSwingWorker = new ASwingWorker("Exclude from shelf"){

                public Object construct() {
                    ARepositoryWindow.this.excludeFromShelf();
                    return null;
                }
            };
        } else if (actionEvent.getActionCommand().equals("Download from Internet")) {
            this.downloadFromInternet();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.dispose();
        } else if (!(actionEvent.getActionCommand().equals("Cut") || actionEvent.getActionCommand().equals("Paste") || actionEvent.getActionCommand().equals("Copy"))) {
            if (actionEvent.getActionCommand().equals("Find First")) {
                ASwingWorker aSwingWorker = new ASwingWorker("FindFirst"){

                    public Object construct() {
                        ARepositoryWindow.this.FindFirst();
                        return null;
                    }
                };
            } else if (actionEvent.getActionCommand().equals("Find Next  F3")) {
                this.FindNext();
            } else if (actionEvent.getActionCommand().equals(AMainWindow.messages.getString("SelectAll"))) {
                this.SelectAll();
            } else if (actionEvent.getActionCommand().equals(AMainWindow.messages.getString("DeselectAll"))) {
                this.DeselectAll();
            } else if (actionEvent.getActionCommand().equals("Sort by Shelves with missing books")) {
                this.sortByMissingShelves();
            } else if (actionEvent.getActionCommand().equals("User's Guide")) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec("start ebrscl10.boo -t \"14.0\" -s3");
                }
                catch (Exception exception) {
                    this.tf.write("User's Guide", 0, "IOException:" + exception.toString());
                }
            } else {
                final String string = actionEvent.getActionCommand();
                ASwingWorker aSwingWorker = new ASwingWorker("SendTo"){

                    public Object construct() {
                        ARepositoryWindow.this.sendTo(string);
                        return null;
                    }
                };
            }
        }
    }

    public boolean constructRest() {
        Object object;
        Object object2;
        boolean bl = true;
        this.menuBar1 = new JMenuBar();
        this.menuBar1.getAccessibleContext().setAccessibleName("Menu Bar 1");
        MyInternalFrameListener myInternalFrameListener = new MyInternalFrameListener();
        this.addInternalFrameListener(myInternalFrameListener);
        this.fileMenu = this.menuBar1.add(new JMenu("File"));
        this.fileMenu.setMnemonic('F');
        this.itemCreateCatalog = this.fileMenu.add(new JMenuItem("Create Catalog"));
        this.itemCreateCatalog.setMnemonic('C');
        this.itemCreateCatalog.addActionListener(this);
        this.itemEraseCache = this.fileMenu.add(new JMenuItem("Erase Cache"));
        this.itemEraseCache.setMnemonic('R');
        this.itemEraseCache.addActionListener(this);
        this.itemPrint = this.fileMenu.add(new JMenuItem("Print"));
        this.itemPrint.setMnemonic('P');
        this.itemPrint.addActionListener(this);
        this.itemSaveAs = this.fileMenu.add(new JMenuItem("Save As"));
        this.itemSaveAs.setMnemonic('A');
        this.itemSaveAs.addActionListener(this);
        this.itemClone = this.fileMenu.add(new JMenuItem("Clone ..."));
        this.itemClone.setMnemonic('L');
        this.itemClone.addActionListener(this);
        this.updateBookShelfSubMenu = new JMenu("Update bookshelves");
        this.updateBookShelfSubMenu.setMnemonic('U');
        this.fileMenu.add(this.updateBookShelfSubMenu);
        this.itemUpdateAll = this.updateBookShelfSubMenu.add(new JMenuItem("All ..."));
        this.itemUpdateAll.setMnemonic('A');
        this.itemUpdateAll.addActionListener(this);
        this.itemUpdateSelected = this.updateBookShelfSubMenu.add(new JMenuItem("Selected ..."));
        this.itemUpdateSelected.setMnemonic('S');
        this.itemUpdateSelected.addActionListener(this);
        if (this.aRepositoryObject.hostType() != 1 && this.aRepositoryObject.hostType() != 3) {
            this.updateBookShelfSubMenu.setEnabled(false);
        }
        this.pItemUpdateSelected = new JMenuItem("Selected ...");
        this.pItemUpdateSelected.addActionListener(this);
        this.pItemUpdateAll = new JMenuItem("All ...");
        this.pItemUpdateAll.addActionListener(this);
        this.fileMenu.addSeparator();
        this.itemExclude = this.fileMenu.add(new JMenuItem("Exclude from shelf"));
        this.itemExclude.setMnemonic('X');
        this.itemExclude.addActionListener(this);
        this.itemExclude.setEnabled(false);
        this.itemDownloadFromInternet = this.fileMenu.add(new JMenuItem("Download from Internet"));
        this.itemDownloadFromInternet.setMnemonic('I');
        this.itemDownloadFromInternet.addActionListener(this);
        this.itemDownloadFromInternet.setEnabled(false);
        this.itemDelete = this.fileMenu.add(new JMenuItem("Delete"));
        this.itemDelete.setMnemonic('D');
        this.itemDelete.addActionListener(this);
        this.itemDetails = this.fileMenu.add(new JMenuItem("Details"));
        this.itemDetails.setMnemonic('E');
        this.itemDetails.addActionListener(this);
        this.itemEditTitle = this.fileMenu.add(new JMenuItem("Edit Title"));
        this.itemEditTitle.setMnemonic('T');
        this.itemEditTitle.addActionListener(this);
        this.itemViewContents = this.fileMenu.add(new JMenuItem("Open"));
        this.itemViewContents.setMnemonic('O');
        this.itemViewContents.addActionListener(this);
        this.sendToSubMenu = new JMenu("Send To");
        this.fileMenu.add(this.sendToSubMenu);
        NewMenuListener newMenuListener = new NewMenuListener();
        this.sendToSubMenu.addMenuListener(newMenuListener);
        this.fileMenu.addSeparator();
        this.itemClose = this.fileMenu.add(new JMenuItem("Close"));
        this.itemClose.setMnemonic('C');
        this.itemClose.addActionListener(this);
        this.pItemEditTitle = new JMenuItem("Edit Title");
        this.pItemEditTitle.addActionListener(this);
        this.pItemViewContents = new JMenuItem("Open");
        this.pItemViewContents.addActionListener(this);
        this.pItemDelete = new JMenuItem("Delete");
        this.pItemDelete.addActionListener(this);
        this.pItemDetails = new JMenuItem("Details");
        this.pItemDetails.addActionListener(this);
        this.pItemExclude = new JMenuItem("Exclude from shelf");
        this.pItemExclude.addActionListener(this);
        this.pItemDownloadFromInternet = new JMenuItem("Download from Internet");
        this.pItemDownloadFromInternet.addActionListener(this);
        this.editMenu = this.menuBar1.add(new JMenu("Edit"));
        this.editMenu.setMnemonic('E');
        this.itemFind = this.editMenu.add(new JMenuItem("Find First"));
        this.itemFind.setMnemonic('F');
        this.itemFind.addActionListener(this);
        this.itemFindNext = this.editMenu.add(new JMenuItem("Find Next  F3"));
        this.itemFindNext.setMnemonic('N');
        this.itemFindNext.addActionListener(this);
        this.itemFindNext.setEnabled(false);
        this.optionsMenu = this.menuBar1.add(new JMenu(AMainWindow.messages.getString("Options")));
        this.optionsMenu.setMnemonic('P');
        this.itemSelectAll = this.optionsMenu.add(new JMenuItem(AMainWindow.messages.getString("SelectAll")));
        this.itemSelectAll.setMnemonic('E');
        this.itemSelectAll.addActionListener(this);
        this.itemDeselectAll = this.optionsMenu.add(new JMenuItem(AMainWindow.messages.getString("DeselectAll")));
        this.itemDeselectAll.setMnemonic('D');
        this.itemDeselectAll.addActionListener(this);
        this.optionsMenu.addSeparator();
        this.itemSortByMissingShelves = this.optionsMenu.add(new JMenuItem("Sort by Shelves with missing books"));
        this.itemSortByMissingShelves.setMnemonic('S');
        this.itemSortByMissingShelves.addActionListener(this);
        this.helpMenu = this.menuBar1.add(new JMenu("Help"));
        this.helpMenu.setMnemonic('H');
        this.itemUserGuide = this.helpMenu.add(new JMenuItem("User's Guide"));
        this.itemUserGuide.setMnemonic('U');
        this.itemUserGuide.addActionListener(this);
        this.getContentPane().add((Component)this.menuBar1, "North");
        this.tabbedPane = new JTabbedPane();
        this.aMyChangeListener = new MyChangeListener();
        this.tabbedPane.addChangeListener(this.aMyChangeListener);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.infoLabel = new JLabel("Total no. of objects : ");
        this.infoLabel.setHorizontalAlignment(2);
        jPanel.add(this.infoLabel);
        this.getContentPane().add((Component)jPanel, "South");
        String[] stringArray = new String[]{"Title", "Filename", "Replaced By"};
        this.groupViewDataModel = new AGroupViewTargetModel(this, stringArray);
        this.groupViewTable = new ADNDTableTarget(this, this.groupViewDataModel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.groupViewScrollPane = new JScrollPane();
        this.groupViewScrollPane.getViewport().add(this.groupViewTable);
        this.groupViewTable.setAutoResizeMode(0);
        this.tabbedPane.addTab("Shelves", this.groupViewScrollPane);
        ListSelectionModel listSelectionModel = this.groupViewTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ASharedListSelectionHandler(this.groupViewTable, this.groupViewDataModel, this.infoLabel));
        RepositoryKeyListener repositoryKeyListener = new RepositoryKeyListener();
        this.groupViewTable.addKeyListener(repositoryKeyListener);
        JTableHeader jTableHeader = this.groupViewTable.getTableHeader();
        jTableHeader.addMouseListener(new ATargetWindowModel.ColumnListener(this.groupViewDataModel, this.groupViewTable));
        this.groupViewTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && ARepositoryWindow.this.groupViewTable.rowAtPoint(mouseEvent.getPoint()) != -1) {
                    ASwingWorker aSwingWorker = new ASwingWorker(this, "View contents"){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object construct() {
                            ARepositoryWindow.access$800(12.access$700(this.this$1));
                            return null;
                        }
                    };
                }
            }

            static /* synthetic */ ARepositoryWindow access$700(12 var0) {
                return var0.ARepositoryWindow.this;
            }
        });
        String[] stringArray2 = new String[]{"Title", "Filename", "Replaced By", "Filetype", "Count"};
        this.fileViewDataModel = new AFileViewTargetModel(this, stringArray2);
        this.fileViewTable = new ADNDTableTarget(this, this.fileViewDataModel);
        this.fileViewScrollPane = new JScrollPane();
        this.fileViewScrollPane.getViewport().add(this.fileViewTable);
        this.fileViewTable.setAutoResizeMode(0);
        this.tabbedPane.addTab("Files", this.fileViewScrollPane);
        ListSelectionModel listSelectionModel2 = this.fileViewTable.getSelectionModel();
        listSelectionModel2.addListSelectionListener(new CustomSharedListSelectionHandler(this.fileViewTable, this.fileViewDataModel, this.infoLabel));
        this.fileViewTable.addKeyListener(repositoryKeyListener);
        JTableHeader jTableHeader2 = this.fileViewTable.getTableHeader();
        jTableHeader2.addMouseListener(new ATargetWindowModel.ColumnListener(this.fileViewDataModel, this.fileViewTable));
        ASwingWorker aSwingWorker = null;
        if (!this.catalogRead) {
            aSwingWorker = new ASwingWorker("Read/Create Catalog"){

                public Object construct() {
                    int n = ARepositoryWindow.this.mainWindow.listWindow.ValidateCatalog(ARepositoryWindow.this.aRepositoryObject);
                    if (n == 1) {
                        return new Integer(n);
                    }
                    if (n == 0) {
                        n = ARepositoryWindow.this.mainWindow.listWindow.CreateCatalog(ARepositoryWindow.this.aRepositoryObject);
                        ARepositoryWindow.this.aRepositoryObject.catalog().clearCatalog();
                        ARepositoryWindow.this.aRepositoryObject.catalog().setCatalogValid(false);
                    }
                    n = ARepositoryWindow.this.mainWindow.listWindow.ReadCatalog(ARepositoryWindow.this.aRepositoryObject);
                    return new Integer(n);
                }
            };
            if (aSwingWorker != null) {
                if (aSwingWorker.getThread().isAlive()) {
                    try {
                        aSwingWorker.getThread().join();
                    }
                    catch (InterruptedException interruptedException) {
                        this.tf.write("constructRest()", 0, "join() interrrupted exception:" + interruptedException.toString());
                    }
                }
                if ((Integer)(object2 = (Integer)aSwingWorker.get()) > 0) {
                    this.tf.write("construct()", 18, "1. User cancelled:" + (Integer)object2);
                    bl = false;
                    return bl;
                }
            }
            this.tf.write("construct()", 18, "2. User not cancelled");
            if (!this.addItemsToRepositoryWindow()) {
                bl = false;
                return bl;
            }
            if (this.sentObjects != null) {
                object2 = ACatalog.getUniqueObjects(this.sentObjects, this.aRepositoryObject);
                this.tf.write("constructRest()", 18, "Send no. of files:" + ((ABaseSet)object2).size());
                if (((ABaseSet)object2).size() == 0) {
                    AUtilities.showInfoMessage("No files to transfer to " + this.aRepositoryObject.repositoryTitle());
                } else {
                    object = null;
                    object = this.srcRepository == null ? new ATransferProcess((JFrame)this.mainWindow, (Object)((ABaseSet)object2).asVector(), (ASource)AMainWindow.sourceObject(), this.aRepositoryObject) : new ATransferProcess((JFrame)this.mainWindow, (Object)((ABaseSet)object2).asVector(), this.srcRepository, this.aRepositoryObject);
                    if (((ATransferProcess)object).filesTransferred.size() > 0) {
                        this.addRows(((ATransferProcess)object).filesTransferred);
                        this.tf.write("constructRest()", 18, "Catalog hasChanged():" + this.aRepositoryObject.catalog().hasChanged());
                        if (this.srcRepository == null) {
                            ((ASource)AMainWindow.sourceObject()).sourceWindow().UpdateStatus(this.aRepositoryObject);
                        }
                    }
                }
            }
        }
        this.catalogRead = true;
        object2 = new OurComponentListener(this.groupViewTable, this.groupViewScrollPane);
        this.addComponentListener((ComponentListener)object2);
        ((OurComponentListener)object2).resizeTableColumns(this.getSize().getWidth());
        object = new OurComponentListener(this.fileViewTable, this.fileViewScrollPane);
        this.addComponentListener((ComponentListener)object);
        ((OurComponentListener)object).resizeTableColumns(this.getSize().getWidth());
        this.popup = new JPopupMenu();
        this.subMenu = new JMenu("Send To");
        this.pUpdateBookShelfSubMenu = new JMenu("Update bookshelf");
        this.pUpdateBookShelfSubMenu.add(this.pItemUpdateAll);
        this.pUpdateBookShelfSubMenu.add(this.pItemUpdateSelected);
        if (this.aRepositoryObject.hostType() != 1 && this.aRepositoryObject.hostType() != 3) {
            this.pUpdateBookShelfSubMenu.setEnabled(false);
        }
        this.popupListener = new PopupListener(this);
        this.groupViewTable.addMouseListener(this.popupListener);
        this.fileViewTable.addMouseListener(this.popupListener);
        this.tf.write("constructRest()", 18, "Exit");
        return bl;
    }

    private void readColumnSettings() {
        int n;
        int n2;
        int n3;
        String string;
        TableColumnModel tableColumnModel;
        int n4 = 0;
        int n5 = 0;
        this.tf.write("readColumnsettings()", 19, "columnSequence:" + this.aPropObject.columnSequence().length);
        n4 = 0;
        while (n4 < this.aPropObject.columnSequence().length) {
            if (this.aPropObject.columnSequence()[n4] == 111) {
                ++n4;
                break;
            }
            this.groupColumnOrder[n5] = this.aPropObject.columnSequence()[n4];
            ++n5;
            ++n4;
        }
        n5 = 0;
        while (n4 < this.aPropObject.columnSequence().length) {
            if (this.aPropObject.columnSequence()[n4] == 111) {
                ++n4;
                break;
            }
            this.fileColumnOrder[n5] = this.aPropObject.columnSequence()[n4];
            ++n5;
            ++n4;
        }
        int n6 = 0;
        String string2 = "";
        if (this.groupColumnSort == null) {
            tableColumnModel = this.groupViewTable.getColumnModel();
            string = "";
            n3 = 0;
            while (n3 < tableColumnModel.getColumnCount()) {
                n2 = this.groupColumnOrder[n3];
                n = tableColumnModel.getColumn(n2).getModelIndex();
                if (string.indexOf(new Integer(n).toString()) == -1 && n == n2) {
                    this.groupViewTable.moveColumn(n2, n3);
                }
                string = string + n2;
                ++n3;
            }
            string2 = this.aPropObject.columnSort();
            this.tf.write("readColumnsettings()", 19, "ColumnSort:" + string2);
            n6 = string2.indexOf(44);
            if (n6 != -1) {
                n2 = new Integer(string2.substring(0, n6));
                string2 = string2.substring(n6 + 1);
                n6 = string2.indexOf(44);
                n = new Boolean(string2.substring(0, n6)).booleanValue() ? 1 : 0;
                this.groupViewDataModel.sort(this.groupViewTable, n2, n != 0);
                string2 = string2.substring(n6 + 1);
            }
        }
        if (this.fileColumnSort == null) {
            tableColumnModel = this.fileViewTable.getColumnModel();
            string = "";
            n3 = 0;
            while (n3 < tableColumnModel.getColumnCount()) {
                n2 = this.fileColumnOrder[n3];
                n = tableColumnModel.getColumn(n2).getModelIndex();
                if (string.indexOf(new Integer(n).toString()) == -1 && n == n2) {
                    this.fileViewTable.moveColumn(n2, n3);
                }
                string = string + n2;
                ++n3;
            }
            n6 = string2.indexOf(44);
            if (n6 != -1 && (n6 = string2.indexOf(44)) != -1) {
                this.fileViewDataModel.sort(this.fileViewTable, new Integer(string2.substring(0, n6)), new Boolean(string2.substring(n6 + 1)));
            }
        }
    }

    public void addRows(Vector vector) {
        Serializable serializable;
        Object object;
        Object object2;
        ABaseObject aBaseObject;
        Object object3;
        if (vector == null || vector.size() == 0) {
            return;
        }
        AGroupObjectsSet aGroupObjectsSet = new AGroupObjectsSet();
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        this.tf.write("addRows()", 18, "Entry:" + this.aRepositoryObject.catalog().isCatalogValid());
        this.tf.write("addRows()", 18, "Master group size:" + this.aRepositoryObject.catalog().groupObjectsSet().size() + ", Master file size:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
        this.tf.write("addRows()", 18, "Transferred objects vector size:" + vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (AFileObject)enumeration.nextElement();
            this.tf.write("addRows()", 19, "Reference count:" + ((AFileObject)object3).referenceCount());
            this.tf.write("addRows()", 19, "Clone:" + object3);
            aFileObjectsSet.add(((ABaseObject)object3).keyField(), object3);
            if (!((ABaseObject)object3).pcFileType().toUpperCase().equals("BKS")) continue;
            try {
                aBaseObject = (AGroupObject)((AFileObject)object3).groupObjectPtr().clone();
                this.tf.write("addRows()", 19, "Clone check1:" + ((AFileObject)object3).groupObjectPtr() + ", " + aBaseObject);
                this.tf.write("addRows()", 19, "Clone check2:" + ((AFileObject)object3).groupObjectPtr().missingFileObjectsSet().size() + ", " + ((AGroupObject)aBaseObject).missingFileObjectsSet().size());
                aBaseObject.setNameInRepository(((ABaseObject)object3).nameInRepository());
                aGroupObjectsSet.add(aBaseObject.keyField(), aBaseObject);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this.tf.write("addRows()", 18, "Check1:" + this.aRepositoryObject.catalog().isCatalogValid());
        this.aRepositoryObject.catalog().changeKey(3);
        this.tf.write("addRows()", 18, "Check2:" + this.aRepositoryObject.catalog().isCatalogValid());
        this.tf.write("addRows()", 18, "B4 Group set size:" + aGroupObjectsSet.size() + ", File set size:" + aFileObjectsSet.size());
        if (!this.aRepositoryObject.catalog().addObjects(aGroupObjectsSet, aFileObjectsSet)) {
            AUtilities.showInfoMessage("Error occurred during adding objects");
            return;
        }
        this.tf.write("addRows()", 18, "After Group set size:" + aGroupObjectsSet.size() + ", File set size:" + aFileObjectsSet.size());
        this.tf.write("addRows()", 18, "Check3:" + this.aRepositoryObject.catalog().isCatalogValid());
        object3 = aFileObjectsSet.elements();
        while (object3.hasMoreElements()) {
            aBaseObject = (AFileObject)object3.nextElement();
            this.fileViewDataModel.addRow(aBaseObject, this.fileViewTable);
            object2 = this.viewContentsVector.elements();
            while (object2.hasMoreElements()) {
                object = (ATargetViewContentsWindow)object2.nextElement();
                serializable = (AFileViewTargetModel)((ATargetViewContentsWindow)object).table.getModel();
                ((ATargetWindowModel)serializable).addRow(aBaseObject, ((ATargetViewContentsWindow)object).table);
                ((ABaseTableModel)serializable).tableRefresh(((ATargetViewContentsWindow)object).table);
            }
            this.tf.write("addRows()", 19, "1. File added:" + aBaseObject.fileName() + " - " + aBaseObject.pcFileType());
        }
        object3 = aGroupObjectsSet.elements();
        while (object3.hasMoreElements()) {
            aBaseObject = (AGroupObject)object3.nextElement();
            if (this.aRepositoryObject.catalog().groupObjectsSet().containsKey(aBaseObject.keyField())) {
                object2 = (AGroupObject)this.aRepositoryObject.catalog().groupObjectsSet().getObjects(aBaseObject.keyField()).elementAt(0);
                this.groupViewDataModel.addRow(object2, this.groupViewTable);
                object = ((AGroupObject)object2).fileObjectsSet().elements();
                while (object.hasMoreElements()) {
                    serializable = (AFileObject)object.nextElement();
                    this.fileViewDataModel.addRow(serializable, this.fileViewTable);
                    this.tf.write("addRows()", 19, "2. File added:" + ((ABaseObject)serializable).fileName() + " - " + ((ABaseObject)serializable).pcFileType());
                    this.tf.write("addRows()", 19, "file index:" + ((ABaseObject)serializable).index());
                }
            }
            this.tf.write("addRows()", 19, "Is it same:" + aBaseObject);
            object2 = ((AGroupObject)aBaseObject).missingFileObjectsSet().elements();
            while (object2.hasMoreElements()) {
                object = (AFileObject)object2.nextElement();
                this.fileViewDataModel.addRow(object, this.fileViewTable);
                this.tf.write("addRows()", 19, "missing from group set size:" + ((AFileObject)object).missingFromGroupSet().size());
                this.tf.write("addRows()", 19, "missing index:" + ((ABaseObject)object).index());
            }
        }
        this.aMyChangeListener.stateChanged(new ChangeEvent(this));
        this.tf.write("addRows()", 18, "Check4:" + this.aRepositoryObject.catalog().isCatalogValid());
        if (this.aRepositoryObject.catalog().hasChanged()) {
            this.updateReplacedByFileName();
        }
        this.tf.write("addRows()", 18, "Catalog valid:" + this.aRepositoryObject.catalog().isCatalogValid());
        this.tf.write("addRows()", 18, "Exit");
    }

    public boolean addItemsToRepositoryWindow() {
        this.tf.write("addItemsToRepositoryWindow()", 18, "File set size:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
        this.tf.write("addItemsToRepositoryWindow()", 18, "Group set size:" + this.aRepositoryObject.catalog().groupObjectsSet().size());
        int n = 0;
        int n2 = 0;
        this.groupViewDataModel.clearTable(this.groupViewTable);
        this.fileViewDataModel.clearTable(this.fileViewTable);
        n = this.aRepositoryObject.catalog().fileObjectsSet().size() + this.aRepositoryObject.catalog().groupObjectsSet().size();
        this.tf.write("addItemsToRepositoryWindow()", 19, "Total count - " + n);
        boolean bl = false;
        AProgressObject aProgressObject = null;
        if (n > 50) {
            aProgressObject = new AProgressObject(this.mainWindow, n);
            aProgressObject.setText("Adding file objects..");
            bl = true;
        }
        this.tf.write("addItemsToRepositoryWindow()", 19, "Current Key:" + this.aRepositoryObject.catalog().currentKey());
        block0: while (n2 < n) {
            ABaseObject aBaseObject;
            Enumeration enumeration = this.aRepositoryObject.catalog().fileObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                if (bl && ++n2 % 50 == 0 && !aProgressObject.update(n2) || bl && aProgressObject.isProcessCanceled()) break;
                aBaseObject = (AFileObject)enumeration.nextElement();
                this.tf.write("addItemsToRepositoryWindow()", 19, "B4 File added:" + aBaseObject.keyField() + ", Type-" + aBaseObject.pcFileType());
                this.fileViewDataModel.addRow(aBaseObject, this.fileViewTable);
                this.tf.write("addItemsToRepositoryWindow()", 19, "File added:" + aBaseObject.keyField() + ", Type-" + aBaseObject.pcFileType());
            }
            if (bl && aProgressObject.isProcessCanceled()) {
                this.tf.write("addItemsToRepositoryWindow()", 19, "User canceled Adding objects to table process (File Objects)");
                break;
            }
            if (bl) {
                aProgressObject.setText("Adding group objects..");
            }
            enumeration = this.aRepositoryObject.catalog().groupObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                if (bl && ++n2 % 10 == 0 && !aProgressObject.update(n2)) continue block0;
                if (bl && aProgressObject.isProcessCanceled()) {
                    this.tf.write("addItemsToRepositoryWindow()", 19, "User canceled Adding objects to table process (Group Objects)");
                    continue block0;
                }
                aBaseObject = (AGroupObject)enumeration.nextElement();
                this.groupViewDataModel.addRow(aBaseObject, this.groupViewTable);
                this.tf.write("addItemsToRepositoryWindow()", 19, "group added:" + aBaseObject.fileName() + " - " + aBaseObject.pcFileType());
            }
        }
        if (bl) {
            aProgressObject.removeProgressObject();
            if (aProgressObject.isProcessCanceled()) {
                return false;
            }
        }
        this.updateReplacedByFileName();
        this.readColumnSettings();
        this.aMyChangeListener.stateChanged(new ChangeEvent(this));
        return true;
    }

    public void setInfoLabelText(String string) {
        this.infoLabel.setText(string);
    }

    public void updateReplacedByFileName() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.tf.write("upateReplacedByFileName()", 18, "Entry");
        this.tf.write("upateReplacedByFileName()", 19, "File count B4 changeKeyToComparisonName:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
        if (this.aRepositoryObject.catalog().currentKey() != 4) {
            AMainWindow.UpdateStatusInfo("Changing keys ...");
            this.aRepositoryObject.catalog().changeKey(4);
            AMainWindow.UpdateStatusInfo("");
        }
        this.tf.write("upateReplacedByFileName()", 19, "File count After changeKeyToComparisonName:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
        AFileObjectsSet aFileObjectsSet = this.aRepositoryObject.catalog().fileObjectsSet();
        AFileObjectsSet aFileObjectsSet2 = this.aRepositoryObject.catalog().fileObjectsSet();
        AGroupObjectsSet aGroupObjectsSet = this.aRepositoryObject.catalog().groupObjectsSet();
        AGroupObjectsSet aGroupObjectsSet2 = this.aRepositoryObject.catalog().groupObjectsSet();
        int n = 0;
        int n2 = 0;
        n = aFileObjectsSet.size() + aGroupObjectsSet.size();
        boolean bl = false;
        AProgressObject aProgressObject = null;
        if (n > 50) {
            aProgressObject = new AProgressObject(this.mainWindow, n);
            aProgressObject.setText("Updating replaced by column for file objects");
            bl = true;
        }
        Enumeration enumeration = aFileObjectsSet.elements();
        while (enumeration.hasMoreElements()) {
            object5 = (AFileObject)enumeration.nextElement();
            object4 = new AComparisonName(((ABaseObject)object5).fileName());
            this.tf.write("updateReplacedByColumn", 19, "file keyfield:" + ((ABaseObject)object5).fileNameType());
            if (bl && ++n2 % 50 == 0 && !aProgressObject.update(n2) || bl && aProgressObject.isProcessCanceled()) break;
            object3 = aFileObjectsSet2.getObjects(((ABaseObject)object5).keyField()).elements();
            while (object3.hasMoreElements()) {
                AComparisonName aComparisonName;
                int n3;
                object2 = (AFileObject)object3.nextElement();
                object = new AComparisonName(((ABaseObject)object2).fileName());
                this.tf.write("updateReplacedByColumn", 19, "check:" + ((AComparisonName)object).stub() + ", " + ((ABaseObject)object2).fileNameType());
                if (!((AComparisonName)object).stub().equals(((AComparisonName)object4).stub())) continue;
                this.tf.write("updateReplacedByColumn", 19, "fObject:" + ((ABaseObject)object2).fileNameType() + ", aFileObject:" + ((ABaseObject)object5).fileNameType());
                this.tf.write("updateReplacedByColumn", 19, "fObject:" + ((ABaseObject)object2).pcFileType() + ", aFileObject:" + ((ABaseObject)object5).pcFileType());
                this.tf.write("updateReplacedByColumn", 19, "fObject:" + ((AFileObject)object2).missingFromGroupSet().size() + ", aFileObject:" + ((AFileObject)object5).missingFromGroupSet().size());
                if (((AFileObject)object2).referenceCount() < 0 || !((ABaseObject)object2).pcFileType().equals(((ABaseObject)object5).pcFileType())) continue;
                if (((AComparisonName)object).text() == ((AComparisonName)object4).text()) {
                    this.tf.write("updateReplacedByColumn", 19, "1. same filename:" + ((AComparisonName)object).stub() + ", " + ((AComparisonName)object).suffix());
                    this.tf.write("updateReplacedByColumn", 19, "2. same filename:" + ((AComparisonName)object4).stub() + ", " + ((AComparisonName)object4).suffix());
                    continue;
                }
                this.tf.write("updateReplacedByColumn", 19, "Suffix check:" + ((AComparisonName)object4).suffix() + ", " + ((AComparisonName)object).suffix());
                int n4 = ((AComparisonName)object4).suffix().compareTo(((AComparisonName)object).suffix());
                this.tf.write("updateReplacedByColumn", 19, "checkSuffix :" + n4);
                if (n4 > 1) {
                    if (((ABaseObject)object2).replacedByFileName().equals("")) {
                        ((ABaseObject)object2).setReplacedByFileName(((ABaseObject)object5).fileName());
                        continue;
                    }
                    if (!((ABaseObject)object5).replacedByFileName().equals("") || (n3 = (aComparisonName = new AComparisonName(((ABaseObject)object2).replacedByFileName())).suffix().compareTo(((AComparisonName)object4).suffix())) <= 0) continue;
                    ((ABaseObject)object2).setReplacedByFileName(((ABaseObject)object5).fileName());
                    continue;
                }
                if (n4 >= 0) continue;
                if (((ABaseObject)object5).replacedByFileName().equals("")) {
                    ((ABaseObject)object5).setReplacedByFileName(((ABaseObject)object2).fileName());
                    continue;
                }
                aComparisonName = new AComparisonName(((ABaseObject)object5).replacedByFileName());
                n3 = aComparisonName.suffix().compareTo(((AComparisonName)object).suffix());
                if (n3 <= 0) continue;
                ((ABaseObject)object5).setReplacedByFileName(((ABaseObject)object2).fileName());
            }
        }
        if (bl && aProgressObject.isProcessCanceled()) {
            aProgressObject.removeProgressObject();
            return;
        }
        this.fileViewDataModel.tableRefresh(this.fileViewTable);
        if (bl) {
            aProgressObject.setText("Updating replaced by column for group objects");
        }
        object5 = aGroupObjectsSet.elements();
        while (object5.hasMoreElements()) {
            object4 = (AGroupObject)object5.nextElement();
            object3 = new AComparisonName(((ABaseObject)object4).fileName());
            this.tf.write("updateReplacedByColumn", 19, "group keyfield:" + ((ABaseObject)object4).fileNameType());
            if (bl && ++n2 % 50 == 0 && !aProgressObject.update(n2) || bl && aProgressObject.isProcessCanceled()) break;
            object2 = aGroupObjectsSet2.getObjects(((ABaseObject)object4).keyField()).elements();
            while (object2.hasMoreElements()) {
                int n5;
                AComparisonName aComparisonName;
                object = (AGroupObject)object2.nextElement();
                AComparisonName aComparisonName2 = new AComparisonName(((ABaseObject)object).fileName());
                this.tf.write("updateReplacedByColumn", 19, "check:" + aComparisonName2.stub() + ", " + ((ABaseObject)object).fileNameType());
                if (!aComparisonName2.stub().equals(((AComparisonName)object3).stub())) continue;
                this.tf.write("updateReplacedByColumn", 19, "gObject:" + ((ABaseObject)object).fileNameType() + ", aGroupObject:" + ((ABaseObject)object4).fileNameType());
                this.tf.write("updateReplacedByColumn", 19, "gObject:" + ((ABaseObject)object).pcFileType() + ", aGroupObject:" + ((ABaseObject)object4).pcFileType());
                if (!((ABaseObject)object).pcFileType().equals(((ABaseObject)object4).pcFileType())) continue;
                if (aComparisonName2.text() == ((AComparisonName)object3).text()) {
                    this.tf.write("updateReplacedByColumn", 19, "1. same groupname:" + aComparisonName2.stub() + ", " + aComparisonName2.suffix());
                    this.tf.write("updateReplacedByColumn", 19, "2. same groupname:" + ((AComparisonName)object3).stub() + ", " + ((AComparisonName)object3).suffix());
                    this.tf.write("updateReplacedByColumn", 19, "gObject Date:" + ((ABaseObject)object).date());
                    this.tf.write("updateReplacedByColumn", 19, "aGroupObject Date:" + ((ABaseObject)object4).date());
                    continue;
                }
                this.tf.write("updateReplacedByColumn", 19, "Suffix check:" + ((AComparisonName)object3).suffix() + ", " + aComparisonName2.suffix());
                int n6 = ((AComparisonName)object3).suffix().compareTo(aComparisonName2.suffix());
                if (n6 > 1) {
                    if (((ABaseObject)object).replacedByFileName().equals("")) {
                        ((ABaseObject)object).setReplacedByFileName(((ABaseObject)object4).fileName());
                        continue;
                    }
                    aComparisonName = new AComparisonName(((ABaseObject)object).replacedByFileName());
                    n5 = aComparisonName.suffix().compareTo(((AComparisonName)object3).suffix());
                    if (n5 <= 0) continue;
                    ((ABaseObject)object).setReplacedByFileName(((ABaseObject)object4).fileName());
                    continue;
                }
                if (n6 >= 0) continue;
                if (((ABaseObject)object4).replacedByFileName().equals("")) {
                    ((ABaseObject)object4).setReplacedByFileName(((ABaseObject)object).fileName());
                    continue;
                }
                aComparisonName = new AComparisonName(((ABaseObject)object4).replacedByFileName());
                n5 = aComparisonName.suffix().compareTo(aComparisonName2.suffix());
                if (n5 <= 0) continue;
                ((ABaseObject)object4).setReplacedByFileName(((ABaseObject)object).fileName());
            }
        }
        this.groupViewDataModel.tableRefresh(this.groupViewTable);
        if (bl) {
            aProgressObject.removeProgressObject();
        }
        AMainWindow.UpdateStatusInfo("Changing keys ...");
        if (this.aRepositoryObject.catalog().currentKey() != 3) {
            this.aRepositoryObject.catalog().changeKey(3);
            this.groupViewDataModel.changeKey(3);
            this.fileViewDataModel.changeKey(3);
        }
        AMainWindow.UpdateStatusInfo("");
        this.addItemsWorker = null;
        this.tf.write("updateReplacedByFileName()", 18, "Exit");
    }

    private void print() {
        ADNDTableTarget aDNDTableTarget = null;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.groupViewScrollPane) {
            aDNDTableTarget = this.groupViewTable;
        } else if (component == this.fileViewScrollPane) {
            aDNDTableTarget = this.fileViewTable;
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(new APrintClass(aDNDTableTarget));
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
                this.tf.write("print()", 18, "Printing user name:" + printerJob.getUserName());
                AStatusWindow.write("Printing job for user : " + printerJob.getUserName());
            }
            catch (Exception exception) {
                this.tf.write("print()", 0, "Printing Exception :" + exception.toString());
            }
        } else {
            this.tf.write("print()", 18, "Printing canceled");
            AStatusWindow.write("Printing canceled" + printerJob.getUserName());
        }
    }

    private void saveAs() {
        Component component = this.tabbedPane.getSelectedComponent();
        ADNDTableTarget aDNDTableTarget = null;
        if (component == this.groupViewScrollPane) {
            aDNDTableTarget = this.groupViewTable;
        } else if (component == this.fileViewScrollPane) {
            aDNDTableTarget = this.fileViewTable;
        }
        this.mainWindow.listWindow.saveAs(aDNDTableTarget);
    }

    private void viewContents() {
        if (this.groupViewTable.getSelectedRow() == -1 || this.groupViewTable.getRowCount() == 0) {
            AUtilities.showInfoMessage("Select at least one item for this operation");
            return;
        }
        this.mainWindow.waitMouseCursor(this, true);
        Vector vector = this.groupViewDataModel.getSelectedObjects(this.groupViewTable, this.groupViewTable.getSelectedRows());
        this.tf.write("viewContents()", 18, "No. of objects selected:" + vector.size());
        ATargetViewContentsWindow aTargetViewContentsWindow = new ATargetViewContentsWindow(this.mainWindow, vector, this.aRepositoryObject.catalog());
        try {
            this.mainWindow.getDeskTopPane().add(aTargetViewContentsWindow);
            AStatusWindow.write("View Contents Window added");
            aTargetViewContentsWindow.moveToFront();
            aTargetViewContentsWindow.setSelected(true);
        }
        catch (Exception exception) {
            this.tf.write("viewContents()", 0, "Caught IOException: " + exception.toString());
        }
        this.mainWindow.waitMouseCursor(this, false);
    }

    private void delete() {
        Enumeration enumeration;
        Cloneable cloneable;
        Enumeration enumeration2;
        int n;
        boolean bl = false;
        Component component = this.tabbedPane.getSelectedComponent();
        AGroupObjectsSet aGroupObjectsSet = new AGroupObjectsSet();
        AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        Vector vector = null;
        this.tf.write("delete()", 18, "Entry");
        if (component == this.groupViewScrollPane) {
            if (this.groupViewTable.getSelectedRow() != -1 && this.groupViewTable.getRowCount() > 0) {
                n = JOptionPane.showConfirmDialog(AUtilities.mainWindow, "<html>Do you want to delete the selected objects?</html>", "IBM - Softcopy Librarian", 0);
                if (n) {
                    return;
                }
                if (this.aRepositoryObject.hostType() == 1 && this.aRepositoryObject.catalog().currentKey() != 2) {
                    this.aRepositoryObject.catalog().changeKey(2);
                    this.groupViewDataModel.changeKey(2);
                    this.fileViewDataModel.changeKey(2);
                }
                vector = this.groupViewDataModel.getSelectedObjects(this.groupViewTable, this.groupViewTable.getSelectedRows());
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    cloneable = (AGroupObject)enumeration2.nextElement();
                    aGroupObjectsSet.add(((ABaseObject)((Object)cloneable)).keyField(), cloneable);
                }
            } else {
                bl = true;
            }
        } else if (component == this.fileViewScrollPane) {
            if (this.fileViewTable.getSelectedRow() != -1 && this.fileViewTable.getRowCount() > 0) {
                n = JOptionPane.showConfirmDialog(AUtilities.mainWindow, "<html>Do you want to delete the selected objects?<html>", "IBM - Softcopy Librarian", 0);
                if (n) {
                    return;
                }
                if (this.aRepositoryObject.hostType() == 1 && this.aRepositoryObject.catalog().currentKey() != 2) {
                    this.aRepositoryObject.catalog().changeKey(2);
                    this.groupViewDataModel.changeKey(2);
                    this.fileViewDataModel.changeKey(2);
                }
                vector = this.fileViewDataModel.getSelectedObjects(this.fileViewTable, this.fileViewTable.getSelectedRows());
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    cloneable = (AFileObject)enumeration2.nextElement();
                    aFileObjectsSet.add(((ABaseObject)((Object)cloneable)).keyField(), cloneable);
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            AUtilities.showInfoMessage("Select at least one item for this operation");
            return;
        }
        n = 0;
        cloneable = new AFileObjectsSet();
        AGroupObjectsSet aGroupObjectsSet2 = new AGroupObjectsSet();
        AFileObjectsSet aFileObjectsSet2 = new AFileObjectsSet();
        if (component == this.fileViewScrollPane) {
            Object object;
            enumeration = aFileObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                if (aFileObject.groupObjectPtr() == null) continue;
                aFileObjectsSet2.add(aFileObject.keyField(), aFileObject);
            }
            this.mainWindow.waitMouseCursor(true);
            this.tf.write("delete()", 18, "B4 call deleteObjects()");
            if (aFileObjectsSet2.size() > 0) {
                this.aRepositoryObject.catalog().deleteObjects(aFileObjectsSet2, aGroupObjectsSet, (AFileObjectsSet)cloneable, aGroupObjectsSet2, n != 0);
            }
            aFileObjectsSet2.clear();
            boolean bl2 = false;
            enumeration = aFileObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                if (aFileObject.canDelete()) continue;
                bl2 = true;
                break;
            }
            int n2 = 1;
            if (bl2) {
                object = new Object[]{"Yes", "No", "Cancel"};
                String string = "<html>You have selected to delete some books which are in use in shelves.<br>Do you still want to delete these books?</html>";
                n2 = JOptionPane.showOptionDialog(this, string, "Delete - Confirm Dialog", 1, 3, null, (Object[])object, object[2]);
            }
            this.tf.write("delete()", 18, "userOption:" + n2);
            if (n2 != 2) {
                enumeration = aFileObjectsSet.elements();
                while (enumeration.hasMoreElements()) {
                    object = (AFileObject)enumeration.nextElement();
                    if (((AFileObject)object).groupObjectPtr() != null) continue;
                    if (!((AFileObject)object).canDelete() && n2 == 0) {
                        aFileObjectsSet2.add(((ABaseObject)object).keyField(), object);
                        n = 1;
                        continue;
                    }
                    aFileObjectsSet2.add(((ABaseObject)object).keyField(), object);
                }
                if (aFileObjectsSet2.size() > 0) {
                    this.aRepositoryObject.catalog().deleteObjects(aFileObjectsSet2, aGroupObjectsSet, (AFileObjectsSet)cloneable, aGroupObjectsSet2, n != 0);
                }
                aFileObjectsSet2.clear();
            }
        } else if (aGroupObjectsSet.size() > 0) {
            this.aRepositoryObject.catalog().deleteObjects(aFileObjectsSet, aGroupObjectsSet, (AFileObjectsSet)cloneable, aGroupObjectsSet2, n != 0);
        }
        this.tf.write("delete()", 18, "After call deleteObjects()");
        this.tf.write("delete()", 18, "aRemoveFSet:" + ((ABaseSet)cloneable).size() + ", aRemoveGSet:" + aGroupObjectsSet2.size());
        if (((ABaseSet)cloneable).size() > 0) {
            enumeration = ((ABaseSet)cloneable).elements();
            while (enumeration.hasMoreElements()) {
                AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                if (this.fileViewDataModel.deleteObjects(aFileObject, this.fileViewTable)) continue;
                this.tf.write("delete()", 18, "Error removing file object from FileView Datamodel");
            }
        }
        if (aGroupObjectsSet2.size() > 0) {
            enumeration = aGroupObjectsSet2.elements();
            while (enumeration.hasMoreElements()) {
                AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
                this.groupViewDataModel.deleteObjects(aGroupObject, this.groupViewTable);
            }
        }
        this.updateReplacedByFileName();
        this.groupViewDataModel.tableRefresh(this.groupViewTable);
        this.fileViewDataModel.tableRefresh(this.fileViewTable);
        this.aMyChangeListener.stateChanged(new ChangeEvent(this));
        this.mainWindow.listWindow.UpdateSource(this.aRepositoryObject);
        this.mainWindow.waitMouseCursor(false);
        this.tf.write("delete()", 18, "Exit");
    }

    private void Details() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.groupViewScrollPane) {
            if (this.groupViewTable.getRowCount() > 0 && this.groupViewTable.getSelectedRow() != -1) {
                AGroupObject aGroupObject = (AGroupObject)this.groupViewDataModel.getSelectedObject(this.groupViewTable.getSelectedRow(), this.groupViewTable);
                AFileObject aFileObject = aGroupObject.fileObjectPtr();
                this.mainWindow.waitMouseCursor(this, true);
                ADetailsWindow aDetailsWindow = new ADetailsWindow(this.mainWindow, aFileObject, "Group", this.aRepositoryObject);
                this.mainWindow.waitMouseCursor(this, false);
            } else {
                AUtilities.showInfoMessage("Select at least one item for this operation");
            }
        } else if (component == this.fileViewScrollPane) {
            if (this.fileViewTable.getRowCount() > 0 && this.fileViewTable.getSelectedRow() != -1) {
                AFileObject aFileObject = (AFileObject)this.fileViewDataModel.getSelectedObject(this.fileViewTable.getSelectedRow(), this.fileViewTable);
                this.mainWindow.waitMouseCursor(this, true);
                ADetailsWindow aDetailsWindow = new ADetailsWindow(this.mainWindow, aFileObject, "File", this.aRepositoryObject);
                this.mainWindow.waitMouseCursor(this, false);
            } else {
                AUtilities.showInfoMessage("Select at least one item for this operation");
            }
        }
    }

    private void SelectAll() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.groupViewScrollPane && this.groupViewTable.getRowCount() > 0) {
            this.groupViewTable.selectAll();
        } else if (component == this.fileViewScrollPane && this.fileViewTable.getRowCount() > 0) {
            this.fileViewTable.selectAll();
        }
    }

    private void DeselectAll() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.groupViewScrollPane && this.groupViewTable.getRowCount() > 0) {
            this.groupViewTable.clearSelection();
        } else if (component == this.fileViewScrollPane && this.fileViewTable.getRowCount() > 0) {
            this.fileViewTable.clearSelection();
        }
    }

    private void editTitle() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.groupViewScrollPane) {
            if (this.groupViewTable.getSelectedRow() != -1 && this.groupViewTable.getRowCount() > 0) {
                AGroupObject aGroupObject = (AGroupObject)this.groupViewDataModel.getSelectedObject(this.groupViewTable.getSelectedRow(), this.groupViewTable);
                String string = aGroupObject.title();
                String string2 = "";
                AEditWindow aEditWindow = new AEditWindow(this.mainWindow, string);
                if (aEditWindow.retCode == 0) {
                    this.mainWindow.waitMouseCursor(true);
                    string2 = aEditWindow.updatedTitle();
                    if (!string2.equals(aGroupObject.title())) {
                        Object object;
                        aGroupObject.setTitle(string2);
                        aGroupObject.fileObjectPtr().setTitle(string2);
                        boolean bl = false;
                        Enumeration enumeration = aGroupObject.fileObjectsSet().elements();
                        while (enumeration.hasMoreElements()) {
                            object = (AFileObject)enumeration.nextElement();
                            if (!((ABaseObject)object).pcFileType().toUpperCase().equals("BKI")) continue;
                            ((ABaseObject)object).setTitle(string2);
                            bl = true;
                            break;
                        }
                        enumeration = aGroupObject.missingFileObjectsSet().elements();
                        while (enumeration.hasMoreElements()) {
                            object = (AFileObject)enumeration.nextElement();
                            if (!((ABaseObject)object).pcFileType().toUpperCase().equals("BKI")) continue;
                            ((ABaseObject)object).setTitle(string2);
                            break;
                        }
                        object = AUtilities.tempDirectory() + File.separator + aGroupObject.fileNameType();
                        String string3 = this.aRepositoryObject.cacheDirectory() + aGroupObject.fileNameType();
                        if (this.aRepositoryObject.hostType() == 1) {
                            string3 = this.aRepositoryObject.cacheDirectory() + AUtilities.strip(aGroupObject.nameInRepository(), '\'');
                            object = AUtilities.tempDirectory() + File.separator + AUtilities.strip(aGroupObject.nameInRepository(), '\'');
                        }
                        if (!AUtilities.CopyFile(string3, (String)object)) {
                            AUtilities.showInfoMessage("Error copying :" + string3 + " to " + (String)object);
                            this.mainWindow.waitMouseCursor(false);
                            return;
                        }
                        if (!aGroupObject.write((String)object)) {
                            AUtilities.showInfoMessage("Error updating shelf:" + (String)object);
                            this.mainWindow.waitMouseCursor(false);
                            return;
                        }
                        AFtpReturnCode aFtpReturnCode = this.aRepositoryObject.putShelfToHost(aGroupObject, (String)object, null);
                        if (aFtpReturnCode.getCommandCode() != 2) {
                            this.tf.write("editTitle()", 0, "Error in putting shelf on to the host:" + aFtpReturnCode.getCommandCode());
                            this.mainWindow.waitMouseCursor(false);
                            return;
                        }
                        if (!AUtilities.CopyFile((String)object, string3)) {
                            AUtilities.showInfoMessage("Error copying :" + (String)object + " to " + string3);
                            this.mainWindow.waitMouseCursor(false);
                            return;
                        }
                        new File((String)object).delete();
                        if (this.aRepositoryObject.hostType() == 1) {
                            this.aRepositoryObject.catalog().bookCase();
                        }
                    }
                    this.aRepositoryObject.catalog().setChanged(true);
                    this.groupViewDataModel.tableRefresh(this.groupViewTable);
                    this.mainWindow.waitMouseCursor(false);
                }
                this.tf.write("updatedTitle()", 18, "updateTitle:" + string2);
            } else {
                AUtilities.showInfoMessage("Select at least one item for this operation");
            }
        }
    }

    protected void excludeFromShelf() {
        this.tf.write("excludeFromShelf()", 18, "Entry");
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.fileViewScrollPane && this.fileViewTable.getSelectedRow() != -1 && this.fileViewTable.getRowCount() > 0) {
            Vector vector = this.fileViewDataModel.getSelectedObjects(this.fileViewTable, this.fileViewTable.getSelectedRows());
            this.excludeFromShelf(vector);
        }
        this.tf.write("excludeFromShelf()", 18, "Exit");
    }

    protected boolean excludeFromShelf(Vector vector) {
        boolean bl = true;
        this.tf.write("excludeFromShelf(Vector)", 18, "Entry");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AFileObject aFileObject = (AFileObject)enumeration.nextElement();
            this.tf.write("excludeFromShelf(Vector)", 19, "File to be excluded:" + aFileObject.fileNameType());
            Enumeration enumeration2 = aFileObject.missingFromGroupSet().elements();
            while (enumeration2.hasMoreElements()) {
                Serializable serializable;
                Serializable serializable2;
                AGroupObject aGroupObject = (AGroupObject)enumeration2.nextElement();
                String string = this.aRepositoryObject.cacheDirectory() + aGroupObject.fileNameType();
                if (aFileObject.pcFileType().toUpperCase().equals("BKI")) {
                    aGroupObject.excludeIndex();
                } else if (aFileObject.pcFileType().toUpperCase().equals("BOO")) {
                    aGroupObject.excludeBook(aFileObject);
                }
                this.mainWindow.waitMouseCursor(true);
                this.tf.write("excludeFromShelf(Vector)", 19, "shelfName:" + string + ", pcFileType:" + aGroupObject.pcFileType());
                this.tf.write("excludeFromShelf(Vector)", 19, "indexName:" + aGroupObject.indexFileName());
                String string2 = AUtilities.tempDirectory() + File.separator + aGroupObject.fileNameType();
                if (this.aRepositoryObject.hostType() == 1) {
                    string = this.aRepositoryObject.cacheDirectory() + AUtilities.strip(aGroupObject.nameInRepository(), '\'');
                    string2 = AUtilities.tempDirectory() + File.separator + AUtilities.strip(aGroupObject.nameInRepository(), '\'');
                }
                if (!AUtilities.CopyFile(string, string2)) {
                    AUtilities.showInfoMessage("Error copying :" + string + " to " + string2);
                    this.mainWindow.waitMouseCursor(false);
                    bl = false;
                    return bl;
                }
                aGroupObject.write(string2);
                this.tf.write("excludeFromShelf(Vector)", 19, "After write shelf:" + string2);
                AFtpReturnCode aFtpReturnCode = this.aRepositoryObject.putShelfToHost(aGroupObject, string2, null);
                if (aFtpReturnCode.getCommandCode() != 2) {
                    this.tf.write("excludeFromShelf()", 0, "Error in putting shelf on to the host:" + aFtpReturnCode.getCommandCode());
                    this.mainWindow.waitMouseCursor(false);
                    bl = false;
                    return bl;
                }
                if (!AUtilities.CopyFile(string2, string)) {
                    AUtilities.showInfoMessage("Error copying :" + string2 + " to " + string);
                    this.mainWindow.waitMouseCursor(false);
                    bl = false;
                    return bl;
                }
                new File(string2).delete();
                if (this.aRepositoryObject.hostType() == 1) {
                    this.aRepositoryObject.catalog().bookCase();
                }
                this.fileViewDataModel.deleteObjects(aFileObject, this.fileViewTable);
                this.fileViewDataModel.tableRefresh(this.fileViewTable);
                Enumeration enumeration3 = this.viewContentsVector.elements();
                while (enumeration3.hasMoreElements()) {
                    serializable2 = (ATargetViewContentsWindow)enumeration3.nextElement();
                    serializable = (AFileViewTargetModel)((ATargetViewContentsWindow)serializable2).table.getModel();
                    if (((ATargetViewContentsWindow)serializable2).aCatalog.repository().hostType() == 1 && ((ATargetViewContentsWindow)serializable2).aCatalog.currentKey() != 2) {
                        ((ATargetWindowModel)serializable).changeKey(2);
                    }
                    ((ATargetWindowModel)serializable).deleteObjects(aFileObject, ((ATargetViewContentsWindow)serializable2).table);
                    ((ABaseTableModel)serializable).tableRefresh(((ATargetViewContentsWindow)serializable2).table);
                    if (((ATargetViewContentsWindow)serializable2).aCatalog.currentKey() == 3) continue;
                    ((ATargetWindowModel)serializable).changeKey(3);
                }
                this.tf.write("excludeFromShelf(Vector)", 19, "Missing from group:" + aGroupObject.fileName() + ", size:" + aGroupObject.missingFileObjectsSet().size());
                serializable2 = aGroupObject.missingFileObjectsSet().getObjects(aFileObject.keyField());
                if (serializable2 != null) {
                    serializable = (AFileObject)((Vector)serializable2).firstElement();
                    this.tf.write("excludeFromShelf(Vector)", 19, "1. Missing set:" + aGroupObject.missingFileObjectsSet().size());
                    aGroupObject.missingFileObjectsSet().remove(((ABaseObject)serializable).keyField());
                    this.tf.write("excludeFromShelf(Vector)", 19, "2. Missing set:" + aGroupObject.missingFileObjectsSet().size());
                }
                serializable2 = null;
                this.aRepositoryObject.catalog().changeKey(2);
                serializable2 = this.aRepositoryObject.catalog().fileObjectsSet().getObjects(aFileObject.keyField());
                if (serializable2 != null) {
                    serializable = (AFileObject)((Vector)serializable2).firstElement();
                    this.tf.write("excludeFromShelf(Vector)", 19, "1. File set:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
                    this.aRepositoryObject.catalog().fileObjectsSet().remove(((ABaseObject)serializable).keyField());
                    this.tf.write("excludeFromShelf(Vector)", 19, "2. File set:" + this.aRepositoryObject.catalog().fileObjectsSet().size());
                }
                this.aRepositoryObject.catalog().changeKey(3);
                this.aRepositoryObject.catalog().setChanged(true);
                this.mainWindow.waitMouseCursor(false);
            }
        }
        this.tf.write("excludeFromShelf(Vector)", 18, "Exit");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendTo(String string) {
        Object object;
        ARepository aRepository;
        Object object2;
        Object object3;
        ABaseSet aBaseSet;
        ATargetWindowModel aTargetWindowModel;
        ADNDTableTarget aDNDTableTarget;
        block17: {
            this.tf.write("sendTo()", 18, "Entry");
            Component component = this.tabbedPane.getSelectedComponent();
            aDNDTableTarget = null;
            aTargetWindowModel = null;
            aBaseSet = null;
            if (component == this.groupViewScrollPane) {
                if (this.groupViewTable.getRowCount() > 0 && this.groupViewTable.getSelectedRow() != -1) {
                    aDNDTableTarget = this.groupViewTable;
                    aTargetWindowModel = this.groupViewDataModel;
                    aBaseSet = new AGroupObjectsSet();
                    break block17;
                } else {
                    AUtilities.showInfoMessage("Select at least one item for this operation");
                    return;
                }
            }
            if (component != this.fileViewScrollPane) {
                return;
            }
            if (this.fileViewTable.getRowCount() > 0 && this.fileViewTable.getSelectedRow() != -1) {
                aDNDTableTarget = this.fileViewTable;
                aTargetWindowModel = this.fileViewDataModel;
                aBaseSet = new AFileObjectsSet();
            } else {
                AUtilities.showInfoMessage("Select at least one item for this operation");
                return;
            }
        }
        Enumeration enumeration = aTargetWindowModel.getSelectedObjects(aDNDTableTarget, aDNDTableTarget.getSelectedRows()).elements();
        while (enumeration.hasMoreElements()) {
            object3 = (ABaseObject)enumeration.nextElement();
            aBaseSet.add(((ABaseObject)object3).keyField(), object3);
        }
        object3 = ((AbstractList)this.mainWindow.listWindow.aRepositoryList).iterator();
        boolean bl = false;
        ARepository aRepository2 = null;
        String string2 = string;
        int n = string2.indexOf("Repository - ");
        if (n != -1) {
            string2 = string2.substring(new String("Repository - ").length());
        }
        if (string2.equals("All")) {
            object2 = this.mainWindow.listWindow.aRepositoryList.elements();
            while (object2.hasMoreElements()) {
                aRepository = (ARepository)object2.nextElement();
                object = new File(aRepository.catalogFileName());
                if (((File)object).exists()) continue;
                String string3 = "The catalog for this repository:<br>" + aRepository.repositoryTitle() + "<br>" + "must be created in order to continue.";
                AUtilities.showInfoMessage("<html>" + string3 + "</html>");
                return;
            }
        }
        this.tf.write("sendTo()", 19, "key:" + string2);
        while (object3.hasNext()) {
            aRepository2 = (ARepository)object3.next();
            this.tf.write("sendTo()", 19, "repObject.repTitle::" + aRepository2.repositoryTitle() + ", Current:" + this.aRepositoryObject.repositoryTitle());
            if (this.aRepositoryObject.repositoryTitle().equals(aRepository2.repositoryTitle()) || !string2.equals(aRepository2.repositoryTitle()) && !string2.equals("All")) continue;
            if (null == aRepository2.repositoryWindow()) {
                object2 = new ARepositoryWindow(this.mainWindow, aRepository2, this.aRepositoryObject, aBaseSet);
                if (aRepository2.repositoryWindow() == null) {
                    return;
                }
            } else if (!aRepository2.repositoryWindow().isClosed()) {
                object2 = aBaseSet;
                aRepository = aRepository2;
                try {
                    object = new Thread((ABaseSet)object2, aRepository){
                        private final /* synthetic */ ABaseSet val$sendObjects;
                        private final /* synthetic */ ARepository val$inRepObject;
                        {
                            this.val$sendObjects = aBaseSet;
                            this.val$inRepObject = aRepository;
                        }

                        public void run() {
                            AFileObjectsSet aFileObjectsSet = ACatalog.getUniqueObjects(this.val$sendObjects, this.val$inRepObject);
                            ARepositoryWindow.this.tf.write("sendTo()", 18, "Send no. of files:" + aFileObjectsSet.size());
                            if (aFileObjectsSet.size() == 0) {
                                AUtilities.showInfoMessage("No files to transfer to " + this.val$inRepObject.repositoryTitle());
                                return;
                            }
                            ATransferProcess aTransferProcess = new ATransferProcess((JFrame)this.val$inRepObject.repositoryWindow().mainWindow, (Object)aFileObjectsSet.asVector(), ARepositoryWindow.this.aRepositoryObject, this.val$inRepObject);
                            this.val$inRepObject.repositoryWindow().addRows(aTransferProcess.filesTransferred);
                        }
                    };
                    ((Thread)object).start();
                    aRepository2.repositoryWindow().setIcon(false);
                    aRepository2.repositoryWindow().moveToFront();
                    aRepository2.repositoryWindow().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (!string2.equals("All")) break;
        }
        this.tf.write("sendTo()", 18, "Exit");
    }

    public void updateTable(AGroupObjectsSet aGroupObjectsSet, AFileObjectsSet aFileObjectsSet) {
        ABaseObject aBaseObject;
        Enumeration enumeration;
        if (aFileObjectsSet.size() > 0) {
            enumeration = aFileObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AFileObject)enumeration.nextElement();
                if (this.fileViewDataModel.deleteObjects(aBaseObject, this.fileViewTable)) continue;
                this.tf.write("updateTable()", 18, "Error deleting file object from FileView DataModel");
            }
        }
        if (aGroupObjectsSet.size() > 0) {
            enumeration = aGroupObjectsSet.elements();
            while (enumeration.hasMoreElements()) {
                aBaseObject = (AGroupObject)enumeration.nextElement();
                this.groupViewDataModel.deleteObjects(aBaseObject, this.groupViewTable);
            }
        }
        this.updateTable();
    }

    public void updateTable() {
        this.groupViewDataModel.tableRefresh(this.groupViewTable);
        this.fileViewDataModel.tableRefresh(this.fileViewTable);
        this.aMyChangeListener.stateChanged(new ChangeEvent(this));
    }

    private void UpdateBookShelves(boolean bl) {
        if (!(bl || this.groupViewTable.getSelectedRow() != -1 && this.groupViewTable.getRowCount() != 0)) {
            AUtilities.showInfoMessage("Select at least one item for this operation");
            return;
        }
        String string = "<html><H3>This function updates your bookshelves to correctly point to your books.<br>Use this function when:</H3><LI>You move or rename books<LI>You install books without using the Softcopy Librarian</html>";
        Object[] objectArray = new Object[]{"OK", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, string, "Confirm Dialog", 2, 3, null, objectArray, objectArray[1]);
        if (n != 0) {
            return;
        }
        final boolean bl2 = bl;
        ASwingWorker aSwingWorker = new ASwingWorker("UpdateProcess"){

            public Object construct() {
                ARepositoryWindow.this.UpdateProcess(bl2);
                return null;
            }
        };
    }

    private void UpdateProcess(boolean bl) {
        Object object;
        Serializable serializable;
        Enumeration enumeration;
        Object object2;
        Vector vector = null;
        if (bl) {
            this.mainWindow.listWindow.EraseCache(this.aRepositoryObject, false);
        } else {
            vector = this.groupViewDataModel.getSelectedObjects(this.groupViewTable, this.groupViewTable.getSelectedRows());
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                enumeration = (AGroupObject)object2.nextElement();
                serializable = new File(this.aRepositoryObject.cacheDirectory() + ((ABaseObject)((Object)enumeration)).fileNameType());
                ((File)serializable).delete();
            }
        }
        this.mainWindow.listWindow.CreateCatalog(this.aRepositoryObject, false);
        this.mainWindow.waitMouseCursor(true);
        object2 = new Vector();
        enumeration = null;
        enumeration = bl ? this.aRepositoryObject.catalog().groupObjectsSet().elements() : vector.elements();
        while (enumeration.hasMoreElements()) {
            serializable = (AGroupObject)enumeration.nextElement();
            object = this.aRepositoryObject.cacheDirectory() + ((ABaseObject)serializable).fileNameType();
            String string = AUtilities.tempDirectory() + File.separator + ((ABaseObject)serializable).fileNameType();
            if (this.aRepositoryObject.hostType() == 1) {
                object = this.aRepositoryObject.cacheDirectory() + AUtilities.strip(((ABaseObject)serializable).nameInRepository(), '\'');
                string = AUtilities.tempDirectory() + File.separator + AUtilities.strip(((ABaseObject)serializable).nameInRepository(), '\'');
            }
            if (!AUtilities.CopyFile((String)object, string)) {
                AUtilities.showInfoMessage("Error copying :" + (String)object + " to " + string);
                this.mainWindow.waitMouseCursor(false);
                return;
            }
            if (this.aRepositoryObject.hostType() == 1) {
                ((AGroupObject)serializable).fileObjectPtr().setDirectName(AUtilities.tempDirectory() + File.separator + AUtilities.strip(((AGroupObject)serializable).fileObjectPtr().nameInRepository(), '\''));
            } else {
                ((AGroupObject)serializable).fileObjectPtr().setDirectName(AUtilities.tempDirectory() + File.separator + ((AGroupObject)serializable).fileObjectPtr().fileNameType());
            }
            ((Vector)object2).add(((AGroupObject)serializable).fileObjectPtr());
        }
        serializable = new ASource("Temp Source");
        ((ASource)serializable).setSourcePath(AUtilities.tempDirectory());
        ((ASource)serializable).setInternet(false);
        object = new ATransferProcess((JFrame)this.mainWindow, object2, (ASource)serializable, this.aRepositoryObject);
        this.mainWindow.waitMouseCursor(false);
        this.mainWindow.listWindow.CreateCatalog(this.aRepositoryObject, false);
        this.mainWindow.waitMouseCursor(true);
        if (this.aRepositoryObject.hostType() == 1) {
            this.aRepositoryObject.catalog().bookCase();
        }
        this.mainWindow.waitMouseCursor(false);
        AUtilities.showInfoMessage("Update bookshelf operation completed");
    }

    private void downloadFromInternet() {
        this.tf.write("downloadFromInternet()", 18, "Entry");
        if (this.fileViewTable.getSelectedRow() == -1 || this.fileViewTable.getRowCount() == 0) {
            AUtilities.showInfoMessage("Select at least one item for this operation");
            return;
        }
        if (this.aRepositoryObject.hostType() == 1 && this.aRepositoryObject.catalog().currentKey() != 2) {
            this.aRepositoryObject.catalog().changeKey(2);
            this.groupViewDataModel.changeKey(2);
            this.fileViewDataModel.changeKey(2);
        }
        Vector vector = this.fileViewDataModel.getSelectedObjects(this.fileViewTable, this.fileViewTable.getSelectedRows());
        this.downloadFromInternet(vector);
        this.tf.write("downloadFromInternet()", 18, "Exit");
    }

    protected void downloadFromInternet(Vector vector) {
        Object object;
        Object object2;
        this.tf.write("downloadFromInternet(Vector)", 18, "Entry");
        final AFileObjectsSet aFileObjectsSet = new AFileObjectsSet();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (AFileObject)enumeration.nextElement();
            if (((AFileObject)object2).referenceCount() >= 0) continue;
            ((ABaseObject)object2).setSize(new Float(0.0f));
            object = "";
            object = ((ABaseObject)object2).pcFileType().toUpperCase().equals("BKS") ? "/epubs/bkshelf/" + ((ABaseObject)object2).fileNameType() : "/epubs/book/" + ((ABaseObject)object2).fileNameType();
            ((AFileObject)object2).setDirectName((String)object);
            aFileObjectsSet.add(((ABaseObject)object2).keyField(), object2);
        }
        object2 = new Object();
        object = new ASwingWorker("Download from Internet"){

            public Object construct() {
                ASource aSource = new ASource("Internet Source");
                aSource.setSourcePath("http://publib.boulder.ibm.com");
                aSource.setInternet(true);
                ATransferProcess aTransferProcess = new ATransferProcess(AUtilities.mainWindow, (Object)aFileObjectsSet.asVector(), aSource, ARepositoryWindow.this.aRepositoryObject);
                if (aTransferProcess.filesTransferred.size() > 0) {
                    AFileObject aFileObject;
                    AFileObjectsSet aFileObjectsSet2 = new AFileObjectsSet();
                    Enumeration enumeration = aTransferProcess.filesTransferred.elements();
                    while (enumeration.hasMoreElements()) {
                        aFileObject = (AFileObject)enumeration.nextElement();
                        aFileObjectsSet2.add(aFileObject.keyField(), aFileObject);
                    }
                    if (!ARepositoryWindow.this.aRepositoryObject.catalog().addObjects(null, aFileObjectsSet2)) {
                        AUtilities.showInfoMessage("Error occurred during adding objects");
                        return null;
                    }
                    if (ARepositoryWindow.this.aRepositoryObject.hostType() == 1) {
                        if (ARepositoryWindow.this.groupViewDataModel.currentKey() != 2) {
                            ARepositoryWindow.this.groupViewDataModel.changeKey(2);
                        }
                        if (ARepositoryWindow.this.fileViewDataModel.currentKey() != 2) {
                            ARepositoryWindow.this.fileViewDataModel.changeKey(2);
                        }
                    }
                    enumeration = aFileObjectsSet2.elements();
                    while (enumeration.hasMoreElements()) {
                        aFileObject = (AFileObject)enumeration.nextElement();
                        ARepositoryWindow.this.fileViewDataModel.addRow(aFileObject, ARepositoryWindow.this.fileViewTable);
                        ARepositoryWindow.this.fileViewDataModel.tableRefresh(ARepositoryWindow.this.fileViewTable);
                        Enumeration enumeration2 = ARepositoryWindow.this.viewContentsVector.elements();
                        while (enumeration2.hasMoreElements()) {
                            ATargetViewContentsWindow aTargetViewContentsWindow = (ATargetViewContentsWindow)enumeration2.nextElement();
                            AFileViewTargetModel aFileViewTargetModel = (AFileViewTargetModel)aTargetViewContentsWindow.table.getModel();
                            ARepositoryWindow.this.tf.write("downloadFromInternet(Vector)", 18, "currentKey:" + aTargetViewContentsWindow.aCatalog.currentKey());
                            if (aTargetViewContentsWindow.aCatalog.repository().hostType() == 1 && aFileViewTargetModel.currentKey() != 2) {
                                aFileViewTargetModel.changeKey(2);
                            }
                            aFileViewTargetModel.addRow(aFileObject, aTargetViewContentsWindow.table);
                            aFileViewTargetModel.tableRefresh(aTargetViewContentsWindow.table);
                            if (aFileViewTargetModel.currentKey() == 3) continue;
                            aFileViewTargetModel.changeKey(3);
                        }
                    }
                    if (ARepositoryWindow.this.aRepositoryObject.catalog().currentKey() != 3) {
                        ARepositoryWindow.this.aRepositoryObject.catalog().changeKey(3);
                        ARepositoryWindow.this.groupViewDataModel.changeKey(3);
                        ARepositoryWindow.this.fileViewDataModel.changeKey(3);
                    }
                }
                return null;
            }
        };
        this.tf.write("downloadFromInternet(Vector)", 18, "Exit");
    }

    private void sortByMissingShelves() {
        this.mainWindow.waitMouseCursor(this, true);
        boolean bl = !this.groupViewDataModel.m_sortAsc;
        this.groupViewDataModel.sort(this.groupViewTable, 4, bl);
        this.mainWindow.waitMouseCursor(this, false);
    }

    private void FindFirst() {
        this.itemFindNext.setEnabled(false);
        Component component = this.tabbedPane.getSelectedComponent();
        ADNDTableTarget aDNDTableTarget = null;
        if (component == this.groupViewScrollPane) {
            aDNDTableTarget = this.groupViewTable;
        } else if (component == this.fileViewScrollPane) {
            aDNDTableTarget = this.fileViewTable;
        }
        this.findWindow = new AFindWindow(this.mainWindow, aDNDTableTarget, this.searchString);
        if (this.findWindow.retCode == 1) {
            this.findWindow = null;
            return;
        }
        this.searchString = this.findWindow.getFindText();
        if (this.findWindow.findFirst()) {
            this.itemFindNext.setEnabled(true);
        } else {
            AUtilities.showInfoMessage(this.searchString + " not found");
        }
    }

    private void FindNext() {
        if (this.findWindow != null && !this.findWindow.findNext()) {
            AUtilities.showInfoMessage(this.findWindow.getFindText() + " not found");
        }
    }

    static /* synthetic */ void access$800(ARepositoryWindow aRepositoryWindow) {
        aRepositoryWindow.viewContents();
    }

    class CustomSharedListSelectionHandler
    extends ASharedListSelectionHandler {
        public CustomSharedListSelectionHandler(JTable jTable, ABaseTableModel aBaseTableModel, JLabel jLabel) {
            super(jTable, aBaseTableModel, jLabel);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionEvent.getFirstIndex();
            int n2 = listSelectionEvent.getLastIndex();
            boolean bl = listSelectionEvent.getValueIsAdjusting();
            if (listSelectionModel.isSelectionEmpty()) {
                ARepositoryWindow.this.itemExclude.setEnabled(false);
                ARepositoryWindow.this.pItemExclude.setEnabled(false);
                ARepositoryWindow.this.itemDownloadFromInternet.setEnabled(false);
                ARepositoryWindow.this.pItemDownloadFromInternet.setEnabled(false);
            } else {
                Vector vector = ARepositoryWindow.this.fileViewDataModel.getSelectedObjects(ARepositoryWindow.this.fileViewTable, ARepositoryWindow.this.fileViewTable.getSelectedRows());
                boolean bl2 = false;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    AFileObject aFileObject = (AFileObject)enumeration.nextElement();
                    if (aFileObject.referenceCount() >= 0) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    ARepositoryWindow.this.itemExclude.setEnabled(true);
                    ARepositoryWindow.this.pItemExclude.setEnabled(true);
                    ARepositoryWindow.this.itemDownloadFromInternet.setEnabled(true);
                    ARepositoryWindow.this.pItemDownloadFromInternet.setEnabled(true);
                } else {
                    ARepositoryWindow.this.itemExclude.setEnabled(false);
                    ARepositoryWindow.this.pItemExclude.setEnabled(false);
                    ARepositoryWindow.this.itemDownloadFromInternet.setEnabled(false);
                    ARepositoryWindow.this.pItemDownloadFromInternet.setEnabled(false);
                }
            }
            super.valueChanged(listSelectionEvent);
        }
    }

    class NewMenuListener
    implements MenuListener {
        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            String string = ((JMenu)menuEvent.getSource()).getText();
            ARepositoryWindow.this.tf.write("menuSelected()", 19, "Selected Menu:" + string);
            ARepositoryWindow.this.tf.write("menuSelected()", 19, "List size:" + ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList.size() + ", send to size:" + ARepositoryWindow.this.sendToSubMenu.getItemCount());
            ARepositoryWindow.this.sendToSubMenu.removeAll();
            boolean bl = true;
            Iterator iterator = ((AbstractList)ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList).iterator();
            while (iterator.hasNext()) {
                ARepository aRepository = (ARepository)iterator.next();
                String string2 = "Repository - " + aRepository.repositoryTitle();
                if (aRepository.repositoryTitle().equals(ARepositoryWindow.this.aRepositoryObject.repositoryTitle())) continue;
                JMenuItem jMenuItem = null;
                if (ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList.size() > 1 && bl) {
                    jMenuItem = ARepositoryWindow.this.sendToSubMenu.add(new JMenuItem("All"));
                }
                JMenuItem jMenuItem2 = ARepositoryWindow.this.sendToSubMenu.add(new JMenuItem(string2));
                ActionListener actionListener = new ActionListener(this, string){
                    private final /* synthetic */ String val$selectedMenuText;
                    private final /* synthetic */ NewMenuListener this$1;
                    {
                        this.this$1 = newMenuListener;
                        this.val$selectedMenuText = string;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        String string2 = string;
                        int n = string2.indexOf("Repository - ");
                        if (n != -1) {
                            string2 = string2.substring(new String("Repository - ").length());
                        }
                        ARepositoryWindow.access$900(NewMenuListener.access$4200(this.this$1)).write("NewMenuListener::actionPerformed():", 19, "Key:" + string2);
                        Iterator<E> iterator = ((AbstractList)NewMenuListener.access$4200((NewMenuListener)this.this$1).mainWindow.listWindow.aRepositoryList).iterator();
                        ARepository aRepository = null;
                        boolean bl = false;
                        while (iterator.hasNext()) {
                            aRepository = (ARepository)iterator.next();
                            ARepositoryWindow.access$900(NewMenuListener.access$4200(this.this$1)).write("menuSelected()", 19, "repObject.repTitle:" + aRepository.repositoryTitle() + ", Current:" + NewMenuListener.access$4200((NewMenuListener)this.this$1).aRepositoryObject.repositoryTitle());
                            if (!string2.equals(aRepository.repositoryTitle()) && !string2.equals("All")) continue;
                            bl = true;
                            break;
                        }
                        if (bl) {
                            ARepository aRepository2 = aRepository;
                            ASwingWorker aSwingWorker = new ASwingWorker(this, string, "Menu"){
                                private final /* synthetic */ String val$actionCommand;
                                private final /* synthetic */ 20 this$2;
                                {
                                    super(string2);
                                    this.this$2 = var1_1;
                                    this.val$actionCommand = string;
                                }

                                public Object construct() {
                                    if (20.access$4300(this.this$2).equals("Send To")) {
                                        ARepositoryWindow.access$600(NewMenuListener.access$4200(20.access$4400(this.this$2)), this.val$actionCommand);
                                    }
                                    return null;
                                }
                            };
                        }
                    }

                    static /* synthetic */ String access$4300(20 var0) {
                        return var0.val$selectedMenuText;
                    }

                    static /* synthetic */ NewMenuListener access$4400(20 var0) {
                        return var0.this$1;
                    }
                };
                if (ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList.size() > 1 && bl) {
                    jMenuItem.addActionListener(actionListener);
                    bl = false;
                }
                jMenuItem2.addActionListener(actionListener);
            }
        }

        static /* synthetic */ ARepositoryWindow access$4200(NewMenuListener newMenuListener) {
            return newMenuListener.ARepositoryWindow.this;
        }
    }

    class RepositoryKeyListener
    implements KeyListener {
        RepositoryKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                ASwingWorker aSwingWorker = new ASwingWorker(this, "Delete"){
                    private final /* synthetic */ RepositoryKeyListener this$1;
                    {
                        this.this$1 = repositoryKeyListener;
                    }

                    public Object construct() {
                        ARepositoryWindow.access$200(RepositoryKeyListener.access$4000(this.this$1));
                        return null;
                    }
                };
            } else if (keyEvent.getKeyCode() == 10) {
                ASwingWorker aSwingWorker = new ASwingWorker(this, "View contents"){
                    private final /* synthetic */ RepositoryKeyListener this$1;
                    {
                        this.this$1 = repositoryKeyListener;
                    }

                    public Object construct() {
                        ARepositoryWindow.access$800(RepositoryKeyListener.access$4000(this.this$1));
                        return null;
                    }
                };
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 114) {
                ARepositoryWindow.this.FindNext();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        static /* synthetic */ ARepositoryWindow access$4000(RepositoryKeyListener repositoryKeyListener) {
            return repositoryKeyListener.ARepositoryWindow.this;
        }
    }

    class PopupListener
    extends ABasePopupListener {
        private ARepositoryWindow repWindow;

        public PopupListener(ARepositoryWindow aRepositoryWindow2) {
            super(ARepositoryWindow.this.popup);
            this.repWindow = aRepositoryWindow2;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkModifier(mouseEvent);
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Object object;
                if (mouseEvent.getComponent() == ARepositoryWindow.this.groupViewTable) {
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.pItemExclude);
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.pItemDownloadFromInternet);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemEditTitle);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemViewContents);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemDelete);
                    ARepositoryWindow.this.pUpdateBookShelfSubMenu.add(ARepositoryWindow.this.pItemUpdateSelected);
                } else if (mouseEvent.getComponent() == ARepositoryWindow.this.fileViewTable) {
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.pItemEditTitle);
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.pItemViewContents);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemExclude);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemDownloadFromInternet);
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemDelete);
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.pUpdateBookShelfSubMenu);
                }
                ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pItemDetails);
                int n = ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList.size();
                ARepositoryWindow.this.subMenu.removeAll();
                if (ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList.size() >= 1) {
                    object = ARepositoryWindow.this.subMenu.add(new JMenuItem("All"));
                    ((AbstractButton)object).addActionListener(this.repWindow);
                }
                object = ((AbstractList)ARepositoryWindow.this.mainWindow.listWindow.aRepositoryList).iterator();
                while (object.hasNext()) {
                    ARepository aRepository = (ARepository)object.next();
                    if (aRepository.repositoryTitle().equals(ARepositoryWindow.this.aRepositoryObject.repositoryTitle())) continue;
                    String string = "Repository - " + aRepository.repositoryTitle();
                    JMenuItem jMenuItem = ARepositoryWindow.this.subMenu.add(new JMenuItem(string));
                    jMenuItem.addActionListener(this.repWindow);
                }
                if (mouseEvent.getComponent() == ARepositoryWindow.this.groupViewTable || mouseEvent.getComponent() == ARepositoryWindow.this.fileViewTable) {
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.subMenu);
                } else {
                    ARepositoryWindow.this.popup.remove(ARepositoryWindow.this.subMenu);
                }
                if (mouseEvent.getComponent() == ARepositoryWindow.this.groupViewTable && (ARepositoryWindow.this.aRepositoryObject.hostType() == 1 || ARepositoryWindow.this.aRepositoryObject.hostType() == 3)) {
                    ARepositoryWindow.this.popup.add(ARepositoryWindow.this.pUpdateBookShelfSubMenu);
                }
                ARepositoryWindow.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class ToggleLogging
    extends AbstractAction {
        ToggleLogging() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Timer.setLogTimers(!Timer.getLogTimers());
        }

        public boolean isEnabled() {
            return true;
        }
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            Component component = ARepositoryWindow.this.tabbedPane.getSelectedComponent();
            if (component == ARepositoryWindow.this.groupViewScrollPane) {
                ARepositoryWindow.this.groupViewTable.dontDrag = false;
            } else if (component == ARepositoryWindow.this.fileViewScrollPane) {
                ARepositoryWindow.this.fileViewTable.dontDrag = false;
            }
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            Object object;
            if (ARepositoryWindow.this.addItemsWorker != null && ARepositoryWindow.this.addItemsWorker.getThread().isAlive()) {
                ARepositoryWindow.this.tf.write("internalFrameClosed()", 19, "Interrupting ..");
                ARepositoryWindow.this.addItemsWorker.interrupt();
            }
            ARepositoryWindow.this.mainWindow.getWindowMenu().remove(ARepositoryWindow.this.itemRepository);
            ARepositoryWindow.this.tf.write("internalFrameClosed()", 19, "Catalog:" + ARepositoryWindow.this.aRepositoryObject.catalog().groupObjectsSet().size() + ", hasChanged:" + ARepositoryWindow.this.aRepositoryObject.catalog().hasChanged());
            if (ARepositoryWindow.this.aRepositoryObject.catalog().hasChanged()) {
                ARepositoryWindow.this.aRepositoryObject.catalog().write(true);
            }
            ARepositoryWindow.this.aRepositoryObject.catalog().clearCatalog();
            ARepositoryWindow.this.aRepositoryObject.catalog().setCatalogValid(false);
            ARepository aRepository = ARepositoryWindow.this.aRepositoryObject;
            ARepositoryWindow.this.aPropObject.setIndex(aRepository.index());
            int n = ((ABaseTableModel)ARepositoryWindow.this.groupViewTable.getModel()).m_sortCol;
            int n2 = ((ABaseTableModel)ARepositoryWindow.this.fileViewTable.getModel()).m_sortCol;
            ARepositoryWindow.this.tf.write("internalFrameClosed()", 19, "Last groups sorted column:" + n);
            ARepositoryWindow.this.tf.write("internalFrameClosed()", 19, "Last files sorted column:" + n2);
            TableColumnModel tableColumnModel = ARepositoryWindow.this.groupViewTable.getColumnModel();
            String string = "";
            int n3 = 0;
            while (n3 < tableColumnModel.getColumnCount()) {
                TableColumn tableColumn = ARepositoryWindow.this.groupViewTable.getColumnModel().getColumn(n3);
                string = string + tableColumnModel.getColumn(n3).getModelIndex() + ",";
                ++n3;
            }
            string = string + ",111,";
            tableColumnModel = ARepositoryWindow.this.fileViewTable.getColumnModel();
            int n4 = 0;
            while (n4 < tableColumnModel.getColumnCount()) {
                object = ARepositoryWindow.this.fileViewTable.getColumnModel().getColumn(n4);
                string = string + tableColumnModel.getColumn(n4).getModelIndex() + ",";
                ++n4;
            }
            ARepositoryWindow.this.aPropObject.setColumnSequence(string, 9);
            ARepositoryWindow.this.aPropObject.setColumnSort(String.valueOf(n) + "," + ((ABaseTableModel)ARepositoryWindow.this.groupViewTable.getModel()).m_sortAsc + "," + String.valueOf(n2) + "," + ((ABaseTableModel)ARepositoryWindow.this.fileViewTable.getModel()).m_sortAsc);
            object = "Repository" + ARepositoryWindow.this.aPropObject.index();
            ARepositoryWindow.this.aPropObject.setKeyField((String)object);
            APropertyObject aPropertyObject = AMainWindow.userProperties.getObject(object);
            if (aPropertyObject == null) {
                AMainWindow.userProperties.propertiesTable().addElement(ARepositoryWindow.this.aPropObject);
            }
            int n5 = ARepositoryWindow.this.viewContentsVector.size();
            int n6 = 0;
            while (n6 < n5) {
                ATargetViewContentsWindow aTargetViewContentsWindow = (ATargetViewContentsWindow)ARepositoryWindow.this.viewContentsVector.elementAt(0);
                aTargetViewContentsWindow.dispose();
                ++n6;
            }
            ARepositoryWindow.this.viewContentsVector.removeAllElements();
            ARepositoryWindow.this.aRepositoryObject.setRepositoryWindow(null);
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n = ARepositoryWindow.this.tabbedPane.getSelectedIndex();
            ARepositoryWindow.this.findWindow = null;
            if (n == 0) {
                ARepositoryWindow.this.itemUpdateSelected.setEnabled(true);
                ARepositoryWindow.this.itemDelete.setEnabled(true);
                ARepositoryWindow.this.itemExclude.setEnabled(false);
                ARepositoryWindow.this.itemDownloadFromInternet.setEnabled(false);
                ARepositoryWindow.this.itemEditTitle.setEnabled(true);
                ARepositoryWindow.this.itemViewContents.setEnabled(true);
                ARepositoryWindow.this.sendToSubMenu.setEnabled(true);
                ARepositoryWindow.this.itemFindNext.setEnabled(false);
                if (ARepositoryWindow.this.aRepositoryObject.hostType() == 1 || ARepositoryWindow.this.aRepositoryObject.hostType() == 3) {
                    ARepositoryWindow.this.updateBookShelfSubMenu.setEnabled(true);
                }
                ARepositoryWindow.this.itemSortByMissingShelves.setEnabled(true);
                ARepositoryWindow.this.setInfoLabelText("Total no. of objects : " + ARepositoryWindow.this.groupViewTable.getRowCount());
            } else if (n == 1) {
                ARepositoryWindow.this.itemUpdateSelected.setEnabled(false);
                ARepositoryWindow.this.itemDelete.setEnabled(true);
                ARepositoryWindow.this.itemEditTitle.setEnabled(false);
                ARepositoryWindow.this.itemViewContents.setEnabled(false);
                ARepositoryWindow.this.sendToSubMenu.setEnabled(true);
                ARepositoryWindow.this.itemFindNext.setEnabled(false);
                ARepositoryWindow.this.updateBookShelfSubMenu.setEnabled(false);
                ARepositoryWindow.this.itemSortByMissingShelves.setEnabled(false);
                ARepositoryWindow.this.setInfoLabelText("Total no. of objects : " + ARepositoryWindow.this.fileViewTable.getRowCount());
            }
        }
    }
}

