/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.AbstractList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class ASetupPanelDefinition
extends ASetupPanel {
    private JTextField repositoryTitleField;
    private JLabel repositoryTitleLabel;
    private JLabel accessTypeLabel;
    private JLabel repositoryTypeLabel;
    private ButtonGroup groupAccessType;
    private ButtonGroup groupSystemType;
    private JRadioButton ftpAccessTypeRadioButton;
    private JRadioButton copyAccessTypeRadioButton;
    private JRadioButton os390SeqTypeRadioButton;
    private JRadioButton os390HfsTypeRadioButton;
    private JRadioButton unixTypeRadioButton;
    private JRadioButton pcTypeRadioButton;

    ASetupPanelDefinition(ASetupWindow aSetupWindow) {
        super(aSetupWindow);
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.repositoryTitleLabel = new JLabel("Repository Title");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.repositoryTitleLabel);
        this.repositoryTitleField = new JTextField(25);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(1, 10, 30, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.repositoryTitleField);
        KeyListener keyListener = new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                ASetupPanelDefinition.this.tf.write("keyPressed()", 17, "Key is:" + keyEvent.getKeyCode() + ", character:" + c);
                if (c == ':' || c == '\\' || c == '/' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                    Toolkit.getDefaultToolkit().beep();
                    String string = ASetupPanelDefinition.this.repositoryTitleField.getText().trim();
                    int n = string.length();
                    int n2 = string.indexOf(c);
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                        ASetupPanelDefinition.this.repositoryTitleField.setText(string);
                    }
                    return;
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                ASetupPanelDefinition.this.tf.write("keyReleased()", 17, "Key is:" + keyEvent.getKeyCode() + ", character:" + c);
                if (c == ':' || c == '\\' || c == '/' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '>' || c == '|') {
                    Toolkit.getDefaultToolkit().beep();
                    String string = ASetupPanelDefinition.this.repositoryTitleField.getText().trim();
                    int n = string.length();
                    int n2 = string.indexOf(c);
                    if (n2 != -1) {
                        string = string.substring(0, n2) + string.substring(n2 + 1);
                        ASetupPanelDefinition.this.repositoryTitleField.setText(string);
                    }
                    return;
                }
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.repositoryTitleField.addKeyListener(keyListener);
        this.accessTypeLabel = new JLabel("Location and method of accessing:");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.accessTypeLabel);
        this.groupSystemType = new ButtonGroup();
        this.os390HfsTypeRadioButton = new JRadioButton(ASetupWindow.LABEL_OS390OE);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(10, 20, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.os390HfsTypeRadioButton);
        this.os390HfsTypeRadioButton.addActionListener(aSetupWindow);
        this.os390SeqTypeRadioButton = new JRadioButton(ASetupWindow.LABEL_OS390, true);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.os390SeqTypeRadioButton);
        this.os390SeqTypeRadioButton.addActionListener(aSetupWindow);
        this.unixTypeRadioButton = new JRadioButton(ASetupWindow.LABEL_UNIX);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.unixTypeRadioButton);
        this.unixTypeRadioButton.addActionListener(aSetupWindow);
        this.pcTypeRadioButton = new JRadioButton(ASetupWindow.LABEL_PC);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.pcTypeRadioButton);
        this.pcTypeRadioButton.addActionListener(aSetupWindow);
        this.groupSystemType.add(this.os390HfsTypeRadioButton);
        this.groupSystemType.add(this.os390SeqTypeRadioButton);
        this.groupSystemType.add(this.pcTypeRadioButton);
        this.groupSystemType.add(this.unixTypeRadioButton);
        this.add(jPanel);
    }

    public void preparePanel() {
        ARepository aRepository = this.setupWindow.aRepository;
        this.repositoryTitleField.setText(aRepository.repositoryTitle());
        int n = aRepository.hostType();
        if (n == 1) {
            this.os390SeqTypeRadioButton.setSelected(true);
        } else if (n == 3) {
            this.os390HfsTypeRadioButton.setSelected(true);
        } else if (n == 5) {
            this.pcTypeRadioButton.setSelected(true);
        } else if (n == 4) {
            this.unixTypeRadioButton.setSelected(true);
        }
    }

    public boolean saveSettings() {
        String string = this.repositoryTitleField.getText().trim();
        if (string.length() == 0) {
            this.setupWindow.setPage(this);
            Rectangle rectangle = new Rectangle(this.repositoryTitleField.getX(), this.repositoryTitleField.getY(), this.repositoryTitleField.getWidth(), this.repositoryTitleField.getHeight());
            this.setupWindow.scrollPane(this).getViewport().scrollRectToVisible(rectangle);
            this.repositoryTitleField.requestFocus();
            AUtilities.showInfoMessage("Enter the title");
            return false;
        }
        if (this.setupWindow.isNewRepository) {
            Cloneable cloneable;
            boolean bl = false;
            ARepositoryList aRepositoryList = this.setupWindow.mainWindow.listWindow.aRepositoryList;
            Iterator iterator = ((AbstractList)aRepositoryList).iterator();
            while (iterator.hasNext()) {
                cloneable = (ARepository)iterator.next();
                this.tf.write("saveSettings()", 17, "Title:" + ((ARepository)cloneable).repositoryTitle() + ", New:" + string);
                if (!((ARepository)cloneable).repositoryTitle().toUpperCase().equals(string.toUpperCase())) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.setupWindow.setPage(this);
                cloneable = new Rectangle(this.repositoryTitleField.getX(), this.repositoryTitleField.getY(), this.repositoryTitleField.getWidth(), this.repositoryTitleField.getHeight());
                this.setupWindow.scrollPane(this).getViewport().scrollRectToVisible((Rectangle)cloneable);
                this.repositoryTitleField.requestFocus();
                AUtilities.showInfoMessage("Repository with the same title already exists");
                return false;
            }
        }
        this.setupWindow.aRepository.setRepositoryTitle(string);
        if (this.os390SeqTypeRadioButton.isSelected()) {
            this.setupWindow.aRepository.setHostType(new hostTypeEnum(1));
        } else if (this.os390HfsTypeRadioButton.isSelected()) {
            this.setupWindow.aRepository.setHostType(new hostTypeEnum(3));
        } else if (this.pcTypeRadioButton.isSelected()) {
            this.setupWindow.aRepository.setHostType(new hostTypeEnum(5));
        } else if (this.unixTypeRadioButton.isSelected()) {
            this.setupWindow.aRepository.setHostType(new hostTypeEnum(4));
        }
        if (!this.setupWindow.isNewRepository && this.setupWindow.aRepository.hostType() != this.setupWindow.orgRepository.hostType()) {
            this.setupWindow.aRepository.setCatalogValid(false);
        }
        return true;
    }

    public String getRepositoryTitle() {
        return this.repositoryTitleField.getText().trim();
    }

    public boolean isAccessTypeFtp() {
        boolean bl = false;
        if (this.ftpAccessTypeRadioButton.isSelected()) {
            bl = true;
        }
        return bl;
    }

    public hostTypeEnum getSystemType() {
        hostTypeEnum hostTypeEnum2 = this.os390HfsTypeRadioButton.isSelected() ? new hostTypeEnum(3) : (this.os390SeqTypeRadioButton.isSelected() ? new hostTypeEnum(1) : (this.pcTypeRadioButton.isSelected() ? new hostTypeEnum(5) : (this.unixTypeRadioButton.isSelected() ? new hostTypeEnum(4) : new hostTypeEnum(0))));
        return hostTypeEnum2;
    }
}

