/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ASourceSetup
extends ABaseInternalFrame
implements Runnable,
ActionListener {
    public AMainWindow mainWindow;
    public ASource aSource;
    private ASource orgSource;
    private ASourceSetupPanel aSourceSetupPanel;
    private MyInternalFrameListener aMyInternalFrameListener1;
    private JPanel buttonPanel;
    private JButton helpButton;
    private JButton okButton;
    private JButton cancelButton;
    private ATraceFile tf;
    private Thread setupThread = null;
    private JMenuItem itemWindow_Setup;
    private String title;
    public boolean isNewSource = false;

    public ASourceSetup(AMainWindow aMainWindow, ASource aSource, ASource aSource2) {
        super("", true, true, true, true);
        if (aSource.sourceTitle().length() == 0) {
            this.title = "Source Properties - New Source";
            this.isNewSource = true;
        } else {
            this.title = "Source Properties - " + aSource.sourceTitle();
        }
        this.mainWindow = aMainWindow;
        this.aSource = aSource;
        this.orgSource = aSource2;
        this.itemWindow_Setup = aMainWindow.windowMenu.add(new JMenuItem(this.title));
        this.itemWindow_Setup.addActionListener(aMainWindow);
        this.tf = new ATraceFile(this);
        APropertyObject aPropertyObject = null;
        if (AMainWindow.userIniFlag) {
            aPropertyObject = AMainWindow.userProperties.getObject(this.title);
            if (aPropertyObject == null) {
                aPropertyObject = new APropertyObject();
                aPropertyObject.setTitle(this.title);
                aPropertyObject.setSize(new Dimension(600, 400));
                aPropertyObject.setLocation(new Point(60, 60));
            }
        } else {
            aPropertyObject = new APropertyObject();
            aPropertyObject.setTitle(this.title);
            aPropertyObject.setSize(new Dimension(600, 400));
            aPropertyObject.setLocation(new Point(60, 60));
        }
        this.setTitle(aPropertyObject.title());
        this.setSize(aPropertyObject.size());
        this.setLocation(aPropertyObject.location());
        this.setupThread = new Thread(this);
        this.setupThread.start();
        this.setVisible(true);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void run() {
        this.aMyInternalFrameListener1 = new MyInternalFrameListener();
        this.addInternalFrameListener(this.aMyInternalFrameListener1);
        this.aSourceSetupPanel = new ASourceSetupPanel(this);
        JPanel jPanel = this.buttonPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Dimension dimension = new Dimension(20, 20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(new Box.Filler(dimension, dimension, dimension), gridBagConstraints);
        jPanel.add(new Box.Filler(dimension, dimension, dimension));
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        jPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jPanel.add(this.cancelButton);
        this.helpButton = new JButton("Help");
        this.helpButton.setMnemonic('H');
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.getContentPane().add((Component)this.aSourceSetupPanel, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.updateUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("ASetupWindow actionPerformed() : ", 17, actionEvent.paramString());
        if (actionEvent.getActionCommand().equals("OK")) {
            this.saveSourceSettings();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            if (!this.isNewSource) {
                JInternalFrame[] jInternalFrameArray = this.getDesktopPane().getAllFrames();
                int n = jInternalFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                    if (jInternalFrame.getTitle().equals("Sources and Repositories")) {
                        ((AListWindow)jInternalFrame).cancelSetup(this.orgSource);
                    }
                    ++n2;
                }
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Help")) {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec("start ebrscl10.boo -t \"12.1\" -s3");
            }
            catch (Exception exception) {
                this.tf.write("User's Guide", 0, "IOException:" + exception.toString());
            }
        }
    }

    private void saveSourceSettings() {
        JInternalFrame[] jInternalFrameArray = this.getDesktopPane().getAllFrames();
        int n = jInternalFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame = jInternalFrameArray[n2];
            this.tf.write("", 17, "Frame title:" + jInternalFrame.getTitle());
            if (jInternalFrame.getTitle().equals("Sources and Repositories")) {
                if (!this.aSourceSetupPanel.saveSettings()) {
                    return;
                }
                if (this.isNewSource) {
                    ((AListWindow)jInternalFrame).addNewSource(this.aSource);
                } else {
                    ((AListWindow)jInternalFrame).updateExistingSource(this.aSource, this.orgSource);
                }
            }
            ++n2;
        }
        this.dispose();
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            ASourceSetup.this.mainWindow.getWindowMenu().remove(ASourceSetup.this.itemWindow_Setup);
            ASourceSetup.this.aSource.setSourceSetupWindow(null);
            if (ASourceSetup.this.isNewSource) {
                ASourceSetup.this.mainWindow.SourceSetupWindowClosed();
            }
        }
    }
}

