/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;

class ASourceSetupPanel
extends JPanel {
    private JLabel sourceTitleLabel;
    private JLabel urlAddressLabel;
    private JLabel softcopyFilePathLabel;
    private JLabel softcopyFilePathInfoLabel;
    private JTextField sourceTitleField;
    private JTextField softcopyFilePathField;
    private JComboBox urlAddressField;
    private JButton softcopyFilepathButton;
    private JRadioButton internetRadioButton;
    private JRadioButton cdlocalRadioButton;
    private ButtonGroup buttonGroup;
    private JButton softcopyBrowseButton;
    protected ASourceSetup sourceSetupWindow;
    private ATraceFile tf = new ATraceFile(this);
    static final String INTERNET_STR = new String("Install softcopy files from the Internet");
    static final String LOCALCD_STR = new String("Install softcopy from CD or hard drive");

    ASourceSetupPanel(ASourceSetup aSourceSetup) {
        JPanel jPanel;
        SoftBevelBorder softBevelBorder = new SoftBevelBorder(1);
        this.setBorder(softBevelBorder);
        this.setLayout(new BoxLayout(this, 1));
        this.sourceSetupWindow = aSourceSetup;
        JPanel jPanel2 = jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.sourceTitleLabel = new JLabel("Source title");
        this.sourceTitleLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 30, 0, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.sourceTitleLabel);
        this.sourceTitleField = new JTextField(25);
        this.sourceTitleField.setText("");
        this.sourceTitleField.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.sourceTitleField);
        this.buttonGroup = new ButtonGroup();
        this.cdlocalRadioButton = new JRadioButton(LOCALCD_STR, true);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(30, 30, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.cdlocalRadioButton);
        this.softcopyFilePathLabel = new JLabel("Softcopy File Path (usually your CD-ROM drive letter)");
        this.softcopyFilePathLabel.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.softcopyFilePathLabel);
        this.softcopyFilePathField = new JTextField(25);
        this.softcopyFilePathField.setText("");
        this.softcopyFilePathField.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.softcopyFilePathField);
        this.softcopyBrowseButton = new JButton("Browse");
        final AMainWindow aMainWindow = aSourceSetup.mainWindow;
        this.softcopyBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                if (ASourceSetupPanel.this.softcopyFilePathField.getText().trim().length() > 0) {
                    string = ASourceSetupPanel.this.softcopyFilePathField.getText().trim();
                }
                AFileChooser aFileChooser = new AFileChooser((JFrame)aMainWindow, string);
                int n = aFileChooser.retCode;
                if (n != 0) {
                    return;
                }
                ASourceSetupPanel.this.softcopyFilePathField.setText(aFileChooser.getSelectedPath());
            }
        });
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 0, 0, 80);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.softcopyBrowseButton);
        this.softcopyFilePathInfoLabel = new JLabel("Enter a drive letter, network name or path to the softcopy files to be installed");
        this.softcopyFilePathInfoLabel.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new Insets(0, 30, 30, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.softcopyFilePathInfoLabel);
        this.internetRadioButton = new JRadioButton(INTERNET_STR);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.insets = new Insets(30, 30, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.internetRadioButton);
        this.buttonGroup.add(this.cdlocalRadioButton);
        this.buttonGroup.add(this.internetRadioButton);
        this.urlAddressLabel = new JLabel("URL address of Internet site");
        this.urlAddressLabel.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.urlAddressLabel);
        this.urlAddressField = new JComboBox();
        this.urlAddressField.setEditable(true);
        this.urlAddressField.setAlignmentX(0.0f);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.urlAddressField);
        this.cdlocalRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ASourceSetupPanel.this.enableLocalCD();
            }
        });
        this.internetRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ASourceSetupPanel.this.enableInternet();
            }
        });
        this.preparePanel();
        this.add(jPanel);
    }

    public void preparePanel() {
        ASource aSource = this.sourceSetupWindow.aSource;
        this.sourceTitleField.setText(aSource.sourceTitle());
        if (aSource.usingInternet()) {
            if (aSource.sourcePath().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(aSource.sourcePath(), " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if ((string = string.trim()).indexOf("://") == -1) {
                        string = "http://" + string;
                    }
                    this.urlAddressField.addItem(string);
                }
            } else {
                this.urlAddressField.addItem("http://publib.boulder.ibm.com");
                this.urlAddressField.addItem("http://test1.ibm.com");
                this.urlAddressField.addItem("http://test2.ibm.com");
            }
            this.urlAddressField.setSelectedIndex(0);
            this.enableInternet();
        } else {
            this.cdlocalRadioButton.setSelected(true);
            this.softcopyFilePathField.setText(aSource.sourcePath());
            this.enableLocalCD();
        }
    }

    public boolean saveSettings() {
        Object object;
        ASource aSource = this.sourceSetupWindow.aSource;
        if (this.sourceTitleField.getText().trim().length() == 0) {
            this.sourceTitleField.requestFocus();
            AUtilities.showInfoMessage("Enter source title");
            return false;
        }
        if (this.sourceSetupWindow.isNewSource) {
            object = this.sourceSetupWindow.mainWindow.listWindow.aSourceList;
            boolean bl = false;
            Iterator iterator = ((AbstractList)object).iterator();
            while (iterator.hasNext()) {
                ASource aSource2 = (ASource)iterator.next();
                if (!aSource2.sourceTitle().toUpperCase().equals(this.sourceTitleField.getText().trim().toUpperCase())) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.sourceTitleField.requestFocus();
                AUtilities.showInfoMessage("Source with the same title already exists");
                return false;
            }
        }
        if (this.cdlocalRadioButton.isSelected()) {
            if (this.softcopyFilePathField.getText().trim().length() == 0) {
                this.softcopyFilePathField.requestFocus();
                AUtilities.showInfoMessage("Enter softcopy filepath");
                return false;
            }
            object = this.softcopyFilePathField.getText().trim();
            if (((String)object).length() == 1) {
                object = (String)object + ":" + System.getProperty("file.separator");
            } else if (((String)object).length() == 2) {
                object = (String)object + System.getProperty("file.separator");
            }
            aSource.setSourcePath((String)object);
        } else {
            if (this.urlAddressField.getSelectedItem().toString().trim().length() == 0) {
                this.urlAddressField.requestFocus();
                AUtilities.showInfoMessage("Enter URL address to internet site");
                return false;
            }
            object = this.urlAddressField.getSelectedItem().toString().trim();
            if (((String)object).indexOf("://") == -1) {
                object = "http://" + (String)object;
            }
            this.tf.write("saveSettings()", 16, "Selected item:" + (String)object);
            this.tf.write("saveSettings()", 16, "item count:" + this.urlAddressField.getItemCount());
            String string = "";
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            while (n2 < this.urlAddressField.getItemCount()) {
                if (this.urlAddressField.getItemAt(n2).toString().trim().equals(object)) {
                    bl = true;
                    n = n2;
                }
                string = string + " " + this.urlAddressField.getItemAt(n2).toString().trim();
                this.tf.write("saveSettings()", 16, "temp:" + string + ", urlField:" + this.urlAddressField.getItemAt(n2).toString().trim());
                ++n2;
            }
            if (!bl) {
                aSource.setSourcePath((String)object + string);
            } else {
                this.urlAddressField.removeItemAt(n);
                this.urlAddressField.insertItemAt(object, 0);
                string = "";
                int n3 = 0;
                while (n3 < this.urlAddressField.getItemCount()) {
                    string = string + " " + this.urlAddressField.getItemAt(n3).toString().trim();
                    ++n3;
                }
                aSource.setSourcePath(string.trim());
            }
        }
        aSource.setSourceTitle(this.sourceTitleField.getText());
        aSource.setInternet(this.internetRadioButton.isSelected());
        return true;
    }

    private void enableLocalCD() {
        this.urlAddressLabel.setEnabled(false);
        this.urlAddressField.setEnabled(false);
        this.softcopyFilePathField.setEnabled(true);
        this.softcopyFilePathLabel.setEnabled(true);
        this.softcopyFilePathInfoLabel.setEnabled(true);
        this.softcopyBrowseButton.setEnabled(true);
        this.repaint();
    }

    private void enableInternet() {
        this.urlAddressLabel.setEnabled(true);
        this.urlAddressField.setEnabled(true);
        this.softcopyFilePathField.setEnabled(false);
        this.softcopyFilePathLabel.setEnabled(false);
        this.softcopyFilePathInfoLabel.setEnabled(false);
        this.softcopyBrowseButton.setEnabled(false);
        this.internetRadioButton.setSelected(true);
        if (this.urlAddressField.getItemCount() == 0) {
            this.urlAddressField.addItem("http://publib.boulder.ibm.com");
        }
        this.repaint();
    }

    private void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }
}

