/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

class ATraceWindow
extends ABaseInternalFrame
implements ActionListener {
    private String traceOnCommand = "traceOn";
    private String traceOffCommand = "traceOff";
    private String okayCommand = "okay";
    private String openCommand = "open";
    private String eraseCommand = "erase";
    private String cancelCommand = "cancel";
    private String browseCommand = "browse";
    private String toggleCommand = "toggle";
    private ATraceFile tf;
    private AMainWindow owner;
    private Container contentPane;
    private GridBagLayout gridbag;
    private GridBagConstraints c;
    private JLabel labelFileName;
    private JLabel labelWindowTitle;
    private JLabel labelIntro;
    private JLabel labelLevelList;
    private JTextField entryFileName;
    private ButtonGroup aButtonGroup;
    private JRadioButton radioButtonOn;
    private JRadioButton radioButtonOff;
    private JButton buttonBrowse;
    private JButton buttonOkay;
    private JButton buttonOpen;
    private JButton buttonErase;
    private JButton buttonCancel;
    private JPanel checkPanel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JCheckBox[] checkBoxLevel = new JCheckBox[32];
    private JMenuItem itemTrace;

    public void turnTracingOn() {
        this.radioButtonOn.setText("On.  Tracing is active.");
        this.radioButtonOff.setText("Off.  Stop tracing now.");
        ATraceFile.open(true);
    }

    public void turnTracingOff() {
        this.radioButtonOn.setText("On.  Start tracing now.");
        this.radioButtonOff.setText("Off.  Tracing is not active.");
        ATraceFile.close();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("actionPerformed()", 0, "entry");
        this.tf.write("actionPerformed()", 0, "Command is: \"" + actionEvent.getActionCommand() + "\"");
        String string = actionEvent.getActionCommand();
        if (string.equals(this.okayCommand)) {
            this.closeMe();
        } else if (string.equals(this.cancelCommand)) {
            this.closeMe();
        } else if (string.equals(this.openCommand)) {
            try {
                Runtime.getRuntime().exec("notepad " + ATraceFile.getTraceFileName());
            }
            catch (IOException iOException) {
                this.tf.write("actionPerformed()", 0, iOException.toString());
            }
        } else if (!string.equals(this.eraseCommand)) {
            if (string.equals(this.traceOnCommand)) {
                this.turnTracingOn();
            } else if (string.equals(this.traceOffCommand)) {
                this.turnTracingOff();
            } else if (string.equals(this.toggleCommand)) {
                Object object = actionEvent.getSource();
                int n = 1;
                while (n < 32) {
                    if (object == this.checkBoxLevel[n]) {
                        ATraceFile.setLevelActive(n, this.checkBoxLevel[n].isSelected());
                        break;
                    }
                    ++n;
                }
            }
        }
        this.tf.write("actionPerformed()", 0, "exit");
    }

    private void addToGrid(int n, int n2, Component component) {
        this.c.gridx = n;
        this.c.gridy = n2;
        this.gridbag.setConstraints(component, this.c);
        this.contentPane.add(component);
    }

    private void closeMe() {
        this.tf.write("closeMe()", 0, "entry");
        this.setVisible(false);
        this.dispose();
        this.tf.write("closeMe()", 0, "exit");
    }

    public ATraceWindow(AMainWindow aMainWindow, ATraceFile aTraceFile) {
        super("Trace Options", true, true, true, true);
        this.tf = aTraceFile;
        aTraceFile.write("ATraceWindow()", 0, "entry");
        this.owner = aMainWindow;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 600;
        int n2 = 480;
        this.labelWindowTitle = new JLabel("Trace Options");
        this.labelIntro = new JLabel("Use this window as instructed by IBM service personnel.");
        this.labelFileName = new JLabel("Trace file name:");
        this.labelLevelList = new JLabel("Select functions to trace");
        this.entryFileName = new JTextField(ATraceFile.getTraceFileName());
        this.entryFileName.setEditable(false);
        this.radioButtonOn = new JRadioButton();
        this.radioButtonOn.setActionCommand(this.traceOnCommand);
        this.radioButtonOn.addActionListener(this);
        this.radioButtonOff = new JRadioButton();
        this.radioButtonOff.setActionCommand(this.traceOffCommand);
        this.radioButtonOff.addActionListener(this);
        this.aButtonGroup = new ButtonGroup();
        this.aButtonGroup.add(this.radioButtonOn);
        this.aButtonGroup.add(this.radioButtonOff);
        this.buttonOkay = new JButton("OK");
        this.buttonOkay.setActionCommand(this.okayCommand);
        this.buttonOkay.addActionListener(this);
        this.buttonOpen = new JButton("Open");
        this.buttonOpen.setActionCommand(this.openCommand);
        this.buttonOpen.addActionListener(this);
        this.buttonErase = new JButton("Erase");
        this.buttonErase.setActionCommand(this.eraseCommand);
        this.buttonErase.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setActionCommand(this.cancelCommand);
        this.buttonCancel.addActionListener(this);
        this.buttonBrowse = new JButton("Browse");
        this.buttonBrowse.setActionCommand(this.browseCommand);
        this.buttonBrowse.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 10));
        this.buttonPanel.add(this.buttonOkay);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.buttonPanel.add(this.buttonOpen);
        this.checkPanel = new JPanel();
        this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 1));
        int n3 = 1;
        while (n3 < 32) {
            this.checkBoxLevel[n3] = new JCheckBox(ATraceFile.traceNames[n3]);
            this.checkBoxLevel[n3].setActionCommand(this.toggleCommand);
            this.checkBoxLevel[n3].addActionListener(this);
            if (ATraceFile.isLevelActive(n3)) {
                this.checkBoxLevel[n3].setSelected(true);
            }
            this.checkPanel.add(this.checkBoxLevel[n3]);
            ++n3;
        }
        this.scrollPane = new JScrollPane(this.checkPanel);
        this.scrollPane.setPreferredSize(new Dimension(300, 100));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(40);
        if (ATraceFile.isActive()) {
            this.radioButtonOn.setSelected(true);
            this.turnTracingOn();
        } else {
            this.radioButtonOff.setSelected(true);
            this.turnTracingOff();
        }
        this.contentPane = this.getContentPane();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.contentPane.setLayout(this.gridbag);
        Dimension dimension2 = new Dimension(10, 10);
        this.c.fill = 2;
        this.addToGrid(0, 0, new Box.Filler(dimension2, dimension2, dimension2));
        this.addToGrid(0, 1, new Box.Filler(dimension2, dimension2, dimension2));
        this.c.weightx = 1.0;
        this.c.gridwidth = 3;
        this.addToGrid(1, 1, this.labelIntro);
        this.addToGrid(1, 2, this.labelFileName);
        this.c.gridwidth = 1;
        this.addToGrid(1, 3, this.entryFileName);
        this.c.fill = 0;
        this.c.weightx = 0.0;
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 3;
        this.addToGrid(1, 4, this.radioButtonOn);
        this.addToGrid(1, 5, this.radioButtonOff);
        this.addToGrid(1, 6, this.labelLevelList);
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.addToGrid(1, 7, this.scrollPane);
        this.c.fill = 2;
        this.c.weighty = 0.0;
        this.addToGrid(1, 9, this.buttonPanel);
        this.addToGrid(4, 10, new Box.Filler(dimension2, dimension2, dimension2));
        this.contentPane.setBackground(this.radioButtonOn.getBackground());
        MyInternalFrameListener myInternalFrameListener = new MyInternalFrameListener();
        this.addInternalFrameListener(myInternalFrameListener);
        this.itemTrace = aMainWindow.getWindowMenu().add(new JMenuItem(this.getTitle()));
        this.itemTrace.addActionListener(aMainWindow);
        this.setDefaultCloseOperation(2);
        this.pack();
        aMainWindow.getDeskTopPane().add(this);
        this.setVisible(true);
        aTraceFile.write("ATraceWindow()", "exit");
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            ATraceWindow.this.owner.getWindowMenu().remove(ATraceWindow.this.itemTrace);
            ATraceWindow.this.tf.setTracePanelClosed();
        }
    }
}

