/*rexx                                                               */
/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* Format Windows Global Heap Info */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit

parse arg hsel

parse var hsel hsel ':' .

hoff=getwords(hsel':6',1)

range=whinfo(hsel':'hoff)

if wlhinfo(hsel':'hoff'+1e') then do
   say 'Local heap signature not valid'
   exit 0
end /* do */

parse var range curr last
curr=right(curr,4)
last=right(last,4)
quit=0=1
nextquit=0=1
address df 'cmd output dl' hsel
o=output.0-1
parse var output.o . 'Lim='lim .
segend=x2d(lim)+1

do until quit
   address df 'cmd output dw' hsel':'curr 'L5'
   o=output.0-1
   parse var output.o . w0 next hs w3 w4
   fl=bitand(x2c(w0),'0003'x)
   prev=lower(c2x(bitand(x2c(w0),'fffc'x)))
   if bitand(fl,'0001'x)='0000'x then do
      say '+'curr 'prev='prev 'next='next 'size='hs 'prev free='w3 'next free='w4 'free block'
   end /* do */
   else if bitand(fl,'0002'x)='0002'x then do
      address df 'cmd output dw' hsel':'hs 'L2'
      o=output.0-1
      parse var output.o . pd flgs .
      lc=left(flgs,2)
      uf=right(flgs,2)
      if bitand(x2c(uf),'40'x)='40'x then disc=', discarded'
      else disc=''
      if '#'next<>'#'curr then size=lower(d2x(x2d(next)-x2d(curr)))
      else size=lower(d2x(segend-x2d(curr)))
      size=right(size,4,'0')
      say '+'curr 'prev='prev 'next='next 'size='size 'hndl='hs 'pdata=+'pd 'lc='lc 'fl='uf 'in-use, movable'disc
   end /* do */
   else do
      pd=right(lower(d2x(x2d(curr)+4)),4,'0')
      if '#'next<>'#'curr then size=lower(d2x(x2d(next)-x2d(curr)))
      else size=lower(d2x(segend-x2d(curr)))
      size=right(size,4,'0')
      say '+'curr 'prev='prev 'next='next 'size='size 'pdata=+'pd 'in-use, fixed'
   end /* do */
   if nextquit then quit=0=0
   else if '#'next='#'last then nextquit=0=0
   curr=next
end /* do */

haltexit: exit 0

lower: procedure expose nothing
parse arg str
return translate(str,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')

getwords: procedure
arg address,length
address df "cmd output DW" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DW "address"+"i*2"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor


wininit: procedure expose nothing

address df 'cmd output .p#'
o=output.0-1
if pos('*vdm',output.o)=0 then do
   say 'Current thread slot is not a VDM'
   return 0=1
end  /* Do */

vdm_slot=substr(output.o,2,4)
init_slot=value('DF_WWINVDM',,'OS2ENVIRONMENT')
if 'x'init_slot='x'vdm_slot then do
   /* just need to reset to vars that change in case we are under the kdb */
   dsel=value('DF_WKDSEL',,'OS2ENVIRONMENT')
   address df 'cmd output dw #'dsel':220  l8' /* make sure we use protmode addressing */
   o=output.0-1
   parse var output.o . tp hp . ht ct .
   otp=value('DF_WTOPPDB',tp,'OS2ENVIRONMENT')
   ohp=value('DF_WHEADPDB',hp,'OS2ENVIRONMENT')
   oht=value('DF_WHEADTDB',ht,'OS2ENVIRONMENT')
   oct=value('DF_WCURTDB',ct,'OS2ENVIRONMENT')   /* bug fix - was DF_WHCURTDB */
   if '#'otp<>'#'tp | '#'ohp<>'#'hp | '#'oht<>'#'ht | '#'oct<>'#'ct then,
      t=value('DF_WDEFTDB',ct,'OS2ENVIRONMENT')
   return 0=0
end /* do */
else do
   say 'Searching for WINDOWS kernel data segment'
   found=0=1
   do i = 1 to 8192
      sel=d2x((i*8)+7)
      if i//64 = 0 then do
         say 'Kernel data segment not found before' sel'. Continuing search'
      end /* do */
      address df 'cmd output dl' sel 'l1'
      o=output.0-1
      if word(output.o,2)='Code' then do
         x=getwords('#'sel':0',1)
         if x='f4cc' then do
            dsel=right(d2x(((i+3)*8)+7),4,'0')
            if translate(getwords('#'sel':30',1))=dsel then do
               say 'Windows Kernel Data Segment selector:' dsel
               x=value('DF_WKDSEL',dsel,'OS2ENVIRONMENT')
               x=value('DF_WWINVDM',vdm_slot,'OS2ENVIRONMENT')
               found=0=0
               leave
            end  /* Do */
         end  /* Do */
      end  /* Do */
   end /* do */

   if found then return 0=1

   say 'Initialising global variables'
   dseg='#'dsel':218' /* set starting address */
   doff=0             /* set current offset from this address */

   x=winsetvar('hGlobalHeap','w')
   x=winsetvar('pGlobalHeap','w')
   x=winsetvar('hExeHead','w')
   x=winsetvar('hExeSweep','w')
   x=winsetvar('TopPDB','w')
   x=winsetvar('headPDB','w')
   x=winsetvar('topsizePDB','w')
   x=winsetvar('headTDB','w')
   x=winsetvar('curTDB','w')
   x=winsetvar('loadTDB','w')
   x=winsetvar('lockTDB','w')
   x=winsetvar('SelTableLen','w')
   x=winsetvar('SelTableStart','d')
   x=winsetvar('hBmDPMI','d')
   x=winsetvar('winVer','w')
   x=winsetvar('fwinx','w')
   x=winsetvar('f8087','w')
   x=winsetvar('PHTcount','w')
   x=winsetvar('hGDI','w')
   x=winsetvar('hUser','w')
   x=winsetvar('hShell','w')
   x=winsetvar('flMDepth','w')
   x=winsetvar('wdefrip','w')
   x=winsetvar('num_tasks','b')
   x=winsetvar('InScheduler','b')
   x=winsetvar('graphics','b')
   /* spare byte */
   doff=doff+1
   x=winsetvar('fastfp','b')
   x=winsetvar('MaxCodeSwapArea','w')
   x=winsetvar('SelLowHeap','w')
   x=winsetvar('cpLowHeap','w')
   x=winsetvar('SelHighHeap','w')
   x=winsetvar('SelWoaPDB','w')
   x=winsetvar('sel_alias_array','w')
   x=winsetvar('temp_sel','w')
   x=winsetvar('dressed_for_success','D')
   x=winsetvar('InDos','d')
   x=winsetvar('pSftLink','d')
   x=winsetvar('lpWinSftLink','d')
   x=winsetvar('pFileTable','d')
   x=winsetvar('FileEntrySize','w')
   x=winsetvar('curDTA','d')
   x=winsetvar('cur_dos_PDB','w')
   x=winsetvar('Win_PDB','w')
   x=winsetvar('cur_drive_owner','w')
   x=winsetvar('fBreak','b')
   x=winsetvar('LastDriveSwapped','b')
   x=winsetvar('DOS_version','b')
   x=winsetvar('DOS_revision','b')
   x=winsetvar('fInt21','b')
   x=winsetvar('fNovell','b')
   x=winsetvar('fPadCode','b')
   x=winsetvar('CurDOSDrive','b')
   x=winsetvar('DOSDrives','b')

   t=value('DF_WCURTDB',,'OS2ENVIRONMENT')
   t=value('DF_WDEFTDB',t,'OS2ENVIRONMENT')

end /* do */

return 0=0

winsetvar: procedure expose dseg doff dsel
arg vname,type
type=translate(type)
if type='B' then do
   x=getbytes(dseg'+'doff't',1)
   doff=doff+1
end  /* Do */
else if type ='W' then do
   x=getwords(dseg'+'doff't',1)
   doff=doff+2
end  /* Do */
else if type ='D' then do
   x=getdwords(dseg'+'doff't',1)
   doff=doff+4
end  /* Do */
y=value('DF_W'vname,x,'OS2ENVIRONMENT')

return 0

getbytes: procedure
arg address,length
address df "cmd output DB" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DB "address"+"i"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor


getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor



whinfo: procedure
parse arg phi .

say ' '
say 'Heap info at' phi
address df 'cmd output dw' phi 'L 0f'

o=output.0-2
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+00 Check                       ' w0
say '+02 Freeze                      ' w1
say '+04 Total heap blocks           ' w2
say '+06 First Arena                 ' w4||w3
say '+0a Last Arena                  ' w6||w5
say '+0e Compactions                 ' right(w7,2)
say '+0f Discard level               ' left(w7,2)
first=w4||w3
last=w6||w5
o=o+1
parse var output.o addr w0 w1 w2 w3 .
say '+10 Number of bytes to discard  ' w1||w0
say '+14 Ptr to local handle table   ' w2
say '+16 Ptr to local free handle tbl' w3
say '+18 Handle delta                ' w4
say '+1a Ptr to Kernel Expand routine' w5
say '+1c Ptr to Local Stats          ' w6

return first last

wlhinfo: procedure
parse arg plhi .
say ' '
say 'Local heap info at' plhi
address df 'cmd output dw' plhi 'L6'

o=output.0-1
parse var output.o addr w0 w1 w2 w3 w4 w5 w6 w7 .
say '+00 Notify routine              ' w1':'w0
say '+04 Lock count                  ' w2
say '+06 Expansion delta             ' w3
say '+08 Minimum size                ' w4
say '+0a Signature (LH)              ' w5
return w5='484c'
