/*                                                                   */
/* (C) Copyright IBM Corp. 1993                                       */
/* (C) Copyright IBM Information Solutions 1993                       */
/*                                                                    */
/* search for all PM WND/MQ/CLS structures */
/* 9/5/97 fixed possible acidental exponential comparison */

signal on halt name haltexit
numeric digits 18
trace 'o'

arg parms

args=''
opts=''
do while parms<>''
   parse var parms parm parms
   if left(parm,1)='/' then opts=opts||substr(parm,2)
   else args=args parm
end /* do */

if pos('?',opts)>0 | word(args,1)='?' then do
   call helpmsg
   exit 0
end /* do */

if words(args)>0 then do
   say 'Invalid parameters'
   call helpmsg
   exit 0
end /* do */

fcls=0=1
fmq=0=1

if pos('C',opts)>0 then fcls=0=0
if pos('Q',opts)>0 then fmq=0=0

pmver=pmver()

/* Now enumerate the desktop window tree */

address df 'cmd output dd %(dw(phandletable))+28 L1'
o=output.0-1
pwnd=word(output.o,2)

say 'Desktop window tree'
say ''
call wndtree(pwnd)
say ''

/* Now enumerate the object window tree */

address df 'cmd output dd %(dw(phandletable))+30 L1'
o=output.0-1
pwnd=word(output.o,2)

say 'Object window tree'
say ''
call wndtree(pwnd)

/* done! */

haltexit: exit 0


wndtree: procedure expose fcls fmq pmver
parse arg pwnd
nc=fmtwnd(pwnd)
parse var nc next child .
do while ('x'next<>'x00000000')
   next=nextwnd(next)
end /* do */
if 'x'child<>'x00000000' then call wndtree(child)
return

nextwnd: procedure expose uheap tdbowner. fcls fmq pmver
parse arg pwnd
nc=fmtwnd(pwnd)
parse var nc next child .
if 'x'child<>'x00000000' then call wndtree(child)
return next

fmtwnd:procedure expose fcls fmq pmver
parse arg pwnd
address df 'cmd output dd %'pwnd 'l18'
o=output.0-6
parse var output.o . nx pa ch ow .
o=o+2
parse var output.o . cl . mq hwnd .
o=o+1
parse var output.o . b16 wp tp wn .
if '#'b16<>'#00000000' then wp=left(wp,4)':'right(wp,4)
say 'pwnd='pwnd 'hwnd='hwnd 'Next='nx 'Parent='pa 'Child='ch 'Owner='ow 'pmq='mq 'Proc='wp
if fmq then do
   if '#'pmver='#00000084' then call fmtmq mq
   else if '#'pmver='#00000080' then call fmtmq1 mq
   else say 'PM version not supported'
end /* do */
if fcls then do while 'x'cl<>'x00000000'
   cl=fmtcls(cl)
end /* do */
return nx ch

fmtcls: procedure expose fcls fmq pmver
parse arg cls
address df 'cmd output dd %'cls 'l0b'
o=output.0-3
parse var output.o . nx .
o=o+1
parse var output.o addr  . b16 wp .
o=o+1
parse var output.o addr  pnm .

if '#'b16<>'#00000000' then wp=left(wp,4)':'right(wp,4)
else wp='%'wp
if '#'pnm<>'#00000000' then do
   address df 'cmd out da %'pnm
   p=out.0-1
   name='mod='word(out.p,2)
end /* do */
else name=''

say '   pCls='cls 'Next='nx 'Proc='wp name
return nx

fmtmq: procedure expose fcls fmq pmver
parse arg pmq

address df 'cmd output dd %'pmq 'L2c'
o=output.0-11
parse var output.o addr nx mq .
mq=left(mq,4)
o=o+4
parse var output.o addr .  sq rq .
o=o+5
parse var output.o addr .  . . rl .
o=o+1
parse var output.o addr .  tk .
tk=right(tk,4)
if '#'tk<>'#0000' then do
   address df 'cmd output .p' tk
   o=output.0-1
   owner=word(output.o,13)
end /* do */
else owner=''
say '   pmq='pmq 'Next='nx 'Slot='tk 'QMsgs='mq 'SentSms='sq 'CurrSms='rq 'RcvSms='rl owner
return

fmtmq1: procedure expose fcls fmq pmver
parse arg pmq

address df 'cmd output dd %'pmq 'L29'
o=output.0-11
parse var output.o addr nx . mq .
o=o+3
parse var output.o addr . . . sq .
o=o+1
parse var output.o addr rq .
o=o+5
parse var output.o addr . . rl .
o=o+1
parse var output.o addr tk .
tk=right(tk,4)
if '#'tk<>'#0000' then do
   address df 'cmd output .p' tk
   o=output.0-1
   owner=word(output.o,13)
end /* do */
else owner=''
say '   pmq='pmq 'Next='nx 'Slot='tk 'QMsgs='mq 'SentSms='sq 'CurrSms='rq 'RcvSms='rl owner
return

helpmsg: procedure

say " List the entire 32-bit PM Window Strcuture Tree"
say " Optionally format each Message Queue for each Window"
say " Optionally format the Class List for each Window"
say " "
say " Syntax:"
say " %WNDLST <options>"
say ""
say " where:"
say "          <options> may be any of the following:"
say ""
say "                    /c - format the Class List for each Window"
say "                    /q - format the Message Queue header for each Window"
say ""
return

getdwords: procedure
arg address,length
address df "cmd output DD" address "L1"
o=output.0-1
parse var output.o . stor .

do i=1 to length-1
   address df "cmd output DD "address"+"i*4"t L1"
   o=output.0-1
   stor=stor word(output.o,2)
end /* do */
return stor


pmver: procedure
magic_offset=value('DF_PMVER',,'OS2ENVIRONMENT')
say 'Warning: PMMERGE symbols assumed and current slot is a PM thread/app.'
say ''
if magic_offset='' then do
   address df "cmd output s %(dw(pmqshell)) l100 'S' 'T' "
   o=output.0-1
   magic=word(output.o,1)
   address df 'cmd output ?' magic '- %(dw(pmqshell))'
   o=output.0-1
   magic_offset=substr(output.o,2)
   x=value('DF_PMVER',magic_offset,'OS2ENVIRONMENT')
end
return magic_offset
