/*****************************************************************************/
/*            (C) Copyright IBM Corp 1996; All rights reserved.              */
/*****************************************************************************/
/* REXX cmd file to restore SYSLEVEL.MPM to correct vlalues for various      */
/* versions of OS/2 Warp.                                                    */
/*                                                                           */
/* Do the following:                                                         */
/* 1. Verify SYSLEVEL.OS2 and SYSLEVEL.MPM both exist.                       */
/* 2. Locate MMPM via SET MMBASE= entry in CONFIG.SYS. If not found exit,    */
/*    nothing to do.                                                         */
/* 3. Get CSD level, COMPID and VERSION from SYSLEVEL.OS2 in the             */
/*    \OS2\INSTALL directory of the boot drive.                              */
/* 4. Get same from SYSLEVEL.MPM pointed to by SET MMBASE= in CONFIG.SYS     */
/* 5. If any value does not match, backup existing SYSLEVEL.MPM as           */
/*    SYSLGA.MPM (if it exists then DO NOT backup).                          */
/* 6. Update SYSLEVEL.MPM with data from SYSLEVEL.OS2 file.                  */
/* 7. Write out new SYSLEVEL.MPM file.                                       */
/*                                                                           */
/* For XR?3000, COMPID of 562137400 is correct for MMPM even though different*/
/* from SYSLEVEL.OS2 value. Was a separate product at that time.             */
/*                                                                           */
/* Preserve the R/O attribute if it is on for the current file.              */
/*                                                                           */
/* Remove restriction on running on a US system so will correct bad Current  */
/* CSD level of SYSLEVEL.MPM for Warp Server SMP (US).                       */
/* ========================================================================= */
/* 178799  - fix update of type filed                                        */
/*         - fix update of version field                                     */
/* 6/11/97 - use different method to find boot drive                         */
/* 9/12/97 - Copy Syslevel Version, System ID and System Edition fields      */
/* 10/23/98- Copy Syslevel Prior CSD level - F.138B and later fixtool chg    */
/*****************************************************************************/
'@Echo off'
ver='1.3 October 23, 1998'
Parse Source . . me .
me=Filespec('NAME',me)
Say me ver

/*****************************************************************************/
/* Register all REXXUTIL functions                                           */
/*****************************************************************************/
rc=RxFuncAdd('SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs')
If rc>1 then
  Do
    Say 'Unable to register REXXUTIL functions, cannot continue.'
    Signal Done
  End
Call SysLoadFuncs

Arg dts .                      /* Target drive to check if other than boot */
If Wordpos(dts,'? /? -?')>0 Then
  Signal Tell
If dts='' Then
  Do
    /*******************/
    /* Find boot drive */
    /*******************/
    Parse Upper Value Value('PATH',,'OS2ENVIRONMENT') With '\OS2\SYSTEM' -2 boot +2
    If boot='' | Length(boot)<>2 | Right(boot,1)<>':' Then
      Do
        Say 'Unable to locate your boot drive based on the location of \OS2\SYSTEM'
        Say 'in your PATH statement in CONFIG.SYS.'
        Signal Done
      End
    Say 'Boot drive is 'boot
  End
Else
  If Length(dts)<>2 | Right(dts,1)<>':' Then
    Signal Tell
  Else
    Do
      boot=dts
      Say 'Target drive is 'boot
    End

/***********************************************/
/* Locate MMBASE via SET MMBASE= in config.sys */
/***********************************************/
mmos2=''
chk='SET MMBASE='
cfg=boot||'\config.sys'
Call Stream cfg,'C','Open Read'
Do While Lines(cfg)
  line=space(strip(translate(linein(cfg)),'B'),1)
  If Substr(line,1,Length(chk))=chk Then
    Do
      Parse Value line With . 'MMBASE='mmos2 .
      Leave
    End
End
Call Stream cfg,'C','Close'
If mmos2='' then
  Do
    Say 'Multimedia is not installed on 'boot', nothing To Do.'
    Signal Done
  End
If right(mmos2,1)=';' then
  mmos2=left(mmos2,length(mmos2)-1)
Say 'Multimedia is installed in 'mmos2

/*************************************************/
/* Make sure SYSLEVEL files exist and are valid. */
/*************************************************/
os2file=boot||'\OS2\INSTALL\SYSLEVEL.OS2'
mpmfile=mmos2||'\INSTALL\SYSLEVEL.MPM'
Parse value 0 0 with os2found mpmfound .
If stream(os2file,'c','Query Exists')='' then
  Say os2file' not found, required.'
Else
  os2found=1
If stream(mpmfile,'c','Query Exists')='' then
  Say mpmfile' not found, required.'
Else
  mpmfound=1
If os2found+mpmfound<>2 then
  Signal Done

/****************************************/
/* Read SYSLEVEL.OS2 into rexx variable */
/****************************************/
Say
Say 'Checking 'os2file
sig='FFFF'x||'SYSLEVEL'                              /* SYSLEVEL signature */
size=stream(os2file,'C','Query Size')
Call stream os2file,'C','Open Read'
os2line=charin(os2file,1,size)
Call stream os2file,'C','Close'
If left(os2line,10)<>sig then
  Do
    Say os2file' is not a valid SYSLEVEL file.'
    Say 'Does not start with "FFFFSYSLEVEL" (FFFF is HEX).'
    Signal Done
  End
os2sv =substr(os2line,16,2)                            /* Syslevel Version */
os2sid=substr(os2line,38,2)                                   /* System ID */
os2sed=substr(os2line,40,1)                              /* System Edition */
os2ver=substr(os2line,41,1)                              /* Version in hex */
os2mod=substr(os2line,42,1)                               /* Modify in hex */
os2csd=substr(os2line,45,8)                           /* Current CSD level */
os2psd=substr(os2line,53,8)                             /* Prior CSD level */
os2cid=substr(os2line,141,9)                                     /* COMPID */
os2ref=substr(os2line,150,1)                             /* Refresh in hex */
os2typ=substr(os2line,151,9)                                       /* Type */
Say '  CSD Current: 'os2csd' Prior: 'os2psd' COMPID: 'os2cid' Type: 'strip(translate(os2typ,' ','00'x))
Say '  Version: 'c2x(os2ver) 'Modify: 'c2x(os2mod) 'Refresh: 'c2x(os2ref)
Say '  Syslevel Version: 'c2x(os2sv)' System ID: 'c2x(os2sid)' System Edition: 'c2x(os2sed)

/****************************************/
/* Read SYSLEVEL.MPM into rexx variable */
/****************************************/
Say
Say 'Checking 'mpmfile
mpmsave=mmos2||'\INSTALL\SYSLGA.MPM'
size=stream(mpmfile,'C','Query Size')
Call stream mpmfile,'C','Open Read'
mpmline=charin(mpmfile,1,size)
Call stream mpmfile,'C','Close'
If left(mpmline,10)<>sig then
  Do
    Say mpmfile' is not a valid SYSLEVEL file.'
    Say 'Does not start with "FFFFSYSLEVEL" (FFFF is HEX).'
    Signal Done
  End
mpmsv =substr(mpmline,16,2)                            /* Syslevel Version */
mpmsid=substr(mpmline,38,2)                                   /* System ID */
mpmsed=substr(mpmline,40,1)                              /* System Edition */
mpmver=substr(mpmline,41,1)                               /* Modify in hex */
mpmmod=substr(mpmline,42,1)                              /* Version in hex */
mpmcsd=substr(mpmline,45,8)                           /* Current CSD level */
mpmpsd=substr(mpmline,53,8)                             /* Prior CSD level */
mpmcid=substr(mpmline,141,9)                                     /* COMPID */
mpmref=substr(mpmline,150,1)                             /* Refresh in hex */
mpmtyp=substr(mpmline,151,9)                                       /* Type */
Say '  CSD Current: 'mpmcsd' Prior: 'mpmpsd' COMPID: 'mpmcid' Type: 'strip(translate(mpmtyp,' ','00'x))
Say '  Version: 'c2x(mpmver) 'Modify: 'c2x(mpmmod) 'Refresh: 'c2x(mpmref)
Say '  Syslevel Version: 'c2x(mpmsv)' System ID: 'c2x(mpmsid)' System Edition: 'c2x(mpmsed)

/********************************************************/
/* Compare all above MPM fields against OS/2 fields.    */
/* For CSD XR?3000, COMPID of 562137400 is correct even */
/* though different from SYSLEVEL.OS2 value.            */
/********************************************************/
update=0                                             /* No update done yet */
cid3000='562137400'                             /* MMPM COMPID for Warp GA */
If os2sv=mpmsv & os2sid=mpmsid & os2sed=mpmsed,
 & os2csd=mpmcsd & os2psd=mpmpsd & os2ver=mpmver & os2mod=mpmmod,
 & os2ref=mpmref & os2typ=mpmtyp,
 & (os2cid=mpmcid | ((substr(os2csd,4,4)='3000'|substr(os2psd,4,4)='3000')&mpmcid=cid3000)) Then
  Do
    Say
    Say 'All values correct, update not required.'
    Signal Done
  End

/******************************************/
/* One or more of the values is different */
/******************************************/
Say
Say 'Mismatch, update required'
If os2sv<>mpmsv Then                         /* Syslevel Version mismatch? */
  mpmline=overlay(os2sv,mpmline,16,2)
If os2sid<>mpmsid Then                              /* System ID mismatch? */
  mpmline=overlay(os2sid,mpmline,38,2)
If os2sed<>mpmsid Then                         /* System Edition mismatch? */
  mpmline=overlay(os2sed,mpmline,40,1)
If os2ver<>mpmver Then                                /* Version mismatch? */
  mpmline=overlay(os2ver,mpmline,41,1)
If os2mod<>mpmmod Then                                 /* Modify mismatch? */
  mpmline=overlay(os2mod,mpmline,42,1)
If os2csd<>mpmcsd Then                      /* Current CSD level mismatch? */
  mpmline=overlay(os2csd,mpmline,45,8)
If os2psd<>mpmpsd Then                        /* Prior CSD level mismatch? */
  mpmline=overlay(os2psd,mpmline,53,8)
If os2cid<>mpmcid then                                 /* COMPID mismatch? */
  If Substr(os2csd,4,4)='3000'|substr(os2psd,4,4)='3000' Then  /* Warp GA? */
    mpmline=overlay(cid3000,mpmline,141,9)
  Else                                                               /* No */
    mpmline=overlay(os2cid,mpmline,141,9)
If os2ref<>mpmref Then                                /* Refresh mismatch? */
  mpmline=overlay(os2ref,mpmline,150,1)
If os2typ<>mpmtyp then                                   /* Type mismatch? */
  mpmline=overlay(os2typ,mpmline,151,9)

/****************************************************/
/* If we get here then we changed some value in the */
/* SYSLEVEL.MPM data so need to backup the file and */
/* create a new one with the updated data. Don't    */
/* overlay existing backup if it exists.            */
/****************************************************/
mpmsv =substr(mpmline,16,2)                            /* Syslevel Version */
mpmsid=substr(mpmline,38,2)                                   /* System ID */
mpmsed=substr(mpmline,40,1)                              /* System Edition */
mpmver=substr(mpmline,41,1)                               /* Modify in hex */
mpmmod=substr(mpmline,42,1)                              /* Version in hex */
mpmcsd=substr(mpmline,45,8)                           /* Current CSD level */
mpmpsd=substr(mpmline,53,8)                             /* Prior CSD level */
mpmcid=substr(mpmline,141,9)                                     /* COMPID */
mpmref=substr(mpmline,150,1)                             /* Refresh in hex */
mpmtyp=substr(mpmline,151,9)                                       /* Type */
Say 'New' mpmfile
Say '  CSD Current: 'mpmcsd' Prior: 'mpmpsd' COMPID: 'mpmcid' Type: 'strip(translate(mpmtyp,' ','00'x))
Say '  Version: 'c2x(mpmver) 'Modify: 'c2x(mpmmod) 'Refresh: 'c2x(mpmref)
Say '  Syslevel Version: 'c2x(mpmsv)' System ID: 'c2x(mpmsid)' System Edition: 'c2x(mpmsed)

saved=0
If Stream(mpmsave,'C','Query Exists')='' then/* Backup file already exist? */
  Do
    '@COPY 'mpmfile mpmsave' > NUL'                 /* No, back it up then */
    saved=1
  End
Call SysFileTree mpmfile,'SFILE','F'                     /* Get file specs */
Parse value sfile.1 with . . . atts .                   /* Just attributes */
mpmro=pos('R',atts)>0 then                            /* Get Read Only bit */
If mpmro then                                               /* Was it set? */
  '@ATTRIB -R' mpmfile                       /* Yes, turn of so can delete */
'@DEL 'mpmfile' >NUL'
Call Stream mpmfile,'C','Open Write'
Call charout mpmfile,mpmline                         /* Write updated file */
Call Stream mpmfile,'C','Close'
If mpmro then                              /* Turn on R/O bit if on before */
  'ATTRIB +R' mpmfile

Say
Say mpmfile' update complete.'
If saved then
  Say 'Original 'mpmfile' saved as 'mpmsave'.'
Else
  Say 'Original 'mpmfile' previously saved as 'mpmsave'.'

/*******************************/
/* Only exit from this program */
/*******************************/
Done:
Exit

Tell:
Say 'Form: SYSZMPM <x:>'
Say
Say 'Where x: is an optional parameter that specifies the OS/2 bootable drive'
Say 'to work with. If not specified, this defaults to the currently booted'
Say 'drive.'
Say
Say 'Updates fields in SYSLEVEL.MPM with fields from SYSLEVEL.OS2 for the'
Say 'target drive to correct the invalid SYSLEVEL.MPM files.'
Say
Say 'The fields checked are Syslevel Version, System ID, System Edition,'
Say 'Modify, Version, Current CSD level, Prior CSD level, COMPID, Refesh,'
Say 'and Type.'
Signal Done
