/*****************************************************************/
/**             Microsoft LAN Manager                            */
/**     Copyright(c) Microsoft Corp., 1987-1990                  */
/**        Copyright(C) IBM Corp. 1994                           */
/**                                                              */
/*****************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  MESSAGE.H                                  *
 *                                                                  *
 *  This file contains information about the NetMessage APIs.       *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/

/***************************************************************************/
/**   Testing History:                                                     */
/**      Unit Test: date by                                                */
/**      Reviewed:  date by                                                */
/**                                                                        */
/**  Flag Change Fixer Date     Tester Date     Review Date                */
/**  ---- ------ ----- -------- ------ -------- ------ --------            */
/**  @f01 f2359  mbbjr 93Oct09                                             */
/**   Provide 32-bit entry points; char all 'char' to UCHAR                */
/**  @d01 D06991 MBB   94Apr09                                             */
/**   Declare all 32-bit functions as API32_FUNCTION                       */
/**  @f01 F05438 MBB   94Aug08                                             */
/**   Make .h files compatible with C++                                    */
/**                                                                        */
/***************************************************************************/

/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETMESSAGE_INCLUDED

#define NETMESSAGE_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetMessageBufferSend ( const unsigned char LSFAR * pszServer,
                         unsigned char LSFAR *       pszRecipient,
                         unsigned char LSFAR *       pbBuffer,
                         unsigned short              cbBuffer );

extern API_FUNCTION
  NetMessageFileSend ( const unsigned char LSFAR * pszServer,
                       unsigned char LSFAR *       pszRecipient,
                       unsigned char LSFAR *       pszFileSpec );

extern API_FUNCTION
  NetMessageLogFileGet ( const unsigned char LSFAR * pszServer,
                         unsigned char LSFAR *       pbBuffer,
                         unsigned short      cbBuffer,
                         short LSFAR *       pfsEnabled );

extern API_FUNCTION
  NetMessageLogFileSet ( const unsigned char LSFAR * pszServer,
                         unsigned char LSFAR *       pszFileSpec,
                         short               fsEnabled );

extern API_FUNCTION
  NetMessageNameAdd ( const unsigned char LSFAR * pszServer,
                      const unsigned char LSFAR * pszMessageName,
                      short               fsFwdAction );

extern API_FUNCTION
  NetMessageNameDel ( const unsigned char LSFAR * pszServer,
                      const unsigned char LSFAR * pszMessageName,
                      short               fsFwdAction );

extern API_FUNCTION
  NetMessageNameEnum ( const unsigned char LSFAR *     pszServer,
                       short                   sLevel,
                       unsigned char LSFAR *           pbBuffer,
                       unsigned short         cbBuffer,
                       unsigned short LSFAR * pcEntriesRead,
                       unsigned short LSFAR * pcTotalAvail );

extern API_FUNCTION
  NetMessageNameGetInfo ( const unsigned char LSFAR *     pszServer,
                          const unsigned char LSFAR *     pszMessageName,
                          short                   sLevel,
                          unsigned char LSFAR *           pbBuffer,
                          unsigned short          cbBuffer,
                          unsigned short LSFAR *  pcbTotalAvail );

extern API_FUNCTION
  NetMessageNameFwd ( const unsigned char LSFAR * pszServer,
                      const unsigned char LSFAR * pszMessageName,
                      const unsigned char LSFAR * pszForwardName,
                      short               fsDelFwdName );

extern API_FUNCTION
  NetMessageNameUnFwd ( const unsigned char LSFAR * pszServer,
                        const unsigned char LSFAR * pszMessageName );


/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/

struct msg_info_0 {
    unsigned char       msgi0_name[CNLEN + 1];
};      /* msg_info_0 */

struct msg_info_1 {
    unsigned char       msgi1_name[CNLEN + 1];
    unsigned char       msgi1_forward_flag;
    unsigned char       msgi1_pad1;
/**INTERNAL_ONLY**/
/*NOINC*/
#if (((CNLEN+1+1)%2) == 0)
# error  "PAD BYTE NOT NEEDED"
#endif
/*INC*/
/**END_INTERNAL**/
    unsigned char       msgi1_forward[CNLEN + 1];
};      /* msg_info_1 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK  /* Define PURE_32 temporarily */
#define PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *            for "pure" 32-bit code                            *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
  Net32MessageBufferSend ( const unsigned char  * pszServer,
                           unsigned char* pszRecipient,
                           unsigned char* pbBuffer,
                           unsigned long  ulBuffer );   /* was USHORT */

extern API32_FUNCTION
  Net32MessageFileSend ( const unsigned char* pszServer,
                         unsigned char      * pszRecipient,
                         unsigned char      * pszFileSpec );

extern API32_FUNCTION
  Net32MessageLogFileGet ( const unsigned char    * pszServer,
                           unsigned char  * pbBuffer,
                           unsigned long    ulBuffer,     /* was USHORT */
                           unsigned long  * pfsEnabled ); /* was signed short */

extern API32_FUNCTION
  Net32MessageLogFileSet ( const unsigned char    * pszServer,
                           unsigned char  * pszFileSpec,
                           unsigned long    fsEnabled );  /* was signed short */

extern API32_FUNCTION
  Net32MessageNameAdd ( const unsigned char    * pszServer,
                        const unsigned char    * pszMessageName,
                        unsigned long    fsFwdAction );    /* was signed short*/

extern API32_FUNCTION
  Net32MessageNameDel ( const unsigned char    * pszServer,
                        const unsigned char    * pszMessageName,
                        unsigned long    fsFwdAction );    /*was signed short */

extern API32_FUNCTION
  Net32MessageNameEnum ( const unsigned char    * pszServer,
                         unsigned long    ulLevel,        /*was signed short*/
                         unsigned char  * pbBuffer,
                         unsigned long    ulBuffer,       /* was USHORT */
                         unsigned long  * pulEntriesRead, /* was USHORT */
                         unsigned long  * pulTotalAvail); /* was USHORT */

extern API32_FUNCTION
  Net32MessageNameGetInfo ( const unsigned char    * pszServer,
                            const unsigned char    * pszMessageName,
                            unsigned long    ulLevel,       /*was signed short*/
                            unsigned char  * pbBuffer,
                            unsigned long    ulBuffer,       /* was USHORT */
                            unsigned long  * pulTotalAvail); /* was USHORT */

extern API32_FUNCTION
  Net32MessageNameFwd ( const unsigned char   * pszServer,
                        const unsigned char   * pszMessageName,
                        const unsigned char   * pszForwardName,
                        unsigned long   fsDelFwdName );  /* was short */

extern API32_FUNCTION
  Net32MessageNameUnFwd ( const unsigned char* pszServer,
                          const unsigned char* pszMessageName );
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK   /* Undefine PURE_32; no data structures to pick up */
#undef PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/

/**INTERNAL_ONLY**/
#define MSGLOGFILE_NAME "MESSAGES.LOG"
/**END_INTERNAL**/

/*
 *      Values for msgi1_forward_flag.
 */

#define MSGNAME_NOT_FORWARDED   0       /* Name not forwarded */
#define MSGNAME_FORWARDED_TO    0x04    /* Name forward to remote station */
#define MSGNAME_FORWARDED_FROM  0x10    /* Name forwarded from remote station */


/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif

#endif /* NETMESSAGE_INCLUDED */
/*INC*/
