
/*
 * This file was generated by the SOM Compiler.
 * FileName: om.h.
 * Generated using:
 *     SOM Precompiler somipc: 2.29.1.17
 *     SOM Emitter emith: 2.47
 */

/*
 *    IDL interface spec for generic Object Manager.
 * 
 *    The Object Manager (abstract) class provides a uniform abstraction
 *    for various sorts of object managers.  Object Request Brokers, persistent
 *    storage managers, and OODBMSs are examples of object managers.
 * 
 *    This is an abstract base class, which defines the "core" interface for
 *    an object manager.  The basic groups of methods are:
 * 
 *  	- object creation (basic)
 *  	- object identification & location/activation
 *  	- object release & destruction
 * 
 *    If a desired object cannot be mapped into the client's address space, the
 *    object manager is responsible for building a local "proxy" for the remote
 *    object.  The client invokes methods on the proxy, and the proxy should
 *    redispatch the requests to the remote object in an appropriate and
 *    transparent way.
 * 
 *    NOTE: Since this is only intended to be an abstract base class, there
 *    is no underlying implementation, and ObjectMgr objects should not actually
 *    be instantiated.
 * 
 */


#ifndef SOM_ObjectMgr_h
#define SOM_ObjectMgr_h


#include <som.h>

/*
 * -- This emitter treats Method Tokens as Thunks by default.
 * -- Use the sc modifier "nothunks" to change this default
 */
#undef somresolve_
#define somresolve_(obj,mToken) ((somMethodProc*)((void)obj, mToken))

/*
 * Define the class name as an object type
 */
#ifndef ObjectMgr
#define ObjectMgr SOMObject
#endif
/*
 *  methods for creation
 */
#include <somobj.h>

/*
 * Start of bindings for IDL types
 */

#ifndef SOMClass
    #define SOMClass SOMObject
#endif /* SOMClass */
#ifndef Container
    #define Container SOMObject
#endif /* Container */

/*
 * End of bindings for IDL types.
 */

#define ObjectMgr_MajorVersion 2
#define ObjectMgr_MinorVersion 1

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define ObjectMgrNewClass c
#pragma linkage(c, system)
#define ObjectMgrClassData d
#define ObjectMgrCClassData x
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */

/*
 * Include the metaclass file
 */
#ifndef SOM_SOMMSingleInstance_h
#include <snglicls.h>
#endif
/*--------------Migration------------*/
#define ObjectMgr_classObj ObjectMgrClassData.classObject
#define _ObjectMgr ObjectMgr_classObj

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMClass * SOMLINK ObjectMgrNewClass(integer4 somtmajorVersion,
		integer4 somtminorVersion);
#pragma linkage(ObjectMgrNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct ObjectMgrClassDataStructure {
	SOMClass *classObject;
	somMToken somdNewObject;
	somMToken somdGetIdFromObject;
	somMToken somdGetObjectFromId;
	somMToken somdReleaseObject;
	somMToken somdDestroyObject;
} SOMDLINK ObjectMgrClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct ObjectMgrCClassDataStructure {
	somMethodTabs parentMtab;
	somDToken instanceDataToken;
} SOMDLINK ObjectMgrCClassData;

/*
 * New and Renew macros for ObjectMgr
 */
#define ObjectMgrNew() \
   ( _ObjectMgr ? \
	_somNew(_ObjectMgr) \
	: ( ObjectMgrNewClass(\
		ObjectMgr_MajorVersion, \
		ObjectMgr_MinorVersion),\
	   _somNew(_ObjectMgr)))
#define ObjectMgrRenew(buf) \
   ( _ObjectMgr ? \
	_somRenew(_ObjectMgr, buf) \
	: ( ObjectMgrNewClass(\
		ObjectMgr_MajorVersion, \
		ObjectMgr_MinorVersion),\
	   _somRenew(_ObjectMgr, buf)))

/*
 * New Method: somdNewObject
 */
typedef SOMObject*   SOMLINK somTP_ObjectMgr_somdNewObject(ObjectMgr *somSelf, Environment *ev, 
		Identifier objclass, 
		string hints);
#pragma linkage(somTP_ObjectMgr_somdNewObject, system)
typedef somTP_ObjectMgr_somdNewObject *somTD_ObjectMgr_somdNewObject;
/*
 *  Returns a new object of the named class.  This is a "basic" creation
 *  method, where the decisions about where and how to create the object
 *  are mostly left up to the Object Manager.  However, the Object Manager
 *  may optionally define creation "hints" which the client may specify in
 *  this call.
 * 
 *  OWNERSHIP of returned object is transferred to the caller.
 *  methods for identification & location/activation
 */
#define somMD_ObjectMgr_somdNewObject "::ObjectMgr::somdNewObject"
#define ObjectMgr_somdNewObject(somSelf,ev,objclass,hints) \
    (SOM_Resolve(somSelf, ObjectMgr, somdNewObject) \
	(somSelf,ev,objclass,hints))
#ifndef SOMGD_somdNewObject
    #if (defined(_somdNewObject) || defined(__somdNewObject))
        #undef _somdNewObject
        #undef __somdNewObject
        #define SOMGD_somdNewObject 1
    #else
        #define _somdNewObject ObjectMgr_somdNewObject
    #endif /* _somdNewObject */
#endif /* SOMGD_somdNewObject */

/*
 * New Method: somdGetIdFromObject
 */
typedef string   SOMLINK somTP_ObjectMgr_somdGetIdFromObject(ObjectMgr *somSelf, Environment *ev, 
		SOMObject* obj);
#pragma linkage(somTP_ObjectMgr_somdGetIdFromObject, system)
typedef somTP_ObjectMgr_somdGetIdFromObject *somTD_ObjectMgr_somdGetIdFromObject;
/*
 *  Returns a external id for an object managed by this Object Manager.
 *  The id is unambiguous -- it always refers to the same object (as long
 *  as the object exists).
 * 
 *  OWNERSHIP of returned id string is transferred to the caller.
 */
#define somMD_ObjectMgr_somdGetIdFromObject "::ObjectMgr::somdGetIdFromObject"
#define ObjectMgr_somdGetIdFromObject(somSelf,ev,obj) \
    (SOM_Resolve(somSelf, ObjectMgr, somdGetIdFromObject) \
	(somSelf,ev,obj))
#ifndef SOMGD_somdGetIdFromObject
    #if (defined(_somdGetIdFromObject) || defined(__somdGetIdFromObject))
        #undef _somdGetIdFromObject
        #undef __somdGetIdFromObject
        #define SOMGD_somdGetIdFromObject 1
    #else
        #define _somdGetIdFromObject ObjectMgr_somdGetIdFromObject
    #endif /* _somdGetIdFromObject */
#endif /* SOMGD_somdGetIdFromObject */

/*
 * New Method: somdGetObjectFromId
 */
typedef SOMObject*   SOMLINK somTP_ObjectMgr_somdGetObjectFromId(ObjectMgr *somSelf, Environment *ev, 
		string id);
#pragma linkage(somTP_ObjectMgr_somdGetObjectFromId, system)
typedef somTP_ObjectMgr_somdGetObjectFromId *somTD_ObjectMgr_somdGetObjectFromId;
/*
 *  Finds and/or activates an object implemented by this Object Manager,
 *  given its id.
 * 
 *  OWNERSHIP of returned object is transferred to the caller.
 *  methods for releasing / destroying objects
 */
#define somMD_ObjectMgr_somdGetObjectFromId "::ObjectMgr::somdGetObjectFromId"
#define ObjectMgr_somdGetObjectFromId(somSelf,ev,id) \
    (SOM_Resolve(somSelf, ObjectMgr, somdGetObjectFromId) \
	(somSelf,ev,id))
#ifndef SOMGD_somdGetObjectFromId
    #if (defined(_somdGetObjectFromId) || defined(__somdGetObjectFromId))
        #undef _somdGetObjectFromId
        #undef __somdGetObjectFromId
        #define SOMGD_somdGetObjectFromId 1
    #else
        #define _somdGetObjectFromId ObjectMgr_somdGetObjectFromId
    #endif /* _somdGetObjectFromId */
#endif /* SOMGD_somdGetObjectFromId */

/*
 * New Method: somdReleaseObject
 */
typedef void   SOMLINK somTP_ObjectMgr_somdReleaseObject(ObjectMgr *somSelf, Environment *ev, 
		SOMObject* obj);
#pragma linkage(somTP_ObjectMgr_somdReleaseObject, system)
typedef somTP_ObjectMgr_somdReleaseObject *somTD_ObjectMgr_somdReleaseObject;
/*
 *  Indicates that the client has finished using the object, and the
 *  "connection" to the object, if any, can be released.
 */
#define somMD_ObjectMgr_somdReleaseObject "::ObjectMgr::somdReleaseObject"
#define ObjectMgr_somdReleaseObject(somSelf,ev,obj) \
    (SOM_Resolve(somSelf, ObjectMgr, somdReleaseObject) \
	(somSelf,ev,obj))
#ifndef SOMGD_somdReleaseObject
    #if (defined(_somdReleaseObject) || defined(__somdReleaseObject))
        #undef _somdReleaseObject
        #undef __somdReleaseObject
        #define SOMGD_somdReleaseObject 1
    #else
        #define _somdReleaseObject ObjectMgr_somdReleaseObject
    #endif /* _somdReleaseObject */
#endif /* SOMGD_somdReleaseObject */

/*
 * New Method: somdDestroyObject
 */
typedef void   SOMLINK somTP_ObjectMgr_somdDestroyObject(ObjectMgr *somSelf, Environment *ev, 
		SOMObject* obj);
#pragma linkage(somTP_ObjectMgr_somdDestroyObject, system)
typedef somTP_ObjectMgr_somdDestroyObject *somTD_ObjectMgr_somdDestroyObject;
/*
 *  Causes the specified object to be destroyed.  (There is an implicit
 *  somoReleaseObject call made.)
 */
#define somMD_ObjectMgr_somdDestroyObject "::ObjectMgr::somdDestroyObject"
#define ObjectMgr_somdDestroyObject(somSelf,ev,obj) \
    (SOM_Resolve(somSelf, ObjectMgr, somdDestroyObject) \
	(somSelf,ev,obj))
#ifndef SOMGD_somdDestroyObject
    #if (defined(_somdDestroyObject) || defined(__somdDestroyObject))
        #undef _somdDestroyObject
        #undef __somdDestroyObject
        #define SOMGD_somdDestroyObject 1
    #else
        #define _somdDestroyObject ObjectMgr_somdDestroyObject
    #endif /* _somdDestroyObject */
#endif /* SOMGD_somdDestroyObject */
#ifndef SOM_DONT_USE_INHERITED_MACROS
#define ObjectMgr_somDefaultInit SOMObject_somDefaultInit
#define ObjectMgr_somDestruct SOMObject_somDestruct
#define ObjectMgr_somDefaultCopyInit SOMObject_somDefaultCopyInit
#define ObjectMgr_somDefaultAssign SOMObject_somDefaultAssign
#define ObjectMgr_somDefaultConstCopyInit SOMObject_somDefaultConstCopyInit
#define ObjectMgr_somDefaultVCopyInit SOMObject_somDefaultVCopyInit
#define ObjectMgr_somDefaultConstVCopyInit SOMObject_somDefaultConstVCopyInit
#define ObjectMgr_somDefaultConstAssign SOMObject_somDefaultConstAssign
#define ObjectMgr_somDefaultVAssign SOMObject_somDefaultVAssign
#define ObjectMgr_somDefaultConstVAssign SOMObject_somDefaultConstVAssign
#define ObjectMgr_somInit SOMObject_somInit
#define ObjectMgr_somFree SOMObject_somFree
#define ObjectMgr_somUninit SOMObject_somUninit
#define ObjectMgr_somGetClass SOMObject_somGetClass
#define ObjectMgr_somGetClassName SOMObject_somGetClassName
#define ObjectMgr_somGetSize SOMObject_somGetSize
#define ObjectMgr_somIsA SOMObject_somIsA
#define ObjectMgr_somIsInstanceOf SOMObject_somIsInstanceOf
#define ObjectMgr_somRespondsTo SOMObject_somRespondsTo
#define ObjectMgr_somDispatch SOMObject_somDispatch
#define ObjectMgr_somClassDispatch SOMObject_somClassDispatch
#define ObjectMgr_somCastObj SOMObject_somCastObj
#define ObjectMgr_somResetObj SOMObject_somResetObj
#define ObjectMgr_somDispatchV SOMObject_somDispatchV
#define ObjectMgr_somDispatchL SOMObject_somDispatchL
#define ObjectMgr_somDispatchA SOMObject_somDispatchA
#define ObjectMgr_somDispatchD SOMObject_somDispatchD
#define ObjectMgr_somPrintSelf SOMObject_somPrintSelf
#define ObjectMgr_somDumpSelf SOMObject_somDumpSelf
#define ObjectMgr_somDumpSelfInt SOMObject_somDumpSelfInt
#endif /* SOM_DONT_USE_INHERITED_MACROS */

#endif       /* SOM_ObjectMgr_h */
