 /*****************************************************************/
 /** ODBCEXT.CPY - This is the include for applications using     */
 /**               Microsoft's SQL Extensions.                    */
 /**             - ODBC V 2.5 Level                               */
 /**                                                              */
 /*****************************************************************/
 /*                                                               */
 /*  Licensed Materials - Property of IBM                         */
 /*  5639-A83, 5639-A24 (C) Copyright IBM Corp. 1997.             */
 /*  All Rights Reserved.                                         */
 /*   (C) Copyright IBM Corp. 1997. All Rights Reserved.          */
 /*   US Government Users Restricted Rights-- Use, duplication or */
 /*   disclosure restricted by GSA ADP Schedule Contract with     */
 /*   IBM Corp.                                                   */
 /*                                                               */
 /* DISCLAIMER OF WARRANTIES                                      */
 /*   The following enclosed code is sample code created by IBM */
 /*   Corporation. This sample code is not part of any standard   */
 /*   IBM product and is provided to you solely for the purpose of*/
 /*   assisting you in the development of your applications.  The */
 /*   code is provided "AS IS", without warranty of any kind.     */
 /*   IBM shall not be liable for any damages arising out of your */
 /*   use of the sample code, even if IBM has been advised of the */
 /*   possibility of such damages.                                */
 /*                                                               */
 /*****************************************************************/

 /* SQLBindParameter extensions */
 %if (ODBCVER >= '0200'x) %then %do;
 %dcl SQL_DEFAULT_PARAM char ext;
 %SQL_DEFAULT_PARAM = '-5 ';
 %dcl SQL_IGNORE char ext;
 %SQL_IGNORE = '-6 ';
 %dcl SQL_LEN_DATA_AT_EXEC_OFFSET char ext;
 %SQL_LEN_DATA_AT_EXEC_OFFSET = '-100 ';

  %end;
  /* ODBCVER >= 0x0200 */


 /* Defines for SQLSetPos */
  dcl SQL_ENTIRE_ROWSET               fixed bin(31) value(0);

 /* Operations in SQLSetPos */
 /*      1.0 FALSE */
  dcl SQL_POSITION                    fixed bin(31) value(0);
 /*      1.0 TRUE */
  dcl SQL_REFRESH                     fixed bin(31) value(1);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_UPDATE                      fixed bin(31) value(2);
  dcl SQL_DELETE                      fixed bin(31) value(3);
  dcl SQL_ADD                         fixed bin(31) value(4);
  %end;
  /* ODBCVER >= 0x0200 */

 /* Lock options in SQLSetPos */
  dcl SQL_LOCK_NO_CHANGE              fixed bin(31) value(0);
 /*      1.0 FALSE */
  dcl SQL_LOCK_EXCLUSIVE              fixed bin(31) value(1);
 /*      1.0 TRUE */
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_LOCK_UNLOCK                 fixed bin(31) value(2);

  %end;
  /* ODBCVER >= 0x0200 */

 /* Level 1 Prototypes                            */

 /* Options for SQLDriverConnect */
  dcl SQL_DRIVER_NOPROMPT             fixed bin(31) value(0);
  dcl SQL_DRIVER_COMPLETE             fixed bin(31) value(1);
  dcl SQL_DRIVER_PROMPT               fixed bin(31) value(2);
  dcl SQL_DRIVER_COMPLETE_REQUIRED    fixed bin(31) value(3);

 dcl SQLDriverConnect entry (
        type SQLHDBC,
        type SQLHWND,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDriverConnect');


 /* Level 2 Functions                             */

 /* SQLExtendedFetch "fFetchType" values */
 %dcl SQL_FETCH_NEXT char ext;
 %if SQL_FETCH_NEXT = '' %then
  %do;
  dcl SQL_FETCH_NEXT                  fixed bin(31) value(1);
  %end;
 %dcl SQL_FETCH_FIRST char ext;
 %if SQL_FETCH_FIRST = '' %then
  %do;
  dcl SQL_FETCH_FIRST                 fixed bin(31) value(2);
  %end;
  dcl SQL_FETCH_LAST                  fixed bin(31) value(3);
  dcl SQL_FETCH_PRIOR                 fixed bin(31) value(4);
  dcl SQL_FETCH_ABSOLUTE              fixed bin(31) value(5);
  dcl SQL_FETCH_RELATIVE              fixed bin(31) value(6);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_FETCH_BOOKMARK              fixed bin(31) value(8);
  %end;
  /* ODBCVER >= 0x0200 */

 /* SQLExtendedFetch "rgfRowStatus" element values */
  dcl SQL_ROW_SUCCESS                 fixed bin(31) value(0);
  dcl SQL_ROW_DELETED                 fixed bin(31) value(1);
  dcl SQL_ROW_UPDATED                 fixed bin(31) value(2);
  dcl SQL_ROW_NOROW                   fixed bin(31) value(3);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_ROW_ADDED                   fixed bin(31) value(4);
  dcl SQL_ROW_ERROR                   fixed bin(31) value(5);
  %end;
  /* ODBCVER >= 0x0200 */

 /* Defines for SQLForeignKeys (returned in result set) */
  dcl SQL_CASCADE                     fixed bin(31) value(0);
  dcl SQL_RESTRICT                    fixed bin(31) value(1);
  dcl SQL_SET_NULL                    fixed bin(31) value(2);
 %if (ODBCVER >= '0250'x) %then %do;
  dcl SQL_NO_ACTION                   fixed bin(31) value(3);
  dcl SQL_SET_DEFAULT			              fixed bin(31) value(4);
  %end;

 /* Defines for SQLBindParameter and                   */
 /*   SQLProcedureColumns (returned in the result set) */
  dcl SQL_PARAM_TYPE_UNKNOWN          fixed bin(31) value(0);
  dcl SQL_PARAM_INPUT                 fixed bin(31) value(1);
  dcl SQL_PARAM_INPUT_OUTPUT          fixed bin(31) value(2);
  dcl SQL_RESULT_COL                  fixed bin(31) value(3);
 %if (ODBCVER >= '0200'x) %then %do;
  dcl SQL_PARAM_OUTPUT                fixed bin(31) value(4);
  dcl SQL_RETURN_VALUE                fixed bin(31) value(5);
  %end;
  /* ODBCVER >= 0x0200 */


 %if (ODBCVER >= '0200'x) %then %do;
 /* Defines for SQLProcedures (returned in the result set) */
  dcl SQL_PT_UNKNOWN                  fixed bin(31) value(0);
  dcl SQL_PT_PROCEDURE                fixed bin(31) value(1);
  dcl SQL_PT_FUNCTION                 fixed bin(31) value(2);

  %end;
  /* ODBCVER >= 0x0200 */

 /* Defines used by Driver Manager when mapping SQLSetParam to */
 /*   SQLBindParameter                                         */
 %dcl SQL_PARAM_TYPE_DEFAULT char ext;
 %SQL_PARAM_TYPE_DEFAULT='SQL_PARAM_INPUT_OUTPUT';
 %dcl @SQL_PARAM_TYPE_DEFAULT char ext;
 %@SQL_PARAM_TYPE_DEFAULT='@SQL_PARAM_INPUT_OUTPUT';
 %dcl SQL_SETPARAM_VALUE_MAX char ext;
 %SQL_SETPARAM_VALUE_MAX = '-1';



 /* Level 2 Prototypes */
 dcl SQLBrowseConnect entry (
        type SQLHDBC,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLBrowseConnect');

 dcl SQLColumnPrivileges entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLColumnPrivileges');

 dcl SQLDescribeParam entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type @SQLSMALLINT,
        type @SQLUINTEGER,
        type @SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDescribeParam');

 dcl SQLExtendedFetch entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLINTEGER,
        type @SQLUINTEGER,
        type @SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLExtendedFetch');

 dcl SQLForeignKeys entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLForeignKeys');

 dcl SQLMoreResults entry (
        type SQLHSTMT )
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLMoreResults');

 dcl SQLNativeSql entry (
        type SQLHDBC,
        type @SQLCHAR,
        type SQLINTEGER,
        type @SQLCHAR,
        type SQLINTEGER,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLNativeSql');

 dcl SQLNumParams entry (
        type SQLHSTMT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLNumParams');

 dcl SQLParamOptions entry (
        type SQLHSTMT,
        type SQLUINTEGER,
        type @SQLUINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLParamOptions');

 dcl SQLPrimaryKeys entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLPrimaryKeys');

 dcl SQLProcedureColumns entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLProcedureColumns');

 dcl SQLProcedures entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLProcedures');

 dcl SQLSetPos entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLUSMALLINT,
        type SQLUSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLSetPos');

 dcl SQLTablePrivileges entry (
        type SQLHSTMT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLTablePrivileges');

 /* SDK 2.0 Additions */

 %if (ODBCVER >= '0200'x) %then %do;
 dcl SQLDrivers entry (
        type SQLHENV,
        type SQLUSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT,
        type @SQLCHAR,
        type SQLSMALLINT,
        type @SQLSMALLINT)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLDrivers');

 dcl SQLBindParameter entry (
        type SQLHSTMT,
        type SQLUSMALLINT,
        type SQLSMALLINT,
        type SQLSMALLINT,
        type SQLSMALLINT,
        type SQLUINTEGER,
        type SQLSMALLINT,
        type SQLPOINTER,
        type SQLINTEGER,
        type @SQLINTEGER)
          returns( fixed bin(15) byvalue )
           SQL_API external('SQLBindParameter');
  %end;
  /* ODBCVER >= 0x0200 */

