 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMSPL.CPY                                    */
 /*                                                                  */
 /*  NAME - PMSPL.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The following symbols are used in this file                      */
 /* for conditional sections.                                        */
 /*                                                                  */
 /*  #define:                To include:                             */
 /*                                                                  */
 /*  INCL_SPLERRORS          defined if INCL_ERRORS defined          */
 /*  INCL_SPLFSE             file system emulation calls             */
 /*  INCL_SPLDOSPRINT        DosPrint APIs                           */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if PMSPL_INCLUDED='Y' %then %do;
   %PMSPL_INCLUDED='Y';
   %declare DosPrintDestControl char;
   %DosPrintDestControl='SplControlDevice';
   %declare DosPrintDestGetInfo char;
   %DosPrintDestGetInfo='SplQueryDevice';
   %declare DosPrintDestEnum char;
   %DosPrintDestEnum='SplEnumDevice';
   %declare DosPrintJobContinue char;
   %DosPrintJobContinue='SplReleaseJob';
   %declare DosPrintJobPause char;
   %DosPrintJobPause='SplHoldJob';
   %declare DosPrintJobDel char;
   %DosPrintJobDel='SplDeleteJob';
   %declare DosPrintJobGetInfo char;
   %DosPrintJobGetInfo='SplQueryJob';
   %declare DosPrintJobSetInfo char;
   %DosPrintJobSetInfo='SplSetJob';
   %declare DosPrintJobEnum char;
   %DosPrintJobEnum='SplEnumJob';
   %declare DosPrintQAdd char;
   %DosPrintQAdd='SplCreateQueue';
   %declare DosPrintQPause char;
   %DosPrintQPause='SplHoldQueue';
   %declare DosPrintQContinue char;
   %DosPrintQContinue='SplReleaseQueue';
   %declare DosPrintQDel char;
   %DosPrintQDel='SplDeleteQueue';
   %declare DosPrintQGetInfo char;
   %DosPrintQGetInfo='SplQueryQueue';
   %declare DosPrintQSetInfo char;
   %DosPrintQSetInfo='SplSetQueue';
   %declare DosPrintQEnum char;
   %DosPrintQEnum='SplEnumQueue';
   %declare DosPrintDestAdd char;
   %DosPrintDestAdd='SplCreateDevice';
   %declare DosPrintDestSetInfo char;
   %DosPrintDestSetInfo='SplSetDevice';
   %declare DosPrintDestDel char;
   %DosPrintDestDel='SplDeleteDevice';
   %declare DosPrintQPurge char;
   %DosPrintQPurge='SplPurgeQueue';
   %declare DosPrintDriverEnum char;
   %DosPrintDriverEnum='SplEnumDriver';
   %declare DosPrintQProcessorEnum char;
   %DosPrintQProcessorEnum='SplEnumQueueProcessor';
   %declare DosPrintPortEnum char;
   %DosPrintPortEnum='SplEnumPort';
   %if INCL_ERRORS='Y' %then %do;
     %INCL_SPLERRORS='Y';
   %end;
   %declare SPL_INI_SPOOLER char;
   %SPL_INI_SPOOLER='''PM_SPOOLER''';
   %declare SPL_INI_QUEUE char;
   %SPL_INI_QUEUE='''PM_SPOOLER_QUEUE''';
   %declare SPL_INI_PRINTER char;
   %SPL_INI_PRINTER='''PM_SPOOLER_PRINTER''';
   %declare SPL_INI_PRINTERDESCR char;
   %SPL_INI_PRINTERDESCR='''PM_SPOOLER_PRINTER_DESCR''';
   %declare SPL_INI_QUEUEDESCR char;
   %SPL_INI_QUEUEDESCR='''PM_SPOOLER_QUEUE_DESCR''';
   %declare SPL_INI_QUEUEDD char;
   %SPL_INI_QUEUEDD='''PM_SPOOLER_QUEUE_DD''';
   %declare SPL_INI_QUEUEDDDATA char;
   %SPL_INI_QUEUEDDDATA='''PM_SPOOLER_QUEUE_DDDATA''';
   %declare SPL_ERROR char;
   %SPL_ERROR=0;
   %declare SPL_OK char;
   %SPL_OK=1;
   %declare HSPL char;
   %HSPL=LHANDLE;
   %declare HSTD char;
   %HSTD=LHANDLE;
   %declare PHSTD char;
   %PHSTD='pointer';
   %declare PQMOPENDATA char;
   %PQMOPENDATA='pointer';
   %declare SPLC_ABORT char;
   %SPLC_ABORT=1;
   %declare SPLC_PAUSE char;
   %SPLC_PAUSE=2;
   %declare SPLC_CONTINUE char;
   %SPLC_CONTINUE=3;

   declare QP_RAWDATA_BYPASS fixed bin(31) value('00_00_00_01'xn);

   %declare HPROC char;
   %HPROC=LHANDLE;
   %declare PQPOPENDATA char;
   %PQPOPENDATA='pointer';
   dcl SplQpOpen entry (
          LONG,
          PQPOPENDATA)
          returns(optional byvalue HPROC)
          EXPENTRY;
   dcl SplQpPrint entry (
          HPROC,
          PSZ)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl SplQpClose entry (
          HPROC)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl SplQpControl entry (
          HPROC,
          LONG)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl SplQpQueryDt entry (
          PLONG,
          PSZ)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl SplQpInstall entry (
          HWND)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl SplQpQueryFlags entry (
          PULONG)
          returns(optional byvalue BOOL)
          EXPENTRY;
   %declare QPDAT_ADDRESS char;
   %QPDAT_ADDRESS=0;
   %declare QPDAT_DRIVER_NAME char;
   %QPDAT_DRIVER_NAME=1;
   %declare QPDAT_DRIVER_DATA char;
   %QPDAT_DRIVER_DATA=2;
   %declare QPDAT_DATA_TYPE char;
   %QPDAT_DATA_TYPE=3;
   %declare QPDAT_COMMENT char;
   %QPDAT_COMMENT=4;
   %declare QPDAT_PROC_PARAMS char;
   %QPDAT_PROC_PARAMS=5;
   %declare QPDAT_SPL_PARAMS char;
   %QPDAT_SPL_PARAMS=6;
   %declare QPDAT_NET_PARAMS char;
   %QPDAT_NET_PARAMS=7;
   %declare QPDAT_DOC_NAME char;
   %QPDAT_DOC_NAME=8;
   %declare QPDAT_QUEUE_NAME char;
   %QPDAT_QUEUE_NAME=9;
   %declare QPDAT_TOKEN char;
   %QPDAT_TOKEN=10;
   %declare QPDAT_JOBID char;
   %QPDAT_JOBID=11;
   %declare SQPOPENDATA char;
   %SQPOPENDATA='char(stg(#SQPOPENDATA))';
   dcl 1 #SQPOPENDATA based(null()) unaligned,
         2 pszLogAddress PSZ,
         2 pszDriverName PSZ,
         2 pdriv PDRIVDATA,
         2 pszDataType PSZ,
         2 pszComment PSZ,
         2 pszProcParams PSZ,
         2 pszSpoolParams PSZ,
         2 pszNetworkParams PSZ,
         2 pszDocName PSZ,
         2 pszQueueName PSZ,
         2 pszToken PSZ,
         2 idJobId USHORT;
   %declare PSQPOPENDATA char;
   %PSQPOPENDATA='pointer';

   declare SPLINFO_QPERROR fixed bin(16) value('00_01'xn);
   declare SPLINFO_DDERROR fixed bin(16) value('00_02'xn);
   declare SPLINFO_SPLERROR fixed bin(16) value('00_04'xn);
   declare SPLINFO_OTHERERROR fixed bin(16) value('00_80'xn);
   declare SPLINFO_INFORMATION fixed bin(16) value('01_00'xn);
   declare SPLINFO_WARNING fixed bin(16) value('02_00'xn);
   declare SPLINFO_ERROR fixed bin(16) value('04_00'xn);
   declare SPLINFO_SEVERE fixed bin(16) value('08_00'xn);
   declare SPLINFO_USERINTREQD fixed bin(16) value('10_00'xn);

   declare SPLDATA_PRINTERJAM fixed bin(16) value('00_01'xn);
   declare SPLDATA_FORMCHGREQD fixed bin(16) value('00_02'xn);
   declare SPLDATA_CARTCHGREQD fixed bin(16) value('00_04'xn);
   declare SPLDATA_PENCHGREQD fixed bin(16) value('00_08'xn);
   declare SPLDATA_DATAERROR fixed bin(16) value('00_10'xn);
   declare SPLDATA_UNEXPECTERROR fixed bin(16) value('00_20'xn);
   declare SPLDATA_OTHER fixed bin(16) value('80_00'xn);

   %declare SSQL_ERROR char;
   %SSQL_ERROR=-1;
   %if INCL_SPLERRORS='Y' %then %do;
     %include pmerr;
   %end;
   %declare SPLERR char;
   %SPLERR='fixed bin(31) unsigned';
   %if INCL_SPLDOSPRINT='Y' %then %do;
     %declare CNLEN char;
     %CNLEN=15;
     %declare UNLEN char;
     %UNLEN=20;
     %declare QNLEN char;
     %QNLEN=12;
     %declare PDLEN char;
     %PDLEN=8;
     %declare DTLEN char;
     %DTLEN=9;
     %declare QP_DATATYPE_SIZE char;
     %QP_DATATYPE_SIZE=15;
     %declare DRIV_DEVICENAME_SIZE char;
     %DRIV_DEVICENAME_SIZE=31;
     %declare DRIV_NAME_SIZE char;
     %DRIV_NAME_SIZE=8;
     %declare PRINTERNAME_SIZE char;
     %PRINTERNAME_SIZE=32;
     %declare FORMNAME_SIZE char;
     %FORMNAME_SIZE=31;
     %declare MAXCOMMENTSZ char;
     %MAXCOMMENTSZ=48;
     %declare DRIVPROPS char;
     %DRIVPROPS='char(stg(#DRIVPROPS))';
     dcl 1 #DRIVPROPS based(null()) unaligned,
           2 pszKeyName PSZ,
           2 cbBuf ULONG,
           2 pBuf PVOID;
     %declare PDRIVPROPS char;
     %PDRIVPROPS='pointer';
     %declare NPDRIVPROPS char;
     %NPDRIVPROPS='pointer';
     %declare PRJINFO char;
     %PRJINFO='char(stg(#PRJINFO))';
     dcl 1 #PRJINFO based(null()) unaligned,
           2 uJobId USHORT,
           2 szUserName char(UNLEN+1-1) varz,
           2 pad_1 CHAR,
           2 szNotifyName char(CNLEN+1-1) varz,
           2 szDataType char(DTLEN+1-1) varz,
           2 pszParms PSZ,
           2 uPosition USHORT,
           2 fsStatus USHORT,
           2 pszStatus PSZ,
           2 ulSubmitted ULONG,
           2 ulSize ULONG,
           2 pszComment PSZ;
     %declare PPRJINFO char;
     %PPRJINFO='pointer';
     %declare NPPRJINFO char;
     %NPPRJINFO='pointer';
     %declare PRJINFO2 char;
     %PRJINFO2='char(stg(#PRJINFO2))';
     dcl 1 #PRJINFO2 based(null()) unaligned,
           2 uJobId USHORT,
           2 uPriority USHORT,
           2 pszUserName PSZ,
           2 uPosition USHORT,
           2 fsStatus USHORT,
           2 ulSubmitted ULONG,
           2 ulSize ULONG,
           2 pszComment PSZ,
           2 pszDocument PSZ;
     %declare PPRJINFO2 char;
     %PPRJINFO2='pointer';
     %declare NPPRJINFO2 char;
     %NPPRJINFO2='pointer';
     %declare PRJINFO3 char;
     %PRJINFO3='char(stg(#PRJINFO3))';
     dcl 1 #PRJINFO3 based(null()) unaligned,
           2 uJobId USHORT,
           2 uPriority USHORT,
           2 pszUserName PSZ,
           2 uPosition USHORT,
           2 fsStatus USHORT,
           2 ulSubmitted ULONG,
           2 ulSize ULONG,
           2 pszComment PSZ,
           2 pszDocument PSZ,
           2 pszNotifyName PSZ,
           2 pszDataType PSZ,
           2 pszParms PSZ,
           2 pszStatus PSZ,
           2 pszQueue PSZ,
           2 pszQProcName PSZ,
           2 pszQProcParms PSZ,
           2 pszDriverName PSZ,
           2 pDriverData PDRIVDATA,
           2 pszPrinterName PSZ;
     %declare PPRJINFO3 char;
     %PPRJINFO3='pointer';
     %declare NPPRJINFO3 char;
     %NPPRJINFO3='pointer';
     %declare PRDINFO char;
     %PRDINFO='char(stg(#PRDINFO))';
     dcl 1 #PRDINFO based(null()) unaligned,
           2 szName char(PDLEN+1-1) varz,
           2 szUserName char(UNLEN+1-1) varz,
           2 uJobId USHORT,
           2 fsStatus USHORT,
           2 pszStatus PSZ,
           2 time USHORT;
     %declare PPRDINFO char;
     %PPRDINFO='pointer';
     %declare NPPRDINFO char;
     %NPPRDINFO='pointer';
     %declare PRDINFO3 char;
     %PRDINFO3='char(stg(#PRDINFO3))';
     dcl 1 #PRDINFO3 based(null()) unaligned,
           2 pszPrinterName PSZ,
           2 pszUserName PSZ,
           2 pszLogAddr PSZ,
           2 uJobId USHORT,
           2 fsStatus USHORT,
           2 pszStatus PSZ,
           2 pszComment PSZ,
           2 pszDrivers PSZ,
           2 time USHORT,
           2 usTimeOut USHORT;
     %declare PPRDINFO3 char;
     %PPRDINFO3='pointer';
     %declare NPPRDINFO3 char;
     %NPPRDINFO3='pointer';
     %declare PRQINFO char;
     %PRQINFO='char(stg(#PRQINFO))';
     dcl 1 #PRQINFO based(null()) unaligned,
           2 szName char(QNLEN+1-1) varz,
           2 pad_1 CHAR,
           2 uPriority USHORT,
           2 uStartTime USHORT,
           2 uUntilTime USHORT,
           2 pszSepFile PSZ,
           2 pszPrProc PSZ,
           2 pszDestinations PSZ,
           2 pszParms PSZ,
           2 pszComment PSZ,
           2 fsStatus USHORT,
           2 cJobs USHORT;
     %declare PPRQINFO char;
     %PPRQINFO='pointer';
     %declare NPPRQINFO char;
     %NPPRQINFO='pointer';
     %declare PRQINFO3 char;
     %PRQINFO3='char(stg(#PRQINFO3))';
     dcl 1 #PRQINFO3 based(null()) unaligned,
           2 pszName PSZ,
           2 uPriority USHORT,
           2 uStartTime USHORT,
           2 uUntilTime USHORT,
           2 fsType USHORT,
           2 pszSepFile PSZ,
           2 pszPrProc PSZ,
           2 pszParms PSZ,
           2 pszComment PSZ,
           2 fsStatus USHORT,
           2 cJobs USHORT,
           2 pszPrinters PSZ,
           2 pszDriverName PSZ,
           2 pDriverData PDRIVDATA;
     %declare PPRQINFO3 char;
     %PPRQINFO3='pointer';
     %declare NPPRQINFO3 char;
     %NPPRQINFO3='pointer';
     %declare PRQINFO6 char;
     %PRQINFO6='char(stg(#PRQINFO6))';
     dcl 1 #PRQINFO6 based(null()) unaligned,
           2 pszName PSZ,
           2 uPriority USHORT,
           2 uStartTime USHORT,
           2 uUntilTime USHORT,
           2 fsType USHORT,
           2 pszSepFile PSZ,
           2 pszPrProc PSZ,
           2 pszParms PSZ,
           2 pszComment PSZ,
           2 fsStatus USHORT,
           2 cJobs USHORT,
           2 pszPrinters PSZ,
           2 pszDriverName PSZ,
           2 pDriverData PDRIVDATA,
           2 pszRemoteComputerName PSZ,
           2 pszRemoteQueueName PSZ;
     %declare PPRQINFO6 char;
     %PPRQINFO6='pointer';
     %declare NPPRQINFO6 char;
     %NPPRQINFO6='pointer';
     %declare PRIDINFO char;
     %PRIDINFO='char(stg(#PRIDINFO))';
     dcl 1 #PRIDINFO based(null()) unaligned,
           2 uJobId USHORT,
           2 szComputerName CHAR(CNLEN+1),
           2 szQueueName CHAR(QNLEN+1),
           2 pad_1 CHAR;
     %declare PPRIDINFO char;
     %PPRIDINFO='pointer';
     %declare NPPRIDINFO char;
     %NPPRIDINFO='pointer';
     %declare PRDRIVINFO char;
     %PRDRIVINFO='char(stg(#PRDRIVINFO))';
     dcl 1 #PRDRIVINFO based(null()) unaligned,
           2 szDrivName char(DRIV_NAME_SIZE+1+DRIV_DEVICENAME_SIZE+1-1)
                        varz;
     %declare PPRDRIVINFO char;
     %PPRDRIVINFO='pointer';
     %declare NPPRDRIVINFO char;
     %NPPRDRIVINFO='pointer';
     %declare PRQPROCINFO char;
     %PRQPROCINFO='char(stg(#PRQPROCINFO))';
     dcl 1 #PRQPROCINFO based(null()) unaligned,
           2 szQProcName char(QNLEN+1-1) varz;
     %declare PPRQPROCINFO char;
     %PPRQPROCINFO='pointer';
     %declare NPPRQPROCINFO char;
     %NPPRQPROCINFO='pointer';
     %declare PRPORTINFO char;
     %PRPORTINFO='char(stg(#PRPORTINFO))';
     dcl 1 #PRPORTINFO based(null()) unaligned,
           2 szPortName char(PDLEN+1-1) varz;
     %declare PPRPORTINFO char;
     %PPRPORTINFO='pointer';
     %declare NPPRPORTINFO char;
     %NPPRPORTINFO='pointer';
     %declare PRPORTINFO1 char;
     %PRPORTINFO1='char(stg(#PRPORTINFO1))';
     dcl 1 #PRPORTINFO1 based(null()) unaligned,
           2 pszPortName PSZ,
           2 pszPortDriverName PSZ,
           2 pszPortDriverPathName PSZ;
     %declare PPRPORTINFO1 char;
     %PPRPORTINFO1='pointer';
     %declare NPPRPORTINFO1 char;
     %NPPRPORTINFO1='pointer';
     %declare PRQ_PRIORITY_PARMNUM char;
     %PRQ_PRIORITY_PARMNUM=2;
     %declare PRQ_STARTTIME_PARMNUM char;
     %PRQ_STARTTIME_PARMNUM=3;
     %declare PRQ_UNTILTIME_PARMNUM char;
     %PRQ_UNTILTIME_PARMNUM=4;
     %declare PRQ_SEPARATOR_PARMNUM char;
     %PRQ_SEPARATOR_PARMNUM=5;
     %declare PRQ_PROCESSOR_PARMNUM char;
     %PRQ_PROCESSOR_PARMNUM=6;
     %declare PRQ_DESTINATIONS_PARMNUM char;
     %PRQ_DESTINATIONS_PARMNUM=7;
     %declare PRQ_PARMS_PARMNUM char;
     %PRQ_PARMS_PARMNUM=8;
     %declare PRQ_COMMENT_PARMNUM char;
     %PRQ_COMMENT_PARMNUM=9;
     %declare PRQ_TYPE_PARMNUM char;
     %PRQ_TYPE_PARMNUM=10;
     %declare PRQ_PRINTERS_PARMNUM char;
     %PRQ_PRINTERS_PARMNUM=12;
     %declare PRQ_DRIVERNAME_PARMNUM char;
     %PRQ_DRIVERNAME_PARMNUM=13;
     %declare PRQ_DRIVERDATA_PARMNUM char;
     %PRQ_DRIVERDATA_PARMNUM=14;
     %declare PRQ_REMOTE_COMPUTER_PARMNUM char;
     %PRQ_REMOTE_COMPUTER_PARMNUM=15;
     %declare PRQ_REMOTE_QUEUE_PARMNUM char;
     %PRQ_REMOTE_QUEUE_PARMNUM=16;
     %declare PRQ_MAXPARMNUM char;
     %PRQ_MAXPARMNUM=16;
     %declare PRQ_MAX_PRIORITY char;
     %PRQ_MAX_PRIORITY=1;
     %declare PRQ_DEF_PRIORITY char;
     %PRQ_DEF_PRIORITY=5;
     %declare PRQ_MIN_PRIORITY char;
     %PRQ_MIN_PRIORITY=9;
     %declare PRQ_NO_PRIORITY char;
     %PRQ_NO_PRIORITY=0;
     %declare PRQ_STATUS_MASK char;
     %PRQ_STATUS_MASK=3;
     %declare PRQ_ACTIVE char;
     %PRQ_ACTIVE=0;

     %declare PRQ_PAUSED char;
     %PRQ_PAUSED=1;
     %declare PRQ_ERROR char;
     %PRQ_ERROR=2;
     %declare PRQ_PENDING char;
     %PRQ_PENDING=3;

     declare PRQ3_PAUSED bit(8) value('00_00_00_01'b);
     declare PRQ3_PENDING bit(8) value('00_00_00_10'b);

     declare PRQ3_TYPE_RAW fixed bin(16) value('00_01'xn);
     declare PRQ3_TYPE_BYPASS fixed bin(16) value('00_02'xn);
     declare PRQ3_TYPE_APPDEFAULT fixed bin(16) value('00_04'xn);

     %declare PRJ_NOTIFYNAME_PARMNUM char;
     %PRJ_NOTIFYNAME_PARMNUM=3;
     %declare PRJ_DATATYPE_PARMNUM char;
     %PRJ_DATATYPE_PARMNUM=4;
     %declare PRJ_PARMS_PARMNUM char;
     %PRJ_PARMS_PARMNUM=5;
     %declare PRJ_POSITION_PARMNUM char;
     %PRJ_POSITION_PARMNUM=6;
     %declare PRJ_JOBFILEINUSE_PARMNUM char;
     %PRJ_JOBFILEINUSE_PARMNUM=7;
     %declare PRJ_COMMENT_PARMNUM char;
     %PRJ_COMMENT_PARMNUM=11;
     %declare PRJ_DOCUMENT_PARMNUM char;
     %PRJ_DOCUMENT_PARMNUM=12;
     %declare PRJ_STATUSCOMMENT_PARMNUM char;
     %PRJ_STATUSCOMMENT_PARMNUM=13;
     %declare PRJ_PRIORITY_PARMNUM char;
     %PRJ_PRIORITY_PARMNUM=14;
     %declare PRJ_PROCPARMS_PARMNUM char;
     %PRJ_PROCPARMS_PARMNUM=16;
     %declare PRJ_DRIVERDATA_PARMNUM char;
     %PRJ_DRIVERDATA_PARMNUM=18;
     %declare PRJ_MAXPARMNUM char;
     %PRJ_MAXPARMNUM=18;

     declare PRJ_QSTATUS fixed bin(16) value('00_03'xn);
     declare PRJ_DEVSTATUS fixed bin(16) value('0F_FC'xn);
     declare PRJ_COMPLETE fixed bin(16) value('00_04'xn);
     declare PRJ_INTERV fixed bin(16) value('00_08'xn);
     declare PRJ_ERROR fixed bin(16) value('00_10'xn);
     declare PRJ_DESTOFFLINE fixed bin(16) value('00_20'xn);
     declare PRJ_DESTPAUSED fixed bin(16) value('00_40'xn);
     declare PRJ_NOTIFY fixed bin(16) value('00_80'xn);
     declare PRJ_DESTNOPAPER fixed bin(16) value('01_00'xn);
     declare PRJ_DESTFORMCHG fixed bin(16) value('02_00'xn);
     declare PRJ_DESTCRTCHG fixed bin(16) value('04_00'xn);
     declare PRJ_DESTPENCHG fixed bin(16) value('08_00'xn);
     declare PRJ_JOBFILEINUSE fixed bin(16) value('40_00'xn);
     declare PRJ_DELETED fixed bin(16) value('80_00'xn);

     %declare PRJ_QS_QUEUED char;
     %PRJ_QS_QUEUED=0;
     %declare PRJ_QS_PAUSED char;
     %PRJ_QS_PAUSED=1;
     %declare PRJ_QS_SPOOLING char;
     %PRJ_QS_SPOOLING=2;
     %declare PRJ_QS_PRINTING char;
     %PRJ_QS_PRINTING=3;
     %declare PRJ_MAX_PRIORITY char;
     %PRJ_MAX_PRIORITY=99;
     %declare PRJ_MIN_PRIORITY char;
     %PRJ_MIN_PRIORITY=1;
     %declare PRJ_NO_PRIORITY char;
     %PRJ_NO_PRIORITY=0;

     declare PRD_STATUS_MASK fixed bin(16) value('00_03'xn);
     declare PRD_DEVSTATUS fixed bin(16) value('0F_FC'xn);

     %declare PRD_ACTIVE char;
     %PRD_ACTIVE=0;
     %declare PRD_PAUSED char;
     %PRD_PAUSED=1;
     %declare PRD_DELETE char;
     %PRD_DELETE=0;
     %declare PRD_PAUSE char;
     %PRD_PAUSE=1;
     %declare PRD_CONT char;
     %PRD_CONT=2;
     %declare PRD_RESTART char;
     %PRD_RESTART=3;
     %declare PRD_LOGADDR_PARMNUM char;
     %PRD_LOGADDR_PARMNUM=3;
     %declare PRD_COMMENT_PARMNUM char;
     %PRD_COMMENT_PARMNUM=7;
     %declare PRD_DRIVERS_PARMNUM char;
     %PRD_DRIVERS_PARMNUM=8;
     %declare PRD_TIMEOUT_PARMNUM char;
     %PRD_TIMEOUT_PARMNUM=10;
     %declare PRINTERINFO char;
     %PRINTERINFO='char(stg(#PRINTERINFO))';
     dcl 1 #PRINTERINFO based(null()) unaligned,
           2 flType ULONG,
           2 pszComputerName PSZ,
           2 pszPrintDestinationName PSZ,
           2 pszDescription PSZ,
           2 pszLocalName PSZ;
     %declare PPRINTERINFO char;
     %PPRINTERINFO='pointer';

     declare SPL_PR_QUEUE fixed bin(31) value('00_00_00_01'xn);
     declare SPL_PR_DIRECT_DEVICE fixed bin(31) value('00_00_00_02'xn);
     declare SPL_PR_QUEUED_DEVICE fixed bin(31) value('00_00_00_04'xn);
     declare SPL_PR_LOCAL_ONLY fixed bin(31) value('00_00_01_00'xn);
   %end;
   dcl SplQmOpen entry (
          PSZ,
          LONG,
          PQMOPENDATA)
          returns(optional byvalue HSPL)
          APIENTRY;
   dcl SplQmStartDoc entry (
          HSPL,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplQmWrite entry (
          HSPL,
          LONG,
          PVOID)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplQmEndDoc entry (
          HSPL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplQmClose entry (
          HSPL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplQmAbort entry (
          HSPL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplQmAbortDoc entry (
          HSPL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplMessageBox entry (
          PSZ,
          ULONG,
          ULONG,
          PSZ,
          PSZ,
          ULONG,
          ULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   %if INCL_SPLFSE='Y' %then %do;
     dcl PrtOpen entry (
            PSZ,
            PHFILE,
            PULONG,
            ULONG,
            ULONG,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrtClose entry (
            HFILE)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrtWrite entry (
            HFILE,
            PVOID,
            ULONG,
            PULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrtDevIOCtl entry (
            PVOID,
            PVOID,
            ULONG,
            ULONG,
            HFILE)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl PrtAbort entry (
            HFILE)
            returns(optional byvalue)
            APIENTRY;
   %end;
   dcl SplStdOpen entry (
          HDC)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplStdClose entry (
          HDC)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplStdStart entry (
          HDC)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplStdStop entry (
          HDC)
          returns(optional byvalue HSTD)
          APIENTRY;
   dcl SplStdDelete entry (
          HSTD)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplStdGetBits entry (
          HSTD,
          LONG,
          LONG,
          PCH)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl SplStdQueryLength entry (
          HSTD)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl SplCreateDevice entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplControlDevice entry (
          PSZ,
          PSZ,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplDeleteDevice entry (
          PSZ,
          PSZ)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumDevice entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplQueryDevice entry (
          PSZ,
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplSetDevice entry (
          PSZ,
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplReleaseJob entry (
          PSZ,
          PSZ,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplDeleteJob entry (
          PSZ,
          PSZ,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumJob entry (
          PSZ,
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplQueryJob entry (
          PSZ,
          PSZ,
          ULONG,
          ULONG,
          PVOID,
          ULONG,
          PULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplHoldJob entry (
          PSZ,
          PSZ,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplSetJob entry (
          PSZ,
          PSZ,
          ULONG,
          ULONG,
          PVOID,
          ULONG,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplCreateQueue entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplReleaseQueue entry (
          PSZ,
          PSZ)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplDeleteQueue entry (
          PSZ,
          PSZ)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumQueue entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplQueryQueue entry (
          PSZ,
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplHoldQueue entry (
          PSZ,
          PSZ)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplPurgeQueue entry (
          PSZ,
          PSZ)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplSetQueue entry (
          PSZ,
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          ULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumDriver entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumPort entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumQueueProcessor entry (
          PSZ,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplEnumPrinter entry (
          PSZ,
          ULONG,
          ULONG,
          PVOID,
          ULONG,
          PULONG,
          PULONG,
          PULONG,
          PVOID)
          returns(optional byvalue SPLERR)
          APIENTRY;
   dcl SplCopyJob entry (
          PSZ,
          PSZ,
          ULONG,
          PSZ,
          PSZ,
          PULONG)
          returns(optional byvalue SPLERR)
          APIENTRY;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
