 /*********************************************************/
 /*  CREATED BY C2PLI CONVERSION UTILITY                  */
 /*********************************************************/
 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: SQLDA_T.CPY                                  */
 /*                                                                  */
 /*    This file is installed in the \IBMPLI\INCLUDE\ directory.     */
 /*                                                                  */
 /*                                                                  */
 /*  NAME - SQLDA_T.CPY                                              */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*                                                                  */
 /*    External Include file for SQLDA using user-defined types      */
 /*    and structures.                                               */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1994, 1997. All Rights Reserved.      */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*  Licensed Materials - Property of IBM                            */
 /*                                                                  */
 /*  Operating System = OS/2                                         */
 /*                                                                  */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/

 %dcl SQLDASIZE char ext;
 %if SQLDASIZE = '' %then
  %do;

                        /* System-Specific Include                   */
    %include sqlsystm;

 /* SQLDA: SQL Descriptor Area - Variable descriptor*/

 define structure
   1 sqlname,                    /* Variable Name                    */
       2 length fixed bin(15),                /* Name length [1..30] */
       2 data char(30) ;                /* Variable or Column name */


 define structure
    1 sqldistinct_type,          /* name of distinct type            */
        2 length fixed bin(15),               /* Name length [1..27] */
        2 data char(27) ,                 /* Name of distince type */
        2 reserved1 char(3) ;                           /*reserved */


 define structure
    1 sqlvar,                    /* Variable Description             */
        2 sqltype fixed bin(15),               /* Variable data type */
        2 sqllen fixed bin(15),              /* Variable data length */
                                    /* Pointer to variable data value*/
        2 sqldata pointer,
        2 sqlind pointer,               /* Pointer to Null indicator */
        2 sqlname type sqlname;                     /* Variable name */


 define structure
   1 sqlda,
        2 sqldaid char(8) ,              /* Eye catcher = 'SQLDA ' */
      /***************************************************************/
      /* The 7th byte has special meaning. If it is a '2', this means*/
      /* there are twice as many sqlvars as there are host variables */
      /* or columns.  This is typically used when Large Objects      */
      /* (LOBs) or User Defined Types (UDFs) are present in the      */
      /* SQLDA. The first N entries use the sqlvar structure and the */
      /* second N entries use the sqlvar2 structure.                 */
      /***************************************************************/
        2 sqldabc fixed bin(31),   /* SQLDA size in bytes=16+44*SQLN */
        2 sqln fixed bin(15),           /* Number of SQLVAR elements */
        2 sqld fixed bin(15),          /* # of columns or host vars. */
        2 sqlvar dim(0:1-1) type sqlvar;     /* first SQLVAR element */



 /********************************************************************/
 /* Because we may need to support 8 byte lengths in the future,     */
 /* sql8bytelen is defined using 8 bytes.  Currently, however, we    */
 /* have only four byte integers.                                    */
 /********************************************************************/
 define structure
 1 sql8bytelen union,
       2 reserved1(2) fixed bin(31),/* rsvd for future 8 byte lengths*/
        2 sqllonglen fixed bin(31);/* this is what is currently used */


 /********************************************************************/
 /* The sqlvar2 structure maps the second "N" sqlvar entries.  The   */
 /* second "N" entries are used to hold the length of LOB columns    */
 /* and host variables.  The second "N" entries may also be used to  */
 /* hold the SQLDATALEN field for LOB columns on a FETCH USING       */
 /* DESCRIPTOR request.                                              */
 /*                                                                  */
 /* To set or retrieve these fields, use the macros provided below.  */
 /********************************************************************/

 define structure
    1 sqlvar2,           /* Variable Description                     */
       2 len type sql8bytelen,/* Eight byte length. 4 bytes used now */
       2 sqldatalen pointer,             /* Pointer to four (4) byte */
                                       /* length buffer. This may be */
                                      /* used to hold the length for */
                                                  /* lob data types. */
       2 sqldatatype_name type sqldistinct_type;/*distinct type name.*/


 /********************************************************************/
 /* Macros for using the sqlvar2 fields.                             */
 /********************************************************************/

 /********************************************************************/
 /* A '2' in the 7th byte of sqldaid indicates a doubled amount of   */
 /*sqlvars.                                                          */
 /********************************************************************/
    dcl SQLDOUBLED char value('2');
    dcl SQLSINGLED char value(' ');


 /********************************************************************/
 /* GETSQLDOUBLED(daptr) will return 1 if the SQLDA pointed to by    */
 /* daptr has been doubled, or 0 if it has not been doubled.         */
 /********************************************************************/
 GetSQLDoubled:
   proc(daptr)
   returns( fixed bin(31) signed )
   options ( inline byvalue ) internal;

   dcl daptr pointer;

   return( substr(daptr->sqldaid,7,1) = SQLDOUBLED );
 end;
 /********************************************************************/
 /* SETSQLDOUBLED(daptr, SQLDOUBLED) will make the 7th byte of       */
 /* sqldaid to be a '2'.                                             */
 /* SETSQLDOUBLED(daptr, SQLSINGLE)  will make the 7th byte of       */
 /* sqldaid to be a ' '.                                             */
 /********************************************************************/
 SetSQLDoubled:
   proc(daptr, newvalue)
   options ( inline byvalue ) internal;

   dcl daptr pointer;
   dcl newvalue char(1);

   substr(daptr->sqldaid,7,1) = newvalue;
 end;

 /********************************************************************/
 /* GETSQLDALONGLEN(daptr,n) will return the data length of the nth  */
 /* entry in the sqlda pointed to by daptr. Use this only if the     */
 /* sqlda was doubled and the nth SQLVAR entry has a LOB datatype.   */
 /********************************************************************/
 GetSQLDALongLen:
   proc(daptr,n)
   returns( fixed bin(31) signed )
   options ( inline byvalue ) internal;

   dcl ( daptr, p2 ) pointer;
   dcl n fixed bin(31) unsigned;
   dcl mysqlvar2 type sqlvar2 based(p2);

   p2 = addr(daptr->sqlvar( n + (daptr->sqld) ) );

   return( p2->mysqlvar2.len.sqllonglen);
 end;

 /********************************************************************/
 /* SETSQLDALONGLEN(daptr,n,len) will set the sqllonglen field of    */
 /* the sqlda pointed to by daptr to len for the nth entry. Use this */
 /* only if the sqlda was doubled and the nth SQLVAR entry has a LOB */
 /* datatype.                                                        */
 /********************************************************************/

 SetSQLDALongLen:
   proc(daptr,n,length)
   options ( inline byvalue ) internal;

   dcl ( daptr, p2 ) pointer;
   dcl n fixed bin(31) unsigned;
   dcl mysqlvar2 type sqlvar2 based(p2);

   p2 = addr(daptr->sqlvar( n + (daptr->sqld) ) );
   p2->mysqlvar2.len.sqllonglen = length;
 end;

 /********************************************************************/
 /* GETSQLDALENPTR(daptr,n) will return a pointer to the data length */
 /* for the nth entry in the sqlda pointed to by daptr.  Unlike the  */
 /* inline value (union sql8bytelen len), which is 8 bytes, the      */
 /* sqldatalen pointer field returns a pointer to a long (4 byte)    */
 /* integer.                                                         */
 /* If the SQLDATALEN pointer is zero, a NULL pointer will be        */
 /* returned.                                                        */
 /*                                                                  */
 /* NOTE: Use this only if the sqlda has been doubled.               */
 /********************************************************************/

 GetSQLDALenPtr:
   proc(daptr,n)
   returns( pointer )
   options ( inline byvalue ) internal;

   dcl ( daptr, p2 ) pointer;
   dcl n fixed bin(31) unsigned;
   dcl mysqlvar2 type sqlvar2 based(p2);

   p2 = addr(daptr->sqlvar( n + (daptr->sqld) ) );

   return( p2->mysqlvar2.sqldatalen);
 end;

 /********************************************************************/
 /* SETSQLDALENPTR(daptr,n,ptr) will set a pointer to the data length*/
 /* for the nth entry in the sqlda pointed to by daptr.              */
 /* Use this only if the sqlda has been doubled.                     */
 /********************************************************************/

 SetSQLDALenPtr:
   proc(daptr,n,ptr )
   options ( inline byvalue ) internal;

   dcl ( daptr, p2, ptr ) pointer;
   dcl n fixed bin(31) unsigned;
   dcl mysqlvar2 type sqlvar2 based(p2);

   p2 = addr(daptr->sqlvar( n + (daptr->sqld) ) );
   p2->mysqlvar2.sqldatalen = ptr;
 end;


  %end;
 /* SQLDASIZE */
