/******************************************************************************/
/* Install the TCP/IP V4.1 (MPTS 5.3) stack files for the latest APAR fix     */
/* TCP/IP Level 3 Service                                                     */
/*                                                                            */
/* Last modification: 11/14/1997  Sweeney   Created this file                 */
/******************************************************************************/
parse source args
call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs
  Call RxFuncAdd 'SysLvlLoadFuncs' , 'SYSLVL' , 'SysLvlLoadFuncs'

  Call SysLvlLoadFuncs , 'SYSLVL' , 'SysLvlLoadFuncs'

/* Get drive & path for \MPTN\ and \TCPIP\from the PATH environment
   variable
 */

'@echo off'

PathVal = value('PATH',,'os2environment')    /* get PATH variable */

/* Make sure the PATH has a terminating semicolon */
if substr(PathVal,length(PathVal),1)<>';' then PathVal = PathVal';'

/* Find the \MPTN\ and \TCPIP\ paths */
MPTNPath=''
TCPath=''

do forever
  parse upper value PathVal with frontpart ';' backpart

  if (substr(frontpart,3,5) = '\MPTN' & MPTNPATH="" ) then do
    MPTNPath = substr(frontpart,1,7)
    end

  if ((substr(frontpart,3,6) = '\TCPIP') & TCPath="") then do
    TCPath=substr(frontpart,1,8)
    end

  if backpart = '' then leave
  PathVal = backpart
end

/* Verify that all the paths were found */
if MPTNPath='' | TCPath='' then do
  "wrongpth.exe"
  exit 1
end

/* Verify the MPTS level before updating the stack */
Call GetSysVersion MPTNPath'\syslevel.mpt'
ver = substr(result,1,3)
if ver <> "5.3" then
do
  "wrongver.exe"
  exit 1
end

Call GetCSDLevel MPTNPath'\syslevel.mpt'
csd = substr(result,1,2) || 'x' || substr(result,4,2)

if csd <> "WRx86" then      /* E.g., WR08600, ... */
do
  "wrongcsd.exe"
  exit 1
end

/* Verifications were successful. Update the stack files */
file.0 = 30
file.1 = "afinet.sys"    ; path.1 = MPTNPath; subdir.1 = protocol
file.2 = "aflean.sys"    ; path.2 = MPTNPath; subdir.2 = protocol
file.3 = "afos2.sys"     ; path.3 = MPTNPath; subdir.3 = protocol
file.4 = "sockets.sys"   ; path.4 = MPTNPath; subdir.4 = protocol
file.5 = "so32dll.dll"   ; path.5 = MPTNPath; subdir.5 = dll
file.6 = "tcp32dll.dll"  ; path.6 = MPTNPath; subdir.6 = dll
file.7 = "tcpipdll.dll"  ; path.7 = MPTNPath; subdir.7 = dll
file.8 = "tcpip32.dll"   ; path.8 = MPTNPath; subdir.8 = dll
file.9 = "tcpmri.dll"    ; path.9 = MPTNPath; subdir.9 = dll
file.10 = "cfg2res.jar"  ; path.10 = TCPath; subdir.10 = "java\en_US"
file.11 = "cntrl.exe"    ; path.11 = MPTNPath; subdir.11 = bin
file.12 = "ipformat.exe" ; path.12 = MPTNPath; subdir.12 = bin
file.13 = "ifconfig.exe" ; path.13 = MPTNPath; subdir.13 = bin
file.14 = "dhcpmon.exe"  ; path.14 = MPTNPath; subdir.14 = bin
file.15 = "dhcpsd.exe"   ; path.15 = TCPath; subdir.15 = bin
file.16 = "ftp.exe"      ; path.16 = TCPath; subdir.16 = bin
file.17 = "ftpd.exe"     ; path.17 = TCPath; subdir.17 = bin
file.18 = "ftpdc.exe"    ; path.18 = TCPath; subdir.18 = bin
file.19 = "named.exe"    ; path.19 = TCPath; subdir.19 = bin
file.20 = "telnet.exe"   ; path.20 = TCPath; subdir.20 = bin
file.21 = "telnetd.exe"  ; path.21 = TCPath; subdir.21 = bin
file.22 = "telnetdc.exe" ; path.22 = TCPath; subdir.22 = bin
file.23 = "telnetpm.exe" ; path.23 = TCPath; subdir.23 = bin
file.24 = "vdebug.exe"   ; path.24 = TCPath; subdir.24 = bin
file.25 = "vdosctl.exe"  ; path.25 = TCPath; subdir.25 = bin
file.26 = "vdostcp.vdd"  ; path.26 = TCPath; subdir.26 = bin
file.27 = "slippm.exe"   ; path.27 = TCPath; subdir.27 = bin
file.28 = "term-is.exe"  ; path.28 = TCPath; subdir.28 = bin
file.29 = "tftp"         ; path.29 = TCPath; subdir.29 = bin
file.30 = "tftpd.exe"    ; path.30 = TCPath; subdir.30 = bin


do i = 1 to file.0
  call SysFileTree '.\'file.i, 'fi', 'F'
  if fi.0 = 1 then tcprep file.i path.i'\'subdir.i
end

/* Prevent new tcpipdll.dll from being overwritten */
call SysFileTree '.\tcpipdll.dll', 'fi', 'F'
if fi.0 = 1 then do
  call SysFileTree TCPath'\archive\dll\tcpipdll.dll', 'file', 'F'
  if file.0 > 0 then call SysFileDelete TCPath'\archive\dll\tcpipdll.dll'
  end

Call ReleaseMemory
"mess.exe"

exit
