/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.tcadmin;
import com.sun.java.swing.border.AbstractBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class SplitBorder
extends AbstractBorder {
    protected String title;
    protected Font titleFont;
    protected Color titleColor;
    protected static final int EDGE_SPACING = 2;
    protected static final int TEXT_SPACING = 2;
    protected static final int TEXT_INSET_H = 5;

    public SplitBorder(String string) {
        this(string, null, null);
    }

    public SplitBorder(String string, Font font) {
        this(string, font, null);
    }

    public SplitBorder(String string, Font font, Color color) {
        this.title = string;
        this.titleFont = font;
        this.titleColor = color;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            graphics.setColor(color.brighter().brighter());
            graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
            graphics.setColor(color.darker().darker());
            graphics.drawLine(n, n2, n + n3, n2);
        } else {
            Rectangle rectangle = new Rectangle(2, 2, n3 - 4, n4 - 4);
            graphics.setFont(this.getFont(component));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = fontMetrics.getHeight();
            int n6 = fontMetrics.getDescent();
            int n7 = fontMetrics.getAscent();
            Point point = new Point();
            int n8 = fontMetrics.stringWidth(this.getTitle());
            int n9 = Math.max(0, n7 / 2 + 2 - 2);
            rectangle.y += n9;
            rectangle.height -= n9;
            point.y = rectangle.y - n6 + (n7 + n6) / 2;
            graphics.setColor(color.brighter().brighter());
            graphics.drawLine(rectangle.x, rectangle.y + 1, rectangle.x + rectangle.width, rectangle.y + 1);
            graphics.setColor(color.darker().darker());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            point.x = rectangle.x + 5;
            graphics.setColor(component.getBackground());
            graphics.fillRect(point.x - 2, point.y - (n5 - n6), n8 + 4, n5 - n6);
            graphics.setColor(this.getTitleColor());
            graphics.drawString(this.getTitle(), point.x, point.y);
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public Insets getBorderInsets(Component component) {
        int n = 0;
        int n2 = 16;
        Insets insets = new Insets(4, 4, 4, 4);
        if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        if (fontMetrics != null) {
            n = fontMetrics.getDescent();
            n2 = fontMetrics.getAscent();
        }
        insets.top += n2 + n;
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        if (this.titleFont == null) {
            String string = (String)tcadmin.locResource.handleGetObject("STR_FONT_FACENAME");
            int n = 0;
            int n2 = Integer.parseInt((String)tcadmin.locResource.handleGetObject("STR_FONT_POINTSIZE"));
            this.titleFont = new Font(string, n, n2);
        }
        return this.titleFont;
    }

    public Color getTitleColor() {
        if (this.titleColor == null) {
            this.titleColor = Color.black;
        }
        return this.titleColor;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Dimension dimension = new Dimension(0, 0);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        dimension.width += fontMetrics.stringWidth(this.getTitle());
        return dimension;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }
}

