/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicTextFieldUI;
import com.sun.java.swing.text.Caret;
import com.sun.java.swing.text.DefaultCaret;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTextFieldUI();
    }

    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        public WindowsFieldCaret() {
            WindowsTextFieldUI.this = WindowsTextFieldUI.this;
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            JTextComponent jTextComponent = this.getComponent();
            Document document = jTextComponent.getDocument();
            this.setDot(0);
            this.moveDot(document.getLength());
        }

        public void focusLost(FocusEvent focusEvent) {
            this.setDot(this.getDot());
            this.setVisible(false);
        }

        protected void adjustVisibility(Rectangle rectangle) {
            JTextField jTextField = (JTextField)this.getComponent();
            BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
            int n = rectangle.x + boundedRangeModel.getValue();
            int n2 = boundedRangeModel.getExtent() / 4;
            if (n < boundedRangeModel.getValue()) {
                boundedRangeModel.setValue(n - n2);
                return;
            }
            if (n > boundedRangeModel.getValue() + boundedRangeModel.getExtent()) {
                boundedRangeModel.setValue(n - 3 * n2);
            }
        }
    }
}

