/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

class LogoCanvas
extends Canvas {
    private Image image;
    private String aboutTitle;
    private String productText;
    private String copyright1;
    private String copyright2;
    private String copyright3;
    private String tradeMark1;
    private String tradeMark2;

    public LogoCanvas(Image image) {
        this.image = image;
        LogoCanvas.waitForImage(this, image);
        this.setSize(image.getWidth(this), image.getHeight(this));
        this.aboutTitle = tcmerge.locResource.getString("STR_ABOUTTITLE");
        this.productText = tcmerge.locResource.getString("STR_PRODUCTTEXT");
        this.copyright1 = tcmerge.locResource.getString("STR_COPYRIGHTTEXT");
        this.copyright2 = tcmerge.locResource.getString("STR_COPYRIGHTTEXT2");
        this.copyright3 = tcmerge.locResource.getString("STR_COPYRIGHTTEXT3");
        this.tradeMark1 = tcmerge.locResource.getString("STR_TRADEMARKTEXT");
        this.tradeMark2 = tcmerge.locResource.getString("STR_TRADEMARKTEXT2");
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, this.getSize().width / 2 - this.image.getWidth(this) / 2, 10, this);
        Font font = new Font("Serif", 0, 10);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        graphics.setColor(Color.black);
        this.setBackground(Color.white);
        int n2 = n * 7;
        graphics.drawString(this.aboutTitle, 15, this.getSize().height / 2 + n2);
        graphics.drawString(this.productText, 15, this.getSize().height / 2 + n2 + n);
        graphics.drawString(this.copyright1, 15, this.getSize().height / 2 + n2 + 2 * n);
        graphics.drawString(this.copyright2, 15, this.getSize().height / 2 + n2 + 3 * n);
        graphics.drawString(this.copyright3, 15, this.getSize().height / 2 + n2 + 4 * n);
        graphics.drawString(this.tradeMark1, 15, this.getSize().height / 2 + n2 + 5 * n);
        graphics.drawString(this.tradeMark2, 15, this.getSize().height / 2 + n2 + 6 * n);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

