/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcadmin;

import com.ibm.vatc.tcadmin.IOEvent;
import com.ibm.vatc.tcadmin.IOListener;
import java.awt.AWTEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ProcessMonitor
implements Runnable {
    private boolean finished = false;
    private Process p;
    private Thread errThread;
    private BufferedReader dataStream;
    private BufferedReader errStream;
    transient IOListener ioListener;

    public ProcessMonitor(String string) {
        this.execProcess(string, null);
    }

    public ProcessMonitor(String string, String[] stringArray) {
        this.execProcess(string, stringArray);
    }

    public void execProcess(String string, String[] stringArray) {
        try {
            this.p = Runtime.getRuntime().exec(string, stringArray);
            new Thread(this).start();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void run() {
        if (this.p != null) {
            try {
                if (Thread.currentThread() == this.errThread) {
                    String string;
                    this.errStream = new BufferedReader(new InputStreamReader(this.p.getErrorStream()), 8);
                    while ((string = this.errStream.readLine()) != null) {
                        this.processIoEvent(new IOEvent(this, 2, string));
                    }
                } else {
                    String string;
                    this.errThread = new Thread(this);
                    this.errThread.start();
                    this.dataStream = new BufferedReader(new InputStreamReader(this.p.getInputStream()), 8);
                    while ((string = this.dataStream.readLine()) != null) {
                        this.processIoEvent(new IOEvent(this, 1, string));
                    }
                    this.processIoEvent(new IOEvent(this, -1, Integer.toString(this.exitValue())));
                    this.finished = true;
                }
            }
            catch (Exception exception) {}
        }
        Thread.currentThread().stop();
    }

    public int waitFor() {
        int n = Integer.MIN_VALUE;
        try {
            if (this.p != null) {
                n = this.p.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {
            n = Integer.MIN_VALUE;
        }
        while (!this.finished) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                System.err.println("Unable to sleep long enough");
            }
        }
        return n;
    }

    public void destroy() {
        this.p.destroy();
    }

    public int exitValue() {
        int n;
        block2: {
            n = Integer.MIN_VALUE;
            if (this.p == null) break block2;
            try {
                n = this.p.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
        return n;
    }

    public synchronized void addIoListener(IOListener iOListener) {
        this.ioListener = iOListener;
    }

    public synchronized void removeIoListener(IOListener iOListener) {
        this.ioListener = null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof IOEvent) {
            this.processIoEvent((IOEvent)aWTEvent);
            return;
        }
    }

    protected void processIoEvent(IOEvent iOEvent) {
        if (this.ioListener != null) {
            this.ioListener.ioPerformed(iOEvent);
        }
    }
}

