CREATE TABLE DSCobolClauses 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     strPictureClause          VarChar(254)   ,
     eSignClause               Int   ,
     eUsageClause              Int   ,
     strUsageClause            VarChar(254)   ,
     isBWZ                     Int   ,
     isGlobal                  Int   ,
     isExternal                Int   ,
     isJustified               Int   ,
     isSync                    Int   ,
     constraint PKDSCobolClauses Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSCobolClauses AS --Plasma for DSCobolClauses
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSCobolClauses a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSRDBDataAttributs   -- DSRDBDataAttributes
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     bitFlag                   Int   ,
     precision                 Int   ,
     scale                     Int   ,
     colLength                 Int   ,
     eTypeName                 Int   ,
     strTypeName               VarChar(254)   ,
     eOracleType               Int   ,
     oracleHasScale            Int   ,
     constraint PKDSRDBDataAttrbts Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSRDBDatAttrbts AS --Plasma for DSRDBDataAttributes
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSRDBDataAttributs a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSPLIDataAttributs   -- DSPLIDataAttributes
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     strTypeString             VarChar(254)   ,
     eDataKind                 Int   ,
     binOrDec                  Int   ,
     fixedOrFloat              Int   ,
     precision                 Int   ,
     scale                     Int   ,
     signedOrUnsigned          Int   ,
     realOrComplex             Int   ,
     strPicture                VarChar(254)   ,
     ulLength                  Int   ,
     eVarLenStr                Int   ,
     constraint PKDSPLIDataAttrbts Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSPLIDatAttrbts AS --Plasma for DSPLIDataAttributes
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSPLIDataAttributs a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSVGDataAttributes 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     eType                     Int   ,
     sDecimals                 Int   ,
     ulLength                  Int   ,
     usBytes                   Int   ,
     bEvenSQL                  Int   ,
     ulBytes                   Int   ,
     cIMSTypeChar              Int   ,
     constraint PKDSVGDataAttribts Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSVGDataAttrbts AS --Plasma for DSVGDataAttributes
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSVGDataAttributes a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

