/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.RollOverButton;
import com.ibm.vatc.reuse.awt.Toolbar;
import com.ibm.vatc.tcmerge.AboutDialog;
import com.ibm.vatc.tcmerge.CollisionsDialog;
import com.ibm.vatc.tcmerge.CollisionsNotifier;
import com.ibm.vatc.tcmerge.CompositeView;
import com.ibm.vatc.tcmerge.DiffInfoCommon;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.DiffOutput;
import com.ibm.vatc.tcmerge.EditLineDialog;
import com.ibm.vatc.tcmerge.FileOneView;
import com.ibm.vatc.tcmerge.FileSave;
import com.ibm.vatc.tcmerge.FileTwoView;
import com.ibm.vatc.tcmerge.FileZeroView;
import com.ibm.vatc.tcmerge.HDragLayout;
import com.ibm.vatc.tcmerge.HDragPanel;
import com.ibm.vatc.tcmerge.IOProperties;
import com.ibm.vatc.tcmerge.Legend;
import com.ibm.vatc.tcmerge.LegendNotifier;
import com.ibm.vatc.tcmerge.MakeViews;
import com.ibm.vatc.tcmerge.MergeDirectoriesDialog;
import com.ibm.vatc.tcmerge.MergeFilesDialog;
import com.ibm.vatc.tcmerge.MergeGuiWindowListener;
import com.ibm.vatc.tcmerge.MergeOptionsDialog;
import com.ibm.vatc.tcmerge.Navigate;
import com.ibm.vatc.tcmerge.NavigatorDialog;
import com.ibm.vatc.tcmerge.NavigatorNotifier;
import com.ibm.vatc.tcmerge.Options;
import com.ibm.vatc.tcmerge.OutputView;
import com.ibm.vatc.tcmerge.PrintDialog;
import com.ibm.vatc.tcmerge.PropertiesGui;
import com.ibm.vatc.tcmerge.RecentFiles;
import com.ibm.vatc.tcmerge.ScrollFileOne;
import com.ibm.vatc.tcmerge.ScrollFileTwo;
import com.ibm.vatc.tcmerge.ScrollFileZero;
import com.ibm.vatc.tcmerge.ScrollPanel;
import com.ibm.vatc.tcmerge.Status;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.TextComposite;
import com.ibm.vatc.tcmerge.TextRefOutput;
import com.ibm.vatc.tcmerge.TitleComposite;
import com.ibm.vatc.tcmerge.TitleFileOne;
import com.ibm.vatc.tcmerge.TitleFileTwo;
import com.ibm.vatc.tcmerge.TitleFileZero;
import com.ibm.vatc.tcmerge.TitleOutput;
import com.ibm.vatc.tcmerge.ToolbarListener;
import com.ibm.vatc.tcmerge.VDragLayout;
import com.ibm.vatc.tcmerge.VDragPanel;
import com.ibm.vatc.tcmerge.ViewParam;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.YesNoDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

class MergeGui
extends Frame
implements ActionListener,
ItemListener {
    private static final String COPYRIGHT__ = "Tool:cmn, IBM Confidential, (C) Copyright IBM Corp (This work is unpublished.) All rights reserved.";
    private tcmerge mergeApp;
    private ViewParam viewParam;
    private Options options;
    private MakeViews makeViews;
    private IOProperties propertiesFile;
    private CompositeView compositeView;
    private OutputView outputView;
    private FileZeroView fileZeroView;
    private FileOneView fileOneView;
    private FileTwoView fileTwoView;
    private ScrollPanel scrollComposite;
    private ScrollPanel scrollOutput;
    private ScrollPanel scrollFileZero;
    private ScrollPanel scrollFileOne;
    private ScrollPanel scrollFileTwo;
    private TitleComposite titleComposite;
    private TitleOutput titleOutput;
    private TitleFileZero titleFileZero;
    private TitleFileOne titleFileOne;
    private TitleFileTwo titleFileTwo;
    private Status status;
    private Toolbar toolbar;
    private Toolbar auxToolbar;
    private DiffInput diffInput;
    private DiffOutput diffOutput;
    private Legend legendWindow;
    private CollisionsDialog collisionsWindow;
    private NavigatorDialog navigatorWindow;
    private EditLineDialog editDialog;
    Cursor waitCursor;
    private MergeGuiWindowListener windowListener;
    private Clipboard clipboard;
    private Panel panelComposite;
    private Panel panelOutput;
    private Panel panelFileZero;
    private Panel panelFileOne;
    private Panel panelFileTwo;
    private Panel panelStatus;
    private HDragPanel panelText;
    private HDragLayout panelTextLayout;
    private VDragPanel panelSplit;
    private VDragLayout panelSplitLayout;
    private RollOverButton rolloverMergeFiles;
    private RollOverButton rolloverMergeDirectory;
    private RollOverButton rolloverSave;
    private RollOverButton rolloverProperties;
    private RollOverButton rolloverNextDiff;
    private RollOverButton rolloverPreviousDiff;
    private RollOverButton rolloverCompositeView;
    private RollOverButton rolloverSplitView;
    private RollOverButton rolloverLegend;
    private RollOverButton rolloverNavigator;
    private RollOverButton rolloverCollisions;
    public static int INITIAL_WIDTH = 900;
    public static int INITIAL_HEIGHT = 600;
    public static int INITIAL_TEXTAREA_HEIGHT = 485;
    public static int RECENTFILECOUNT = 5;
    private boolean propertiesState = true;
    MenuBar menuBar;
    private Menu menuFile;
    private MenuItem itemMergeFiles;
    private MenuItem itemMergeDirectories;
    private MenuItem itemSaveOutput;
    private MenuItem itemSaveOutputAs;
    private MenuItem itemProperties;
    private MenuItem itemPrint;
    private Vector itemRecentFiles;
    private MenuItem itemExit;
    private Menu menuEdit;
    private MenuItem itemUndo;
    private Menu menuInsertBlock;
    private MenuItem itemFromInput1;
    private MenuItem itemFromInput2;
    private MenuItem itemFromInput3;
    private MenuItem itemEditBlock;
    private MenuItem itemCopy;
    private MenuItem itemPaste;
    private Menu menuView;
    private CheckboxMenuItem itemComposite;
    private CheckboxMenuItem itemSplit;
    private CheckboxMenuItem itemScrollTogether;
    private Menu menuMaximize;
    private MenuItem itemMaximizeInputs;
    private MenuItem itemMaximizeInput1;
    private MenuItem itemMaximizeInput2;
    private MenuItem itemMaximizeInput3;
    private MenuItem itemMaximizeOutput;
    private MenuItem itemResetPanes;
    private CheckboxMenuItem itemLineNumbers;
    private MenuItem itemNextDifference;
    private MenuItem itemPreviousDifference;
    private MenuItem itemFirstDifference;
    private MenuItem itemLastDifference;
    private MenuItem itemGotoDifference;
    private MenuItem itemStartOfDifference;
    private MenuItem itemEndOfDifference;
    private CheckboxMenuItem itemToolbar;
    private CheckboxMenuItem itemStatusBar;
    private Menu menuOptions;
    private MenuItem itemRecalculate;
    private Menu menuIgnoreUnique;
    private MenuItem itemIgnoreNone;
    private MenuItem itemIgnoreInput1;
    private MenuItem itemIgnoreInput2;
    private MenuItem itemIgnoreInput3;
    private Menu menuWindow;
    private CheckboxMenuItem itemNavigator;
    private CheckboxMenuItem itemCollisions;
    private CheckboxMenuItem itemLegend;
    private Menu menuHelp;
    private MenuItem itemMergeTool;
    private MenuItem itemContents;
    private MenuItem itemAboutMerge;
    static /* synthetic */ Class class$com$ibm$vatc$tcmerge$MergeGui;

    public MergeGui(tcmerge tcmerge2) throws IOException {
        super(tcmerge.locResource.getString("STR_TCMERGE"));
        Dimension dimension = this.getToolkit().getScreenSize();
        if (dimension.height < INITIAL_HEIGHT) {
            INITIAL_HEIGHT = dimension.height - 10;
            INITIAL_TEXTAREA_HEIGHT = INITIAL_HEIGHT * 485 / 600;
        }
        if (dimension.width < INITIAL_WIDTH) {
            INITIAL_WIDTH = dimension.width - 10;
        }
        this.setupMenu();
        this.mergeApp = tcmerge2;
        this.diffInput = tcmerge2.getDiffInput();
        this.diffOutput = tcmerge2.getDiffOutput();
        this.viewParam = new ViewParam();
        this.options = new Options();
        this.makeViews = new MakeViews(this);
        this.status = new Status(this);
        Class clazz = class$com$ibm$vatc$tcmerge$MergeGui != null ? class$com$ibm$vatc$tcmerge$MergeGui : (class$com$ibm$vatc$tcmerge$MergeGui = MergeGui.class$("com.ibm.vatc.tcmerge.MergeGui"));
        this.toolbar = new Toolbar(clazz);
        this.auxToolbar = new Toolbar(clazz);
        this.scrollComposite = new ScrollPanel(this);
        this.scrollOutput = new ScrollPanel(this);
        this.scrollFileZero = new ScrollFileZero(this);
        this.scrollFileOne = new ScrollFileOne(this);
        this.scrollFileTwo = new ScrollFileTwo(this);
        this.outputView = new OutputView(this.scrollOutput, this);
        this.compositeView = new CompositeView(this.scrollComposite, this);
        this.fileZeroView = new FileZeroView(this.scrollFileZero, this);
        this.fileOneView = new FileOneView(this.scrollFileOne, this);
        this.fileTwoView = new FileTwoView(this.scrollFileTwo, this);
        this.titleComposite = new TitleComposite(this);
        this.titleOutput = new TitleOutput(this);
        this.titleFileZero = new TitleFileZero(this);
        this.titleFileOne = new TitleFileOne(this);
        this.titleFileTwo = new TitleFileTwo(this);
        this.panelComposite = new Panel(new BorderLayout());
        this.panelOutput = new Panel(new BorderLayout());
        this.panelFileZero = new Panel(new BorderLayout());
        this.panelFileOne = new Panel(new BorderLayout());
        this.panelFileTwo = new Panel(new BorderLayout());
        this.panelStatus = new Panel(new FlowLayout(30));
        this.panelText = new HDragPanel();
        this.panelTextLayout = new HDragLayout(0, this.panelText);
        this.panelSplit = new VDragPanel();
        this.panelSplitLayout = new VDragLayout(0, this.panelSplit);
        this.panelText.setLayout(this.panelTextLayout);
        this.panelSplit.setLayout(this.panelSplitLayout);
        this.waitCursor = new Cursor(3);
        this.windowListener = new MergeGuiWindowListener(this);
        this.addWindowListener(this.windowListener);
        ToolbarListener toolbarListener = new ToolbarListener(this);
        this.rolloverMergeFiles = this.toolbar.addTool("mfnoroll.gif", "mfgrey.gif", "mfroll.gif", "mfdown.gif", toolbarListener);
        this.rolloverMergeDirectory = this.toolbar.addTool("mdnoroll.gif", "mdgrey.gif", "mdroll.gif", "mddown.gif", toolbarListener);
        this.rolloverSave = this.toolbar.addTool("svnoroll.gif", "svgrey.gif", "svroll.gif", "svdown.gif", toolbarListener);
        this.rolloverProperties = this.toolbar.addTool("prnoroll.gif", "prgrey.gif", "prroll.gif", "prdown.gif", toolbarListener);
        this.toolbar.addSeparator(3);
        this.rolloverNextDiff = this.toolbar.addTool("ndnoroll.gif", "ndgrey.gif", "ndroll.gif", "nddown.gif", toolbarListener);
        this.rolloverPreviousDiff = this.toolbar.addTool("pdnoroll.gif", "pdgrey.gif", "pdroll.gif", "pddown.gif", toolbarListener);
        this.rolloverCompositeView = this.toolbar.addTool("cvnoroll.gif", "cvgrey.gif", "cvroll.gif", "cvdown.gif", toolbarListener);
        this.rolloverSplitView = this.toolbar.addTool("spnoroll.gif", "spgrey.gif", "sproll.gif", "spdown.gif", toolbarListener);
        this.rolloverLegend = this.auxToolbar.addTool("lgnoroll.gif", "lggrey.gif", "lgroll.gif", "lgdown.gif", toolbarListener);
        this.rolloverNavigator = this.auxToolbar.addTool("nvnoroll.gif", "nvgrey.gif", "nvroll.gif", "nvdown.gif", toolbarListener);
        this.rolloverCollisions = this.auxToolbar.addTool("dmnoroll.gif", "dmgrey.gif", "dmroll.gif", "dmdown.gif", toolbarListener);
        this.propertiesFile = new IOProperties(this);
        if (this.propertiesFile.setPropertiesFileName() == 0) {
            this.propertiesFile.LoadPropertyFile();
            this.propertiesFile.getPropertyScheme();
            this.setFontsInViews();
        }
        this.scrollComposite.add(this.compositeView);
        this.panelComposite.add("Center", this.scrollComposite);
        this.panelComposite.add("North", this.titleComposite);
        this.scrollOutput.add(this.outputView);
        this.panelOutput.add("Center", this.scrollOutput);
        this.panelOutput.add("North", this.titleOutput);
        this.scrollFileZero.add(this.fileZeroView);
        this.panelFileZero.add("Center", this.scrollFileZero);
        this.panelFileZero.add("North", this.titleFileZero);
        this.scrollFileOne.add(this.fileOneView);
        this.panelFileOne.add("Center", this.scrollFileOne);
        this.panelFileOne.add("North", this.titleFileOne);
        this.scrollFileTwo.add(this.fileTwoView);
        this.panelFileTwo.add("Center", this.scrollFileTwo);
        this.panelFileTwo.add("North", this.titleFileTwo);
        if (this.diffInput.getInputFiles().size() == 2) {
            this.panelSplit.setTopDividerPos(INITIAL_TEXTAREA_HEIGHT / 2);
            this.panelSplit.setBottomDividerPos(INITIAL_TEXTAREA_HEIGHT);
            this.panelSplit.add("One", this.panelFileZero);
            this.panelSplit.add("Two", this.panelFileOne);
        } else {
            this.panelSplit.setTopDividerPos(INITIAL_TEXTAREA_HEIGHT / 3);
            this.panelSplit.setBottomDividerPos(INITIAL_TEXTAREA_HEIGHT * 2 / 3);
            this.panelSplit.add("One", this.panelFileZero);
            this.panelSplit.add("Two", this.panelFileOne);
            this.panelSplit.add("Three", this.panelFileTwo);
        }
        if (this.viewParam.getIsCompo()) {
            this.itemComposite.setState(true);
            this.panelText.add("Left", this.panelComposite);
        } else {
            this.itemSplit.setState(true);
            this.panelText.add("Left", this.panelSplit);
        }
        this.panelText.add("Right", this.panelOutput);
        this.status.setStatusBar(0);
        this.panelStatus.setBackground(Color.lightGray);
        this.panelStatus.add(this.status);
        this.panelStatus.add(this.auxToolbar);
        this.add("Center", this.panelText);
        this.add("South", this.panelStatus);
        this.add("North", this.toolbar);
        this.setTitles();
        if (this.diffInput.getInputFiles().size() == 2) {
            this.itemFromInput3.setEnabled(false);
            this.menuIgnoreUnique.setEnabled(false);
        }
        if (this.diffInput.getAutomerge()) {
            this.menuIgnoreUnique.setEnabled(false);
        }
        this.itemFirstDifference.setEnabled(false);
        this.itemPreviousDifference.setEnabled(false);
        this.rolloverPreviousDiff.setEnabled(false);
        if (this.viewParam.getIsCompo()) {
            this.rolloverCompositeView.setEnabled(false);
            this.itemScrollTogether.setEnabled(false);
            this.itemMaximizeInput1.setEnabled(false);
            this.itemMaximizeInput2.setEnabled(false);
            this.itemMaximizeInput3.setEnabled(false);
        } else {
            this.rolloverSplitView.setEnabled(false);
            this.itemScrollTogether.setEnabled(true);
            this.itemMaximizeInput1.setEnabled(true);
            this.itemMaximizeInput2.setEnabled(true);
            this.itemMaximizeInput3.setEnabled(true);
        }
        if (this.diffInput.getDirectoryMergeList().size() < 2) {
            this.itemCollisions.setEnabled(false);
            this.rolloverCollisions.setEnabled(false);
        }
        if (this.makeViews.totalDifferences == 0) {
            this.itemNextDifference.setEnabled(false);
            this.itemLastDifference.setEnabled(false);
            this.itemGotoDifference.setEnabled(false);
            this.itemStartOfDifference.setEnabled(false);
            this.itemEndOfDifference.setEnabled(false);
            this.menuEdit.setEnabled(false);
            this.itemNavigator.setEnabled(false);
            this.rolloverNavigator.setEnabled(false);
            this.menuIgnoreUnique.setEnabled(false);
        }
        this.addRecentFiles();
    }

    public void updateMergeGui() {
        if (this.diffInput.getInputFiles().size() == 2) {
            this.itemFromInput3.setEnabled(false);
            this.menuIgnoreUnique.setEnabled(false);
        } else {
            this.itemFromInput3.setEnabled(true);
            this.menuIgnoreUnique.setEnabled(true);
        }
        if (this.diffInput.getAutomerge()) {
            this.menuIgnoreUnique.setEnabled(false);
        }
        this.panelSplit.invalidate();
        this.panelSplit.removeAll();
        if (this.diffInput.getInputFiles().size() == 2) {
            this.panelSplit.setTopDividerPos((this.getSize().height - 100) / 2);
            this.panelSplit.setBottomDividerPos(this.getSize().height - 100);
            this.panelSplit.add("One", this.panelFileZero);
            this.panelSplit.add("Two", this.panelFileOne);
        } else {
            this.panelSplit.setTopDividerPos((this.getSize().height - 100) / 3);
            this.panelSplit.setBottomDividerPos((this.getSize().height - 100) * 2 / 3);
            this.panelSplit.add("One", this.panelFileZero);
            this.panelSplit.add("Two", this.panelFileOne);
            this.panelSplit.add("Three", this.panelFileTwo);
        }
        this.panelSplit.validate();
        this.panelSplit.doLayout();
        this.doLayout();
        if (!this.viewParam.getIsCompo()) {
            this.itemMaximizeInput1.setEnabled(true);
            this.itemMaximizeInput2.setEnabled(true);
            if (this.diffInput.getInputFiles().size() == 2) {
                this.fileZeroView.setVScrollToCurrentDiff();
                this.fileOneView.setVScrollToCurrentDiff();
                this.fileZeroView.repaint();
                this.fileOneView.repaint();
            } else {
                this.itemMaximizeInput3.setEnabled(true);
                this.fileZeroView.setVScrollToCurrentDiff();
                this.fileOneView.setVScrollToCurrentDiff();
                this.fileTwoView.setMaximumVerticalScrollbar();
                this.fileTwoView.setVScrollToCurrentDiff();
                this.fileZeroView.repaint();
                this.fileOneView.repaint();
                this.fileTwoView.repaint();
            }
        } else {
            this.compositeView.setVScrollToCurrentDiff();
            this.compositeView.repaint();
            this.itemMaximizeInput1.setEnabled(false);
            this.itemMaximizeInput2.setEnabled(false);
            this.itemMaximizeInput3.setEnabled(false);
        }
        this.setTitles();
        this.status.setMessageFlag(false);
        this.status.repaint();
        this.panelSplit.resetPanes();
        this.outputView.setVScrollToCurrentDiff();
        this.outputView.repaint();
        this.itemFirstDifference.setEnabled(false);
        this.itemPreviousDifference.setEnabled(false);
        this.rolloverPreviousDiff.setEnabled(false);
        this.itemLastDifference.setEnabled(true);
        this.itemNextDifference.setEnabled(true);
        this.rolloverNextDiff.setEnabled(true);
        if (this.diffInput.getDirectoryMergeList().size() < 2) {
            this.itemCollisions.setEnabled(false);
            this.rolloverCollisions.setEnabled(false);
        } else {
            this.itemCollisions.setEnabled(true);
            this.rolloverCollisions.setEnabled(true);
        }
        if (this.makeViews.totalDifferences == 0) {
            this.itemNextDifference.setEnabled(false);
            this.itemLastDifference.setEnabled(false);
            this.itemGotoDifference.setEnabled(false);
            this.itemStartOfDifference.setEnabled(false);
            this.itemEndOfDifference.setEnabled(false);
            this.menuEdit.setEnabled(false);
            this.itemNavigator.setEnabled(false);
            this.rolloverNavigator.setEnabled(false);
            this.menuIgnoreUnique.setEnabled(false);
        } else {
            this.itemNextDifference.setEnabled(true);
            this.itemLastDifference.setEnabled(true);
            this.itemGotoDifference.setEnabled(true);
            this.itemStartOfDifference.setEnabled(true);
            this.itemEndOfDifference.setEnabled(true);
            this.menuEdit.setEnabled(true);
            this.itemNavigator.setEnabled(true);
            this.rolloverNavigator.setEnabled(true);
            this.menuIgnoreUnique.setEnabled(true);
        }
        if (this.navigatorWindow != null && this.navigatorWindow.isVisible()) {
            this.navigatorWindow.updateNavigator();
        }
        this.addRecentFiles();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.status.setMessageFlag(false);
        this.status.repaint();
        MenuItem menuItem = (MenuItem)actionEvent.getSource();
        if (menuItem == this.itemMergeFiles) {
            this.mergeFiles();
            return;
        }
        if (menuItem == this.itemMergeDirectories) {
            this.mergeDirectories();
            return;
        }
        if (menuItem == this.itemSaveOutput) {
            ((Component)this).setCursor(this.waitCursor);
            FileSave fileSave = new FileSave(this);
            fileSave.saveOutputFile();
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (menuItem == this.itemSaveOutputAs) {
            ((Component)this).setCursor(this.waitCursor);
            FileSave fileSave = new FileSave(this);
            fileSave.saveOutputFileAs();
            ((Component)this).setCursor(Cursor.getDefaultCursor());
            return;
        }
        if (menuItem == this.itemProperties) {
            this.propertiesWindow();
            return;
        }
        if (menuItem == this.itemPrint) {
            PrintDialog printDialog = new PrintDialog((Frame)this, this.makeViews);
            printDialog.show();
            printDialog.dispose();
            return;
        }
        if (menuItem == this.itemExit) {
            int n = -1;
            if (!this.viewParam.getOutputSaved()) {
                FileSave fileSave = new FileSave(this);
                n = fileSave.isSaveNeeded();
                if (n == 0) {
                    System.exit(0);
                    return;
                }
            } else {
                System.exit(0);
            }
            return;
        }
        if (menuItem == this.itemUndo) {
            this.makeViews.undoLastAction();
            this.outputView.repaint();
            return;
        }
        if (menuItem == this.itemFromInput1) {
            int n = this.viewParam.getCurrentDiff();
            this.makeViews.primeOneDiff(0, n);
            this.outputView.repaint();
            this.viewParam.setOutputSaved(false);
            this.setOutputViewTitle();
            if (this.navigatorWindow != null && this.navigatorWindow.isVisible()) {
                this.navigatorWindow.updateNavigator();
                return;
            }
        } else if (menuItem == this.itemFromInput2) {
            int n = this.viewParam.getCurrentDiff();
            this.makeViews.primeOneDiff(1, n);
            this.outputView.repaint();
            this.viewParam.setOutputSaved(false);
            this.setOutputViewTitle();
            if (this.navigatorWindow != null && this.navigatorWindow.isVisible()) {
                this.navigatorWindow.updateNavigator();
                return;
            }
        } else if (menuItem == this.itemFromInput3) {
            int n = this.viewParam.getCurrentDiff();
            this.makeViews.primeOneDiff(2, n);
            this.outputView.repaint();
            this.viewParam.setOutputSaved(false);
            this.setOutputViewTitle();
            if (this.navigatorWindow != null && this.navigatorWindow.isVisible()) {
                this.navigatorWindow.updateNavigator();
                return;
            }
        } else {
            if (menuItem == this.itemEditBlock) {
                this.editBlock(0);
                return;
            }
            if (menuItem == this.itemCopy) {
                this.copyToClipboard();
                return;
            }
            if (menuItem == this.itemPaste) {
                this.pasteFromClipboard();
                return;
            }
            if (menuItem == this.itemMaximizeInputs) {
                this.maximizeComposite();
                return;
            }
            if (menuItem == this.itemMaximizeInput1) {
                this.maximizeFileZero();
                return;
            }
            if (menuItem == this.itemMaximizeInput2) {
                this.maximizeFileOne();
                return;
            }
            if (menuItem == this.itemMaximizeInput3) {
                this.maximizeFileTwo();
                return;
            }
            if (menuItem == this.itemMaximizeOutput) {
                this.maximizeOutput();
                return;
            }
            if (menuItem == this.itemResetPanes) {
                this.resetPanes();
                return;
            }
            if (menuItem == this.itemNextDifference) {
                Navigate navigate = new Navigate(this);
                navigate.nextDifference();
                return;
            }
            if (menuItem == this.itemPreviousDifference) {
                Navigate navigate = new Navigate(this);
                navigate.previousDifference();
                return;
            }
            if (menuItem == this.itemFirstDifference) {
                Navigate navigate = new Navigate(this);
                navigate.firstDifference();
                return;
            }
            if (menuItem == this.itemLastDifference) {
                Navigate navigate = new Navigate(this);
                navigate.lastDifference();
                return;
            }
            if (menuItem == this.itemGotoDifference) {
                ((Component)this).setCursor(this.waitCursor);
                Navigate navigate = new Navigate(this);
                navigate.gotoDifference();
                ((Component)this).setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (menuItem == this.itemStartOfDifference) {
                Navigate navigate = new Navigate(this);
                navigate.startOfDifference();
                return;
            }
            if (menuItem == this.itemEndOfDifference) {
                Navigate navigate = new Navigate(this);
                navigate.endOfDifference();
                return;
            }
            if (menuItem == this.itemRecalculate) {
                ((Component)this).setCursor(this.waitCursor);
                this.recalculate();
                ((Component)this).setCursor(Cursor.getDefaultCursor());
                return;
            }
            if (menuItem == this.itemIgnoreNone) {
                this.ignoreUniqueDifference(-1);
                return;
            }
            if (menuItem == this.itemIgnoreInput1) {
                this.ignoreUniqueDifference(0);
                return;
            }
            if (menuItem == this.itemIgnoreInput2) {
                this.ignoreUniqueDifference(1);
                return;
            }
            if (menuItem == this.itemIgnoreInput3) {
                this.ignoreUniqueDifference(2);
                return;
            }
            if (menuItem == this.itemMergeTool) {
                TCMergeHelp.showHelp(this, "Header_1");
                return;
            }
            if (menuItem == this.itemContents) {
                TCMergeHelp.showHelp(this, "ToC");
                return;
            }
            if (menuItem == this.itemAboutMerge) {
                AboutDialog aboutDialog = new AboutDialog(this);
                ((Component)aboutDialog).setSize(600, 420);
                Dimension dimension = this.getToolkit().getScreenSize();
                ((Component)aboutDialog).setLocation(Math.round((dimension.width - 600) / 2), Math.round((dimension.height - 380) / 2));
                aboutDialog.show();
                return;
            }
            int n = 0;
            while (n < RECENTFILECOUNT) {
                if (menuItem == this.getItemRecentFiles(n)) {
                    this.recalculateRecentFiles(n);
                    return;
                }
                ++n;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.status.setMessageFlag(false);
        this.status.repaint();
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getItemSelectable();
        if (checkboxMenuItem == this.itemComposite) {
            this.showCompositeWindow();
            return;
        }
        if (checkboxMenuItem == this.itemSplit) {
            this.showSplitWindow();
            return;
        }
        if (checkboxMenuItem == this.itemScrollTogether) {
            if (!this.itemScrollTogether.getState()) {
                this.viewParam.setScrollTogether(false);
                return;
            }
            this.viewParam.setScrollTogether(true);
            return;
        }
        if (checkboxMenuItem == this.itemToolbar) {
            if (!this.itemToolbar.getState()) {
                this.viewParam.setToolbar(false);
                this.toolbar.setVisible(false);
                ((Component)this).setVisible(true);
                return;
            }
            this.viewParam.setToolbar(true);
            this.toolbar.setVisible(true);
            ((Component)this).setVisible(true);
            return;
        }
        if (checkboxMenuItem == this.itemStatusBar) {
            if (!this.itemStatusBar.getState()) {
                this.viewParam.setStatusBar(false);
                this.panelStatus.setVisible(false);
                ((Component)this).setVisible(true);
                return;
            }
            this.viewParam.setStatusBar(true);
            this.panelStatus.setVisible(true);
            ((Component)this).setVisible(true);
            return;
        }
        if (checkboxMenuItem == this.itemLineNumbers) {
            if (this.itemLineNumbers.getState()) {
                this.viewParam.setIsLineShown(true);
            } else {
                this.viewParam.setIsLineShown(false);
            }
            this.outputView.repaint();
            return;
        }
        if (checkboxMenuItem == this.itemNavigator) {
            this.navigatorWindow();
            return;
        }
        if (checkboxMenuItem == this.itemCollisions) {
            this.collisionsWindow();
            return;
        }
        if (checkboxMenuItem == this.itemLegend) {
            this.legendWindow();
        }
    }

    public MakeViews getMakeViews() {
        return this.makeViews;
    }

    public tcmerge getTcMerge() {
        return this.mergeApp;
    }

    public Options getOptions() {
        return this.options;
    }

    public IOProperties getPropertiesFile() {
        return this.propertiesFile;
    }

    public ViewParam getViewParam() {
        return this.viewParam;
    }

    public CompositeView getCompositeView() {
        return this.compositeView;
    }

    public OutputView getOutputView() {
        return this.outputView;
    }

    public FileZeroView getFileZeroView() {
        return this.fileZeroView;
    }

    public FileOneView getFileOneView() {
        return this.fileOneView;
    }

    public FileTwoView getFileTwoView() {
        return this.fileTwoView;
    }

    public DiffInput getDiffInput() {
        return this.diffInput;
    }

    public DiffOutput getDiffOutput() {
        return this.diffOutput;
    }

    public ScrollPanel getScrollComposite() {
        return this.scrollComposite;
    }

    public ScrollPanel getScrollOutput() {
        return this.scrollOutput;
    }

    public Status getStatus() {
        return this.status;
    }

    public VDragPanel getPanelSplit() {
        return this.panelSplit;
    }

    public TitleOutput getOutputViewTitle() {
        return this.titleOutput;
    }

    public CollisionsDialog getCollisionsDialog() {
        return this.collisionsWindow;
    }

    public NavigatorDialog getNavigatorDialog() {
        return this.navigatorWindow;
    }

    public CheckboxMenuItem getItemLegend() {
        return this.itemLegend;
    }

    public CheckboxMenuItem getItemCollisions() {
        return this.itemCollisions;
    }

    public CheckboxMenuItem getItemNavigator() {
        return this.itemNavigator;
    }

    public MenuItem getItemPreviousDiff() {
        return this.itemPreviousDifference;
    }

    public MenuItem getItemNextDiff() {
        return this.itemNextDifference;
    }

    public MenuItem getItemFirstDiff() {
        return this.itemFirstDifference;
    }

    public MenuItem getItemLastDiff() {
        return this.itemLastDifference;
    }

    public RollOverButton getRolloverPreviousDiff() {
        return this.rolloverPreviousDiff;
    }

    public RollOverButton getRolloverNextDiff() {
        return this.rolloverNextDiff;
    }

    public RollOverButton getRolloverSave() {
        return this.rolloverSave;
    }

    public RollOverButton getRolloverMergeFiles() {
        return this.rolloverMergeFiles;
    }

    public RollOverButton getRolloverMergeDirectory() {
        return this.rolloverMergeDirectory;
    }

    public RollOverButton getRolloverProperties() {
        return this.rolloverProperties;
    }

    public RollOverButton getRolloverCompositeView() {
        return this.rolloverCompositeView;
    }

    public RollOverButton getRolloverSplitView() {
        return this.rolloverSplitView;
    }

    public RollOverButton getRolloverLegend() {
        return this.rolloverLegend;
    }

    public RollOverButton getRolloverNavigator() {
        return this.rolloverNavigator;
    }

    public RollOverButton getRolloverCollisions() {
        return this.rolloverCollisions;
    }

    public void maximizeFileZero() {
        this.panelText.maximizeLeft();
        this.panelSplit.maximizeOne();
        this.viewParam.setIsMaximized(true);
    }

    public void maximizeFileOne() {
        this.panelText.maximizeLeft();
        this.panelSplit.maximizeTwo();
        this.viewParam.setIsMaximized(true);
    }

    public void maximizeFileTwo() {
        this.panelText.maximizeLeft();
        this.panelSplit.maximizeThree();
        this.viewParam.setIsMaximized(true);
    }

    public void maximizeComposite() {
        this.panelText.maximizeLeft();
        this.viewParam.setIsMaximized(true);
    }

    public void maximizeOutput() {
        this.panelText.maximizeRight();
        this.viewParam.setIsMaximized(true);
    }

    public void maximizeInput() {
        this.panelText.maximizeLeft();
        this.viewParam.setIsMaximized(true);
    }

    public void resetPanes() {
        this.panelSplit.resetPanes();
        this.panelText.resetPanes();
        this.viewParam.setIsMaximized(false);
    }

    public void resetSplitPanes() {
        if (this.diffInput.getInputFiles().size() == 3) {
            this.panelSplit.setPreviousHeight(this.panelOutput.getSize().height);
            this.panelSplit.setTopDividerPos(this.panelOutput.getSize().height / 3);
            this.panelSplit.setBottomDividerPos(this.panelOutput.getSize().height * 2 / 3);
            return;
        }
        if (this.diffInput.getInputFiles().size() == 2) {
            this.panelSplit.setPreviousHeight(this.panelOutput.getSize().height);
            this.panelSplit.setTopDividerPos(this.panelOutput.getSize().height / 2);
            this.panelSplit.setBottomDividerPos(this.panelOutput.getSize().height);
        }
    }

    public void showSplitWindow() {
        if (this.viewParam.getIsCompo() && this.itemSplit.getState()) {
            this.viewParam.setIsCompo(false);
            this.panelText.invalidate();
            this.panelText.removeAll();
            this.resetSplitPanes();
            this.panelText.add("Left", this.panelSplit);
            this.panelText.add("Right", this.panelOutput);
            this.itemComposite.setState(false);
            this.panelText.validate();
            this.panelText.doLayout();
            this.doLayout();
            ((Component)this).setVisible(true);
            this.itemMaximizeInput1.setEnabled(true);
            this.itemMaximizeInput2.setEnabled(true);
            if (this.diffInput.getInputFiles().size() == 3) {
                this.itemMaximizeInput3.setEnabled(true);
            }
        } else if (this.viewParam.getIsCompo() && !this.itemSplit.getState()) {
            this.viewParam.setIsCompo(false);
            this.itemSplit.setState(true);
            this.panelText.invalidate();
            this.panelText.removeAll();
            this.resetSplitPanes();
            this.panelText.add("Left", this.panelSplit);
            this.panelText.add("Right", this.panelOutput);
            this.itemComposite.setState(false);
            this.panelText.validate();
            this.panelText.doLayout();
            this.doLayout();
            ((Component)this).setVisible(true);
            this.itemMaximizeInput1.setEnabled(true);
            this.itemMaximizeInput2.setEnabled(true);
            if (this.diffInput.getInputFiles().size() == 3) {
                this.itemMaximizeInput3.setEnabled(true);
            }
        } else if (!this.viewParam.getIsCompo() && !this.itemSplit.getState()) {
            this.itemSplit.setState(true);
        }
        this.itemScrollTogether.setEnabled(true);
        this.fileZeroView.setVScrollToCurrentDiff();
        this.fileOneView.setVScrollToCurrentDiff();
        this.fileTwoView.setVScrollToCurrentDiff();
        this.rolloverSplitView.setEnabled(false);
        this.rolloverCompositeView.setEnabled(true);
    }

    public void showCompositeWindow() {
        if (!this.viewParam.getIsCompo() && this.itemComposite.getState()) {
            this.viewParam.setIsCompo(true);
            this.panelText.invalidate();
            this.panelText.removeAll();
            this.panelText.add("Left", this.panelComposite);
            this.panelText.add("Right", this.panelOutput);
            this.itemSplit.setState(false);
            this.panelText.validate();
            this.panelText.doLayout();
            this.doLayout();
            this.itemMaximizeInputs.setEnabled(true);
            this.itemMaximizeInput1.setEnabled(false);
            this.itemMaximizeInput2.setEnabled(false);
            this.itemMaximizeInput3.setEnabled(false);
        } else if (!this.viewParam.getIsCompo() && !this.itemComposite.getState()) {
            this.viewParam.setIsCompo(true);
            this.itemComposite.setState(true);
            this.panelText.invalidate();
            this.panelText.removeAll();
            this.panelText.add("Left", this.panelComposite);
            this.panelText.add("Right", this.panelOutput);
            this.itemSplit.setState(false);
            this.panelText.validate();
            this.panelText.doLayout();
            this.doLayout();
            this.itemMaximizeInputs.setEnabled(true);
            this.itemMaximizeInput1.setEnabled(false);
            this.itemMaximizeInput2.setEnabled(false);
            this.itemMaximizeInput3.setEnabled(false);
        } else if (this.viewParam.getIsCompo() && !this.itemComposite.getState()) {
            this.itemComposite.setState(true);
        }
        this.itemScrollTogether.setEnabled(false);
        this.compositeView.setVScrollToCurrentDiff();
        this.rolloverCompositeView.setEnabled(false);
        this.rolloverSplitView.setEnabled(true);
    }

    public void addRecentFiles() {
        if (this.viewParam.getAddToRecentFiles()) {
            int n;
            RecentFiles recentFiles = new RecentFiles();
            recentFiles.input1 = (String)this.diffInput.getInputFiles().elementAt(0);
            recentFiles.input2 = (String)this.diffInput.getInputFiles().elementAt(1);
            if (this.diffInput.getInputFiles().size() > 2) {
                recentFiles.input3 = (String)this.diffInput.getInputFiles().elementAt(2);
            }
            recentFiles.output = this.diffInput.getOutputFile();
            this.viewParam.getRecentMergeFiles().addElement(recentFiles);
            int n2 = this.viewParam.getRecentMergeFiles().size();
            boolean bl = false;
            if (n2 > 1) {
                n = 0;
                while (n < n2 - 1) {
                    if (this.getRecentFileLabel(n2 - 1).equals(this.getRecentFileLabel(n))) {
                        int n3 = n;
                        while (n3 <= RECENTFILECOUNT - 1) {
                            this.getItemRecentFiles(n3).setLabel(this.getRecentFileLabel(n3 + 1));
                            ++n3;
                        }
                        this.viewParam.getRecentMergeFiles().removeElementAt(n);
                        this.menuFile.insert(this.getItemRecentFiles(n), 10);
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (!bl) {
                if (n2 > RECENTFILECOUNT) {
                    n = 0;
                    while (n < RECENTFILECOUNT) {
                        this.getItemRecentFiles(n).setLabel(this.getRecentFileLabel(n + 1));
                        ++n;
                    }
                    this.viewParam.getRecentMergeFiles().removeElementAt(0);
                    n2 = RECENTFILECOUNT;
                } else {
                    this.getItemRecentFiles(n2 - 1).setLabel(this.getRecentFileLabel(n2 - 1));
                }
                this.menuFile.insert(this.getItemRecentFiles(n2 - 1), 10);
            }
        }
    }

    private String getRecentFileLabel(int n) {
        if (n >= this.viewParam.getRecentMergeFiles().size()) {
            return "";
        }
        RecentFiles recentFiles = (RecentFiles)this.viewParam.getRecentMergeFiles().elementAt(n);
        String string = recentFiles.input1;
        File file = new File(string);
        string = file.getName();
        String string2 = recentFiles.input2;
        file = new File(string2);
        string2 = file.getName();
        String string3 = recentFiles.input3;
        if (string3 != null) {
            file = new File(string3);
            string3 = file.getName();
        } else {
            string3 = "";
        }
        String string4 = !string.equals(string2) ? String.valueOf(string) + "," + string2 : string;
        if (!string.equals(string3) && !string3.equals("")) {
            string4 = String.valueOf(string4) + "," + string3;
        }
        return string4;
    }

    private MenuItem getItemRecentFiles(int n) {
        return (MenuItem)this.itemRecentFiles.elementAt(n);
    }

    private void recalculateRecentFiles(int n) {
        Object object;
        int n2 = 0;
        if (!this.viewParam.getOutputSaved()) {
            object = new FileSave(this);
            n2 = ((FileSave)object).isSaveNeeded();
        }
        if (n2 == 0) {
            object = (RecentFiles)this.viewParam.getRecentMergeFiles().elementAt(n);
            this.diffInput.getInputFiles().removeAllElements();
            this.diffInput.getInputFiles().addElement(((RecentFiles)object).input1);
            this.diffInput.getInputFiles().addElement(((RecentFiles)object).input2);
            if (((RecentFiles)object).input3 != null) {
                this.diffInput.getInputFiles().addElement(((RecentFiles)object).input3);
            }
            this.diffInput.setOutputFile(((RecentFiles)object).output);
            this.mergeApp.execute();
        }
    }

    public void mergeFiles() {
        Object object;
        ((Component)this).setCursor(this.waitCursor);
        int n = 0;
        if (!this.viewParam.getOutputSaved()) {
            object = new FileSave(this);
            n = ((FileSave)object).isSaveNeeded();
        }
        if (n == 0) {
            object = new MergeFilesDialog((Frame)this, this.diffInput, this.options.getLocation());
            ((Dialog)object).show();
            if (((MergeFilesDialog)object).getAction() == "OK") {
                if (((MergeFilesDialog)object).recalculateNeeded()) {
                    this.mergeApp.execute();
                } else {
                    this.setTitles();
                }
            }
        }
        this.setOutputViewTitle();
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void mergeDirectories() {
        Object object;
        ((Component)this).setCursor(this.waitCursor);
        int n = 0;
        if (!this.viewParam.getOutputSaved()) {
            object = new FileSave(this);
            n = ((FileSave)object).isSaveNeeded();
        }
        if (n == 0) {
            object = new MergeDirectoriesDialog((Frame)this, this.diffInput, this.options.getLocation());
            ((Dialog)object).show();
            if (((MergeDirectoriesDialog)object).getAction() == "OK") {
                this.mergeApp.buildFileList(this.diffInput.getInputDirectories(), this.diffInput.getOutputDirectory());
                if (this.diffInput.getDirectoryMergeList().size() != 0) {
                    if (((MergeDirectoriesDialog)object).recalculateNeeded()) {
                        this.mergeApp.execute();
                        if (this.viewParam.getCollisions()) {
                            Vector vector = this.diffInput.getDirectoryMergeList();
                            this.collisionsWindow.updateCollisions(vector, 0);
                        } else {
                            this.collisionsWindow();
                        }
                    } else {
                        this.setTitles();
                    }
                } else {
                    if (this.viewParam.getCollisions() || this.itemCollisions.getState()) {
                        this.itemCollisions.setState(false);
                        this.itemCollisions.setEnabled(false);
                        this.rolloverCollisions.setEnabled(false);
                        this.viewParam.setCollisions(false);
                        ((Component)this.collisionsWindow).setVisible(false);
                    }
                    WarningDialog warningDialog = new WarningDialog((Frame)this, tcmerge.locResource.getString("STR_ERROR_DIRECTORY"));
                    warningDialog.show();
                }
            }
        }
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void editBlock(int n) {
        int n2 = this.viewParam.getCurrentDiff();
        Vector vector = this.makeViews.getDiffTableOutput();
        this.makeViews.getTableOutput();
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)vector.elementAt(n2);
        int n3 = diffInfoCommon.getStartBlock();
        int n4 = diffInfoCommon.getEndBlock();
        int n5 = n == 0 ? n3 : n;
        if (this.editDialog == null) {
            this.editDialog = new EditLineDialog(this, n3, n5, n4);
        } else {
            this.editDialog.editNewBlock(n3, n5, n4);
        }
        this.editDialog.show();
    }

    public void recalculate() {
        Object object;
        int n = 0;
        if (!this.viewParam.getOutputSaved()) {
            object = new FileSave(this);
            n = ((FileSave)object).isSaveNeeded();
        }
        if (n == 0) {
            int n2;
            object = null;
            if (object == null) {
                n2 = this.diffInput.getInputFiles().size();
                object = new MergeOptionsDialog((Frame)this, n2);
                ((MergeOptionsDialog)object).setIgnoreBlanksAnswer(this.diffInput.getIgnoreBlanks());
                ((MergeOptionsDialog)object).setIgnoreUniqueDifferencesAnswer(this.diffInput.getIgnoreDiff());
                ((MergeOptionsDialog)object).setPrimeOutputFileAnswer(this.diffInput.getPrimeOutput());
                ((MergeOptionsDialog)object).setColumnsToIgnoreAnswer(this.diffInput.getColsToIgnore());
                ((MergeOptionsDialog)object).setIgnoreCaseSensitiveAnswer(this.diffInput.getIgnoreCaseSensitive());
                ((MergeOptionsDialog)object).setAutomergeAnswer(this.diffInput.getAutomerge());
                ((MergeOptionsDialog)object).setIgnoreBlankLinesAnswer(this.diffInput.getIgnoreBlankLines());
                ((MergeOptionsDialog)object).setTitlesAnswer(this.diffInput.getTitles());
                ((MergeOptionsDialog)object).createDialog();
            }
            ((Dialog)object).show();
            if (!((MergeOptionsDialog)object).getAction().equals("OK")) {
                ((Window)object).dispose();
                object = null;
                return;
            }
            if (object != null && ((MergeOptionsDialog)object).getAction().equals("OK")) {
                int n3;
                this.diffInput.setIgnoreBlanks(((MergeOptionsDialog)object).getIgnoreBlanksAnswer());
                this.diffInput.setIgnoreDiff(((MergeOptionsDialog)object).getIgnoreUniqueDifferencesAnswer());
                this.diffInput.setPrimeOutput(((MergeOptionsDialog)object).getPrimeOutputFileAnswer());
                this.diffInput.setColsToIgnore(((MergeOptionsDialog)object).getColumnsToIgnoreAnswer());
                this.diffInput.setIgnoreCaseSensitive(((MergeOptionsDialog)object).getIgnoreCaseSensitiveAnswer());
                this.diffInput.setAutomerge(((MergeOptionsDialog)object).getAutomergeAnswer());
                this.diffInput.setIgnoreBlankLines(((MergeOptionsDialog)object).getIgnoreBlankLinesAnswer());
                this.diffInput.setTitles(((MergeOptionsDialog)object).getTitlesAnswer());
                if (((MergeOptionsDialog)object).recalculateNeeded()) {
                    this.mergeApp.execute();
                    return;
                }
                n2 = this.diffInput.getPrimeOutput();
                if (n2 < (n3 = this.diffInput.getInputFiles().size()) && n2 != -1) {
                    this.makeViews.primeAllDiffs(n2);
                    this.outputView.repaint();
                    return;
                }
                if (n2 == 2) {
                    WarningDialog warningDialog = new WarningDialog((Frame)this, tcmerge.locResource.getString("STR_PRIME_ERROR1"));
                    warningDialog.show();
                }
            }
        }
    }

    public void setFontsInViews() {
        this.compositeView.setFont();
        this.fileZeroView.setFont();
        this.fileOneView.setFont();
        if (this.diffInput.getInputFiles().size() == 3) {
            this.fileTwoView.setFont();
        }
        this.outputView.setFont();
    }

    public void repaintWindows() {
        if (this.viewParam.getIsCompo()) {
            this.compositeView.repaint();
        } else {
            this.fileZeroView.repaint();
            this.fileOneView.repaint();
            if (this.diffInput.getInputFiles().size() == 3) {
                this.fileTwoView.repaint();
            }
        }
        this.outputView.repaint();
        this.updateLegendWindow();
        if (this.navigatorWindow != null && this.navigatorWindow.isVisible()) {
            this.navigatorWindow.updateNavigator();
        }
    }

    public void propertiesWindow() {
        ((Component)this).setCursor(this.waitCursor);
        new PropertiesGui(this);
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void collisionsWindow() {
        if (this.diffInput.getDirectoryMergeList().size() > 1) {
            Vector vector = this.diffInput.getDirectoryMergeList();
            if (this.itemCollisions.getState() && !this.viewParam.getCollisions()) {
                if (this.collisionsWindow == null) {
                    CollisionsNotifier collisionsNotifier = new CollisionsNotifier(this);
                    this.collisionsWindow = new CollisionsDialog((Frame)this, vector, 0);
                    this.collisionsWindow.addCollisionsListener(collisionsNotifier);
                }
                ((Component)this.collisionsWindow).setVisible(true);
                this.viewParam.setCollisions(true);
                return;
            }
            if (!this.itemCollisions.getState() && this.viewParam.getCollisions()) {
                ((Component)this.collisionsWindow).setVisible(false);
                this.viewParam.setCollisions(false);
                return;
            }
            if (!this.itemCollisions.getState() && !this.viewParam.getCollisions()) {
                if (this.collisionsWindow == null) {
                    CollisionsNotifier collisionsNotifier = new CollisionsNotifier(this);
                    this.collisionsWindow = new CollisionsDialog((Frame)this, vector, 0);
                    this.collisionsWindow.addCollisionsListener(collisionsNotifier);
                }
                this.itemCollisions.setState(true);
                this.viewParam.setCollisions(true);
                ((Component)this.collisionsWindow).setVisible(true);
                return;
            }
            if (this.itemCollisions.getState() && this.viewParam.getCollisions()) {
                this.itemCollisions.setState(false);
                ((Component)this.collisionsWindow).setVisible(false);
                this.viewParam.setCollisions(false);
            }
        }
    }

    public void navigatorWindow() {
        if (this.makeViews.totalDifferences > 0) {
            if (this.itemNavigator.getState() && !this.viewParam.getNavigator()) {
                if (this.navigatorWindow == null) {
                    NavigatorNotifier navigatorNotifier = new NavigatorNotifier(this);
                    this.navigatorWindow = new NavigatorDialog(this);
                    this.navigatorWindow.addWindowListener(navigatorNotifier);
                    ((Component)this.navigatorWindow).setBounds(0, 0, 146, INITIAL_HEIGHT);
                }
                ((Component)this.navigatorWindow).setVisible(true);
                this.viewParam.setNavigator(true);
                return;
            }
            if (!this.itemNavigator.getState() && this.viewParam.getNavigator()) {
                ((Component)this.navigatorWindow).setVisible(false);
                this.viewParam.setNavigator(false);
                return;
            }
            if (!this.itemNavigator.getState() && !this.viewParam.getNavigator()) {
                if (this.navigatorWindow == null) {
                    NavigatorNotifier navigatorNotifier = new NavigatorNotifier(this);
                    this.navigatorWindow = new NavigatorDialog(this);
                    this.navigatorWindow.addWindowListener(navigatorNotifier);
                    ((Component)this.navigatorWindow).setBounds(0, 0, 146, INITIAL_HEIGHT);
                }
                this.itemNavigator.setState(true);
                this.viewParam.setNavigator(true);
                ((Component)this.navigatorWindow).setVisible(true);
                return;
            }
            if (this.itemNavigator.getState() && this.viewParam.getNavigator()) {
                this.itemNavigator.setState(false);
                ((Component)this.navigatorWindow).setVisible(false);
                this.viewParam.setNavigator(false);
            }
        }
    }

    public void legendWindow() {
        Color[] colorArray;
        Color[] colorArray2;
        String[] stringArray;
        Vector vector = this.diffInput.getInputFiles();
        if (vector.size() == 3) {
            stringArray = new String[]{String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1")) + ": " + (String)vector.elementAt(0), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2")) + ": " + (String)vector.elementAt(1), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT3")) + ": " + (String)vector.elementAt(2), tcmerge.locResource.getString("ITEM_EDITED_DIFF_BLOCK")};
            colorArray2 = new Color[]{this.options.getEditor().getZerothDiffColor(), this.options.getEditor().getFirstDiffColor(), this.options.getEditor().getSecondDiffColor(), this.options.getEditor().getOutviewEditedColor()};
            colorArray = new Color[]{this.options.getEditor().getZerothCurrentDiffFG(), this.options.getEditor().getFirstCurrentDiffFG(), this.options.getEditor().getSecondCurrentDiffFG(), this.options.getEditor().getOutviewEditedFG()};
        } else {
            stringArray = new String[]{String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1")) + ": " + (String)vector.elementAt(0), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2")) + ": " + (String)vector.elementAt(1), tcmerge.locResource.getString("ITEM_EDITED_DIFF_BLOCK")};
            colorArray2 = new Color[]{this.options.getEditor().getZerothDiffColor(), this.options.getEditor().getFirstDiffColor(), this.options.getEditor().getOutviewEditedColor()};
            colorArray = new Color[]{this.options.getEditor().getZerothCurrentDiffFG(), this.options.getEditor().getFirstCurrentDiffFG(), this.options.getEditor().getOutviewEditedFG()};
        }
        if (this.itemLegend.getState() && !this.viewParam.getLegend()) {
            if (this.legendWindow == null) {
                LegendNotifier legendNotifier = new LegendNotifier(this);
                this.legendWindow = new Legend((Frame)this, stringArray, colorArray2, colorArray, legendNotifier);
            }
            this.viewParam.setLegend(true);
            ((Component)this.legendWindow).setVisible(true);
            return;
        }
        if (!this.itemLegend.getState() && this.viewParam.getLegend()) {
            ((Component)this.legendWindow).setVisible(false);
            this.viewParam.setLegend(false);
            return;
        }
        if (!this.itemLegend.getState() && !this.viewParam.getLegend()) {
            if (this.legendWindow == null) {
                LegendNotifier legendNotifier = new LegendNotifier(this);
                this.legendWindow = new Legend((Frame)this, stringArray, colorArray2, colorArray, legendNotifier);
            }
            this.itemLegend.setState(true);
            this.viewParam.setLegend(true);
            ((Component)this.legendWindow).setVisible(true);
            return;
        }
        if (this.itemLegend.getState() && this.viewParam.getLegend()) {
            this.itemLegend.setState(false);
            ((Component)this.legendWindow).setVisible(false);
            this.viewParam.setLegend(false);
        }
    }

    public void updateLegendWindow() {
        Color[] colorArray;
        Color[] colorArray2;
        String[] stringArray;
        Vector vector = this.diffInput.getInputFiles();
        if (vector.size() == 3) {
            stringArray = new String[]{String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1")) + ": " + (String)vector.elementAt(0), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2")) + ": " + (String)vector.elementAt(1), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT3")) + ": " + (String)vector.elementAt(2), tcmerge.locResource.getString("ITEM_EDITED_DIFF_BLOCK")};
            colorArray2 = new Color[]{this.options.getEditor().getZerothDiffColor(), this.options.getEditor().getFirstDiffColor(), this.options.getEditor().getSecondDiffColor(), this.options.getEditor().getOutviewEditedColor()};
            colorArray = new Color[]{this.options.getEditor().getZerothCurrentDiffFG(), this.options.getEditor().getFirstCurrentDiffFG(), this.options.getEditor().getSecondCurrentDiffFG(), this.options.getEditor().getOutviewEditedFG()};
        } else {
            stringArray = new String[]{String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1")) + ": " + (String)vector.elementAt(0), String.valueOf(tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2")) + ": " + (String)vector.elementAt(1), tcmerge.locResource.getString("ITEM_EDITED_DIFF_BLOCK")};
            colorArray2 = new Color[]{this.options.getEditor().getZerothDiffColor(), this.options.getEditor().getFirstDiffColor(), this.options.getEditor().getOutviewEditedColor()};
            colorArray = new Color[]{this.options.getEditor().getZerothCurrentDiffFG(), this.options.getEditor().getFirstCurrentDiffFG(), this.options.getEditor().getOutviewEditedFG()};
        }
        if (this.legendWindow != null && this.legendWindow.isVisible()) {
            ((Component)this.legendWindow).setVisible(false);
            this.legendWindow.updateLegend(stringArray, colorArray2, colorArray);
            ((Component)this.legendWindow).setVisible(true);
        }
    }

    public void setCompositeViewTitle() {
        this.titleComposite.setText();
    }

    public void setOutputViewTitle() {
        this.titleOutput.setText();
    }

    public void setFileZeroViewTitle() {
        this.titleFileZero.setText();
    }

    public void setFileOneViewTitle() {
        this.titleFileOne.setText();
    }

    public void setFileTwoViewTitle() {
        this.titleFileTwo.setText();
    }

    public void setTitles() {
        this.setOutputViewTitle();
        this.setCompositeViewTitle();
        this.setFileZeroViewTitle();
        this.setFileOneViewTitle();
        if (this.diffInput.getInputFiles().size() == 3) {
            this.setFileTwoViewTitle();
        }
    }

    public void copyToClipboard() {
        String string = "";
        if (this.clipboard == null) {
            this.clipboard = this.getToolkit().getSystemClipboard();
        }
        int n = this.viewParam.getCurrentDiff();
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.makeViews.getDiffTableOutput().elementAt(n);
        int n2 = diffInfoCommon.getStartBlock();
        int n3 = diffInfoCommon.getEndBlock();
        int n4 = n2;
        while (n4 <= n3) {
            TextRefOutput textRefOutput = (TextRefOutput)this.makeViews.getTableOutput().elementAt(n4);
            if (textRefOutput.textRef != -1 && textRefOutput.textRef != -2) {
                TextComposite textComposite = (TextComposite)this.makeViews.getTableComposite().elementAt(textRefOutput.textRef);
                string = String.valueOf(string) + textComposite.text + "\n";
            }
            ++n4;
        }
        StringSelection stringSelection = new StringSelection(string);
        this.clipboard.setContents(stringSelection, null);
    }

    public void pasteFromClipboard() {
        Object object;
        Vector<String> vector = new Vector<String>();
        String string = "";
        try {
            if (this.clipboard == null) {
                this.clipboard = this.getToolkit().getSystemClipboard();
            }
            object = this.clipboard.getContents(this);
            string = (String)object.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Throwable throwable) {
            object = new WarningDialog((Frame)this, tcmerge.locResource.getString("STR_PASTE_ERROR1"));
            ((Dialog)object).show();
        }
        int n = string.indexOf("\n");
        while (n != -1) {
            String string2 = string.substring(0, n);
            string = string.substring(n + 1);
            vector.addElement(string2);
            n = string.indexOf("\n");
        }
        int n2 = this.viewParam.getCurrentDiff();
        DiffInfoCommon diffInfoCommon = (DiffInfoCommon)this.makeViews.getDiffTableOutput().elementAt(n2);
        int n3 = diffInfoCommon.getStartBlock();
        int n4 = diffInfoCommon.getEndBlock();
        if (vector.size() == n4 - n3 + 1) {
            int n5 = n3;
            while (n5 <= n4) {
                TextRefOutput textRefOutput = (TextRefOutput)this.makeViews.getTableOutput().elementAt(n5);
                this.makeViews.getTableEdit().addElement(vector.elementAt(n5 - n3));
                textRefOutput.flag = (byte)(textRefOutput.flag & 0xF);
                textRefOutput.flag = (byte)(textRefOutput.flag | 8);
                textRefOutput.textRef = this.makeViews.getTableEdit().size() - 1;
                ++n5;
            }
        } else if (vector.size() < n4 - n3 + 1) {
            int n6 = n3;
            while (n6 < n3 + vector.size()) {
                TextRefOutput textRefOutput = (TextRefOutput)this.makeViews.getTableOutput().elementAt(n6);
                this.makeViews.getTableEdit().addElement(vector.elementAt(n6 - n3));
                textRefOutput.flag = (byte)(textRefOutput.flag & 0xF);
                textRefOutput.flag = (byte)(textRefOutput.flag | 8);
                textRefOutput.textRef = this.makeViews.getTableEdit().size() - 1;
                ++n6;
            }
        } else if (vector.size() > n4 - n3 + 1) {
            String string3 = tcmerge.locResource.getString("STR_PASTE_MSG1");
            String string4 = tcmerge.locResource.getString("STR_TCMERGE");
            YesNoDialog yesNoDialog = new YesNoDialog((Frame)this, string3, string4);
            yesNoDialog.show();
            if (yesNoDialog.getAction().equals("Yes")) {
                int n7 = n3;
                while (n7 < n3 + vector.size()) {
                    TextRefOutput textRefOutput = (TextRefOutput)this.makeViews.getTableOutput().elementAt(n7);
                    this.makeViews.getTableEdit().addElement(vector.elementAt(n7 - n3));
                    textRefOutput.flag = (byte)(textRefOutput.flag & 0xF);
                    textRefOutput.flag = (byte)(textRefOutput.flag | 8);
                    textRefOutput.textRef = this.makeViews.getTableEdit().size() - 1;
                    ++n7;
                }
            }
        }
        this.outputView.repaint();
    }

    public void ignoreUniqueDifference(int n) {
        int n2 = 0;
        if (!this.viewParam.getOutputSaved()) {
            FileSave fileSave = new FileSave(this);
            n2 = fileSave.isSaveNeeded();
        }
        if (n2 == 0) {
            this.viewParam.setAddToRecentFiles(false);
            this.diffInput.setIgnoreDiff(n);
            this.viewParam.updateViewParam();
            this.getMakeViews().updateMakeViews();
            this.getStatus().setStatusBar(0);
            this.updateMergeGui();
            this.viewParam.setAddToRecentFiles(true);
        }
    }

    public void setupMenu() {
        this.menuBar = new MenuBar();
        String string = tcmerge.locResource.getString("MENU_FILE");
        this.menuFile = new Menu(string);
        this.menuBar.add(this.menuFile);
        string = tcmerge.locResource.getString("ITEM_MERGE_FILE");
        this.itemMergeFiles = new MenuItem(string);
        this.itemMergeFiles.addActionListener(this);
        this.menuFile.add(this.itemMergeFiles);
        string = tcmerge.locResource.getString("ITEM_MERGE_DIRECTORY");
        this.itemMergeDirectories = new MenuItem(string);
        this.itemMergeDirectories.addActionListener(this);
        this.menuFile.add(this.itemMergeDirectories);
        this.itemMergeDirectories.setEnabled(true);
        this.menuFile.addSeparator();
        MenuShortcut menuShortcut = new MenuShortcut(83);
        string = tcmerge.locResource.getString("ITEM_SAVE_OUTPUT");
        this.itemSaveOutput = new MenuItem(string, menuShortcut);
        this.itemSaveOutput.addActionListener(this);
        this.menuFile.add(this.itemSaveOutput);
        string = tcmerge.locResource.getString("ITEM_SAVE_OUTPUT_AS");
        this.itemSaveOutputAs = new MenuItem(string);
        this.itemSaveOutputAs.addActionListener(this);
        this.menuFile.add(this.itemSaveOutputAs);
        this.menuFile.addSeparator();
        string = tcmerge.locResource.getString("ITEM_PROPERTIES");
        this.itemProperties = new MenuItem(string);
        this.itemProperties.addActionListener(this);
        this.menuFile.add(this.itemProperties);
        this.itemProperties.setEnabled(true);
        this.menuFile.addSeparator();
        menuShortcut = new MenuShortcut(80);
        string = tcmerge.locResource.getString("ITEM_PRINT");
        this.itemPrint = new MenuItem(string, menuShortcut);
        this.itemPrint.addActionListener(this);
        this.menuFile.add(this.itemPrint);
        this.itemPrint.setEnabled(true);
        this.menuFile.addSeparator();
        this.itemRecentFiles = new Vector();
        int n = 0;
        while (n < RECENTFILECOUNT) {
            this.itemRecentFiles.addElement(new MenuItem(""));
            this.getItemRecentFiles(n).addActionListener(this);
            ++n;
        }
        this.menuFile.addSeparator();
        string = tcmerge.locResource.getString("ITEM_EXIT");
        this.itemExit = new MenuItem(string);
        this.itemExit.addActionListener(this);
        this.menuFile.add(this.itemExit);
        string = tcmerge.locResource.getString("MENU_EDIT");
        this.menuEdit = new Menu(string);
        this.menuBar.add(this.menuEdit);
        menuShortcut = new MenuShortcut(90);
        string = tcmerge.locResource.getString("ITEM_UNDO");
        this.itemUndo = new MenuItem(string, menuShortcut);
        this.itemUndo.addActionListener(this);
        this.menuEdit.add(this.itemUndo);
        this.itemUndo.setEnabled(true);
        this.menuEdit.addSeparator();
        string = tcmerge.locResource.getString("MENU_INSERT_BLOCK");
        this.menuInsertBlock = new Menu(string);
        menuShortcut = new MenuShortcut(49);
        string = tcmerge.locResource.getString("ITEM_FROM_INPUT1");
        this.itemFromInput1 = new MenuItem(string, menuShortcut);
        this.itemFromInput1.addActionListener(this);
        this.menuInsertBlock.add(this.itemFromInput1);
        menuShortcut = new MenuShortcut(50);
        string = tcmerge.locResource.getString("ITEM_FROM_INPUT2");
        this.itemFromInput2 = new MenuItem(string, menuShortcut);
        this.itemFromInput2.addActionListener(this);
        this.menuInsertBlock.add(this.itemFromInput2);
        menuShortcut = new MenuShortcut(51);
        string = tcmerge.locResource.getString("ITEM_FROM_INPUT3");
        this.itemFromInput3 = new MenuItem(string, menuShortcut);
        this.itemFromInput3.addActionListener(this);
        this.menuInsertBlock.add(this.itemFromInput3);
        this.menuEdit.add(this.menuInsertBlock);
        string = tcmerge.locResource.getString("ITEM_EDIT_CURR_DIFF");
        this.itemEditBlock = new MenuItem(string);
        this.itemEditBlock.addActionListener(this);
        this.menuEdit.add(this.itemEditBlock);
        menuShortcut = new MenuShortcut(67);
        string = tcmerge.locResource.getString("ITEM_COPY_CURR_DIFF");
        this.itemCopy = new MenuItem(string, menuShortcut);
        this.itemCopy.addActionListener(this);
        this.menuEdit.add(this.itemCopy);
        this.itemCopy.setEnabled(true);
        menuShortcut = new MenuShortcut(86);
        string = tcmerge.locResource.getString("ITEM_PASTE_CURR_DIFF");
        this.itemPaste = new MenuItem(string, menuShortcut);
        this.itemPaste.addActionListener(this);
        this.menuEdit.add(this.itemPaste);
        this.itemPaste.setEnabled(true);
        string = tcmerge.locResource.getString("MENU_VIEW");
        this.menuView = new Menu(string);
        this.menuBar.add(this.menuView);
        string = tcmerge.locResource.getString("ITEM_COMPOSITE");
        this.itemComposite = new CheckboxMenuItem(string, true);
        this.itemComposite.addItemListener(this);
        this.menuView.add(this.itemComposite);
        this.menuView.addSeparator();
        string = tcmerge.locResource.getString("ITEM_SPLIT");
        this.itemSplit = new CheckboxMenuItem(string, false);
        this.itemSplit.addItemListener(this);
        this.menuView.add(this.itemSplit);
        this.itemSplit.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_SCROLL_TOGETHER");
        this.itemScrollTogether = new CheckboxMenuItem(string, true);
        this.itemScrollTogether.addItemListener(this);
        this.menuView.add(this.itemScrollTogether);
        this.itemScrollTogether.setEnabled(true);
        this.menuView.addSeparator();
        string = tcmerge.locResource.getString("MENU_MAXIMIZE");
        this.menuMaximize = new Menu(string);
        this.menuMaximize.addActionListener(this);
        this.menuMaximize.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUTS");
        this.itemMaximizeInputs = new MenuItem(string);
        this.itemMaximizeInputs.addActionListener(this);
        this.menuMaximize.add(this.itemMaximizeInputs);
        this.itemMaximizeInputs.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT1");
        this.itemMaximizeInput1 = new MenuItem(string);
        this.itemMaximizeInput1.addActionListener(this);
        this.menuMaximize.add(this.itemMaximizeInput1);
        this.itemMaximizeInput1.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT2");
        this.itemMaximizeInput2 = new MenuItem(string);
        this.itemMaximizeInput2.addActionListener(this);
        this.menuMaximize.add(this.itemMaximizeInput2);
        this.itemMaximizeInput2.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_MAXIMIZE_INPUT3");
        this.itemMaximizeInput3 = new MenuItem(string);
        this.itemMaximizeInput3.addActionListener(this);
        this.menuMaximize.add(this.itemMaximizeInput3);
        this.itemMaximizeInput3.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_MAXIMIZE_OUTPUT");
        this.itemMaximizeOutput = new MenuItem(string);
        this.itemMaximizeOutput.addActionListener(this);
        this.menuMaximize.add(this.itemMaximizeOutput);
        this.itemMaximizeOutput.setEnabled(true);
        this.menuView.add(this.menuMaximize);
        string = tcmerge.locResource.getString("ITEM_RESET_PANES");
        this.itemResetPanes = new MenuItem(string);
        this.itemResetPanes.addActionListener(this);
        this.menuView.add(this.itemResetPanes);
        this.itemResetPanes.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_LINE_NUMBERS");
        this.itemLineNumbers = new CheckboxMenuItem(string, true);
        this.itemLineNumbers.addItemListener(this);
        this.menuView.add(this.itemLineNumbers);
        this.itemLineNumbers.setEnabled(true);
        this.menuView.addSeparator();
        string = tcmerge.locResource.getString("ITEM_NEXT_DIFF");
        this.itemNextDifference = new MenuItem(string);
        this.itemNextDifference.addActionListener(this);
        this.menuView.add(this.itemNextDifference);
        string = tcmerge.locResource.getString("ITEM_PREVIOUS_DIFF");
        this.itemPreviousDifference = new MenuItem(string);
        this.itemPreviousDifference.addActionListener(this);
        this.menuView.add(this.itemPreviousDifference);
        string = tcmerge.locResource.getString("ITEM_FIRST_DIFF");
        this.itemFirstDifference = new MenuItem(string);
        this.itemFirstDifference.addActionListener(this);
        this.menuView.add(this.itemFirstDifference);
        string = tcmerge.locResource.getString("ITEM_LAST_DIFF");
        this.itemLastDifference = new MenuItem(string);
        this.itemLastDifference.addActionListener(this);
        this.menuView.add(this.itemLastDifference);
        string = tcmerge.locResource.getString("ITEM_GOTO_DIFF");
        this.itemGotoDifference = new MenuItem(string);
        this.itemGotoDifference.addActionListener(this);
        this.menuView.add(this.itemGotoDifference);
        this.menuView.addSeparator();
        string = tcmerge.locResource.getString("ITEM_START_OF_DIFF");
        this.itemStartOfDifference = new MenuItem(string);
        this.itemStartOfDifference.addActionListener(this);
        this.menuView.add(this.itemStartOfDifference);
        string = tcmerge.locResource.getString("ITEM_END_OF_DIFF");
        this.itemEndOfDifference = new MenuItem(string);
        this.itemEndOfDifference.addActionListener(this);
        this.menuView.add(this.itemEndOfDifference);
        this.menuView.addSeparator();
        string = tcmerge.locResource.getString("ITEM_TOOLBAR");
        this.itemToolbar = new CheckboxMenuItem(string, true);
        this.itemToolbar.addItemListener(this);
        this.menuView.add(this.itemToolbar);
        string = tcmerge.locResource.getString("ITEM_STATUS_BAR");
        this.itemStatusBar = new CheckboxMenuItem(string, true);
        this.itemStatusBar.addItemListener(this);
        this.menuView.add(this.itemStatusBar);
        string = tcmerge.locResource.getString("MENU_OPTION");
        this.menuOptions = new Menu(string);
        this.menuBar.add(this.menuOptions);
        string = tcmerge.locResource.getString("ITEM_RECALCULATE");
        this.itemRecalculate = new MenuItem(string);
        this.itemRecalculate.addActionListener(this);
        this.menuOptions.add(this.itemRecalculate);
        this.menuOptions.addSeparator();
        string = tcmerge.locResource.getString("MENU_IGNORE_UNIQUE_DIFF");
        this.menuIgnoreUnique = new Menu(string);
        this.menuIgnoreUnique.addActionListener(this);
        string = tcmerge.locResource.getString("ITEM_IGNORE_UNIQUE_NONE");
        this.itemIgnoreNone = new MenuItem(string);
        this.itemIgnoreNone.addActionListener(this);
        this.menuIgnoreUnique.add(this.itemIgnoreNone);
        string = tcmerge.locResource.getString("ITEM_IGNORE_UNIQUE_INPUT1");
        this.itemIgnoreInput1 = new MenuItem(string);
        this.itemIgnoreInput1.addActionListener(this);
        this.menuIgnoreUnique.add(this.itemIgnoreInput1);
        string = tcmerge.locResource.getString("ITEM_IGNORE_UNIQUE_INPUT2");
        this.itemIgnoreInput2 = new MenuItem(string);
        this.itemIgnoreInput2.addActionListener(this);
        this.menuIgnoreUnique.add(this.itemIgnoreInput2);
        string = tcmerge.locResource.getString("ITEM_IGNORE_UNIQUE_INPUT3");
        this.itemIgnoreInput3 = new MenuItem(string);
        this.itemIgnoreInput3.addActionListener(this);
        this.menuIgnoreUnique.add(this.itemIgnoreInput3);
        this.menuOptions.add(this.menuIgnoreUnique);
        this.menuIgnoreUnique.setEnabled(true);
        string = tcmerge.locResource.getString("MENU_WINDOW");
        this.menuWindow = new Menu(string);
        this.menuBar.add(this.menuWindow);
        string = tcmerge.locResource.getString("ITEM_NAVIGATOR");
        this.itemNavigator = new CheckboxMenuItem(string);
        this.itemNavigator.addItemListener(this);
        this.menuWindow.add(this.itemNavigator);
        this.itemNavigator.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_COLLISION");
        this.itemCollisions = new CheckboxMenuItem(string);
        this.itemCollisions.addItemListener(this);
        this.menuWindow.add(this.itemCollisions);
        this.itemCollisions.setEnabled(true);
        string = tcmerge.locResource.getString("ITEM_LEGEND");
        this.itemLegend = new CheckboxMenuItem(string);
        this.itemLegend.addItemListener(this);
        this.menuWindow.add(this.itemLegend);
        string = tcmerge.locResource.getString("MENU_HELP");
        this.menuHelp = new Menu(string);
        this.menuBar.add(this.menuHelp);
        string = tcmerge.locResource.getString("ITEM_MERGE_TOOL_HELP");
        this.itemMergeTool = new MenuItem(string);
        this.itemMergeTool.addActionListener(this);
        this.menuHelp.add(this.itemMergeTool);
        this.itemMergeTool.setEnabled(true);
        this.menuHelp.addSeparator();
        string = tcmerge.locResource.getString("ITEM_CONTENTS_AND_INDEX");
        this.itemContents = new MenuItem(string);
        this.itemContents.addActionListener(this);
        this.menuHelp.add(this.itemContents);
        this.itemContents.setEnabled(true);
        this.menuHelp.addSeparator();
        string = tcmerge.locResource.getString("ITEM_ABOUT_MERGE_TOOL");
        this.itemAboutMerge = new MenuItem(string);
        this.itemAboutMerge.addActionListener(this);
        this.menuHelp.add(this.itemAboutMerge);
        this.itemAboutMerge.setEnabled(true);
        this.setMenuBar(this.menuBar);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

