/*
****************************************************************************

NAME: tcDBcfg familyName

EXAMPLE USAGE:

      rexx tcDBcfg.rex testfam  2>&1  |  tee tcdbconfig.out

ENVIRONMENT VARIABLES:
      TC_FAMILY
      TC_BECOME

DESCRIPTION:
   This command displays the db2level, tclevel, all db2 variables and
   all tc_ variables, the DB2 "admin", "dbm", and
   "db" configurations, as well as info for bufferpools, tablespaces,
   TCPERF% indexes, and current statistics.

NOTE:
* It must be run from the VA TC family user id.
* It must be run from a DB2 Command Window (invoke db2cmd from a normal window).
****************************************************************************
*/

parse arg tcFamily .
if tcFamily = '' then
do
    say 'Usage: [ rexx ] tcDBcfg tcFamily'
    say 'Where tcFamily is the family DB2 database name.'
    say 'This command displays the db2level, tclevel, all db2 variables and '
    say 'all tc_ variables, the DB2 "admin", "dbm", and'
    say '"db" configurations, as well as info for bufferpools, tablespaces,'
    say 'TCPERF% indexes, and current statistics.'
    exit 1
end
say '+-------------------------------------------------------------+'
say '|                                                             |'
say '| VisualAge TeamConnection and DB2 Configuration information  |'
say '|                                                             |'
say '+-------------------------------------------------------------+'
say ' '
say 'Configuration date'
'date /T'
say ' '
say 'Configuration time'
'time /T'
say ' '
say 'tcDBcfg ---------------------------------TeamConnection version'
say ' '
'tclevel'
say ' '

say 'tcDBcfg -------------------TeamConnection environment variables'
say ' '
'set tc'
say ' '

say 'tcDBcfg ---------------------------Operating system and version'
'ver'
say ' '

say 'tcDBcfg ----------------------------------------------User info'
say ' '
'set user'
say ' '

say 'tcDBcfg --------------------------------------------DB2 version'
say ' '
'db2level'
say ' '

say 'tcDBcfg ---------------------------------DB2 registry variables'
say ' '
'db2set -all'
say ' '

say 'tcDBcfg ------------------------------DB2 environment variables'
say ' '
'set db2'
say ' '

say 'tcDBcfg --------------------------------DB2 admin configuration'
say ' '
'db2 get admin cfg'
say ' '

say 'tcDBcfg ---------------------DB2 database manager configuration'
say ' '
'db2 get dbm cfg'
say ' '

say 'tcDBcfg ----------------------DB2 family database configuration'
say ' '
'db2 get db cfg for' tcFamily
say ' '

say 'tcDBcfg ------------------------Connecting to tcFamily database'
say ' '
'db2 connect to' tcFamily
say ' '

say 'tcDBcfg ----------------------------------------Bufferpool info'
say ' '
'db2 "select * from syscat.bufferpools"'
say ' '

say 'tcDBcfg ----------------------------------------Tablespace info'
say ' '
'db2 "select definer, tbspace, tbspacetype as type, tbspaceid as id, bufferpoolid as pool, ' ,
    'datatype, extentsize, prefetchsize, pagesize, overhead, transferrate from syscat.tablespaces"'
say ' '

say 'tcDBcfg -----------------------------Last table statistics time'
say ' '
'db2 "select tabschema, tabname, stats_time, card from syscat.tables ' ,
    'where type='"'T'"' and tabschema=(select tabschema from syscat.tables ' ,
    'where tabname='"'FHCFILE'"') order by tabname"'
say ' '

say 'tcDBcfg -----------------------------Last index statistics time'
say ' '
'db2 "select tabname, indname, stats_time, unique_colcount, colnames from syscat.indexes ' ,
    'where tabschema=(select tabschema from syscat.tables ' ,
    'where tabname='"'FHCFILE'"') order by tabname, indname"'
say ' '

say 'tcDBcfg ---------------------------------Last package bind time'
say ' '
'db2 "select pkgschema, pkgname, valid, last_bind_time from syscat.packages ' ,
    'where pkgschema=(select pkgschema from syscat.packages ' ,
    'where pkgname='"'TCMOD'"') order by pkgname"'
say ' '

say 'tcDBcfg -------------------------------DB2 reorganization check'
say ' '
'db2 "reorgchk current statistics on table user"'

say 'tcDBcfg ---------------Disconnecting from the tcFamily database'
say ' '
'db2 connect reset'
say ' '

/* This stuff needs to be last, to avoid problems with the piping and tee */

say 'tcDBcfg --------------------------TeamConnection user exit info'
say ' '
'type %tc_dbpath%\config\userExit'

exit 0

/* end of script */
